/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.template;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.file.FileUtils;

public final class TemplateAsText {
    private static final String VAR_PATTERN = "\\$\\{%s}";
    private final boolean throwExceptionForNotResolved;
    private String templateText;

    private TemplateAsText(String templateText, boolean throwExceptionForNotResolved) {
        this.throwExceptionForNotResolved = throwExceptionForNotResolved;
        this.templateText = templateText;
    }

    private TemplateAsText(String templateText) {
        this(templateText, false);
    }

    public static TemplateAsText fromClassPath(String resourcePath) {
        return new TemplateAsText(FileUtils.readAsTextFromClassPath(resourcePath));
    }

    public static TemplateAsText fromClassPath(String resourcePath, boolean throwExceptionForNotResolved) {
        return new TemplateAsText(FileUtils.readAsTextFromClassPath(resourcePath), throwExceptionForNotResolved);
    }

    public static TemplateAsText fromFile(String filePath) {
        return new TemplateAsText(FileUtils.readAsText(filePath));
    }

    public static TemplateAsText fromFile(String filePath, boolean throwExceptionForNotResolved) {
        return new TemplateAsText(FileUtils.readAsText(filePath), throwExceptionForNotResolved);
    }

    public static TemplateAsText fromText(String templateText) {
        return new TemplateAsText(templateText);
    }

    public static TemplateAsText fromText(String templateText, boolean throwExceptionForNotResolved) {
        return new TemplateAsText(templateText, throwExceptionForNotResolved);
    }

    public TemplateAsText overrideVariable(String varName, String value) {
        Objects.requireNonNull(value, "Value for variable: '" + varName + "' cannot be null");
        this.templateText = this.templateText.replaceAll(String.format(VAR_PATTERN, varName), value.replace("$", "\\$"));
        return this;
    }

    public TemplateAsText overrideVariables(Map<String, ?> valuesByArgNames) {
        valuesByArgNames.forEach((name, value) -> this.overrideVariable((String)name, value.toString()));
        return this;
    }

    public String getCurrentTemplateText() {
        if (this.throwExceptionForNotResolved) {
            Pattern pattern = Pattern.compile(String.format(VAR_PATTERN, "(\\w|-)+"));
            Matcher matcher = pattern.matcher(this.templateText);
            ArrayList<String> notResolved = new ArrayList<String>();
            while (matcher.find()) {
                notResolved.add(matcher.group(0));
            }
            if (CollectionUtils.isNotEmpty(notResolved)) {
                throw new IllegalArgumentException("Not resolved placeholders: " + notResolved);
            }
        }
        return this.templateText;
    }
}

