/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.string;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.constants.Constants;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNotEmpty(String text) {
        return !StringUtils.isEmpty(text);
    }

    public static boolean isBlank(String text) {
        return text == null || StringUtils.isBlank(text.toCharArray());
    }

    private static boolean isBlank(char ... chars) {
        boolean result = true;
        for (char currentChar : chars) {
            boolean bl = result = result && Character.isWhitespace(currentChar);
            if (!result) break;
        }
        return result;
    }

    public static boolean isNotBlank(String text) {
        return !StringUtils.isBlank(text);
    }

    public static <E> String concatElementsAsLines(List<E> elements) {
        return StringUtils.concatElements(elements, Constants.NEW_LINE);
    }

    public static String concatElementsAsLines(Object ... elements) {
        return StringUtils.concatElements(Arrays.asList(elements), Constants.NEW_LINE);
    }

    public static <E> String concatElementsAsLines(Function<E, String> mapper, E ... elements) {
        return StringUtils.concatElements(Arrays.asList(elements), mapper, Constants.NEW_LINE);
    }

    public static <E> String concatElementsAsLines(List<E> elements, Function<E, String> mapper) {
        return StringUtils.concatElements(elements, mapper, Constants.NEW_LINE);
    }

    public static String tabsNTimes(int tabsNumber) {
        return StringUtils.repeatTextNTimes(tabsNumber, "\t");
    }

    public static String repeatTextNTimes(int nTimes, String text) {
        return String.join((CharSequence)"", Collections.nCopies(nTimes, text));
    }

    public static <E> String concatElements(Collection<E> collection) {
        return StringUtils.concatElements(collection, "");
    }

    public static <E> String concatElements(Elements<E> elements) {
        return StringUtils.concatElements(elements.asList(), "");
    }

    public static <E> String concatElements(Collection<E> collection, Function<E, String> mapper) {
        return StringUtils.concatElements(collection, mapper, "");
    }

    public static <E> String concatElements(Elements<E> elements, String joinText) {
        return StringUtils.concatElements(elements.asList(), Object::toString, joinText);
    }

    public static <E> String concatElements(Collection<E> collection, String joinText) {
        return StringUtils.concatElements(collection, Object::toString, joinText);
    }

    public static <E> String concatElements(Collection<E> collection, Function<E, String> mapper, String joinText) {
        return StringUtils.concatElements("", collection, (E t) -> true, mapper, joinText, "");
    }

    public static <E> String concatElements(String textPrefix, Collection<E> collection, Function<E, String> mapper, String joinText, String textSuffix) {
        return StringUtils.concatElements(textPrefix, collection, (E e) -> true, mapper, joinText, textSuffix);
    }

    public static <E> String concatElements(String textPrefix, Collection<E> collection, Predicate<E> filter, Function<E, String> mapper, String joinText, String textSuffix) {
        return textPrefix.concat(collection.stream().filter(filter).map(mapper).collect(Collectors.joining(joinText))).concat(textSuffix);
    }

    public static <E> String concatElements(String textPrefix, Collection<E> collection, String joinText, String textSuffix) {
        return StringUtils.concatElements(textPrefix, collection, (E t) -> true, Objects::toString, joinText, textSuffix);
    }

    public static String concatElements(String joinText, String ... texts) {
        return StringUtils.concatElements(Arrays.asList(texts), joinText);
    }

    public static <E> String concatElementsSkipNulls(Elements<E> elements) {
        return StringUtils.concatElementsSkipNulls(elements.asList(), "");
    }

    public static <E> String concatElementsSkipNulls(Collection<E> collection) {
        return StringUtils.concatElementsSkipNulls(collection, "");
    }

    public static <E> String concatElementsSkipNulls(Collection<E> collection, String joinText) {
        return StringUtils.concatElementsSkipNulls(collection, Object::toString, joinText);
    }

    public static <E> String concatElementsSkipNulls(Elements<E> eElements, String joinText) {
        return StringUtils.concatElementsSkipNulls(eElements.asList(), Object::toString, joinText);
    }

    public static <E> String concatElementsSkipNulls(Collection<E> collection, Function<E, String> mapper, String joinText) {
        return StringUtils.concatElements("", collection, Objects::nonNull, mapper, joinText, "");
    }

    public static String concat(String ... texts) {
        return StringUtils.concatElements(Arrays.asList(texts), "");
    }

    public static String concatObjects(Object ... texts) {
        return StringUtils.concatElements(Arrays.asList(texts), "");
    }

    public static int countSearchedChar(String text, char searchedChar) {
        char[] chars = text.toCharArray();
        int counter = 0;
        for (char currentChar : chars) {
            if (currentChar != searchedChar) continue;
            ++counter;
        }
        return counter;
    }
}

