/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.reflection.ClassNameFixer;
import pl.jalokim.utils.reflection.ExecutableByArgsFinder;
import pl.jalokim.utils.reflection.ReflectionOperationException;
import pl.jalokim.utils.reflection.TypeMetadata;
import pl.jalokim.utils.reflection.TypeWrapperBuilder;
import pl.jalokim.utils.reflection.UnresolvedRealClassException;
import pl.jalokim.utils.string.StringUtils;

public final class MetadataReflectionUtils {
    private static final List<Class<?>> SIMPLE_CLASSES = MetadataReflectionUtils.createSimpleClassesList();
    private static final List<Class<?>> SIMPLE_NUMBERS = MetadataReflectionUtils.createPrimitiveClassesList();
    private static final String FIELD_IS_NOT_ARRAY_MSG = "field: '%s' is not array type, is type: %s";

    private MetadataReflectionUtils() {
    }

    private static List<Class<?>> createSimpleClassesList() {
        ArrayList<Class<Instant>> classes = new ArrayList<Class<Instant>>();
        classes.add(String.class);
        classes.add(Character.class);
        classes.add(Number.class);
        classes.add(Boolean.class);
        classes.add(Enum.class);
        classes.add(LocalDate.class);
        classes.add(LocalDateTime.class);
        classes.add(LocalTime.class);
        classes.add(ZonedDateTime.class);
        classes.add(OffsetDateTime.class);
        classes.add(Duration.class);
        classes.add(Period.class);
        classes.add(Instant.class);
        return Collections.unmodifiableList(classes);
    }

    private static List<Class<?>> createPrimitiveClassesList() {
        ArrayList<Class<Number>> classes = new ArrayList<Class<Number>>();
        classes.add(Integer.TYPE);
        classes.add(Short.TYPE);
        classes.add(Byte.TYPE);
        classes.add(Long.TYPE);
        classes.add(Double.TYPE);
        classes.add(Float.TYPE);
        return Collections.unmodifiableList(classes);
    }

    public static Field getField(Object targetObject, String fieldName) {
        return MetadataReflectionUtils.getField(targetObject.getClass(), fieldName);
    }

    public static Field getField(Class<?> targetClass, String fieldName) {
        Field foundField = null;
        ArrayList searchedClasses = new ArrayList();
        for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                foundField = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                searchedClasses.add(currentClass);
            }
            if (foundField != null) break;
        }
        if (foundField == null) {
            throw new ReflectionOperationException("field '" + fieldName + "' not exist in classes: " + CollectionUtils.mapToList(searchedClasses, Class::getCanonicalName));
        }
        return foundField;
    }

    public static Class<?> getTypeOfArrayField(Field field) {
        if (!MetadataReflectionUtils.isArrayType(field.getType())) {
            throw new ReflectionOperationException(String.format(FIELD_IS_NOT_ARRAY_MSG, field, field.getType()));
        }
        return field.getType().getComponentType();
    }

    public static Method getMethod(Object targetObject, String methodName, Class<?> ... argClasses) {
        return MetadataReflectionUtils.getMethod(targetObject.getClass(), methodName, argClasses);
    }

    public static Method getMethod(Object targetObject, String methodName, List<Class<?>> argClasses) {
        return MetadataReflectionUtils.getMethod(targetObject.getClass(), methodName, argClasses.toArray(new Class[0]));
    }

    public static Method getMethod(Class<?> targetClass, String methodName, List<Class<?>> argClasses) {
        return MetadataReflectionUtils.getMethod(targetClass, methodName, argClasses.toArray(new Class[0]));
    }

    public static Method getMethod(Class<?> targetClass, String methodName, Class<?> ... argClasses) {
        Method method = null;
        ArrayList<String> noSuchMethodExceptions = new ArrayList<String>();
        for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                method = currentClass.getDeclaredMethod(methodName, argClasses);
            }
            catch (NoSuchMethodException e) {
                noSuchMethodExceptions.add(e.getMessage());
            }
            if (method != null) break;
        }
        if ((method = Optional.ofNullable(method).orElseGet(() -> ExecutableByArgsFinder.findMethod(targetClass, methodName, argClasses))) == null) {
            throw new ReflectionOperationException(new NoSuchMethodException(StringUtils.concatElementsAsLines(noSuchMethodExceptions)));
        }
        return method;
    }

    public static Constructor<?> getConstructor(Class<?> targetClass, Class<?> ... argsClasses) {
        try {
            return targetClass.getDeclaredConstructor(argsClasses);
        }
        catch (NoSuchMethodException noSuchConstructor) {
            return Optional.ofNullable(ExecutableByArgsFinder.findConstructor(targetClass, argsClasses)).orElseThrow(() -> new ReflectionOperationException("Cannot find constructor", noSuchConstructor));
        }
    }

    public static Constructor<?> getConstructor(Object targetInstance, Class<?> ... argsClasses) {
        return MetadataReflectionUtils.getConstructor(targetInstance.getClass(), argsClasses);
    }

    public static <T> Set<Class<? extends T>> getAllChildClassesForClass(Class<T> superType, String packageDefinition, boolean withAbstractClasses) {
        Reflections reflections = new Reflections(packageDefinition, new Scanner[0]);
        Set<Class<T>> findAllClassesInClassPath = reflections.getSubTypesOf(superType);
        if (!withAbstractClasses) {
            findAllClassesInClassPath = CollectionUtils.filterToSet(findAllClassesInClassPath, classMeta -> !Modifier.isAbstract(classMeta.getModifiers()));
        }
        return Collections.unmodifiableSet(findAllClassesInClassPath);
    }

    public static boolean isSimpleType(Field field) {
        return MetadataReflectionUtils.isSimpleType(field.getType());
    }

    public static boolean isSimpleType(Class<?> someClass) {
        return someClass.isPrimitive() || SIMPLE_CLASSES.stream().anyMatch(type -> type.isAssignableFrom(someClass));
    }

    public static boolean isNumberType(Field field) {
        return MetadataReflectionUtils.isNumberType(field.getType());
    }

    public static boolean isNumberType(Class<?> someClass) {
        return Number.class.isAssignableFrom(someClass) || SIMPLE_NUMBERS.contains(someClass);
    }

    public static boolean isTextType(Field field) {
        return MetadataReflectionUtils.isTextType(field.getType());
    }

    public static boolean isTextType(Class<?> someClass) {
        return String.class.isAssignableFrom(someClass);
    }

    public static boolean isEnumType(Field field) {
        return MetadataReflectionUtils.isEnumType(field.getType());
    }

    public static boolean isEnumType(Class<?> someClass) {
        return someClass.isEnum();
    }

    public static boolean isMapType(Field field) {
        return MetadataReflectionUtils.isMapType(field.getType());
    }

    public static boolean isMapType(Class<?> someClass) {
        return Map.class.isAssignableFrom(someClass);
    }

    public static boolean isCollectionType(Field field) {
        return MetadataReflectionUtils.isCollectionType(field.getType());
    }

    public static boolean isCollectionType(Class<?> someClass) {
        return Collection.class.isAssignableFrom(someClass);
    }

    public static boolean isHavingElementsType(Field field) {
        return MetadataReflectionUtils.isHavingElementsType(field.getType());
    }

    public static boolean isHavingElementsType(Class<?> someClass) {
        return MetadataReflectionUtils.isCollectionType(someClass) || MetadataReflectionUtils.isArrayType(someClass) || MetadataReflectionUtils.isMapType(someClass) || Stream.class.isAssignableFrom(someClass);
    }

    public static boolean isArrayType(Field field) {
        return MetadataReflectionUtils.isArrayType(field.getType());
    }

    public static boolean isArrayType(Class<?> someClass) {
        return someClass.isArray();
    }

    public static Class<?> getParametrizedType(Field field, int index) {
        try {
            return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[index];
        }
        catch (Exception ex) {
            throw new ReflectionOperationException(String.format("Cannot find parametrized type for field with class: '%s', at: %s index", field.getType(), index), ex);
        }
    }

    @Deprecated
    public static Class<?> getParametrizedType(Object targetObject, int index) {
        return MetadataReflectionUtils.getParametrizedType(targetObject.getClass(), index);
    }

    @Deprecated
    public static Class<?> getParametrizedType(Class<?> originalClass, int index) {
        Exception exception = null;
        for (Class<?> currentClass = originalClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return (Class)((ParameterizedType)currentClass.getGenericSuperclass()).getActualTypeArguments()[index];
            }
            catch (Exception ex) {
                exception = ex;
                continue;
            }
        }
        throw new ReflectionOperationException(String.format("Cannot find parametrized type for class: '%s', at: %s index", originalClass, index), exception);
    }

    public static Class<?> getClassForName(String className) {
        try {
            return ClassUtils.getClass(ClassNameFixer.fixClassName(className));
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionOperationException(e);
        }
    }

    public static List<Type> getParametrizedRawTypes(Class<?> someClass) {
        TypeVariable<Class<?>>[] typeParameters = someClass.getTypeParameters();
        if (!MetadataReflectionUtils.isEnumType(someClass) && typeParameters.length > 0) {
            ArrayList types = new ArrayList(Elements.elements(typeParameters).asList());
            return Collections.unmodifiableList(types);
        }
        return Collections.emptyList();
    }

    public static TypeMetadata getTypeMetadataFromClass(Class<?> someClass) {
        return TypeWrapperBuilder.buildFromClass(someClass);
    }

    public static TypeMetadata getTypeMetadataFromField(Field field) {
        try {
            return TypeWrapperBuilder.buildFromField(field);
        }
        catch (UnresolvedRealClassException ex) {
            throw new UnresolvedRealClassException(String.format("Cannot resolve some type for field: %s for class: %s", field.getName(), field.getDeclaringClass().getCanonicalName()), ex);
        }
    }

    public static TypeMetadata getTypeMetadataFromField(Field field, int index) {
        TypeMetadata parametrizedField = MetadataReflectionUtils.getTypeMetadataFromField(field);
        return parametrizedField.getGenericType(index);
    }

    public static TypeMetadata getTypeMetadataFromType(Type type) {
        if (type instanceof Class) {
            return TypeWrapperBuilder.buildFromClass((Class)type);
        }
        return TypeWrapperBuilder.buildFromType(type);
    }

    public static TypeMetadata getTypeMetadataOfArray(Field field) {
        if (!MetadataReflectionUtils.isArrayType(field.getType())) {
            throw new ReflectionOperationException(String.format(FIELD_IS_NOT_ARRAY_MSG, field, field.getType()));
        }
        TypeMetadata typeMetadata = TypeWrapperBuilder.buildForArrayField(field);
        return typeMetadata.getGenericType(0);
    }
}

