/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.reflection.MetadataReflectionUtils;
import pl.jalokim.utils.reflection.ReflectionOperationException;

public final class InvokableReflectionUtils {
    private InvokableReflectionUtils() {
    }

    public static void setValueForField(Object targetObject, String fieldName, Object newValue) {
        InvokableReflectionUtils.setValueForField(targetObject, targetObject.getClass(), fieldName, newValue);
    }

    public static void setValueForField(Object targetObject, Class<?> targetClass, String fieldName, Object newValue) {
        Field foundField = MetadataReflectionUtils.getField(targetClass, fieldName);
        InvokableReflectionUtils.setValueForField(targetObject, foundField, newValue);
    }

    public static void setValueForField(Object targetObject, Field field, Object newValue) {
        try {
            Field modifiersField = null;
            int oldModifiers = -1;
            if (Modifier.isFinal(field.getModifiers())) {
                modifiersField = Field.class.getDeclaredField("modifiers");
                oldModifiers = field.getModifiers();
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.setAccessible(true);
            field.set(targetObject, newValue);
            if (modifiersField != null) {
                modifiersField.setInt(field, oldModifiers);
                modifiersField.setAccessible(false);
            }
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw new ReflectionOperationException(e);
        }
    }

    public static void setValueForStaticField(Class<?> targetClass, String fieldName, Object newValue) {
        InvokableReflectionUtils.setValueForField(null, targetClass, fieldName, newValue);
    }

    public static void setValueForStaticField(Field field, Object newValue) {
        InvokableReflectionUtils.setValueForField(null, field, newValue);
    }

    public static <T> T getValueOfField(Object targetObject, String fieldName) {
        return InvokableReflectionUtils.getValueOfField(targetObject, targetObject.getClass(), fieldName);
    }

    public static <T> T getValueOfField(Object targetObject, Class<?> targetClass, String fieldName) {
        Field field = MetadataReflectionUtils.getField(targetClass, fieldName);
        return InvokableReflectionUtils.getValueOfField(targetObject, field);
    }

    public static <T> T getValueOfField(Object targetObject, Field field) {
        if (!Modifier.isStatic(field.getModifiers()) && targetObject == null) {
            throw new ReflectionOperationException("Cannot find non static field on null target object");
        }
        try {
            field.setAccessible(true);
            Object result = field.get(targetObject);
            field.setAccessible(false);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionOperationException(e);
        }
    }

    public static <T> T getValueForStaticField(Class<?> targetClass, String fieldName) {
        return InvokableReflectionUtils.getValueOfField(null, targetClass, fieldName);
    }

    public static <T> T getValueForStaticField(Field field) {
        return InvokableReflectionUtils.getValueOfField(null, field);
    }

    public static <T> T invokeMethod(Object target, String methodName, List<Class<?>> argClasses, List<Object> args) {
        return InvokableReflectionUtils.invokeMethod(target, target.getClass(), methodName, argClasses, args);
    }

    public static <T> T invokeMethod(Object target, String methodName, List<Object> args) {
        return InvokableReflectionUtils.invokeMethod(target, methodName, args.toArray());
    }

    public static <T> T invokeMethod(Object target, String methodName, Object ... args) {
        List<Class<?>> argClasses = CollectionUtils.mapToList(Object::getClass, args);
        return InvokableReflectionUtils.invokeMethod(target, target.getClass(), methodName, argClasses, Arrays.asList(args));
    }

    public static <T> T invokeMethod(Object target, Class<?> targetClass, String methodName, List<Object> args) {
        return InvokableReflectionUtils.invokeMethod(target, targetClass, methodName, args.toArray());
    }

    public static <T> T invokeMethod(Object target, Class<?> targetClass, String methodName, Object ... args) {
        List<Class<?>> argClasses = CollectionUtils.mapToList(Object::getClass, args);
        return InvokableReflectionUtils.invokeMethod(target, targetClass, methodName, argClasses, Arrays.asList(args));
    }

    public static <T> T invokeMethod(Object target, Class<?> targetClass, String methodName, List<Class<?>> argClasses, List<Object> args) {
        Method method = MetadataReflectionUtils.getMethod(targetClass, methodName, argClasses.toArray(new Class[0]));
        return InvokableReflectionUtils.invokeMethod(target, method, args);
    }

    public static <T> T invokeMethod(Object target, Method method, Object ... args) {
        return InvokableReflectionUtils.invokeMethod(target, method, Arrays.asList(args));
    }

    public static <T> T invokeMethod(Object target, Method method, List<Object> args) {
        if (!Modifier.isStatic(method.getModifiers()) && target == null) {
            throw new ReflectionOperationException("Cannot invoke non static method on null target object");
        }
        try {
            method.setAccessible(true);
            Object result = method.invoke(target, args.toArray(new Object[0]));
            method.setAccessible(false);
            return (T)result;
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ReflectionOperationException(e);
        }
    }

    public static <T> T invokeStaticMethod(Class<?> targetClass, String methodName, List<Class<?>> argClasses, List<Object> args) {
        return InvokableReflectionUtils.invokeMethod(null, targetClass, methodName, argClasses, args);
    }

    public static <T> T invokeStaticMethod(Class<?> targetClass, String methodName, List<Object> args) {
        return InvokableReflectionUtils.invokeMethod(null, targetClass, methodName, args);
    }

    public static <T> T invokeStaticMethod(Class<?> targetClass, String methodName, Object ... args) {
        return InvokableReflectionUtils.invokeMethod(null, targetClass, methodName, args);
    }

    public static <T> T invokeStaticMethod(Method method, Object ... args) {
        return InvokableReflectionUtils.invokeMethod(null, method, args);
    }

    public static <T> T newInstance(Class<T> type, List<Class<?>> argsClasses, List<Object> args) {
        return InvokableReflectionUtils.newInstance(type, argsClasses, args.toArray());
    }

    public static <T> T newInstance(Class<T> type, List<Class<?>> argsClasses, Object ... args) {
        try {
            Constructor<?> constructor = MetadataReflectionUtils.getConstructor(type, argsClasses.toArray(new Class[0]));
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(args);
            constructor.setAccessible(false);
            return (T)instance;
        }
        catch (Exception e) {
            throw new ReflectionOperationException(e);
        }
    }

    public static <T> T newInstance(Class<T> type, List<Object> args) {
        List<Class<?>> argumentClasses = CollectionUtils.mapToList(args, Object::getClass);
        return InvokableReflectionUtils.newInstance(type, argumentClasses, args);
    }

    public static <T> T newInstance(Class<T> type, Object ... args) {
        return InvokableReflectionUtils.newInstance(type, Arrays.asList(args));
    }

    public static <T> T newInstance(Class<T> type) {
        return InvokableReflectionUtils.newInstance(type, new ArrayList[0]);
    }
}

