/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.util.Map;
import lombok.Generated;

final class ClassParentsInfo {
    private final Class<?> currentClass;
    private final Map<Class<?>, Integer> levelByType;

    public boolean canBeCastTo(Class<?> typeToCast) {
        return typeToCast.isAssignableFrom(this.currentClass);
    }

    public Integer getHierarchyDiffLength(Class<?> type) {
        Integer level = this.levelByType.get(type);
        if (level == null) {
            throw new IllegalArgumentException("Cannot find class " + type.getCanonicalName() + " as super type for: " + this.currentClass.getCanonicalName());
        }
        return level;
    }

    @Generated
    public ClassParentsInfo(Class<?> currentClass, Map<Class<?>, Integer> levelByType) {
        this.currentClass = currentClass;
        this.levelByType = levelByType;
    }

    @Generated
    public Class<?> getCurrentClass() {
        return this.currentClass;
    }

    @Generated
    public Map<Class<?>, Integer> getLevelByType() {
        return this.levelByType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassParentsInfo)) {
            return false;
        }
        ClassParentsInfo other = (ClassParentsInfo)o;
        Class<?> this$currentClass = this.getCurrentClass();
        Class<?> other$currentClass = other.getCurrentClass();
        if (this$currentClass == null ? other$currentClass != null : !this$currentClass.equals(other$currentClass)) {
            return false;
        }
        Map<Class<?>, Integer> this$levelByType = this.getLevelByType();
        Map<Class<?>, Integer> other$levelByType = other.getLevelByType();
        return !(this$levelByType == null ? other$levelByType != null : !((Object)this$levelByType).equals(other$levelByType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $currentClass = this.getCurrentClass();
        result = result * 59 + ($currentClass == null ? 43 : $currentClass.hashCode());
        Map<Class<?>, Integer> $levelByType = this.getLevelByType();
        result = result * 59 + ($levelByType == null ? 43 : ((Object)$levelByType).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClassParentsInfo(currentClass=" + this.getCurrentClass() + ", levelByType=" + this.getLevelByType() + ")";
    }
}

