/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.file;

import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.file.FileCursor;
import pl.jalokim.utils.file.FileException;
import pl.jalokim.utils.string.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static String readAsText(String path) {
        return FileUtils.readAsText(new File(path));
    }

    public static String readAsText(String path, Charset charset) {
        return FileUtils.readAsText(new File(path), charset);
    }

    public static String readAsText(File file) {
        return FileUtils.readAsText(file.toPath());
    }

    public static String readAsText(File file, Charset charset) {
        return FileUtils.readAsText(file.toPath(), charset);
    }

    public static String readAsText(Path path) {
        return FileUtils.readAsText(path, StandardCharsets.UTF_8);
    }

    public static String readAsText(Path path, Charset charset) {
        return FileUtils.catchIoExAndReturn(() -> new String(Files.readAllBytes(path), charset));
    }

    public static String readAsTextFromClassPath(String path) {
        return FileUtils.readAsTextFromClassPath(path, StandardCharsets.UTF_8);
    }

    public static String readAsTextFromClassPath(String path, Charset charset) {
        return FileUtils.catchIoExAndReturn(() -> {
            URL url = Resources.getResource(path);
            return Resources.toString(url, charset);
        });
    }

    public static Elements<String> readAsElements(String path) {
        return FileUtils.readAsElements(path, StandardCharsets.UTF_8);
    }

    public static Elements<String> readAsElements(Path path) {
        return FileUtils.readAsElements(path, StandardCharsets.UTF_8);
    }

    public static Elements<String> readAsElements(File path) {
        return FileUtils.readAsElements(path, StandardCharsets.UTF_8);
    }

    public static Elements<String> readAsElements(File path, Charset charset) {
        return FileUtils.readAsElements(path.toString(), charset);
    }

    public static Elements<String> readAsElements(Path path, Charset charset) {
        return FileUtils.readAsElements(path.toString(), charset);
    }

    public static Elements<String> readAsElements(String path, Charset charset) {
        return Elements.elements(FileUtils.catchIoExAndReturn(() -> Files.lines(Paths.get(path, new String[0]), charset)));
    }

    public static List<String> readAsList(String path) {
        return FileUtils.readAsList(path, StandardCharsets.UTF_8);
    }

    public static List<String> readAsList(File file) {
        return FileUtils.readAsList(file, StandardCharsets.UTF_8);
    }

    public static List<String> readAsList(Path path) {
        return FileUtils.readAsList(path, StandardCharsets.UTF_8);
    }

    public static List<String> readAsList(File file, Charset charset) {
        return FileUtils.readAsList(file.toString(), charset);
    }

    public static List<String> readAsList(Path path, Charset charset) {
        return FileUtils.readAsList(path.toString(), charset);
    }

    public static List<String> readAsList(String path, Charset charset) {
        ArrayList<String> lines = new ArrayList<String>();
        FileUtils.consumeEveryLineFromFile(path, lines::add, charset);
        return lines;
    }

    public static void consumeEveryLineFromFile(String path, Consumer<String> consumerLine) {
        FileUtils.consumeEveryLineFromFile(path, consumerLine, StandardCharsets.UTF_8);
    }

    public static void consumeEveryLineFromFile(String path, Consumer<String> consumerLine, Charset charset) {
        FileUtils.catchIoExAndReturn(() -> {
            try (BufferedReader br = Files.newBufferedReader(Paths.get(path, new String[0]), charset);){
                String line;
                while ((line = br.readLine()) != null) {
                    consumerLine.accept(line);
                }
            }
            return null;
        });
    }

    public static void consumeEveryLineWitNumberFromFile(String path, BiConsumer<Long, String> consumerLineIndex) {
        FileUtils.consumeEveryLineWitNumberFromFile(path, consumerLineIndex, StandardCharsets.UTF_8);
    }

    public static void consumeEveryLineWitNumberFromFile(String path, BiConsumer<Long, String> consumerLineIndex, Charset charset) {
        FileUtils.catchIoExAndReturn(() -> {
            long index = 0L;
            try (BufferedReader br = Files.newBufferedReader(Paths.get(path, new String[0]), charset);){
                String line;
                while ((line = br.readLine()) != null) {
                    consumerLineIndex.accept(++index, line);
                }
            }
            return null;
        });
    }

    public static FileCursor readFileFromPathToFileCursor(String path) {
        return new FileCursor(path);
    }

    public static FileCursor readFileFromPathToFileCursor(String path, Charset charset) {
        return new FileCursor(path, charset);
    }

    public static void writeToFile(String filePath, String fileContent) {
        FileUtils.writeToFile(new File(filePath), fileContent);
    }

    public static void writeToFile(String filePath, String fileContent, Charset charset) {
        FileUtils.writeToFile(new File(filePath), fileContent, charset);
    }

    public static void writeToFile(File filePath, String fileContent) {
        FileUtils.writeToFile(filePath.toPath(), fileContent);
    }

    public static void writeToFile(File filePath, String fileContent, Charset charset) {
        FileUtils.writeToFile(filePath.toPath(), fileContent, charset);
    }

    public static void writeToFile(Path filePath, String fileContent) {
        FileUtils.writeToFile(filePath, fileContent, StandardCharsets.UTF_8);
    }

    public static void writeToFile(Path filePath, String fileContent, Charset charset) {
        byte[] strToBytes = fileContent.getBytes(charset);
        FileUtils.catchIoExAndReturn(() -> Files.write(filePath, strToBytes, new OpenOption[0]));
    }

    public static void writeToFile(String filePath, List<String> elementsToWrite) {
        FileUtils.writeToFile(filePath, elementsToWrite, StandardCharsets.UTF_8);
    }

    public static void writeToFile(String filePath, Elements<String> elementsToWrite) {
        FileUtils.writeToFile(filePath, elementsToWrite, StandardCharsets.UTF_8);
    }

    public static void writeToFile(String filePath, Elements<String> elementsToWrite, Charset charset) {
        FileUtils.writeToFile(filePath, elementsToWrite.asList(), charset);
    }

    public static void writeToFile(String filePath, List<String> elementToWrite, Charset charset) {
        Path path = Paths.get(filePath, new String[0]);
        String fileContent = StringUtils.concatElementsAsLines(elementToWrite);
        byte[] strToBytes = fileContent.getBytes(charset);
        FileUtils.catchIoExAndReturn(() -> Files.write(path, strToBytes, new OpenOption[0]));
    }

    public static void appendToFile(File filePath, List<String> elementToWrite) {
        FileUtils.appendToFile(filePath.toString(), elementToWrite, StandardCharsets.UTF_8);
    }

    public static void appendToFile(Path filePath, List<String> elementToWrite) {
        FileUtils.appendToFile(filePath.toString(), elementToWrite, StandardCharsets.UTF_8);
    }

    public static void appendToFile(String filePath, List<String> elementToWrite) {
        FileUtils.appendToFile(filePath, elementToWrite, StandardCharsets.UTF_8);
    }

    public static void appendToFile(String filePath, List<String> elementToWrite, Charset charset) {
        Path path = Paths.get(filePath, new String[0]);
        String fileContent = StringUtils.concatElementsAsLines(elementToWrite);
        byte[] strToBytes = fileContent.getBytes(charset);
        FileUtils.catchIoExAndReturn(() -> Files.write(path, strToBytes, StandardOpenOption.APPEND, StandardOpenOption.CREATE));
    }

    public static void appendToFile(File filePath, String fileContent) {
        FileUtils.appendToFile(filePath, fileContent, StandardCharsets.UTF_8);
    }

    public static void appendToFile(Path filePath, String fileContent) {
        FileUtils.appendToFile(filePath, fileContent, StandardCharsets.UTF_8);
    }

    public static void appendToFile(String filePath, String fileContent) {
        FileUtils.appendToFile(filePath, fileContent, StandardCharsets.UTF_8);
    }

    public static void appendToFile(Path filePath, String fileContent, Charset charset) {
        FileUtils.appendToFile(filePath.toString(), fileContent, charset);
    }

    public static void appendToFile(File filePath, String fileContent, Charset charset) {
        FileUtils.appendToFile(filePath.toString(), fileContent, charset);
    }

    public static void appendToFile(String filePath, String fileContent, Charset charset) {
        Path path = Paths.get(filePath, new String[0]);
        byte[] strToBytes = fileContent.getBytes(charset);
        FileUtils.catchIoExAndReturn(() -> Files.write(path, strToBytes, StandardOpenOption.APPEND, StandardOpenOption.CREATE));
    }

    public static void createDirectoriesForFile(File pathToFile) {
        FileUtils.createDirectoriesForFile(pathToFile.toString());
    }

    public static void createDirectoriesForFile(Path pathToFile) {
        FileUtils.createDirectoriesForFile(pathToFile.toString());
    }

    public static void createDirectoriesForFile(String pathToFile) {
        Path folderPath = Paths.get(pathToFile, new String[0]).getParent();
        if (folderPath != null) {
            FileUtils.catchIoExAndReturn(() -> Files.createDirectories(folderPath, new FileAttribute[0]));
        }
    }

    public static void createDirectories(File folderPath) {
        FileUtils.createDirectories(folderPath.toString());
    }

    public static void createDirectories(Path folderPath) {
        FileUtils.createDirectories(folderPath.toString());
    }

    public static void createDirectories(String folderPath) {
        FileUtils.catchIoExAndReturn(() -> Files.createDirectories(Paths.get(folderPath, new String[0]), new FileAttribute[0]));
    }

    public static List<File> listOfFiles(String pathToFile) {
        return FileUtils.listOfFiles(new File(pathToFile));
    }

    public static List<File> listOfFiles(Path path) {
        return FileUtils.listOfFiles(path.toFile());
    }

    public static List<File> listOfFiles(File rootFile) {
        return FileUtils.listOfFiles(rootFile, (File file) -> true);
    }

    public static List<File> listOfFiles(String pathToFile, FileFilter fileFilter) {
        return FileUtils.listOfFiles(new File(pathToFile), fileFilter);
    }

    public static List<File> listOfFiles(Path path, FileFilter fileFilter) {
        return FileUtils.listOfFiles(path.toFile(), fileFilter);
    }

    public static List<File> listOfFiles(File rootFile, FileFilter fileFilter) {
        File[] files = rootFile.listFiles();
        if (files == null) {
            throw new FileException("Provided path: " + rootFile.getAbsolutePath() + " does not exist");
        }
        return ((Elements)Elements.elements(files).filter(fileFilter::accept)).asList();
    }

    public static List<Path> listOfFilesRecursively(File rootFile) {
        return FileUtils.listOfFilesRecursively(rootFile, (Path f) -> true);
    }

    public static List<Path> listOfFilesRecursively(Path rootFile) {
        return FileUtils.listOfFilesRecursively(rootFile, (Path f) -> true);
    }

    public static List<Path> listOfFilesRecursively(String rootFile) {
        return FileUtils.listOfFilesRecursively(rootFile, (Path f) -> true);
    }

    public static List<Path> listOfFilesRecursively(File rootFile, Predicate<Path> fileFilter) {
        return FileUtils.listOfFilesRecursively(rootFile.toPath(), fileFilter);
    }

    public static List<Path> listOfFilesRecursively(String rootFile, Predicate<Path> fileFilter) {
        return FileUtils.listOfFilesRecursively(Paths.get(rootFile, new String[0]), fileFilter);
    }

    public static List<Path> listOfFilesRecursively(Path rootFile, Predicate<Path> fileFilter) {
        return Elements.elements(FileUtils.catchIoExAndReturn(() -> Files.walk(rootFile, new FileVisitOption[0]).filter(fileFilter))).asList();
    }

    public static void deleteFileOrDirectory(String pathAsText) {
        FileUtils.deleteFileOrDirectory(new File(pathAsText));
    }

    public static void deleteFileOrDirectory(File file) {
        boolean deleted;
        if (file.isDirectory()) {
            List<File> files = FileUtils.listOfFiles(file);
            for (File childField : files) {
                FileUtils.deleteFileOrDirectory(childField);
            }
        }
        if (!(deleted = file.delete())) {
            throw new FileException("cannot delete file: " + file.getAbsolutePath());
        }
    }

    public static void deleteFileOrDirectory(Path path) {
        FileUtils.deleteFileOrDirectory(path.toFile());
    }

    static <T> T catchIoExAndReturn(IOExceptionSupplier<T> throwableSupplier) {
        try {
            return throwableSupplier.get();
        }
        catch (IOException ex) {
            throw new FileException(ex);
        }
    }

    static void catchIoEx(IOExceptionRunnable ioExceptionRunnable) {
        try {
            ioExceptionRunnable.run();
        }
        catch (IOException ex) {
            throw new FileException(ex);
        }
    }

    @FunctionalInterface
    static interface IOExceptionRunnable {
        public void run() throws IOException;
    }

    @FunctionalInterface
    static interface IOExceptionSupplier<T> {
        public T get() throws IOException;
    }
}

