/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.collection.IndexedElement;
import pl.jalokim.utils.file.FileUtils;
import pl.jalokim.utils.string.StringUtils;

public final class Elements<T>
implements Stream<T> {
    private final Stream<T> stream;

    private Elements(@Nullable Stream<T> stream) {
        this.stream = Optional.ofNullable(stream).orElse(Stream.empty());
    }

    public static <T> Elements<T> elements(@Nullable Iterable<T> iterable) {
        return new Elements(Optional.ofNullable(iterable).map((? super T nonNullIterable) -> StreamSupport.stream(nonNullIterable.spliterator(), false)).orElse(Stream.empty()));
    }

    public static <T> Elements<T> elements(@Nullable Iterator<T> iterator) {
        return Optional.ofNullable(iterator).map((? super T nonNullIterator) -> Elements.elements(() -> iterator)).orElse(Elements.empty());
    }

    public static <T> Elements<T> elements(T ... array) {
        return new Elements<T>(Optional.ofNullable(array).map(Stream::of).orElse(Elements.empty()));
    }

    public static <T> Elements<T> elements(@Nullable Stream<T> stream) {
        return new Elements<T>(stream);
    }

    @Override
    public Elements<T> filter(Predicate<? super T> predicate) {
        return new Elements<T>(this.stream.filter(predicate));
    }

    @Override
    public <R> Elements<R> map(Function<? super T, ? extends R> mapper) {
        return new Elements<R>(this.stream.map(mapper));
    }

    public <R> Elements<R> mapWithIndex(BiFunction<Integer, ? super T, ? extends R> mapper) {
        ArrayList<R> resultList = new ArrayList<R>();
        List<T> sourceList = new Elements<T>(this.stream).asList();
        for (int index = 0; index < sourceList.size(); ++index) {
            resultList.add(mapper.apply(index, (Integer)sourceList.get(index)));
        }
        return Elements.elements(resultList);
    }

    @Override
    public <R> Elements<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Elements(this.stream.flatMap(mapper));
    }

    public <R> Elements<R> flatMapByElements(Function<? super T, ? extends Elements<? extends R>> mapper) {
        return new Elements(this.asStream().flatMap((? super T element) -> {
            Elements elements = (Elements)mapper.apply(element);
            return elements.asStream();
        }));
    }

    public <R> Elements<R> flatMapByIterables(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return new Elements(this.asStream().flatMap((? super T element) -> {
            Iterable newIterable = (Iterable)mapper.apply(element);
            return Elements.elements(newIterable).asStream();
        }));
    }

    public <R> Elements<R> flatMapByArray(Function<? super T, R[]> mapper) {
        return new Elements(this.asStream().flatMap((? super T element) -> {
            Object[] array = (Object[])mapper.apply(element);
            return Elements.elements(array).asStream();
        }));
    }

    public T getFirst() {
        return this.stream.findFirst().get();
    }

    public T getLast() {
        return CollectionUtils.getLast(this.asList());
    }

    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList(this.stream.collect(Collectors.toList())));
    }

    public Set<T> asSet() {
        return Collections.unmodifiableSet(new HashSet(this.stream.collect(Collectors.toSet())));
    }

    public <K> Map<K, T> asMap(Function<? super T, ? extends K> keyMapper) {
        return this.stream.collect(Collectors.toMap(keyMapper, Function.identity()));
    }

    public <K, V> Map<K, V> asMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return this.stream.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public <K> Map<K, List<T>> asMapGroupedBy(Function<? super T, ? extends K> keyMapper) {
        return this.stream.collect(Collectors.groupingBy(keyMapper));
    }

    public T[] asArray(T[] array) {
        return this.stream.collect(Collectors.toList()).toArray(array);
    }

    public Stream<T> asStream() {
        return this.stream;
    }

    public void writeToFile(String filePath) {
        FileUtils.writeToFile(filePath, (Elements<String>)this.map(Objects::toString));
    }

    public String toString() {
        return this.asText();
    }

    public String asText() {
        return this.asText(StringUtils.concat(",", " "));
    }

    public String asText(String joinText) {
        return StringUtils.concatElements("[", this.asList(), joinText, "]");
    }

    public String asConcatText(String joinText) {
        return StringUtils.concatElements(this.asList(), joinText);
    }

    public String concatWithNewLines() {
        return this.asConcatText(System.lineSeparator());
    }

    public void forEach(BiConsumer<Integer, T> consumer) {
        AtomicInteger currentIndex = new AtomicInteger();
        this.stream.forEach((? super T element) -> consumer.accept(currentIndex.getAndIncrement(), element));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.stream.forEachOrdered(action);
    }

    public void forEachWithIndexed(Consumer<IndexedElement<T>> consumer) {
        List<T> elements = this.asList();
        int index = 0;
        for (T element : elements) {
            consumer.accept(new IndexedElement<T>(index, element, index == 0, CollectionUtils.isLastIndex(elements, index)));
            ++index;
        }
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.stream.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.stream.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.stream.mapToDouble(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.stream.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.stream.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.stream.flatMapToDouble(mapper);
    }

    @Override
    public Elements<T> distinct() {
        return Elements.elements(this.stream.distinct());
    }

    @Override
    public Elements<T> sorted() {
        return Elements.elements(this.stream.sorted());
    }

    @Override
    public Elements<T> sorted(Comparator<? super T> comparator) {
        return Elements.elements(this.stream.sorted(comparator));
    }

    @Override
    public Elements<T> peek(Consumer<? super T> action) {
        return Elements.elements(this.stream.peek(action));
    }

    @Override
    public Elements<T> limit(long maxSize) {
        return Elements.elements(this.stream.limit(maxSize));
    }

    @Override
    public Elements<T> skip(long n) {
        return Elements.elements(this.stream.skip(n));
    }

    @Override
    public Object[] toArray() {
        return this.stream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream.toArray(generator);
    }

    public <A> A[] toArray(A ... aTable) {
        return this.asList().toArray(aTable);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.stream.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.stream.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.stream.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.stream.max(comparator);
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.stream.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.stream.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.stream.findAny();
    }

    public Elements<T> concat(Stream<? extends T> toConcat) {
        return Elements.concat(this, toConcat);
    }

    public static <T> Elements<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        return Elements.elements(Stream.concat(a, b));
    }

    public static <T> Elements<T> empty() {
        return Elements.elements(Stream.empty());
    }

    public static <T> Elements<T> of(T t1) {
        return Elements.elements(Stream.of(t1));
    }

    @SafeVarargs
    public static <T> Elements<T> of(T ... values) {
        return Elements.elements(values);
    }

    public static <T> Elements<T> iterate(T seed, UnaryOperator<T> f) {
        return Elements.elements(Stream.iterate(seed, f));
    }

    public static <T> Elements<T> generate(Supplier<? extends T> s) {
        Stream<? extends T> generate = Stream.generate(s);
        return Elements.elements(generate);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public Elements<T> sequential() {
        return Elements.elements((Stream)this.stream.sequential());
    }

    @Override
    public Elements<T> parallel() {
        return Elements.elements((Stream)this.stream.parallel());
    }

    @Override
    public Elements<T> unordered() {
        return Elements.elements((Stream)this.stream.unordered());
    }

    @Override
    public Elements<T> onClose(Runnable closeHandler) {
        return Elements.elements((Stream)this.stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

