/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import pl.jalokim.propertiestojson.AlgorithmType;
import pl.jalokim.propertiestojson.JsonObjectsTraverseResolver;
import pl.jalokim.propertiestojson.helper.PropertiesWithInsertOrder;
import pl.jalokim.propertiestojson.helper.PropertyKeysOrderResolver;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.path.PathMetadataBuilder;
import pl.jalokim.propertiestojson.resolvers.ArrayJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.JsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.ObjectJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.PrimitiveJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.StringJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.adapter.PrimitiveJsonTypeResolverToNewApiAdapter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NullToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.StringToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToEmptyStringResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToJsonNullReferenceResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToStringResolver;
import pl.jalokim.propertiestojson.util.PropertiesToJsonConverterBuilder;
import pl.jalokim.propertiestojson.util.exception.ParsePropertiesException;
import pl.jalokim.propertiestojson.util.exception.ReadInputException;

public final class PropertiesToJsonConverter {
    private final NullToJsonTypeConverter nullToJsonConverter;
    private final TextToJsonNullReferenceResolver textToJsonNullResolver;
    private final TextToEmptyStringResolver textToEmptyStringResolver;
    private final Map<AlgorithmType, JsonTypeResolver> algorithms = new HashMap<AlgorithmType, JsonTypeResolver>();
    private final PrimitiveJsonTypesResolver primitiveResolvers;
    private final Charset charsetToUse;
    private PropertyKeysOrderResolver propertyKeysOrderResolver = new PropertyKeysOrderResolver();

    public PropertiesToJsonConverter() {
        this(PropertiesToJsonConverterBuilder.TO_OBJECT_RESOLVERS, PropertiesToJsonConverterBuilder.TO_JSON_TYPE_CONVERTERS);
    }

    @Deprecated
    public PropertiesToJsonConverter(PrimitiveJsonTypeResolver<?> ... customPrimitiveResolvers) {
        this(PropertiesToJsonConverter.convertToNewResolvers(customPrimitiveResolvers), PropertiesToJsonConverter.convertToNewConverters(customPrimitiveResolvers));
    }

    public PropertiesToJsonConverter(List<TextToConcreteObjectResolver<?>> toObjectsResolvers, List<ObjectToJsonTypeConverter<?>> toJsonTypeResolvers) {
        this(toObjectsResolvers, toJsonTypeResolvers, NullToJsonTypeConverter.NULL_TO_JSON_RESOLVER, TextToJsonNullReferenceResolver.TEXT_TO_NULL_JSON_RESOLVER, TextToEmptyStringResolver.EMPTY_TEXT_RESOLVER, false);
    }

    public PropertiesToJsonConverter(List<TextToConcreteObjectResolver<?>> toObjectsResolvers, List<ObjectToJsonTypeConverter<?>> toJsonTypeResolvers, NullToJsonTypeConverter nullToJsonConverter, TextToJsonNullReferenceResolver textToJsonNullResolver, TextToEmptyStringResolver textToEmptyStringResolver, Boolean skipNull) {
        this(toObjectsResolvers, toJsonTypeResolvers, nullToJsonConverter, textToJsonNullResolver, textToEmptyStringResolver, skipNull, null);
    }

    public PropertiesToJsonConverter(List<TextToConcreteObjectResolver<?>> toObjectsResolvers, List<ObjectToJsonTypeConverter<?>> toJsonTypeResolvers, NullToJsonTypeConverter nullToJsonConverter, TextToJsonNullReferenceResolver textToJsonNullResolver, TextToEmptyStringResolver textToEmptyStringResolver, Boolean skipNull, Charset charset) {
        this.nullToJsonConverter = nullToJsonConverter;
        this.textToJsonNullResolver = textToJsonNullResolver;
        this.textToEmptyStringResolver = textToEmptyStringResolver;
        this.charsetToUse = Optional.ofNullable(charset).orElse(StandardCharsets.UTF_8);
        PropertiesToJsonConverter.validateTypeResolverOrder(toJsonTypeResolvers);
        this.primitiveResolvers = new PrimitiveJsonTypesResolver(this.buildAllToObjectResolvers(toObjectsResolvers), this.buildAllToJsonResolvers(toJsonTypeResolvers), skipNull, nullToJsonConverter);
        this.algorithms.put(AlgorithmType.OBJECT, new ObjectJsonTypeResolver());
        this.algorithms.put(AlgorithmType.PRIMITIVE, this.primitiveResolvers);
        this.algorithms.put(AlgorithmType.ARRAY, new ArrayJsonTypeResolver());
    }

    private static List<ObjectToJsonTypeConverter<?>> convertToNewConverters(PrimitiveJsonTypeResolver<?> ... customPrimitiveResolvers) {
        PropertiesToJsonConverter.validateTypeResolverOrder(customPrimitiveResolvers);
        return Arrays.stream(customPrimitiveResolvers).map(PrimitiveJsonTypeResolverToNewApiAdapter::new).collect(Collectors.toList());
    }

    private static List<TextToConcreteObjectResolver<?>> convertToNewResolvers(PrimitiveJsonTypeResolver<?> ... customPrimitiveResolvers) {
        return Arrays.stream(customPrimitiveResolvers).map(PrimitiveJsonTypeResolverToNewApiAdapter::new).collect(Collectors.toList());
    }

    private static String prettifyOfJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        return gson.toJson(je);
    }

    private static void checkKey(Map<String, Object> properties, Map<String, Object> filteredProperties, String key, String requiredKey) {
        if (key.equals(requiredKey) || key.startsWith(requiredKey) && PropertiesToJsonConverter.keyIsCompatibleWithRequiredKey(requiredKey, key)) {
            filteredProperties.put(key, properties.get(key));
        }
    }

    private static boolean keyIsCompatibleWithRequiredKey(String requiredKey, String key) {
        String testedChar = key.substring(requiredKey.length(), requiredKey.length() + 1);
        return "[".equals(testedChar) || ".".equals(testedChar);
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    private static Map<String, Object> propertiesToMap(Properties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object key : properties.keySet()) {
            map.put(key.toString(), properties.get(key));
        }
        return map;
    }

    private static void validateTypeResolverOrder(PrimitiveJsonTypeResolver<?> ... primitiveResolvers) {
        PrimitiveJsonTypeResolver<?> lastResolver;
        List<PrimitiveJsonTypeResolver<?>> resolvers = Arrays.asList(primitiveResolvers);
        boolean containStringResolverType = false;
        for (PrimitiveJsonTypeResolver<?> resolver : resolvers) {
            if (!resolver.getClass().equals(StringJsonTypeResolver.class)) continue;
            containStringResolverType = true;
        }
        if (containStringResolverType && !(lastResolver = resolvers.get(resolvers.size() - 1)).getClass().equals(StringJsonTypeResolver.class)) {
            throw new ParsePropertiesException(ParsePropertiesException.STRING_RESOLVER_AS_NOT_LAST);
        }
    }

    private static void validateTypeResolverOrder(List<ObjectToJsonTypeConverter<?>> resolvers) {
        ObjectToJsonTypeConverter<?> lastResolver;
        boolean containStringResolverType = false;
        for (ObjectToJsonTypeConverter<?> resolver : resolvers) {
            if (!resolver.getClass().equals(StringToJsonTypeConverter.class)) continue;
            containStringResolverType = true;
        }
        if (containStringResolverType && !(lastResolver = resolvers.get(resolvers.size() - 1)).getClass().equals(StringToJsonTypeConverter.class)) {
            throw new ParsePropertiesException(ParsePropertiesException.STRING_TO_JSON_RESOLVER_AS_NOT_LAST);
        }
    }

    private List<TextToConcreteObjectResolver<?>> buildAllToObjectResolvers(List<TextToConcreteObjectResolver<?>> resolvers) {
        ArrayList allResolvers = new ArrayList();
        allResolvers.add(this.textToJsonNullResolver);
        allResolvers.add(this.textToEmptyStringResolver);
        allResolvers.addAll(resolvers);
        allResolvers.add(TextToStringResolver.TO_STRING_RESOLVER);
        return allResolvers;
    }

    private List<ObjectToJsonTypeConverter<?>> buildAllToJsonResolvers(List<ObjectToJsonTypeConverter<?>> toJsonTypeResolvers) {
        ArrayList mergedToJsonTypeConverters = new ArrayList(toJsonTypeResolvers);
        mergedToJsonTypeConverters.add(StringToJsonTypeConverter.STRING_TO_JSON_RESOLVER);
        mergedToJsonTypeConverters.add(this.nullToJsonConverter);
        return mergedToJsonTypeConverters;
    }

    public String convertPropertiesFromFileToJson(String pathToFile) {
        return this.convertPropertiesFromFileToJson(new File(pathToFile));
    }

    public String convertPropertiesFromFileToJson(String pathToFile, String ... includeDomainKeys) {
        return this.convertPropertiesFromFileToJson(new File(pathToFile), includeDomainKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertPropertiesFromFileToJson(File file) {
        try (InputStream targetStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = this.convertToJson(targetStream);
            return string;
        }
        catch (IOException e) {
            throw new ReadInputException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertPropertiesFromFileToJson(File file, String ... includeDomainKeys) {
        try (InputStream targetStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = this.convertToJson(targetStream, includeDomainKeys);
            return string;
        }
        catch (IOException e) {
            throw new ReadInputException(e);
        }
    }

    public String convertToJson(InputStream inputStream) {
        return this.convertToJson(this.inputStreamToProperties(inputStream));
    }

    public String convertToJson(InputStream inputStream, String ... includeDomainKeys) {
        return this.convertToJson(this.inputStreamToProperties(inputStream), includeDomainKeys);
    }

    public String convertToJson(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() instanceof String) continue;
            throw new ParsePropertiesException(String.format("Unsupported property key type: %s for key: %s, Property key needs to be a string type", entry.getKey().getClass(), entry.getKey() == null ? "null" : entry.getKey()));
        }
        return this.convertFromValuesAsObjectMap(PropertiesToJsonConverter.propertiesToMap(properties));
    }

    public String convertToJson(Properties properties, boolean tryConvertStringValuesToOtherObjects) {
        if (tryConvertStringValuesToOtherObjects) {
            PropertiesWithInsertOrder innerProperties = new PropertiesWithInsertOrder();
            for (String property : this.getAllKeysFromProperties(PropertiesToJsonConverter.propertiesToMap(properties))) {
                Object propertyValue = properties.get(property);
                if (propertyValue instanceof String) {
                    propertyValue = this.primitiveResolvers.getResolvedObject((String)propertyValue, property);
                }
                ((Properties)innerProperties).put(property, propertyValue);
            }
            return this.convertToJson(innerProperties);
        }
        return this.convertToJson(properties);
    }

    public String convertToJson(Properties properties, String ... includeDomainKeys) {
        return this.convertFromValuesAsObjectMap(PropertiesToJsonConverter.propertiesToMap(properties), includeDomainKeys);
    }

    public String convertToJson(Map<String, String> properties) {
        return this.convertFromValuesAsObjectMap(this.stringValueMapToObjectValueMap(properties));
    }

    public String convertToJson(Map<String, String> properties, String ... includeDomainKeys) {
        return this.convertFromValuesAsObjectMap(this.stringValueMapToObjectValueMap(properties), includeDomainKeys);
    }

    public String convertFromValuesAsObjectMap(Map<String, Object> properties) {
        ObjectJsonType coreObjectJsonType = new ObjectJsonType();
        for (String propertyKey : this.getAllKeysFromProperties(properties)) {
            this.addFieldsToJsonObject(properties, coreObjectJsonType, propertyKey);
        }
        return PropertiesToJsonConverter.prettifyOfJson(coreObjectJsonType.toStringJson());
    }

    public String convertFromValuesAsObjectMap(Map<String, Object> properties, boolean tryConvertStringValuesToOtherObjects) {
        if (tryConvertStringValuesToOtherObjects) {
            PropertiesWithInsertOrder innerProperties = new PropertiesWithInsertOrder();
            for (String property : this.getAllKeysFromProperties(properties)) {
                Object propertyValue = properties.get(property);
                if (propertyValue instanceof String) {
                    propertyValue = this.primitiveResolvers.getResolvedObject((String)propertyValue, property);
                }
                ((Properties)innerProperties).put(property, propertyValue);
            }
            return this.convertToJson(innerProperties);
        }
        return this.convertFromValuesAsObjectMap(properties);
    }

    public String convertFromValuesAsObjectMap(Map<String, Object> properties, String ... includeDomainKeys) {
        LinkedHashMap<String, Object> filteredProperties = new LinkedHashMap<String, Object>();
        for (String key : properties.keySet()) {
            for (String requiredKey : includeDomainKeys) {
                PropertiesToJsonConverter.checkKey(properties, filteredProperties, key, requiredKey);
            }
        }
        return this.convertFromValuesAsObjectMap(filteredProperties);
    }

    public void setPropertyKeysOrderResolver(PropertyKeysOrderResolver propertyKeysOrderResolver) {
        Objects.requireNonNull(propertyKeysOrderResolver);
        this.propertyKeysOrderResolver = propertyKeysOrderResolver;
    }

    private Properties inputStreamToProperties(InputStream inputStream) {
        PropertiesWithInsertOrder propertiesWithConvertedValues = new PropertiesWithInsertOrder();
        PropertiesWithInsertOrder properties = new PropertiesWithInsertOrder();
        try {
            properties.load(new InputStreamReader(inputStream, this.charsetToUse));
            for (String property : this.getAllKeysFromProperties(PropertiesToJsonConverter.propertiesToMap(properties))) {
                Object object = this.primitiveResolvers.getResolvedObject((String)properties.get(property), property);
                ((Properties)propertiesWithConvertedValues).put(property, object);
            }
        }
        catch (IOException e) {
            throw new ReadInputException(e);
        }
        return propertiesWithConvertedValues;
    }

    private void addFieldsToJsonObject(Map<String, Object> properties, ObjectJsonType coreObjectJsonType, String propertyKey) {
        PathMetadata rootPathMetaData = PathMetadataBuilder.createRootPathMetaData(propertyKey);
        new JsonObjectsTraverseResolver(this.algorithms, properties, propertyKey, rootPathMetaData, coreObjectJsonType).initializeFieldsInJson();
    }

    private List<String> getAllKeysFromProperties(Map<String, ?> properties) {
        return this.propertyKeysOrderResolver.getKeysInExpectedOrder(properties);
    }

    private Map<String, Object> stringValueMapToObjectValueMap(Map<String, String> properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String property : this.getAllKeysFromProperties(properties)) {
            Object object = this.primitiveResolvers.getResolvedObject(properties.get(property), property);
            map.put(property, object);
        }
        return map;
    }
}

