/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.object;

import com.google.gson.JsonElement;
import java.util.Optional;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.JsonNullReferenceType;
import pl.jalokim.propertiestojson.object.StringJsonType;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.object.AbstractObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.utils.JsonObjectHelper;

public class SuperObjectToJsonTypeConverter
extends AbstractObjectToJsonTypeConverter<Object> {
    public static AbstractJsonType convertFromObjectToJson(Object propertyValue, String propertyKey) {
        return SuperObjectToJsonTypeConverter.convertToObjectArrayOrJsonText(JsonObjectHelper.toJsonElement(JsonObjectHelper.toJson(propertyValue)), propertyKey);
    }

    private static AbstractJsonType convertToObjectArrayOrJsonText(JsonElement someField, String propertyKey) {
        AbstractJsonType valueOfNextField = null;
        if (someField.isJsonNull()) {
            valueOfNextField = JsonNullReferenceType.NULL_OBJECT;
        }
        if (someField.isJsonObject()) {
            valueOfNextField = JsonObjectHelper.createObjectJsonType(someField, propertyKey);
        }
        if (someField.isJsonArray()) {
            valueOfNextField = JsonObjectHelper.createArrayJsonType(someField, propertyKey);
        }
        if (someField.isJsonPrimitive()) {
            return new StringJsonType(someField.toString());
        }
        return valueOfNextField;
    }

    @Override
    public Optional<AbstractJsonType> convertToJsonTypeOrEmpty(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, Object propertyValue, String propertyKey) {
        if (AbstractJsonType.class.isAssignableFrom(propertyValue.getClass())) {
            return Optional.of((AbstractJsonType)propertyValue);
        }
        return Optional.of(SuperObjectToJsonTypeConverter.convertFromObjectToJson(propertyValue, propertyKey));
    }
}

