/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.custom;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;

public class TextToLocalDateResolver
implements TextToConcreteObjectResolver<LocalDate> {
    private static final String DATE_FORMAT = "dd-MM-yyyy";
    private final DateTimeFormatter formatter;

    public TextToLocalDateResolver() {
        this(DATE_FORMAT);
    }

    public TextToLocalDateResolver(String formatOfDate) {
        this.formatter = DateTimeFormatter.ofPattern(formatOfDate);
    }

    @Override
    public Optional<LocalDate> returnObjectWhenCanBeResolved(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, String propertyValue, String propertyKey) {
        try {
            return Optional.ofNullable(LocalDate.parse(propertyValue, this.formatter));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }
}

