/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers;

import pl.jalokim.propertiestojson.JsonObjectFieldsValidator;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.resolvers.JsonTypeResolver;

public class ObjectJsonTypeResolver
extends JsonTypeResolver {
    @Override
    public ObjectJsonType traverse(PathMetadata currentPathMetaData) {
        this.fetchJsonObjectOrCreate(currentPathMetaData);
        return this.currentObjectJsonType;
    }

    private void fetchJsonObjectOrCreate(PathMetadata currentPathMetaData) {
        if (this.currentObjectJsonType.containsField(currentPathMetaData.getFieldName())) {
            this.fetchJsonObjectWhenIsNotPrimitive(currentPathMetaData);
        } else {
            this.createNewJsonObjectAndAssignToCurrent(currentPathMetaData);
        }
    }

    private void createNewJsonObjectAndAssignToCurrent(PathMetadata currentPathMetaData) {
        ObjectJsonType nextObjectJsonType = new ObjectJsonType();
        this.currentObjectJsonType.addField(currentPathMetaData.getFieldName(), nextObjectJsonType, currentPathMetaData);
        this.currentObjectJsonType = nextObjectJsonType;
    }

    private void fetchJsonObjectWhenIsNotPrimitive(PathMetadata currentPathMetaData) {
        AbstractJsonType jsonType = this.currentObjectJsonType.getField(currentPathMetaData.getFieldName());
        JsonObjectFieldsValidator.checkEarlierWasJsonObject(this.propertyKey, currentPathMetaData, jsonType);
        this.currentObjectJsonType = (ObjectJsonType)jsonType;
    }
}

