/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers;

import java.util.List;
import pl.jalokim.propertiestojson.JsonObjectFieldsValidator;
import pl.jalokim.propertiestojson.PropertyArrayHelper;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ArrayJsonType;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.resolvers.JsonTypeResolver;
import pl.jalokim.utils.collection.CollectionUtils;

public class ArrayJsonTypeResolver
extends JsonTypeResolver {
    @Override
    public ObjectJsonType traverse(PathMetadata currentPathMetaData) {
        this.fetchJsonObjectAndCreateArrayWhenNotExist(currentPathMetaData);
        return this.currentObjectJsonType;
    }

    private void fetchJsonObjectAndCreateArrayWhenNotExist(PathMetadata currentPathMetaData) {
        if (this.isArrayExist(currentPathMetaData.getFieldName())) {
            this.fetchArrayAndAddElement(currentPathMetaData);
        } else {
            this.createArrayAndAddElement(currentPathMetaData);
        }
    }

    private boolean isArrayExist(String field) {
        return this.currentObjectJsonType.containsField(field);
    }

    private void fetchArrayAndAddElement(PathMetadata currentPathMetaData) {
        PropertyArrayHelper propertyArrayHelper = currentPathMetaData.getPropertyArrayHelper();
        ArrayJsonType arrayJsonType = this.getArrayJsonWhenIsValid(currentPathMetaData);
        List<Integer> dimIndexes = propertyArrayHelper.getDimensionalIndexes();
        ArrayJsonType currentArray = arrayJsonType;
        for (int index = 0; index < dimIndexes.size(); ++index) {
            if (CollectionUtils.isLastIndex(dimIndexes, index)) {
                int lastDimIndex = dimIndexes.get(index);
                if (currentArray.existElementByGivenIndex(lastDimIndex)) {
                    this.fetchJsonObjectWhenIsValid(currentPathMetaData, lastDimIndex, currentArray);
                    continue;
                }
                this.createJsonObjectAndAddToArray(lastDimIndex, currentArray, currentPathMetaData);
                continue;
            }
            currentArray = ArrayJsonType.createOrGetNextDimensionOfArray(currentArray, dimIndexes, index, currentPathMetaData);
        }
    }

    private void createJsonObjectAndAddToArray(int index, ArrayJsonType arrayJsonType, PathMetadata currentPathMetaData) {
        ObjectJsonType nextObjectJsonType = new ObjectJsonType();
        arrayJsonType.addElement(index, (AbstractJsonType)nextObjectJsonType, currentPathMetaData);
        this.currentObjectJsonType = nextObjectJsonType;
    }

    private void fetchJsonObjectWhenIsValid(PathMetadata currentPathMetaData, int index, ArrayJsonType arrayJsonType) {
        AbstractJsonType element = arrayJsonType.getElement(index);
        JsonObjectFieldsValidator.checkEarlierWasJsonObject(currentPathMetaData.getOriginalPropertyKey(), currentPathMetaData, element);
        this.currentObjectJsonType = (ObjectJsonType)element;
    }

    private void createArrayAndAddElement(PathMetadata currentPathMetaData) {
        ArrayJsonType arrayJsonTypeObject = new ArrayJsonType();
        ObjectJsonType nextObjectJsonType = new ObjectJsonType();
        arrayJsonTypeObject.addElement(currentPathMetaData.getPropertyArrayHelper(), (AbstractJsonType)nextObjectJsonType, currentPathMetaData);
        this.currentObjectJsonType.addField(currentPathMetaData.getFieldName(), arrayJsonTypeObject, currentPathMetaData);
        this.currentObjectJsonType = nextObjectJsonType;
    }
}

