/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pl.jalokim.propertiestojson.PropertyArrayHelper;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.JsonNullReferenceType;
import pl.jalokim.propertiestojson.object.MergableObject;
import pl.jalokim.propertiestojson.object.SkipJsonField;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.util.exception.CannotOverrideFieldException;
import pl.jalokim.utils.collection.CollectionUtils;

public class ArrayJsonType
extends AbstractJsonType
implements MergableObject<ArrayJsonType> {
    public static final int INIT_SIZE = 100;
    private AbstractJsonType[] elements = new AbstractJsonType[100];
    private int maxIndex = -1;

    public ArrayJsonType() {
    }

    public ArrayJsonType(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, Collection<?> elements, PathMetadata currentPathMetadata, String propertyKey) {
        Iterator<?> iterator = elements.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.addElement(index, primitiveJsonTypesResolver.resolvePrimitiveTypeAndReturn(element, propertyKey), currentPathMetadata);
            ++index;
        }
    }

    public static ArrayJsonType createOrGetNextDimensionOfArray(ArrayJsonType currentArray, List<Integer> indexes, int indexToTest, PathMetadata currentPathMetadata) {
        if (currentArray.existElementByGivenIndex(indexes.get(indexToTest))) {
            AbstractJsonType element = currentArray.getElement(indexes.get(indexToTest));
            if (element instanceof ArrayJsonType) {
                return (ArrayJsonType)element;
            }
            List<Integer> currentIndexes = indexes.subList(0, indexToTest + 1);
            String indexesAsText = currentIndexes.stream().map(Object::toString).reduce("", (oldText, index) -> oldText + "[" + index + "]");
            throw new CannotOverrideFieldException(currentPathMetadata.getCurrentFullPathWithoutIndexes() + indexesAsText, element, currentPathMetadata.getOriginalPropertyKey());
        }
        ArrayJsonType newArray = new ArrayJsonType();
        currentArray.addElement(indexes.get(indexToTest), (AbstractJsonType)newArray, currentPathMetadata);
        return newArray;
    }

    public void addElement(int index, AbstractJsonType elementToAdd, PathMetadata currentPathMetadata) {
        if (this.maxIndex < index) {
            this.maxIndex = index;
        }
        this.rewriteArrayWhenIsFull(index);
        AbstractJsonType oldObject = this.elements[index];
        if (oldObject == null) {
            this.elements[index] = elementToAdd;
        } else if (oldObject instanceof MergableObject && elementToAdd instanceof MergableObject) {
            MergableObject.mergeObjectIfPossible(oldObject, elementToAdd, currentPathMetadata);
        } else {
            throw new CannotOverrideFieldException(currentPathMetadata.getCurrentFullPath(), oldObject, currentPathMetadata.getOriginalPropertyKey());
        }
    }

    public void addElement(PropertyArrayHelper propertyArrayHelper, AbstractJsonType elementToAdd, PathMetadata currentPathMetadata) {
        List<Integer> indexes = propertyArrayHelper.getDimensionalIndexes();
        int size = propertyArrayHelper.getDimensionalIndexes().size();
        ArrayJsonType currentArray = this;
        for (int index = 0; index < size; ++index) {
            if (CollectionUtils.isLastIndex(propertyArrayHelper.getDimensionalIndexes(), index)) {
                currentArray.addElement(indexes.get(index), elementToAdd, currentPathMetadata);
                continue;
            }
            currentArray = ArrayJsonType.createOrGetNextDimensionOfArray(currentArray, indexes, index, currentPathMetadata);
        }
    }

    public AbstractJsonType getElementByGivenDimIndexes(PathMetadata currentPathMetaData) {
        PropertyArrayHelper propertyArrayHelper = currentPathMetaData.getPropertyArrayHelper();
        List<Integer> indexes = propertyArrayHelper.getDimensionalIndexes();
        int size = propertyArrayHelper.getDimensionalIndexes().size();
        ArrayJsonType currentArray = this;
        for (int i = 0; i < size; ++i) {
            if (CollectionUtils.isLastIndex(propertyArrayHelper.getDimensionalIndexes(), i)) {
                return currentArray.getElement(indexes.get(i));
            }
            AbstractJsonType element = currentArray.getElement(indexes.get(i));
            if (element == null) {
                return null;
            }
            if (!(element instanceof ArrayJsonType)) {
                List<Integer> currentIndexes = indexes.subList(0, i + 1);
                String indexesAsText = currentIndexes.stream().map(Object::toString).reduce("", (oldText, index) -> oldText + "[" + index + "]");
                throw new CannotOverrideFieldException(currentPathMetaData.getCurrentFullPathWithoutIndexes() + indexesAsText, element, currentPathMetaData.getOriginalPropertyKey());
            }
            currentArray = (ArrayJsonType)element;
        }
        throw new UnsupportedOperationException("cannot return expected object for " + currentPathMetaData.getCurrentFullPath() + " " + currentPathMetaData.getPropertyArrayHelper().getDimensionalIndexes());
    }

    public boolean existElementByGivenIndex(int index) {
        return this.getElement(index) != null;
    }

    private void rewriteArrayWhenIsFull(int index) {
        if (this.indexHigherThanArraySize(index)) {
            int predictedNewSize = this.elements.length + 100;
            int newSize = predictedNewSize > index ? predictedNewSize : index + 1;
            AbstractJsonType[] elementsTemp = new AbstractJsonType[newSize];
            System.arraycopy(this.elements, 0, elementsTemp, 0, this.elements.length);
            this.elements = elementsTemp;
        }
    }

    private boolean indexHigherThanArraySize(int index) {
        return index > CollectionUtils.getLastIndex(this.elements);
    }

    public AbstractJsonType getElement(int index) {
        this.rewriteArrayWhenIsFull(index);
        return this.elements[index];
    }

    @Override
    public String toStringJson() {
        StringBuilder result = new StringBuilder().append("[");
        int index = 0;
        List<AbstractJsonType> elementsAsList = this.convertToListWithoutRealNull();
        int lastIndex = CollectionUtils.getLastIndex(elementsAsList);
        for (AbstractJsonType element : elementsAsList) {
            if (!(element instanceof SkipJsonField)) {
                String lastSign = index == lastIndex ? "" : ",";
                result.append(element.toStringJson()).append(lastSign);
            }
            ++index;
        }
        return result.append("]").toString();
    }

    public List<AbstractJsonType> convertToListWithoutRealNull() {
        ArrayList<AbstractJsonType> elementsList = new ArrayList<AbstractJsonType>();
        for (int i = 0; i < this.maxIndex + 1; ++i) {
            AbstractJsonType element = this.elements[i];
            if (element == null) {
                elementsList.add(JsonNullReferenceType.NULL_OBJECT);
                continue;
            }
            elementsList.add(element);
        }
        return elementsList;
    }

    private List<AbstractJsonType> convertToListWithRealNull() {
        ArrayList<AbstractJsonType> elementsList = new ArrayList<AbstractJsonType>();
        for (int i = 0; i < this.maxIndex + 1; ++i) {
            AbstractJsonType element = this.elements[i];
            elementsList.add(element);
        }
        return elementsList;
    }

    @Override
    public void merge(ArrayJsonType mergeWith, PathMetadata currentPathMetadata) {
        int index = 0;
        for (AbstractJsonType abstractJsonType : mergeWith.convertToListWithRealNull()) {
            this.addElement(index, abstractJsonType, currentPathMetadata);
            ++index;
        }
    }
}

