/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.spi.UpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletUpnpStream
extends UpnpStream {
    protected StreamResponseMessage responseMessage;
    protected final Logger logger = LoggerFactory.getLogger(ServletUpnpStream.class);

    protected ServletUpnpStream(ProtocolFactory protocolFactory) {
        super(protocolFactory);
    }

    @Override
    public void run() {
        try {
            StreamRequestMessage requestMessage = this.readRequestMessage();
            this.logger.trace("Processing new request message: {}", (Object)requestMessage);
            this.responseMessage = this.process(requestMessage);
            if (this.responseMessage != null) {
                this.logger.trace("Preparing HTTP response message: {}", (Object)this.responseMessage);
                this.writeResponseMessage(this.responseMessage);
            } else {
                this.logger.trace("Sending HTTP response status: {}", (Object)404);
                this.getResponse().setStatus(404);
            }
        }
        catch (Exception e) {
            this.logger.info("Exception occurred during UPnP stream processing", e);
            if (!this.getResponse().isCommitted()) {
                this.logger.trace("Response hasn't been committed, returning INTERNAL SERVER ERROR to client");
                this.getResponse().setStatus(500);
            } else {
                this.logger.info("Could not return INTERNAL SERVER ERROR to client, response was already committed");
            }
            this.responseException(e);
        }
        finally {
            this.complete();
        }
    }

    protected StreamRequestMessage readRequestMessage() throws IOException {
        byte[] bodyBytes;
        StreamRequestMessage requestMessage;
        String requestMethod = this.getRequest().getMethod();
        String requestURI = this.getRequest().getRequestURI();
        this.logger.trace("Processing HTTP request: {} {} ", (Object)requestMethod, (Object)requestURI);
        try {
            requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(requestMethod), URI.create(requestURI));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid request URI: " + requestURI, e);
        }
        if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
            throw new RuntimeException("Method not supported: " + requestMethod);
        }
        requestMessage.setConnection(this.createConnection());
        UpnpHeaders headers = new UpnpHeaders();
        Enumeration headerNames = this.getRequest().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = this.getRequest().getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                headers.add(headerName, headerValue);
            }
        }
        requestMessage.setHeaders(headers);
        try (ServletInputStream is = this.getRequest().getInputStream();){
            bodyBytes = UpnpRequest.Method.GET.getHttpName().equals(requestMethod) ? new byte[]{} : is.readAllBytes();
        }
        this.logger.trace("Reading request body bytes: {}", (Object)bodyBytes.length);
        if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
            this.logger.trace("Request contains textual entity body, converting then setting string on message");
            requestMessage.setBodyCharacters(bodyBytes);
        } else if (bodyBytes.length > 0) {
            this.logger.trace("Request contains binary entity body, setting bytes on message");
            requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
        } else {
            this.logger.trace("Request did not contain entity body");
        }
        return requestMessage;
    }

    protected void writeResponseMessage(StreamResponseMessage responseMessage) throws IOException {
        int contentLength;
        this.logger.trace("Sending HTTP response status: {}", (Object)((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        this.getResponse().setStatus(((UpnpResponse)responseMessage.getOperation()).getStatusCode());
        for (Map.Entry<String, List<String>> entry : responseMessage.getHeaders().entrySet()) {
            for (String value : entry.getValue()) {
                this.getResponse().addHeader(entry.getKey(), value);
            }
        }
        this.getResponse().setDateHeader("Date", System.currentTimeMillis());
        byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
        int n = contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
        if (contentLength > 0) {
            this.getResponse().setContentLength(contentLength);
            this.logger.trace("Response message has body, writing bytes to stream...");
            this.getResponse().getOutputStream().write(responseBodyBytes);
        }
    }

    protected abstract Connection createConnection();

    protected abstract HttpServletRequest getRequest();

    protected abstract HttpServletResponse getResponse();

    protected abstract void complete();
}

