/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.spi.UpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpExchangeUpnpStream
extends UpnpStream {
    private final Logger logger = LoggerFactory.getLogger(HttpExchangeUpnpStream.class.getName());
    private HttpExchange httpExchange;

    protected HttpExchangeUpnpStream(ProtocolFactory protocolFactory, HttpExchange httpExchange) {
        super(protocolFactory);
        this.httpExchange = httpExchange;
    }

    public HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    @Override
    public void run() {
        try {
            byte[] bodyBytes;
            this.logger.trace("Processing HTTP request: {} {}", (Object)this.getHttpExchange().getRequestMethod(), (Object)this.getHttpExchange().getRequestURI());
            StreamRequestMessage requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(this.getHttpExchange().getRequestMethod()), this.getHttpExchange().getRequestURI());
            if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
                this.logger.trace("Method not supported by UPnP stack: {}", (Object)this.getHttpExchange().getRequestMethod());
                throw new RuntimeException("Method not supported: " + this.getHttpExchange().getRequestMethod());
            }
            ((UpnpRequest)requestMessage.getOperation()).setHttpMinorVersion(this.getHttpExchange().getProtocol().toUpperCase(Locale.ROOT).equals("HTTP/1.1") ? 1 : 0);
            this.logger.trace("Created new request message: {}", (Object)requestMessage);
            requestMessage.setConnection(this.createConnection());
            requestMessage.setHeaders(new UpnpHeaders(this.getHttpExchange().getRequestHeaders()));
            try (InputStream is = this.getHttpExchange().getRequestBody();){
                bodyBytes = is.readAllBytes();
            }
            this.logger.trace("Reading request body bytes: {}", (Object)bodyBytes.length);
            if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
                this.logger.trace("Request contains textual entity body, converting then setting string on message");
                requestMessage.setBodyCharacters(bodyBytes);
            } else if (bodyBytes.length > 0) {
                this.logger.trace("Request contains binary entity body, setting bytes on message");
                requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
            } else {
                this.logger.trace("Request did not contain entity body");
            }
            StreamResponseMessage responseMessage = this.process(requestMessage);
            if (responseMessage != null) {
                this.logger.trace("Preparing HTTP response message: {}", (Object)responseMessage);
                this.getHttpExchange().getResponseHeaders().putAll(responseMessage.getHeaders());
                byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
                int contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
                this.logger.trace("Sending HTTP response message: {} with content length: {}", (Object)responseMessage, (Object)contentLength);
                this.getHttpExchange().sendResponseHeaders(((UpnpResponse)responseMessage.getOperation()).getStatusCode(), contentLength);
                if (contentLength > 0) {
                    this.logger.trace("Response message has body, writing bytes to stream...");
                    try (OutputStream os = this.getHttpExchange().getResponseBody();){
                        os.write(responseBodyBytes);
                        os.flush();
                    }
                }
            } else {
                this.logger.trace("Sending HTTP response status: {}", (Object)404);
                this.getHttpExchange().sendResponseHeaders(404, -1L);
            }
            this.responseSent(responseMessage);
        }
        catch (Exception e) {
            this.logger.trace("Exception occurred during UPnP stream processing", e);
            try {
                this.httpExchange.sendResponseHeaders(500, -1L);
            }
            catch (IOException ioe) {
                this.logger.warn("Couldn't send error response: {}", (Object)ioe.getMessage(), (Object)ioe);
            }
            this.responseException(e);
        }
    }

    protected abstract Connection createConnection();
}

