/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.net.URI;
import org.jupnp.UpnpService;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.ContentTypeHeader;
import org.jupnp.model.message.header.ServerHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.DeviceDescriptorResource;
import org.jupnp.model.resource.IconResource;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.resource.ServiceDescriptorResource;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingRetrieval
extends ReceivingSync<StreamRequestMessage, StreamResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingRetrieval.class);

    public ReceivingRetrieval(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        if (!((StreamRequestMessage)this.getInputMessage()).hasHostHeader()) {
            this.logger.trace("Ignoring message, missing HOST header: {}", this.getInputMessage());
            return new StreamResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        URI requestedURI = ((UpnpRequest)((StreamRequestMessage)this.getInputMessage()).getOperation()).getURI();
        Resource foundResource = this.getUpnpService().getRegistry().getResource(requestedURI);
        if (foundResource == null && (foundResource = this.onResourceNotFound(requestedURI)) == null) {
            this.logger.trace("No local resource found: {}", this.getInputMessage());
            return null;
        }
        return this.createResponse(requestedURI, foundResource);
    }

    protected StreamResponseMessage createResponse(URI requestedURI, Resource resource) {
        StreamResponseMessage response;
        block5: {
            try {
                if (DeviceDescriptorResource.class.isAssignableFrom(resource.getClass())) {
                    this.logger.trace("Found local device matching relative request URI: {}", (Object)requestedURI);
                    LocalDevice device = (LocalDevice)resource.getModel();
                    DeviceDescriptorBinder deviceDescriptorBinder = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
                    String deviceDescriptor = deviceDescriptorBinder.generate(device, this.getRemoteClientInfo(), this.getUpnpService().getConfiguration().getNamespace());
                    response = new StreamResponseMessage(deviceDescriptor, new ContentTypeHeader(ContentTypeHeader.DEFAULT_CONTENT_TYPE));
                    break block5;
                }
                if (ServiceDescriptorResource.class.isAssignableFrom(resource.getClass())) {
                    this.logger.trace("Found local service matching relative request URI: {}", (Object)requestedURI);
                    LocalService service = (LocalService)resource.getModel();
                    ServiceDescriptorBinder serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
                    String serviceDescriptor = serviceDescriptorBinder.generate(service);
                    response = new StreamResponseMessage(serviceDescriptor, new ContentTypeHeader(ContentTypeHeader.DEFAULT_CONTENT_TYPE));
                    break block5;
                }
                if (IconResource.class.isAssignableFrom(resource.getClass())) {
                    this.logger.trace("Found local icon matching relative request URI: {}", (Object)requestedURI);
                    Icon icon = (Icon)resource.getModel();
                    response = new StreamResponseMessage(icon.getData(), icon.getMimeType());
                    break block5;
                }
                this.logger.trace("Ignoring GET for found local resource: {}", (Object)resource);
                return null;
            }
            catch (DescriptorBindingException e) {
                this.logger.warn("Error generating requested device/service descriptor", e);
                response = new StreamResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
            }
        }
        response.getHeaders().add(UpnpHeader.Type.SERVER, new ServerHeader());
        return response;
    }

    protected Resource onResourceNotFound(URI requestedURIPath) {
        return null;
    }
}

