/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jupnp.binding.staging.MutableDevice;
import org.jupnp.binding.staging.MutableIcon;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.xml.Descriptor;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.model.Namespace;
import org.jupnp.model.ValidationException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.util.MimeType;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UDA10DeviceDescriptorBinderImpl
implements DeviceDescriptorBinder,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(DeviceDescriptorBinder.class);

    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            this.logger.trace("Populating device from XML descriptor: {}", (Object)undescribedDevice);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute("http://apache.org/xml/properties/locale", Locale.ROOT);
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Parser does not support 'http://apache.org/xml/properties/locale' attribute", e);
            }
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this);
            Document d = documentBuilder.parse(new InputSource(new StringReader(descriptorXml.trim())));
            return this.describe(undescribedDevice, d);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not parse device descriptor", e);
        }
    }

    public <D extends Device> D describe(D undescribedDevice, Document dom) throws DescriptorBindingException, ValidationException {
        try {
            this.logger.trace("Populating device from DOM: {}", (Object)undescribedDevice);
            MutableDevice descriptor = new MutableDevice();
            Element rootElement = dom.getDocumentElement();
            this.hydrateRoot(descriptor, rootElement);
            return this.buildInstance(undescribedDevice, descriptor);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not parse device DOM", e);
        }
    }

    public <D extends Device> D buildInstance(D undescribedDevice, MutableDevice descriptor) throws ValidationException {
        return (D)descriptor.build(undescribedDevice);
    }

    protected void hydrateRoot(MutableDevice descriptor, Element rootElement) throws DescriptorBindingException {
        if (rootElement.getNamespaceURI() == null || !rootElement.getNamespaceURI().equals("urn:schemas-upnp-org:device-1-0")) {
            SpecificationViolationReporter.report("Wrong XML namespace declared on root element: {}", rootElement.getNamespaceURI());
        }
        if (!rootElement.getNodeName().equals(Descriptor.Device.ELEMENT.root.name())) {
            throw new DescriptorBindingException("Root element name is not <root>: " + rootElement.getNodeName());
        }
        NodeList rootChildren = rootElement.getChildNodes();
        Node deviceNode = null;
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node rootChild = rootChildren.item(i);
            if (rootChild.getNodeType() != 1) continue;
            if (Descriptor.Device.ELEMENT.specVersion.equals(rootChild)) {
                this.hydrateSpecVersion(descriptor, rootChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.URLBase.equals(rootChild)) {
                try {
                    String urlString = XMLUtil.getTextContent(rootChild);
                    if (urlString == null || urlString.isEmpty()) continue;
                    descriptor.baseURL = new URL(urlString);
                    continue;
                }
                catch (Exception e) {
                    throw new DescriptorBindingException("Invalid URLBase: " + e.getMessage());
                }
            }
            if (Descriptor.Device.ELEMENT.device.equals(rootChild)) {
                if (deviceNode != null) {
                    throw new DescriptorBindingException("Found multiple <device> elements in <root>");
                }
                deviceNode = rootChild;
                continue;
            }
            this.logger.trace("Ignoring unknown element: {}", (Object)rootChild.getNodeName());
        }
        if (deviceNode == null) {
            throw new DescriptorBindingException("No <device> element in <root>");
        }
        this.hydrateDevice(descriptor, deviceNode);
    }

    public void hydrateSpecVersion(MutableDevice descriptor, Node specVersionNode) throws DescriptorBindingException {
        NodeList specVersionChildren = specVersionNode.getChildNodes();
        for (int i = 0; i < specVersionChildren.getLength(); ++i) {
            String version;
            Node specVersionChild = specVersionChildren.item(i);
            if (specVersionChild.getNodeType() != 1) continue;
            if (Descriptor.Device.ELEMENT.major.equals(specVersionChild)) {
                version = XMLUtil.getTextContent(specVersionChild).trim();
                if (!version.equals("1")) {
                    SpecificationViolationReporter.report("Unsupported UDA major version, ignoring: " + version, new Object[0]);
                    version = "1";
                }
                descriptor.udaVersion.major = Integer.parseInt(version);
                continue;
            }
            if (!Descriptor.Device.ELEMENT.minor.equals(specVersionChild)) continue;
            version = XMLUtil.getTextContent(specVersionChild).trim();
            if (!version.equals("0")) {
                SpecificationViolationReporter.report("Unsupported UDA minor version, ignoring: " + version, new Object[0]);
                version = "0";
            }
            descriptor.udaVersion.minor = Integer.parseInt(version);
        }
    }

    public void hydrateDevice(MutableDevice descriptor, Node deviceNode) throws DescriptorBindingException {
        NodeList deviceNodeChildren = deviceNode.getChildNodes();
        for (int i = 0; i < deviceNodeChildren.getLength(); ++i) {
            Node deviceNodeChild = deviceNodeChildren.item(i);
            if (deviceNodeChild.getNodeType() != 1) continue;
            if (Descriptor.Device.ELEMENT.deviceType.equals(deviceNodeChild)) {
                descriptor.deviceType = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.friendlyName.equals(deviceNodeChild)) {
                descriptor.friendlyName = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.manufacturer.equals(deviceNodeChild)) {
                descriptor.manufacturer = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.manufacturerURL.equals(deviceNodeChild)) {
                descriptor.manufacturerURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelDescription.equals(deviceNodeChild)) {
                descriptor.modelDescription = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelName.equals(deviceNodeChild)) {
                descriptor.modelName = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelNumber.equals(deviceNodeChild)) {
                descriptor.modelNumber = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelURL.equals(deviceNodeChild)) {
                descriptor.modelURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.presentationURL.equals(deviceNodeChild)) {
                descriptor.presentationURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.UPC.equals(deviceNodeChild)) {
                descriptor.upc = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.serialNumber.equals(deviceNodeChild)) {
                descriptor.serialNumber = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.UDN.equals(deviceNodeChild)) {
                descriptor.udn = UDN.valueOf(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.iconList.equals(deviceNodeChild)) {
                this.hydrateIconList(descriptor, deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.serviceList.equals(deviceNodeChild)) {
                this.hydrateServiceList(descriptor, deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.deviceList.equals(deviceNodeChild)) {
                this.hydrateDeviceList(descriptor, deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.X_DLNADOC.equals(deviceNodeChild) && "dlna".equals(deviceNodeChild.getPrefix())) {
                String txt = XMLUtil.getTextContent(deviceNodeChild);
                try {
                    descriptor.dlnaDocs.add(DLNADoc.valueOf(txt));
                }
                catch (InvalidValueException e) {
                    this.logger.info("Invalid X_DLNADOC value, ignoring value: {}", (Object)txt);
                }
                continue;
            }
            if (!Descriptor.Device.ELEMENT.X_DLNACAP.equals(deviceNodeChild) || !"dlna".equals(deviceNodeChild.getPrefix())) continue;
            descriptor.dlnaCaps = DLNACaps.valueOf(XMLUtil.getTextContent(deviceNodeChild));
        }
    }

    public void hydrateIconList(MutableDevice descriptor, Node iconListNode) throws DescriptorBindingException {
        NodeList iconListNodeChildren = iconListNode.getChildNodes();
        for (int i = 0; i < iconListNodeChildren.getLength(); ++i) {
            Node iconListNodeChild = iconListNodeChildren.item(i);
            if (iconListNodeChild.getNodeType() != 1 || !Descriptor.Device.ELEMENT.icon.equals(iconListNodeChild)) continue;
            MutableIcon icon = new MutableIcon();
            NodeList iconChildren = iconListNodeChild.getChildNodes();
            for (int x = 0; x < iconChildren.getLength(); ++x) {
                Node iconChild = iconChildren.item(x);
                if (iconChild.getNodeType() != 1) continue;
                if (Descriptor.Device.ELEMENT.width.equals(iconChild)) {
                    icon.width = Integer.parseInt(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.height.equals(iconChild)) {
                    icon.height = Integer.parseInt(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.depth.equals(iconChild)) {
                    String depth = XMLUtil.getTextContent(iconChild);
                    try {
                        icon.depth = Integer.parseInt(depth);
                    }
                    catch (NumberFormatException e) {
                        SpecificationViolationReporter.report("Invalid icon depth '{}', using 16 as default: {}", depth, e);
                        icon.depth = 16;
                    }
                    continue;
                }
                if (Descriptor.Device.ELEMENT.url.equals(iconChild)) {
                    icon.uri = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (!Descriptor.Device.ELEMENT.mimetype.equals(iconChild)) continue;
                try {
                    icon.mimeType = XMLUtil.getTextContent(iconChild);
                    MimeType.valueOf(icon.mimeType);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    SpecificationViolationReporter.report("Ignoring invalid icon mime type: " + icon.mimeType, new Object[0]);
                    icon.mimeType = "";
                }
            }
            descriptor.icons.add(icon);
        }
    }

    public void hydrateServiceList(MutableDevice descriptor, Node serviceListNode) throws DescriptorBindingException {
        NodeList serviceListNodeChildren = serviceListNode.getChildNodes();
        for (int i = 0; i < serviceListNodeChildren.getLength(); ++i) {
            Node serviceListNodeChild = serviceListNodeChildren.item(i);
            if (serviceListNodeChild.getNodeType() != 1 || !Descriptor.Device.ELEMENT.service.equals(serviceListNodeChild)) continue;
            NodeList serviceChildren = serviceListNodeChild.getChildNodes();
            try {
                MutableService service = new MutableService();
                for (int x = 0; x < serviceChildren.getLength(); ++x) {
                    Node serviceChild = serviceChildren.item(x);
                    if (serviceChild.getNodeType() != 1) continue;
                    if (Descriptor.Device.ELEMENT.serviceType.equals(serviceChild)) {
                        service.serviceType = ServiceType.valueOf(XMLUtil.getTextContent(serviceChild));
                        continue;
                    }
                    if (Descriptor.Device.ELEMENT.serviceId.equals(serviceChild)) {
                        service.serviceId = ServiceId.valueOf(XMLUtil.getTextContent(serviceChild));
                        continue;
                    }
                    if (Descriptor.Device.ELEMENT.SCPDURL.equals(serviceChild)) {
                        service.descriptorURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                        continue;
                    }
                    if (Descriptor.Device.ELEMENT.controlURL.equals(serviceChild)) {
                        service.controlURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                        continue;
                    }
                    if (!Descriptor.Device.ELEMENT.eventSubURL.equals(serviceChild)) continue;
                    service.eventSubscriptionURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                }
                descriptor.services.add(service);
                continue;
            }
            catch (InvalidValueException e) {
                SpecificationViolationReporter.report("Skipping invalid service declaration. " + e.getMessage(), new Object[0]);
            }
        }
    }

    public void hydrateDeviceList(MutableDevice descriptor, Node deviceListNode) throws DescriptorBindingException {
        NodeList deviceListNodeChildren = deviceListNode.getChildNodes();
        for (int i = 0; i < deviceListNodeChildren.getLength(); ++i) {
            Node deviceListNodeChild = deviceListNodeChildren.item(i);
            if (deviceListNodeChild.getNodeType() != 1 || !Descriptor.Device.ELEMENT.device.equals(deviceListNodeChild)) continue;
            MutableDevice embeddedDevice = new MutableDevice();
            embeddedDevice.parentDevice = descriptor;
            descriptor.embeddedDevices.add(embeddedDevice);
            this.hydrateDevice(embeddedDevice, deviceListNodeChild);
        }
    }

    @Override
    public String generate(Device deviceModel, RemoteClientInfo info, Namespace namespace) throws DescriptorBindingException {
        try {
            this.logger.trace("Generating XML descriptor from device model: {}", (Object)deviceModel);
            return XMLUtil.documentToString(this.buildDOM(deviceModel, info, namespace));
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not build DOM: " + e.getMessage(), e);
        }
    }

    @Override
    public Document buildDOM(Device deviceModel, RemoteClientInfo info, Namespace namespace) throws DescriptorBindingException {
        try {
            this.logger.trace("Generating DOM from device model: {}", (Object)deviceModel);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().newDocument();
            this.generateRoot(namespace, deviceModel, d, info);
            return d;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not generate device descriptor: " + e.getMessage(), e);
        }
    }

    protected void generateRoot(Namespace namespace, Device deviceModel, Document descriptor, RemoteClientInfo info) {
        Element rootElement = descriptor.createElementNS("urn:schemas-upnp-org:device-1-0", Descriptor.Device.ELEMENT.root.toString());
        descriptor.appendChild(rootElement);
        this.generateSpecVersion(namespace, deviceModel, descriptor, rootElement);
        this.generateDevice(namespace, deviceModel, descriptor, rootElement, info);
    }

    protected void generateSpecVersion(Namespace namespace, Device deviceModel, Document descriptor, Element rootElement) {
        Element specVersionElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Device.ELEMENT.specVersion);
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Device.ELEMENT.major, (Object)deviceModel.getVersion().getMajor());
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Device.ELEMENT.minor, (Object)deviceModel.getVersion().getMinor());
    }

    protected void generateDevice(Namespace namespace, Device deviceModel, Document descriptor, Element rootElement, RemoteClientInfo info) {
        Element deviceElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Device.ELEMENT.device);
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.deviceType, (Object)deviceModel.getType());
        DeviceDetails deviceModelDetails = deviceModel.getDetails(info);
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.friendlyName, (Object)deviceModelDetails.getFriendlyName());
        if (deviceModelDetails.getManufacturerDetails() != null) {
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.manufacturer, (Object)deviceModelDetails.getManufacturerDetails().getManufacturer());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.manufacturerURL, (Object)deviceModelDetails.getManufacturerDetails().getManufacturerURI());
        }
        if (deviceModelDetails.getModelDetails() != null) {
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelDescription, (Object)deviceModelDetails.getModelDetails().getModelDescription());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelName, (Object)deviceModelDetails.getModelDetails().getModelName());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelNumber, (Object)deviceModelDetails.getModelDetails().getModelNumber());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelURL, (Object)deviceModelDetails.getModelDetails().getModelURI());
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.serialNumber, (Object)deviceModelDetails.getSerialNumber());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.UDN, (Object)((DeviceIdentity)deviceModel.getIdentity()).getUdn());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.presentationURL, (Object)deviceModelDetails.getPresentationURI());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.UPC, (Object)deviceModelDetails.getUpc());
        if (deviceModelDetails.getDlnaDocs() != null) {
            for (DLNADoc dlnaDoc : deviceModelDetails.getDlnaDocs()) {
                XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "dlna:" + String.valueOf((Object)Descriptor.Device.ELEMENT.X_DLNADOC), (Object)dlnaDoc, "urn:schemas-dlna-org:device-1-0");
            }
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "dlna:" + String.valueOf((Object)Descriptor.Device.ELEMENT.X_DLNACAP), (Object)deviceModelDetails.getDlnaCaps(), "urn:schemas-dlna-org:device-1-0");
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "sec:" + String.valueOf((Object)Descriptor.Device.ELEMENT.ProductCap), (Object)deviceModelDetails.getSecProductCaps(), "http://www.sec.co.kr/dlna");
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "sec:" + String.valueOf((Object)Descriptor.Device.ELEMENT.X_ProductCap), (Object)deviceModelDetails.getSecProductCaps(), "http://www.sec.co.kr/dlna");
        this.generateIconList(namespace, deviceModel, descriptor, deviceElement);
        this.generateServiceList(namespace, deviceModel, descriptor, deviceElement);
        this.generateDeviceList(namespace, deviceModel, descriptor, deviceElement, info);
    }

    protected void generateIconList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement) {
        if (!deviceModel.hasIcons()) {
            return;
        }
        Element iconListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.iconList);
        for (Icon icon : deviceModel.getIcons()) {
            Element iconElement = XMLUtil.appendNewElement(descriptor, iconListElement, Descriptor.Device.ELEMENT.icon);
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.mimetype, (Object)icon.getMimeType());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.width, (Object)icon.getWidth());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.height, (Object)icon.getHeight());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.depth, (Object)icon.getDepth());
            if (deviceModel instanceof RemoteDevice) {
                XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.url, (Object)icon.getUri());
                continue;
            }
            if (!(deviceModel instanceof LocalDevice)) continue;
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.url, (Object)namespace.getIconPath(icon));
        }
    }

    protected void generateServiceList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement) {
        if (!deviceModel.hasServices()) {
            return;
        }
        Element serviceListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.serviceList);
        for (Service service : deviceModel.getServices()) {
            Element serviceElement = XMLUtil.appendNewElement(descriptor, serviceListElement, Descriptor.Device.ELEMENT.service);
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.serviceType, (Object)service.getServiceType());
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.serviceId, (Object)service.getServiceId());
            if (service instanceof RemoteService) {
                RemoteService rs = (RemoteService)service;
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.SCPDURL, (Object)rs.getDescriptorURI());
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.controlURL, (Object)rs.getControlURI());
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.eventSubURL, (Object)rs.getEventSubscriptionURI());
                continue;
            }
            if (!(service instanceof LocalService)) continue;
            LocalService ls = (LocalService)service;
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.SCPDURL, (Object)namespace.getDescriptorPath(ls));
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.controlURL, (Object)namespace.getControlPath(ls));
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.eventSubURL, (Object)namespace.getEventSubscriptionPath(ls));
        }
    }

    protected void generateDeviceList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement, RemoteClientInfo info) {
        if (!deviceModel.hasEmbeddedDevices()) {
            return;
        }
        Element deviceListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.deviceList);
        for (Device device : deviceModel.getEmbeddedDevices()) {
            this.generateDevice(namespace, device, descriptor, deviceListElement, info);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    protected static URI parseURI(String uri) {
        if (((String)uri).startsWith("www.")) {
            uri = "http://" + (String)uri;
        }
        if (((String)uri).contains(" ")) {
            uri = ((String)uri).replaceAll(" ", "%20");
        }
        try {
            return URI.create((String)uri);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Logger logger1 = LoggerFactory.getLogger(DeviceDescriptorBinder.class);
            logger1.trace("Illegal URI, trying with ./ prefix", e);
            try {
                return URI.create("./" + (String)uri);
            }
            catch (IllegalArgumentException e2) {
                SpecificationViolationReporter.report("Illegal URI '{}', ignoring value", uri, e2);
                return null;
            }
        }
    }
}

