/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2;

public class Lyrics3v1
extends AbstractLyrics3 {
    private String lyric = "";

    public Lyrics3v1() {
    }

    public Lyrics3v1(Lyrics3v1 copyObject) {
        super(copyObject);
        this.lyric = copyObject.lyric;
    }

    public Lyrics3v1(AbstractTag mp3Tag) {
        if (mp3Tag != null) {
            if (mp3Tag instanceof Lyrics3v1) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            Lyrics3v2 lyricTag = mp3Tag instanceof Lyrics3v2 ? (Lyrics3v2)mp3Tag : new Lyrics3v2(mp3Tag);
            FieldFrameBodyLYR lyricField = (FieldFrameBodyLYR)lyricTag.getField("LYR").getBody();
            this.lyric = lyricField.getLyric();
        }
    }

    public Lyrics3v1(ByteBuffer byteBuffer) throws TagNotFoundException, IOException {
        try {
            this.read(byteBuffer);
        }
        catch (TagException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getIdentifier() {
        return "Lyrics3v1.00";
    }

    public void setLyric(String lyric) {
        this.lyric = ID3Tags.truncate(lyric, 5100);
    }

    public String getLyric() {
        return this.lyric;
    }

    @Override
    public int getSize() {
        return "LYRICSBEGIN".length() + this.lyric.length() + "LYRICSEND".length();
    }

    @Override
    public boolean isSubsetOf(Object obj) {
        return obj instanceof Lyrics3v1 && ((Lyrics3v1)obj).lyric.contains(this.lyric);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3v1)) {
            return false;
        }
        Lyrics3v1 object = (Lyrics3v1)obj;
        return this.lyric.equals(object.lyric) && super.equals(obj);
    }

    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException("Method iterator() not yet implemented.");
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        return false;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        byte[] buffer = new byte[5120];
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        byteBuffer.get(buffer);
        String lyricBuffer = new String(buffer);
        this.lyric = lyricBuffer.substring(0, lyricBuffer.indexOf("LYRICSEND"));
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        long offset;
        byte[] buffer = new byte[5120];
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        String lyricsEnd = new String(buffer, 0, 9);
        if (lyricsEnd.equals("LYRICSEND")) {
            offset = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricsEnd = new String(buffer, 0, 9);
            if (lyricsEnd.equals("LYRICSEND")) {
                offset = file.getFilePointer();
            } else {
                return false;
            }
        }
        file.seek(offset -= 5120L);
        file.read(buffer);
        String lyricsStart = new String(buffer);
        int i = lyricsStart.indexOf("LYRICSBEGIN");
        if (i == -1) {
            return false;
        }
        file.seek(offset + (long)i + 11L);
        return true;
    }

    public String toString() {
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        return str + this.lyric;
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
        int i;
        this.delete(file);
        file.seek(file.length());
        byte[] buffer = new byte[this.lyric.length() + 11 + 9];
        String str = "LYRICSBEGIN";
        for (i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        int offset = str.length();
        str = ID3Tags.truncate(this.lyric, 5100);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        str = "LYRICSEND";
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, offset += str.length());
    }
}

