/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacAudioHeader;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.Utils;

public class FlacInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");

    public FlacAudioHeader read(Path path) throws CannotReadException, IOException {
        logger.config(path + ":start");
        try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
            FlacStreamReader flacStream = new FlacStreamReader(fc, path.toString() + " ");
            flacStream.findStream();
            MetadataBlockDataStreamInfo mbdsi = null;
            boolean isLastBlock = false;
            while (!isLastBlock) {
                MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(fc);
                logger.info(path.toString() + " " + mbh.toString());
                if (mbh.getBlockType() == BlockType.STREAMINFO) {
                    if (mbh.getDataLength() == 0) {
                        throw new CannotReadException(path + ":FLAC StreamInfo has zeo data length");
                    }
                    mbdsi = new MetadataBlockDataStreamInfo(mbh, fc);
                    if (!mbdsi.isValid()) {
                        throw new CannotReadException(path + ":FLAC StreamInfo not valid");
                    }
                } else {
                    fc.position(fc.position() + (long)mbh.getDataLength());
                }
                isLastBlock = mbh.isLastBlock();
            }
            long streamStart = fc.position();
            if (mbdsi == null) {
                throw new CannotReadException(path + ":Unable to find Flac StreamInfo");
            }
            FlacAudioHeader info = new FlacAudioHeader();
            info.setNoOfSamples(mbdsi.getNoOfSamples());
            info.setPreciseLength(mbdsi.getPreciseLength());
            info.setChannelNumber(mbdsi.getNoOfChannels());
            info.setSamplingRate(mbdsi.getSamplingRate());
            info.setBitsPerSample(mbdsi.getBitsPerSample());
            info.setEncodingType(mbdsi.getEncodingType());
            info.setFormat(SupportedFileFormat.FLAC.getDisplayName());
            info.setLossless(true);
            info.setMd5(mbdsi.getMD5Signature());
            info.setAudioDataLength(fc.size() - streamStart);
            info.setAudioDataStartPosition(streamStart);
            info.setAudioDataEndPosition(fc.size());
            info.setBitRate(this.computeBitrate(info.getAudioDataLength(), mbdsi.getPreciseLength()));
            FlacAudioHeader flacAudioHeader = info;
            return flacAudioHeader;
        }
    }

    private int computeBitrate(long size, float length) {
        return (int)((float)(size / (long)Utils.KILOBYTE_MULTIPLIER * (long)Utils.BITS_IN_BYTE_MULTIPLIER) / length);
    }

    public int countMetaBlocks(File f) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(f.toPath(), new OpenOption[0]);){
            FlacStreamReader flacStream = new FlacStreamReader(fc, f.toPath().toString() + " ");
            flacStream.findStream();
            boolean isLastBlock = false;
            int count = 0;
            while (!isLastBlock) {
                MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(fc);
                logger.config(f + ":Found block:" + (Object)((Object)mbh.getBlockType()));
                fc.position(fc.position() + (long)mbh.getDataLength());
                isLastBlock = mbh.isLastBlock();
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

