/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputstream
extends OutputStream {
    private long count = 0L;
    private final OutputStream wrapped;

    public CountingOutputstream(OutputStream outputStream) {
        assert (outputStream != null);
        this.wrapped = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.wrapped.write(bytes);
        this.count += (long)bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.wrapped.write(bytes, off, len);
        this.count += (long)len;
    }

    @Override
    public void write(int toWrite) throws IOException {
        this.wrapped.write(toWrite);
        ++this.count;
    }
}

