/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UniqueList<E>
extends ArrayList<E> {
    public UniqueList() {
    }

    public UniqueList(int initialCapacity) {
        super(initialCapacity);
    }

    public UniqueList(Collection<? extends E> c) {
        super(c.size());
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        if (!this.contains(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (!this.contains(element)) {
            super.add(index, element);
        }
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        for (E e : c) {
            if (this.contains(e)) continue;
            super.add(e);
        }
        return oldSize != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        ArrayList<E> tmpList = new ArrayList<E>();
        for (E e : c) {
            if (this.contains(e)) continue;
            tmpList.add(e);
        }
        return !tmpList.isEmpty() && super.addAll(index, tmpList);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int idx = this.indexOf(element);
        if (idx == index) {
            return element;
        }
        if (idx > -1) {
            if (index > idx) {
                --index;
            }
            this.remove(element);
        }
        return super.set(index, element);
    }
}

