/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.renderers.Renderer;
import net.pms.store.StoreResource;
import net.pms.util.Iso639;
import net.pms.util.StringUtil;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class UMSUtils {
    private UMSUtils() {
    }

    public static StoreResource getFirstResourceWithSystemName(List<StoreResource> resources, String systemName) {
        if (resources != null && systemName != null) {
            for (StoreResource resource : resources) {
                if (!systemName.equals(resource.getSystemName())) continue;
                return resource;
            }
        }
        return null;
    }

    public static void filterResourcesByName(List<StoreResource> resources, String searchString, boolean isExpectOneResult, boolean isExactMatch) {
        if (resources == null || searchString == null) {
            return;
        }
        searchString = searchString.toLowerCase();
        for (int i = resources.size() - 1; i >= 0; --i) {
            StoreResource res = resources.get(i);
            if (res.isSearched()) continue;
            boolean keep = isExactMatch ? res.getName().toLowerCase().equals(searchString) : res.getName().toLowerCase().contains(searchString);
            MediaInfo media = res.getMediaInfo();
            if (keep && isExpectOneResult) {
                resources.clear();
                resources.add(res);
                break;
            }
            if (!keep && media != null && media.hasAudioMetadata()) {
                MediaAudioMetadata audioMetadata = media.getAudioMetadata();
                if (audioMetadata.getAlbum() != null) {
                    keep |= audioMetadata.getAlbum().toLowerCase().contains(searchString);
                }
                if (audioMetadata.getArtist() != null) {
                    keep |= audioMetadata.getArtist().toLowerCase().contains(searchString);
                }
                if (audioMetadata.getSongname() != null) {
                    keep |= audioMetadata.getSongname().toLowerCase().contains(searchString);
                }
            }
            if (keep) continue;
            resources.remove(i);
        }
    }

    public static String playedDurationStr(String current, String duration) {
        String pos = StringUtil.shortTime(current, 4);
        String dur = StringUtil.shortTime(duration, 4);
        return pos + (String)(pos.equals("0:00") ? "" : (dur.equals("0:00") ? "" : " / " + dur));
    }

    public static String unescape(String s) throws IllegalArgumentException {
        return StringEscapeUtils.unescapeXml(StringEscapeUtils.unescapeHtml4(URLDecoder.decode(s, StandardCharsets.UTF_8)));
    }

    private static String iso639(String s) {
        String[] tmp = s.split(",");
        StringBuilder res = new StringBuilder();
        String sep = "";
        for (String tmp1 : tmp) {
            res.append(sep).append(Iso639.getISO639_2Code(tmp1));
            sep = ",";
        }
        if (StringUtils.isNotEmpty(res)) {
            return res.toString();
        }
        return s;
    }

    public static String getLangList(Renderer renderer, boolean three) {
        String res = renderer != null ? renderer.getSubLanguage() : PMS.getConfiguration().getSubtitlesLanguages();
        if (three) {
            res = UMSUtils.iso639(res);
        }
        return res;
    }

    public static void checkGPUDecodingAccelerationMethodsForFFmpeg(UmsConfiguration configuration) throws ConfigurationException {
        String ffmpegPath = configuration.getFFmpegPath();
        if (ffmpegPath == null) {
            return;
        }
        OutputParams outputParams = new OutputParams(configuration);
        outputParams.setWaitBeforeStart(0);
        outputParams.setLog(true);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(new String[]{configuration.getFFmpegPath(), "-hwaccels"}, false, outputParams, true, false);
        Runnable r = () -> {
            UMSUtils.sleep(10000);
            pw.stopProcess();
        };
        Thread failsafe = new Thread(r, "Get GPU acceleration methods used by FFmpeg");
        failsafe.start();
        pw.run();
        List<String> result = pw.getOtherResults();
        ArrayList<String> availableMethods = new ArrayList<String>(1);
        availableMethods.addAll(Arrays.asList("none"));
        availableMethods.add("auto");
        if (result != null) {
            for (String line : result) {
                if ((line = line.trim()).equals("Hardware acceleration methods:") || availableMethods.contains(line)) continue;
                availableMethods.add(line);
            }
        }
        configuration.setFFmpegAvailableGPUDecodingAccelerationMethods(availableMethods);
        configuration.save();
    }

    public static boolean isListsEqual(List<String> a, List<String> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.size() != b.size()) {
            return false;
        }
        Collections.sort(a);
        Collections.sort(b);
        return a.equals(b);
    }

    public static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static JsonArray getArraysAsJsonArrayOfObjects(String[] values, String[] labels, JsonArray jsonArray) {
        if (jsonArray == null) {
            jsonArray = new JsonArray();
        }
        for (int i = 0; i < values.length; ++i) {
            JsonObject objectGroup = new JsonObject();
            String value = values[i];
            String label = labels[i];
            objectGroup.addProperty("value", value);
            objectGroup.addProperty("label", label);
            jsonArray.add(objectGroup);
        }
        return jsonArray;
    }

    public static synchronized JsonArray getListsAsJsonArrayOfObjects(List<String> values, List<String> labels, JsonArray jsonArray) {
        if (jsonArray == null) {
            jsonArray = new JsonArray();
        }
        for (int i = 0; i < values.size(); ++i) {
            JsonObject objectGroup = new JsonObject();
            String value = values.get(i);
            String label = labels.get(i);
            objectGroup.addProperty("label", label);
            objectGroup.addProperty("value", value);
            jsonArray.add(objectGroup);
        }
        return jsonArray;
    }
}

