/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.pms.PMS;
import net.pms.platform.PlatformUtils;
import net.pms.util.StringUtil;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;

public class SystemInformation
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemInformation.class);

    public SystemInformation() {
        super("System Information Logger");
    }

    public static List<String> getSystemInfo() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        long jvmMemory = Runtime.getRuntime().maxMemory();
        OperatingSystem os = null;
        CentralProcessor processor = null;
        CentralProcessor.ProcessorIdentifier processorIdentifier = null;
        GlobalMemory memory = null;
        List<NetworkIF> networkInterfaces = null;
        try {
            SystemInfo systemInfo = new SystemInfo();
            HardwareAbstractionLayer hardware = systemInfo.getHardware();
            os = systemInfo.getOperatingSystem();
            processor = hardware.getProcessor();
            processorIdentifier = processor.getProcessorIdentifier();
            memory = hardware.getMemory();
            networkInterfaces = hardware.getNetworkIFs();
        }
        catch (Error e) {
            LOGGER.debug("Could not retrieve system information: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        sb.append("OS: ");
        if (os != null && StringUtils.isNotBlank(os.toString())) {
            sb.append(os.toString()).append(" ").append(os.getBitness()).append("-bit");
        } else {
            sb.append(System.getProperty("os.name")).append(" ").append(PlatformUtils.getOSBitness()).append("-bit ");
            sb.append(System.getProperty("os.version"));
        }
        result.add(sb.toString());
        sb.setLength(0);
        sb.append("JVM: ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.version")).append(" (").append(System.getProperty("sun.arch.data.model")).append("-bit) by ").append(System.getProperty("java.vendor"));
        result.add(sb.toString());
        sb.setLength(0);
        sb.append("Language: ").append(WordUtils.capitalize(PMS.getLocale().getDisplayName(Locale.ENGLISH)));
        result.add(sb.toString());
        sb.setLength(0);
        sb.append("Encoding: ").append(System.getProperty("file.encoding"));
        result.add(sb.toString());
        sb.setLength(0);
        if (processor != null && processorIdentifier != null) {
            sb.append("CPU: ").append(processorIdentifier.getName()).append(" with ").append(processor.getPhysicalProcessorCount());
            if (processor.getPhysicalProcessorCount() > 1) {
                sb.append(" cores");
            } else {
                sb.append(" core");
            }
            if (processor.getLogicalProcessorCount() != processor.getPhysicalProcessorCount()) {
                sb.append(" (").append(processor.getLogicalProcessorCount());
                if (processor.getLogicalProcessorCount() > 1) {
                    sb.append(" virtual cores)");
                } else {
                    sb.append(" virtual core)");
                }
            }
            if (processorIdentifier.getMicroarchitecture() != null) {
                sb.append(" (").append(processorIdentifier.getMicroarchitecture()).append(")");
            }
            result.add(sb.toString());
            sb.setLength(0);
        }
        if (memory != null) {
            sb.append("Physical Memory: ").append(StringUtil.formatBytes(memory.getTotal(), true));
            result.add(sb.toString());
            sb.setLength(0);
            sb.append("Free Memory: ").append(StringUtil.formatBytes(memory.getAvailable(), true));
            result.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("Maximum JVM Memory: ");
        if (jvmMemory == Long.MAX_VALUE) {
            sb.append("Unlimited");
        } else {
            sb.append(StringUtil.formatBytes(jvmMemory, true));
        }
        result.add(sb.toString());
        if (networkInterfaces != null) {
            result.add("Used network interfaces:");
            for (NetworkIF net : networkInterfaces) {
                if (net.getBytesRecv() <= 0L) continue;
                sb.setLength(0);
                sb.append(net.getDisplayName()).append(", speed ").append(net.getSpeed() / 1000000L).append(" Mb/s");
                result.add(sb.toString());
            }
        }
        return result;
    }

    public static void logSystemInfo(Level logLevel) {
        if (logLevel == null) {
            throw new IllegalArgumentException("logLevel cannot be null");
        }
        SystemInformation.logSystemInfo(Level.toLocationAwareLoggerInteger(logLevel));
    }

    public static void logSystemInfo(org.slf4j.event.Level logLevel) {
        if (logLevel == null) {
            throw new IllegalArgumentException("logLevel cannot be null");
        }
        SystemInformation.logSystemInfo(logLevel.toInt());
    }

    public static void logSystemInfo(int locationAwareLogLevel) {
        StringBuilder systemInfo = new StringBuilder("System information:\n");
        for (String s : SystemInformation.getSystemInfo()) {
            systemInfo.append("  ").append(s).append("\n");
        }
        ((ch.qos.logback.classic.Logger)LOGGER).log(null, SystemInformation.class.getName(), locationAwareLogLevel, systemInfo.toString(), null, null);
    }

    @Override
    public void run() {
        LOGGER.trace("Starting gathering of system information");
        SystemInformation.logSystemInfo(org.slf4j.event.Level.INFO);
        LOGGER.trace("Done logging system information, shutting down thread");
    }
}

