/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.FFmpegLogLevels;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.renderers.Renderer;
import net.pms.store.StoreResource;
import net.pms.util.Constants;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import net.pms.util.Iso639;
import net.pms.util.StringUtil;
import net.pms.util.UMSUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtitleUtils {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtitleUtils.class);
    private static final long FOLDER_CACHE_EXPIRATION_TIME = 300000L;
    private static final char[] SUBTITLES_UPPER_CASE;
    private static final char[] SUBTITLES_LOWER_CASE;
    private static final File ALTERNATIVE_SUBTITLES_FOLDER;
    private static final Map<String, String> FILE_CHARSET_TO_MENCODER_SUBCP_OPTION_MAP;
    private static final String SUB_DIR = "subs";
    private static final HashMap<File, CacheFolder> FOLDER_CACHE;

    private SubtitleUtils() {
    }

    public static String getSubCpOptionForMencoder(MediaSubtitle dlnaMediaSubtitle) {
        if (dlnaMediaSubtitle == null) {
            throw new NullPointerException("dlnaMediaSubtitle can't be null.");
        }
        if (StringUtils.isBlank(dlnaMediaSubtitle.getSubCharacterSet())) {
            return null;
        }
        return FILE_CHARSET_TO_MENCODER_SUBCP_OPTION_MAP.get(dlnaMediaSubtitle.getSubCharacterSet());
    }

    public static File applyCodepageConversion(File fileToConvert, File outputSubs) throws IOException {
        String cp = CONFIGURATION.getSubtitlesCodepage();
        boolean isSubtitlesCodepageForcedInConfigurationAndSupportedByJVM = StringUtils.isNotBlank(cp) && Charset.isSupported(cp);
        try (BufferedReader reader = isSubtitlesCodepageForcedInConfigurationAndSupportedByJVM ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToConvert), Charset.forName(cp))) : FileUtil.createBufferedReaderDetectCharset(fileToConvert, null).getBufferedReader();
             BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputSubs), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.write(line + "\n");
            }
            output.flush();
            output.close();
        }
        return outputSubs;
    }

    public static File getSubtitles(StoreResource resource, MediaInfo media, OutputParams params, UmsConfiguration configuration, SubtitleType subtitleType) throws IOException {
        File tempSubs;
        String basename;
        if (media == null || params.getSid() == null || params.getSid().getId() == Integer.MIN_VALUE || !params.getSid().getType().isText()) {
            return null;
        }
        String dir2 = configuration.getDataFile(SUB_DIR);
        File subsPath = new File(dir2);
        if (!subsPath.exists() && !subsPath.mkdirs()) {
            LOGGER.error("Could not create subtitles conversion folder \"{}\" - subtitles operation aborted!", (Object)dir2);
            return null;
        }
        if (params.getSid().isExternal() && params.getSid().getExternalFile() == null) {
            return null;
        }
        boolean applyFontConfig = configuration.isFFmpegFontConfig();
        boolean isEmbeddedSource = params.getSid().isEmbedded();
        boolean is3D = media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().is3d() && !media.getDefaultVideoTrack().multiViewIsAnaglyph();
        File convertedFile = params.getSid().getConvertedFile();
        if (convertedFile != null && convertedFile.canRead()) {
            params.getSid().setType(SubtitleType.ASS);
            params.getSid().setSubCharacterSet(Constants.CHARSET_UTF_8);
            return convertedFile;
        }
        String filename = isEmbeddedSource ? resource.getFileName() : params.getSid().getExternalFile().getAbsolutePath();
        long modId = new File(filename).lastModified();
        if (modId != 0L) {
            basename = FilenameUtils.getBaseName(filename).replaceAll("[<>:\"\\\\/|?*+\\[\\]\n\r ']", "").trim();
        } else {
            basename = resource.getName().replaceAll("[<>:\"\\\\/|?*+\\[\\]\n\r ']", "").trim();
            modId = filename.hashCode();
        }
        StringBuilder nameBuilder = new StringBuilder(subsPath.getAbsolutePath());
        nameBuilder.append(File.separator).append(basename);
        if (isEmbeddedSource) {
            nameBuilder.append("_ID").append(params.getSid().getId());
        }
        if (applyFontConfig) {
            nameBuilder.append("_FB");
        }
        if (is3D) {
            nameBuilder.append("_3D");
        }
        nameBuilder.append("_").append(modId);
        String extension = subtitleType != null && StringUtils.isNotBlank(subtitleType.getExtension()) ? subtitleType.getExtension() : FileUtil.getExtension(basename);
        if (StringUtils.isNotBlank(extension)) {
            nameBuilder.append(".").append(extension);
        }
        File convertedSubs = new File(nameBuilder.toString());
        File converted3DSubs = new File(FileUtil.getFileNameWithoutExtension(convertedSubs.getAbsolutePath()) + "_3D.ass");
        if (convertedSubs.canRead() || converted3DSubs.canRead()) {
            if (applyFontConfig || isEmbeddedSource || is3D) {
                params.getSid().setType(SubtitleType.ASS);
                params.getSid().setSubCharacterSet(Constants.CHARSET_UTF_8);
                if (converted3DSubs.canRead()) {
                    convertedSubs = converted3DSubs;
                }
            }
            params.getSid().setConvertedFile(convertedSubs);
            return convertedSubs;
        }
        boolean isExternalAss = false;
        if (params.getSid().getType() == SubtitleType.ASS && params.getSid().isExternal() && !isEmbeddedSource) {
            isExternalAss = true;
        }
        if ((tempSubs = isExternalAss || !applyFontConfig && !isEmbeddedSource && params.getSid().getType() == subtitleType && (params.getSid().getType() == SubtitleType.SUBRIP || params.getSid().getType() == SubtitleType.WEBVTT) && !is3D ? params.getSid().getExternalFile() : SubtitleUtils.convertSubsToSubtitleType(filename, media, params, configuration, subtitleType)) == null) {
            return null;
        }
        if (!FileUtil.isFileUTF8(tempSubs)) {
            try {
                tempSubs = SubtitleUtils.applyCodepageConversion(tempSubs, convertedSubs);
                params.getSid().setSubCharacterSet(Constants.CHARSET_UTF_8);
            }
            catch (IOException ex) {
                params.getSid().setSubCharacterSet(null);
                LOGGER.warn("Exception during external file charset detection.", ex);
            }
        } else {
            FileUtils.copyFile(tempSubs, convertedSubs);
            tempSubs = convertedSubs;
        }
        if (applyFontConfig && (!configuration.isUseEmbeddedSubtitlesStyle() || params.getSid().getType() != SubtitleType.ASS)) {
            try {
                tempSubs = SubtitleUtils.applyFontconfigToASSTempSubsFile(tempSubs, media, configuration);
                params.getSid().setSubCharacterSet(Constants.CHARSET_UTF_8);
            }
            catch (IOException e) {
                LOGGER.debug("Applying subs setting ends with error: " + e);
                return null;
            }
        }
        if (is3D) {
            try {
                tempSubs = SubtitleUtils.convertASSToASS3D(tempSubs, media, params);
            }
            catch (IOException | NullPointerException e) {
                LOGGER.debug("Converting to ASS3D format ends with error: " + e);
                return null;
            }
        }
        if (isEmbeddedSource) {
            params.getSid().setType(SubtitleType.ASS);
        }
        PMS.get().addTempFile(tempSubs, -1702967296);
        params.getSid().setConvertedFile(tempSubs);
        return tempSubs;
    }

    public static File convertSubsToSubtitleType(String fileName, MediaInfo media, OutputParams params, UmsConfiguration configuration, SubtitleType outputSubtitleType) {
        File tempSubsFile;
        if (!params.getSid().getType().isText()) {
            return null;
        }
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO));
        cmdList.add("-y");
        cmdList.add("-loglevel");
        FFmpegLogLevels askedLogLevel = FFmpegLogLevels.valueOfLabel(configuration.getFFmpegLoggingLevel());
        if (LOGGER.isTraceEnabled()) {
            if (FFmpegLogLevels.INFO.isMoreVerboseThan(askedLogLevel)) {
                cmdList.add("info");
            } else {
                cmdList.add(askedLogLevel.label);
            }
        } else if (FFmpegLogLevels.FATAL.isMoreVerboseThan(askedLogLevel)) {
            cmdList.add("fatal");
        } else {
            cmdList.add(askedLogLevel.label);
        }
        if (params.getSid().isExternal() && !params.getSid().isExternalFileUtf8()) {
            String encoding;
            String string = StringUtils.isNotBlank(configuration.getSubtitlesCodepage()) ? configuration.getSubtitlesCodepage() : (encoding = params.getSid().getSubCharacterSet() != null ? params.getSid().getSubCharacterSet() : null);
            if (encoding != null) {
                cmdList.add("-sub_charenc");
                cmdList.add(encoding);
            }
        }
        cmdList.add("-i");
        cmdList.add(fileName);
        if (params.getSid().isEmbedded()) {
            cmdList.add("-map");
            cmdList.add("0:s:" + media.getSubtitlesTracks().indexOf(params.getSid()));
        }
        try {
            tempSubsFile = new File(CONFIGURATION.getTempFolder(), FilenameUtils.getBaseName(fileName) + "." + outputSubtitleType.getExtension());
        }
        catch (IOException e1) {
            LOGGER.debug("Subtitles conversion finished with error: " + e1);
            return null;
        }
        cmdList.add(tempSubsFile.getAbsolutePath());
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.runInNewThread();
        try {
            pw.join();
            pw.stopProcess();
        }
        catch (InterruptedException e) {
            LOGGER.debug("Subtitles conversion finished with error: " + e);
            Thread.currentThread().interrupt();
            return null;
        }
        tempSubsFile.deleteOnExit();
        return tempSubsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File applyFontconfigToASSTempSubsFile(File tempSubs, MediaInfo media, UmsConfiguration configuration) throws IOException {
        LOGGER.debug("Applying fontconfig to subtitles " + tempSubs.getName());
        File outputSubs = tempSubs;
        StringBuilder outputString = new StringBuilder();
        File temp = new File(CONFIGURATION.getTempFolder(), tempSubs.getName() + ".tmp");
        FileUtils.copyFile(tempSubs, temp);
        try (FileUtil.BufferedReaderDetectCharsetResult input = FileUtil.createBufferedReaderDetectCharset(temp, StandardCharsets.UTF_8);
             BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputSubs), input.getCharset()));){
            String line;
            String[] format = null;
            boolean playResIsSet = false;
            BufferedReader reader = input.getBufferedReader();
            while ((line = reader.readLine()) != null) {
                outputString.setLength(0);
                if (line.contains("[Script Info]")) {
                    outputString.append(line).append("\n");
                    output.write(outputString.toString());
                    while ((line = reader.readLine()) != null) {
                        outputString.setLength(0);
                        if (StringUtils.isNotBlank(line)) {
                            if (line.contains("PlayResY:") || line.contains("PlayResX:")) {
                                playResIsSet = true;
                            }
                            outputString.append(line).append("\n");
                            output.write(outputString.toString());
                            continue;
                        }
                        if (playResIsSet) break;
                        outputString.append("PlayResY: ").append(media.getHeight()).append("\n");
                        outputString.append("PlayResX: ").append(media.getWidth()).append("\n");
                        break;
                    }
                }
                if (line != null && line.contains("Format:")) {
                    format = line.split(",");
                    outputString.append(line).append("\n");
                    output.write(outputString.toString());
                    continue;
                }
                if (line != null && line.contains("Style: Default")) {
                    Object[] params = line.split(",");
                    int length = format != null ? format.length : 0;
                    block31: for (int i = 0; i < length; ++i) {
                        switch (format[i].trim()) {
                            case "Fontname": {
                                if (configuration.getFont().isEmpty()) continue block31;
                                params[i] = configuration.getFont();
                                continue block31;
                            }
                            case "Fontsize": {
                                if (!playResIsSet) {
                                    params[i] = Integer.toString((int)((double)(Integer.parseInt((String)params[i]) * media.getHeight()) / 288.0 * Double.parseDouble(configuration.getAssScale())));
                                    continue block31;
                                }
                                params[i] = Integer.toString((int)((double)Integer.parseInt((String)params[i]) * Double.parseDouble(configuration.getAssScale())));
                                continue block31;
                            }
                            case "PrimaryColour": {
                                params[i] = configuration.getSubsColor().getASSv4StylesHexValue();
                                continue block31;
                            }
                            case "Outline": {
                                params[i] = configuration.getAssOutline();
                                continue block31;
                            }
                            case "Shadow": {
                                params[i] = configuration.getAssShadow();
                                continue block31;
                            }
                            case "MarginV": {
                                params[i] = configuration.getAssMargin();
                                continue block31;
                            }
                        }
                    }
                    outputString.append(StringUtils.join(params, ",")).append("\n");
                    output.write(outputString.toString());
                    continue;
                }
                outputString.append(line).append("\n");
                output.write(outputString.toString());
                output.flush();
            }
        }
        finally {
            temp.deleteOnExit();
        }
        return outputSubs;
    }

    public static File convertASSToASS3D(File tempSubs, MediaInfo media, OutputParams params) throws IOException, NullPointerException {
        boolean isSBS;
        MediaVideo.Mode3D mode3D;
        File outputSubs = new File(FileUtil.getFileNameWithoutExtension(tempSubs.getAbsolutePath()) + "_3D.ass");
        StringBuilder outputString = new StringBuilder();
        Charset subsFileCharset = FileUtil.getFileCharset(tempSubs);
        if (subsFileCharset == null) {
            subsFileCharset = StandardCharsets.UTF_8;
        }
        boolean isOU = (mode3D = media.getDefaultVideoTrack().get3DLayout()) == MediaVideo.Mode3D.ABL || mode3D == MediaVideo.Mode3D.ABR || mode3D == MediaVideo.Mode3D.AB2L;
        boolean bl = isSBS = mode3D == MediaVideo.Mode3D.SBSL || mode3D == MediaVideo.Mode3D.SBSR || mode3D == MediaVideo.Mode3D.SBS2L;
        if (mode3D == null) {
            LOGGER.debug("The 3D layout not recognized for the 3D video");
            throw new NullPointerException("The 3D layout not recognized for the 3D video");
        }
        int depth3D = CONFIGURATION.getDepth3D();
        Pattern timePattern = Pattern.compile("[0-9]:[0-9]{2}:[0-9]{2}.[0-9]{2},[0-9]:[0-9]{2}:[0-9]{2}.[0-9]{2},");
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempSubs), subsFileCharset));
             BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputSubs), StandardCharsets.UTF_8));){
            String line;
            outputString.append("[Script Info]\n");
            outputString.append("ScriptType: v4.00+\n");
            outputString.append("Collisions: Normal\n");
            outputString.append("PlayResX: ").append("384\n");
            outputString.append("PlayResY: ").append("288\n");
            outputString.append("ScaledBorderAndShadow: yes\n");
            outputString.append("PlayDepth: 0\n");
            outputString.append("Timer: 100.0\n");
            outputString.append("WrapStyle: 0\n\n");
            outputString.append("[V4+ Styles]\n");
            outputString.append("Format: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\n");
            String fontScaleX = "1";
            String fontScaleY = "1";
            if (isOU) {
                fontScaleX = Double.toString(100.0 * Double.parseDouble(CONFIGURATION.getAssScale()));
                fontScaleY = Double.toString(100.0 * Double.parseDouble(CONFIGURATION.getAssScale()) / 2.0);
            } else if (isSBS) {
                fontScaleX = Double.toString(100.0 * Double.parseDouble(CONFIGURATION.getAssScale()) / 2.0);
                fontScaleY = Double.toString(100.0 * Double.parseDouble(CONFIGURATION.getAssScale()));
            }
            String primaryColour = CONFIGURATION.getSubsColor().getASSv4StylesHexValue();
            String outline = CONFIGURATION.getAssOutline();
            String shadow = CONFIGURATION.getAssShadow();
            outputString.append("Style: Default,Arial,").append("15").append(',').append(primaryColour).append(",&H000000FF,&H00000000,&H00000000,0,0,0,0,").append(fontScaleX).append(',').append(fontScaleY).append(",0,0,1,").append(outline).append(',').append(shadow);
            if (isOU) {
                outputString.append(",2,15,15,15,0\n\n");
            } else if (isSBS) {
                outputString.append(",2,0,0,15,0\n\n");
            }
            outputString.append("[Events]\n");
            outputString.append("Format: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\n\n");
            output.write(outputString.toString());
            int textPosition = 0;
            while ((line = input.readLine()) != null) {
                if (line.startsWith("[Events]") && (line = input.readLine()) != null && line.startsWith("Format:")) {
                    String[] formatPattern = line.split(",");
                    int i = 0;
                    for (String component : formatPattern) {
                        if (component.trim().equals("Text")) {
                            textPosition = i;
                        }
                        ++i;
                    }
                }
                outputString.setLength(0);
                if (line == null || !line.startsWith("Dialogue:") || !line.contains("Default")) continue;
                Object[] dialogPattern = line.split(",");
                String text = StringUtils.join(dialogPattern, ",", textPosition, dialogPattern.length);
                Matcher timeMatcher = timePattern.matcher(line);
                if (timeMatcher.find()) {
                    if (isOU) {
                        outputString.append("Dialogue: 0,").append(timeMatcher.group()).append("Default,,");
                        if (depth3D > 0) {
                            outputString.append("0000,").append(String.format("%04d,", depth3D));
                        } else if (depth3D < 0) {
                            outputString.append(String.format("%04d,", -depth3D)).append("0000,");
                        } else {
                            outputString.append("0000,0000,");
                        }
                        outputString.append(String.format("%04d,,", 159)).append(text).append("\n").append("Dialogue: 0,").append(timeMatcher.group()).append("Default,,0000,0000,0000,,").append(text).append("\n");
                    } else if (isSBS) {
                        outputString.append("Dialogue: 0,").append(timeMatcher.group()).append("Default,,").append("0000,").append(String.format("%04d,", 192 - depth3D)).append("0000,,").append(text).append("\n").append("Dialogue: 0,").append(timeMatcher.group()).append("Default,,").append(String.format("%04d,", 192 - depth3D)).append("0000,0000,,").append(text).append("\n");
                    }
                }
                output.write(outputString.toString());
            }
            output.flush();
        }
        LOGGER.debug("Subtitles converted to 3DASS format and stored in the file: \"{}\"", (Object)outputSubs.getName());
        tempSubs.deleteOnExit();
        return outputSubs;
    }

    public static void deleteSubs() {
        FileUtils.deleteQuietly(new File(CONFIGURATION.getDataFile(SUB_DIR)));
    }

    /*
     * Exception decompiling
     */
    public static InputStream removeSubRipTags(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File isSubtitlesFolder(File folder, CharSequence name) {
        if (folder == null || name == null) {
            return null;
        }
        if (name.length() == 4 || name.length() == SUBTITLES_LOWER_CASE.length) {
            int lastIdx = name.length() - 1;
            for (int i = 0; i <= lastIdx; ++i) {
                char c = name.charAt(i);
                if (i == lastIdx && (c == SUBTITLES_LOWER_CASE[0] || c == SUBTITLES_UPPER_CASE[0])) {
                    File subsFolder = new File(folder, name.toString());
                    return subsFolder.isDirectory() ? subsFolder : null;
                }
                if (c == SUBTITLES_LOWER_CASE[i] || c == SUBTITLES_UPPER_CASE[i]) continue;
                return null;
            }
        }
        return null;
    }

    private static boolean isSubtitlesFile(File file, Set<String> supportedExtensions) {
        String extension = FileUtil.getExtension(file.getPath(), StringUtil.LetterCase.LOWER, Locale.ROOT);
        if ("sub".equals(extension)) {
            return FileUtil.replaceExtension(file, "idx", true, true) == null;
        }
        return supportedExtensions.contains(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean searchAndAttachExternalSubtitles(File file, MediaInfo media, boolean forceRefresh) {
        boolean bl;
        File subFolder;
        if (file == null || media == null) {
            return false;
        }
        if (file.isAbsolute()) {
            subFolder = file.getParentFile();
        } else {
            try {
                subFolder = file.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                LOGGER.error("Could not find the folder for \"{}\" when looking for external subtitles", (Object)file);
                return false;
            }
        }
        if (subFolder == null) {
            return false;
        }
        LOGGER.trace("Searching for external subtitles for {}", (Object)file.getName());
        ArrayList<File> folders = new ArrayList<File>();
        if (subFolder.isDirectory()) {
            folders.add(subFolder);
        }
        if (ALTERNATIVE_SUBTITLES_FOLDER != null) {
            if (ALTERNATIVE_SUBTITLES_FOLDER.isAbsolute()) {
                folders.add(ALTERNATIVE_SUBTITLES_FOLDER);
            } else {
                File tmpFolder = new File(subFolder, ALTERNATIVE_SUBTITLES_FOLDER.toString());
                if (tmpFolder.isDirectory()) {
                    folders.add(tmpFolder);
                }
            }
        }
        if (folders.isEmpty()) {
            LOGGER.trace("There are no folders to search for subtitles for {}", (Object)file.getName());
            return false;
        }
        Set<String> supportedFileExtensions = SubtitleType.getSupportedFileExtensions();
        boolean cleaned = false;
        ArrayList<File> folderSubtitles = new ArrayList<File>();
        for (File file2 : folders) {
            CacheFolder cacheFolder = null;
            Object object = FOLDER_CACHE;
            synchronized (object) {
                if (cleaned) {
                    if (forceRefresh) {
                        FOLDER_CACHE.remove(file2);
                    }
                    cacheFolder = FOLDER_CACHE.get(file2);
                } else {
                    long earliestBirth = System.currentTimeMillis() - 300000L;
                    String[] iterator = FOLDER_CACHE.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<File, CacheFolder> entry = iterator.next();
                        if (entry.getValue().getBirth() < earliestBirth) {
                            iterator.remove();
                            continue;
                        }
                        if (!file2.equals(entry.getKey())) continue;
                        if (forceRefresh) {
                            iterator.remove();
                            continue;
                        }
                        cacheFolder = entry.getValue();
                    }
                    cleaned = true;
                }
                if (cacheFolder == null) {
                    cacheFolder = new CacheFolder();
                    FOLDER_CACHE.put(file2, cacheFolder);
                }
            }
            object = cacheFolder;
            synchronized (object) {
                if (!cacheFolder.isPopulated()) {
                    ArrayList<File> folderSubtitlesList = new ArrayList<File>();
                    String[] folderContent = file2.list();
                    if (folderContent != null && folderContent.length > 0) {
                        for (String fileNameEntry : folderContent) {
                            File fileEntry;
                            File file3 = fileEntry = subFolder.equals(file2) ? SubtitleUtils.isSubtitlesFolder(file2, fileNameEntry) : null;
                            if (fileEntry != null) {
                                String[] subsFolderContent = fileEntry.list();
                                if (subsFolderContent == null || subsFolderContent.length <= 0) continue;
                                for (String subsFileNameEntry : subsFolderContent) {
                                    File subsFileEntry = new File(fileEntry, subsFileNameEntry);
                                    if (!SubtitleUtils.isSubtitlesFile(subsFileEntry, supportedFileExtensions) || !subsFileEntry.isFile() || subsFileEntry.isHidden()) continue;
                                    folderSubtitlesList.add(subsFileEntry);
                                }
                                continue;
                            }
                            fileEntry = new File(file2, fileNameEntry);
                            if (!SubtitleUtils.isSubtitlesFile(fileEntry, supportedFileExtensions) || !fileEntry.isFile() || fileEntry.isHidden()) continue;
                            folderSubtitlesList.add(fileEntry);
                        }
                    }
                    cacheFolder.setItems(folderSubtitlesList);
                    folderSubtitles.addAll(folderSubtitlesList);
                } else {
                    folderSubtitles.addAll(Arrays.asList(cacheFolder.getItems()));
                }
            }
        }
        HashSet<File> existingSubtitles = new HashSet<File>();
        for (MediaSubtitle subtitle : media.getSubtitlesTracks()) {
            if (subtitle == null || subtitle.getExternalFile() == null) continue;
            existingSubtitles.add(subtitle.getExternalFile());
        }
        boolean bl2 = false;
        String baseFileName = FileUtil.getFileNameWithoutExtension(file.getName()).toLowerCase(Locale.ROOT);
        block13: for (File subtitlesFile : folderSubtitles) {
            boolean bl3;
            List<String> suffixParts;
            if (existingSubtitles.contains(subtitlesFile)) continue;
            String subtitlesName = subtitlesFile.getName();
            String subtitlesNameLower = subtitlesName.toLowerCase(Locale.ROOT);
            if (subtitlesNameLower.startsWith(baseFileName)) {
                suffixParts = Arrays.asList(FileUtil.getFileNameWithoutExtension(subtitlesNameLower).replace(baseFileName, "").split("[\\s\\.-]+"));
                SubtitleUtils.attachExternalSubtitlesFile(subtitlesFile, media, suffixParts);
                bl3 = true;
                continue;
            }
            if (SubtitleUtils.isSubtitlesFolder(subtitlesFile.getParentFile(), subtitlesName) == null) continue;
            suffixParts = Arrays.asList(FileUtil.getFileNameWithoutExtension(subtitlesNameLower).split("[\\s\\.-]+"));
            for (String suffixPart : suffixParts) {
                if (!Iso639.isValid(suffixPart)) continue;
                SubtitleUtils.attachExternalSubtitlesFile(subtitlesFile, media, suffixParts);
                bl3 = true;
                continue block13;
            }
        }
        Iterator<MediaSubtitle> iterator = media.getSubtitlesTracks().iterator();
        while (iterator.hasNext()) {
            MediaSubtitle subtitles = iterator.next();
            if (!subtitles.isExternal() || folderSubtitles.contains(subtitles.getExternalFile())) continue;
            bl = true;
            iterator.remove();
        }
        return bl;
    }

    private static void attachExternalSubtitlesFile(File subtitlesFile, MediaInfo media, List<String> suffixParts) {
        LOGGER.trace("Attaching external subtitles file for {}", (Object)subtitlesFile.getName());
        MediaSubtitle subtitles = new MediaSubtitle();
        subtitles.setType(SubtitleType.valueOfFileExtension(FileUtil.getExtension(subtitlesFile.getPath(), StringUtil.LetterCase.LOWER, Locale.ROOT)));
        String language = null;
        if (suffixParts != null && !suffixParts.isEmpty()) {
            ArrayList<String> modifiableSuffixParts = new ArrayList<String>(suffixParts);
            Iterator<String> iterator = modifiableSuffixParts.iterator();
            while (iterator.hasNext()) {
                String part = iterator.next();
                if (StringUtils.isBlank(part)) {
                    iterator.remove();
                    continue;
                }
                if (!Iso639.isValid(part)) continue;
                language = Iso639.getISO639_2Code(part);
                iterator.remove();
            }
            if (!modifiableSuffixParts.isEmpty()) {
                subtitles.setTitle(StringUtils.join(modifiableSuffixParts, '-'));
            }
        }
        try {
            if (StringUtils.isNotBlank(language)) {
                subtitles.setLang(language);
            }
            subtitles.setExternalFile(subtitlesFile);
            if (subtitles.getLang() == null) {
                subtitles.setLang("und");
            }
            media.addSubtitlesTrack(subtitles);
            LOGGER.trace("Added external subtitles file {} to the media {}", (Object)subtitlesFile.getName(), (Object)media.toString());
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("File not found during external subtitles scan: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    private static int getPriorityIndex(List<String> languagePriorities, String languageCode) {
        if (StringUtils.isBlank(languageCode)) {
            return languagePriorities.size();
        }
        for (int i = 0; i < languagePriorities.size(); ++i) {
            String code = languagePriorities.get(i);
            if (!"*".equals(code) && !"und".equals(code) && !Iso639.isCodesMatching(languageCode, code)) continue;
            return i;
        }
        return languagePriorities.size();
    }

    public static MediaSubtitle findPrioritizedSubtitles(Collection<MediaSubtitle> candidates, Renderer renderer, boolean returnNotPrioritized) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        ArrayList<String> languagePriorities = new ArrayList<String>();
        for (String language : UMSUtils.getLangList(renderer, false).split(",")) {
            if (!StringUtils.isNotBlank(language)) continue;
            languagePriorities.add(language.trim().toLowerCase(Locale.ROOT));
        }
        LOGGER.trace("Looking for subtitles with the highest priority from {}", (Object)StringUtils.join(languagePriorities, ", "));
        ArrayList<MediaSubtitle> candidatesList = new ArrayList<MediaSubtitle>(candidates);
        Collections.sort(candidatesList, (o1, o2) -> {
            int o2Priority;
            int o1Priority;
            if (StringUtils.isBlank(o1.getLang()) || StringUtils.isBlank(o2.getLang())) {
                if (StringUtils.isNotBlank(o1.getLang()) || StringUtils.isNotBlank(o2.getLang())) {
                    return StringUtils.isBlank(o1.getLang()) ? 1 : -1;
                }
            } else if (!Iso639.isCodesMatching(o1.getLang(), o2.getLang()) && (o1Priority = SubtitleUtils.getPriorityIndex(languagePriorities, o1.getLang())) != (o2Priority = SubtitleUtils.getPriorityIndex(languagePriorities, o2.getLang()))) {
                return o1Priority - o2Priority;
            }
            if (o1.isExternal() == o2.isExternal()) {
                return 0;
            }
            return o1.isExternal() ? -1 : 1;
        });
        MediaSubtitle result = candidatesList.get(0);
        int priority = SubtitleUtils.getPriorityIndex(languagePriorities, result.getLang());
        if (priority == languagePriorities.size()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("No prioritized subtitles language found, returning: {}", returnNotPrioritized ? result : "null");
            }
            return returnNotPrioritized ? result : null;
        }
        LOGGER.trace("Returning subtitles with priority {}: {}", (Object)result);
        return result;
    }

    static {
        String subtitles = "Subtitles";
        SUBTITLES_UPPER_CASE = new char[subtitles.length()];
        SUBTITLES_LOWER_CASE = new char[subtitles.length()];
        for (int i = 0; i < subtitles.length(); ++i) {
            SubtitleUtils.SUBTITLES_UPPER_CASE[i] = Character.toUpperCase(subtitles.charAt(i));
            SubtitleUtils.SUBTITLES_LOWER_CASE[i] = Character.toLowerCase(subtitles.charAt(i));
        }
        if (PMS.getConfiguration() == null || StringUtils.isBlank(PMS.getConfiguration().getAlternateSubtitlesFolder())) {
            ALTERNATIVE_SUBTITLES_FOLDER = null;
        } else {
            File alternativeFolder = new File(PMS.getConfiguration().getAlternateSubtitlesFolder());
            if (alternativeFolder.isAbsolute()) {
                try {
                    if (!new FilePermissions(alternativeFolder).isBrowsable()) {
                        alternativeFolder = null;
                        LOGGER.error("Ignoring alternative subtitles folder \"{}\" because of lacking permissions", (Object)alternativeFolder);
                    }
                }
                catch (FileNotFoundException e) {
                    alternativeFolder = null;
                    LOGGER.error("Alternative subtitles folder \"{}\" not found", (Object)alternativeFolder);
                }
                if (alternativeFolder != null && !alternativeFolder.isDirectory()) {
                    alternativeFolder = null;
                    LOGGER.error("Alternative subtitles folder \"{}\" isn't a folder", (Object)alternativeFolder);
                }
                ALTERNATIVE_SUBTITLES_FOLDER = alternativeFolder;
            } else {
                ALTERNATIVE_SUBTITLES_FOLDER = alternativeFolder;
            }
        }
        FILE_CHARSET_TO_MENCODER_SUBCP_OPTION_MAP = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(Constants.CHARSET_IBM855, "enca:ru:cp1251");
                this.put(Constants.CHARSET_ISO_8859_5, "enca:ru:cp1251");
                this.put(Constants.CHARSET_KOI8_R, "enca:ru:cp1251");
                this.put(Constants.CHARSET_MACCYRILLIC, "enca:ru:cp1251");
                this.put(Constants.CHARSET_WINDOWS_1251, "enca:ru:cp1251");
                this.put(Constants.CHARSET_IBM866, "enca:ru:cp1251");
                this.put(Constants.CHARSET_WINDOWS_1250, "cp1250");
                this.put(Constants.CHARSET_ISO_8859_2, "ISO-8859-2");
                this.put(Constants.CHARSET_WINDOWS_1252, "cp1252");
                this.put(Constants.CHARSET_ISO_8859_1, "ISO-8859-1");
                this.put(Constants.CHARSET_WINDOWS_1253, "cp1253");
                this.put(Constants.CHARSET_ISO_8859_7, "ISO-8859-7");
                this.put(Constants.CHARSET_WINDOWS_1254, "cp1254");
                this.put(Constants.CHARSET_ISO_8859_9, "ISO-8859-9");
                this.put(Constants.CHARSET_WINDOWS_1255, "cp1255");
                this.put(Constants.CHARSET_ISO_8859_8, "ISO-8859-8");
                this.put(Constants.CHARSET_WINDOWS_1256, "cp1256");
                this.put(Constants.CHARSET_ISO_8859_6, "ISO-8859-6");
                this.put(Constants.CHARSET_ISO_2022_CN, "ISO-2022-CN");
                this.put(Constants.CHARSET_BIG5, "enca:zh:big5");
                this.put(Constants.CHARSET_GB18030, "enca:zh:big5");
                this.put(Constants.CHARSET_EUC_TW, "enca:zh:big5");
                this.put(Constants.CHARSET_ISO_2022_KR, "cp949");
                this.put(Constants.CHARSET_EUC_KR, "euc-kr");
                this.put(Constants.CHARSET_ISO_2022_JP, "ISO-2022-JP");
                this.put(Constants.CHARSET_EUC_JP, "euc-jp");
                this.put(Constants.CHARSET_SHIFT_JIS, "shift-jis");
                this.put(Constants.CHARSET_WINDOWS_874, "MS874");
                this.put(Constants.CHARSET_ISO_8859_11, "ISO-8859-11");
                this.put(Constants.CHARSET_TIS_620, "TIS-620");
            }
        };
        FOLDER_CACHE = new HashMap();
    }

    private static class CacheFolder {
        private File[] items;
        private final long birth = System.currentTimeMillis();
        private boolean populated;

        public boolean isPopulated() {
            return this.populated;
        }

        public long getBirth() {
            return this.birth;
        }

        public File[] getItems() {
            if (!this.populated) {
                throw new IllegalStateException("Instance hasn't been populated yet");
            }
            return this.items;
        }

        public void setItems(List<File> items) {
            this.setItems(items == null ? null : (File[])items.toArray(File[]::new));
        }

        public void setItems(File[] items) {
            this.populated = true;
            this.items = items == null ? new File[0] : items;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append(" [Age=");
            sb.append((System.currentTimeMillis() - this.birth) / 1000L).append(" s");
            sb.append(", Populated=").append(this.populated ? "Yes" : "No");
            if (this.items == null || this.items.length == 0) {
                sb.append(", Empty");
            } else {
                sb.append(", Items: ");
                boolean first = true;
                for (File item : this.items) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(item.getName());
                    first = false;
                }
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

