/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.pms.util.XmlUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtil.class);
    private static final int[] MULTIPLIER = new int[]{3600, 60, 1};
    public static final String SEC_TIME_FORMAT = "%02d:%02d:%02.0f";
    public static final String DURATION_TIME_FORMAT = "%02d:%02d:%05.2f";
    public static final String DLNA_DURATION_FORMAT = "%01d:%02d:%06.3f";
    public static final String NEWLINE_CHARACTER = System.getProperty("line.separator");
    public static final long KIBI = 1024L;
    public static final long MEBI = 0x100000L;
    public static final long GIBI = 0x40000000L;
    public static final long TEBI = 0x10000000000L;
    public static final long PEBI = 0x4000000000000L;
    public static final long EXBI = 0x1000000000000000L;
    public static final long KILO = 1000L;
    public static final long MEGA = 1000000L;
    public static final long GIGA = 1000000000L;
    public static final long TERA = 1000000000000L;
    public static final long PETA = 1000000000000000L;
    public static final long EXA = 1000000000000000000L;

    public static String convertURLToFileName(String url) {
        url = url.replace('/', '\u00b5');
        url = url.replace('\\', '\u00b5');
        url = url.replace(':', '\u00b5');
        url = url.replace('?', '\u00b5');
        url = url.replace('*', '\u00b5');
        url = url.replace('|', '\u00b5');
        url = url.replace('<', '\u00b5');
        url = url.replace('>', '\u00b5');
        return url;
    }

    public static double convertStringToTime(String time) throws IllegalArgumentException {
        if (StringUtils.isBlank(time)) {
            throw new IllegalArgumentException("time String should not be blank.");
        }
        try {
            return Double.parseDouble(time);
        }
        catch (NumberFormatException e) {
            String[] arguments = time.split(":");
            double sum = 0.0;
            int i = 0;
            for (String argument : arguments) {
                sum += Double.parseDouble(argument.replace(",", ".")) * (double)MULTIPLIER[i];
                ++i;
            }
            return sum;
        }
    }

    public static String convertTimeToString(double d, String timeFormat) {
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb, Locale.US);){
            double s = d % 60.0;
            int h = (int)(d / 3600.0);
            int m = (int)(d / 60.0) % 60;
            formatter.format(timeFormat, h, m, s);
        }
        return sb.toString();
    }

    public static String formatDLNADuration(double duration) {
        int minutes;
        int hours;
        double seconds;
        if (duration < 0.0) {
            seconds = 0.0;
            hours = 0;
            minutes = 0;
        } else {
            seconds = duration % 60.0;
            hours = (int)(duration / 3600.0);
            minutes = (int)(duration / 60.0) % 60;
        }
        if (hours > 99999) {
            hours = 99999;
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb, Locale.ROOT);){
            formatter.format(DLNA_DURATION_FORMAT, hours, minutes, seconds);
        }
        return sb.toString();
    }

    public static String shortTime(String t, int n) {
        int n2 = n = n < 8 ? n : 8;
        if (!StringUtils.isBlank((CharSequence)t)) {
            int l;
            if (((String)t).startsWith("NOT_IMPLEMENTED")) {
                return ((String)t).length() > 15 ? ((String)t).substring(15) : " ";
            }
            int i = ((String)t).indexOf(46);
            if (i > -1) {
                t = ((String)t).substring(0, i);
            }
            if ((l = ((String)t).length()) < 8) {
                t = "00:00:00".substring(0, 8 - l) + (String)t;
            } else if (l > 8) {
                t = ((String)t).substring(l - 8);
            }
            for (i = 0; i < n && ((String)t).charAt(i) == "00:00:00".charAt(i); ++i) {
            }
            return ((String)t).substring(i);
        }
        return "00:00:00".substring(n);
    }

    public static boolean isZeroTime(String t) {
        return StringUtils.isBlank(t) || "00:00:00.000".contains(t);
    }

    public static int getYear(CharSequence date) {
        if (StringUtils.isBlank(date)) {
            return -1;
        }
        Pattern pattern = Pattern.compile("\\b\\d{4}\\b");
        Matcher matcher = pattern.matcher(date);
        while (matcher.find()) {
            int result = Integer.parseInt(matcher.group());
            if (result <= 1600 || result >= 2100) continue;
            return result;
        }
        return -1;
    }

    public static boolean isSameYear(CharSequence firstDate, CharSequence secondDate) {
        int first = StringUtil.getYear(firstDate);
        if (first < 0) {
            return false;
        }
        int second = StringUtil.getYear(secondDate);
        if (second < 0) {
            return false;
        }
        return first == second;
    }

    public static boolean isEqual(String first, String second) {
        return StringUtil.isEqual(first, second, false, false, false, null, false, 0, -1, -1);
    }

    public static boolean isEqual(String first, String second, boolean blankIsNull) {
        return StringUtil.isEqual(first, second, blankIsNull, false, false, null, false, 0, -1, -1);
    }

    public static boolean isEqual(String first, String second, boolean blankIsNull, boolean trim, boolean ignoreCase, Locale locale) {
        return StringUtil.isEqual(first, second, blankIsNull, trim, ignoreCase, locale, false, 0, -1, -1);
    }

    public static boolean isEqual(String first, String second, boolean blankIsNull, boolean trim, boolean ignoreCase, Locale locale, boolean shortest, int minLength) {
        return StringUtil.isEqual(first, second, blankIsNull, trim, ignoreCase, locale, shortest, minLength, -1, -1);
    }

    public static boolean isEqualFrom(String first, String second, boolean blankIsNull, boolean ignoreCase, Locale locale, int fromIdx) {
        return StringUtil.isEqual(first, second, blankIsNull, false, ignoreCase, locale, false, 0, fromIdx, -1);
    }

    public static boolean isEqualTo(String first, String second, boolean blankIsNull, boolean ignoreCase, Locale locale, int toIdx) {
        return StringUtil.isEqual(first, second, blankIsNull, false, ignoreCase, locale, false, 0, -1, toIdx);
    }

    public static boolean isEqual(String first, String second, boolean blankIsNull, boolean ignoreCase, Locale locale, int fromIdx, int toIdx) {
        return StringUtil.isEqual(first, second, blankIsNull, false, ignoreCase, locale, false, 0, fromIdx, toIdx);
    }

    protected static boolean isEqual(String first, String second, boolean blankIsNull, boolean trim, boolean ignoreCase, Locale locale, boolean shortest, int minLength, int fromIdx, int toIdx) {
        if ((trim || shortest) && (fromIdx >= 0 || toIdx >= 0)) {
            throw new IllegalArgumentException("trim or shortest and index range can't be used together");
        }
        if (blankIsNull) {
            if (first == null) {
                first = "";
            }
            if (second == null) {
                second = "";
            }
        } else if (first == null || second == null) {
            return first == null && second == null;
        }
        if (trim) {
            first = first.trim();
            second = second.trim();
        }
        if (ignoreCase) {
            if (locale == null) {
                locale = Locale.ROOT;
            }
            first = first.toLowerCase(locale);
            second = second.toLowerCase(locale);
        }
        if (shortest) {
            if (first.length() != second.length()) {
                int shortestIdx = Math.max(Math.min(first.length(), second.length()), minLength);
                first = first.substring(0, Math.min(shortestIdx, first.length()));
                second = second.substring(0, Math.min(shortestIdx, second.length()));
            }
        } else if (fromIdx >= 0 || toIdx >= 0) {
            if (fromIdx == toIdx) {
                return true;
            }
            if (fromIdx > toIdx && toIdx >= 0) {
                throw new IllegalArgumentException("fromIdx (" + fromIdx + ") > toIdx (" + toIdx + ")");
            }
            if (fromIdx >= first.length() || fromIdx >= second.length()) {
                throw new IndexOutOfBoundsException("fromIdx=" + fromIdx + ", first length=" + first.length() + ", second length=" + second.length());
            }
            if (toIdx > first.length() || toIdx > second.length()) {
                throw new IndexOutOfBoundsException("toIdx=" + fromIdx + ", first length=" + first.length() + ", second length=" + second.length());
            }
            if (fromIdx < 0) {
                fromIdx = 0;
            }
            if (toIdx < 0) {
                first = first.substring(fromIdx);
                second = second.substring(fromIdx);
            } else {
                first = first.substring(fromIdx, toIdx);
                second = second.substring(fromIdx, toIdx);
            }
        }
        if (blankIsNull && (StringUtils.isBlank(first) || StringUtils.isBlank(second))) {
            return StringUtils.isBlank(first) && StringUtils.isBlank(second);
        }
        return first.equals(second);
    }

    public static String quoteArg(String arg) {
        if (arg != null && arg.indexOf(32) > -1) {
            return "\"" + arg + "\"";
        }
        return arg;
    }

    public static String fillString(String subString, int count) {
        StringBuilder sb = new StringBuilder(subString.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(subString);
        }
        return sb.toString();
    }

    public static String fillString(char[] chars, int count) {
        StringBuilder sb = new StringBuilder(chars.length * count);
        for (int i = 0; i < count; ++i) {
            sb.append(chars);
        }
        return sb.toString();
    }

    public static String fillString(int codePoint, int count) {
        return StringUtil.fillString(Character.toChars(codePoint), count);
    }

    public static String stripHTML(String html) {
        Pattern pattern = Pattern.compile("<body>(.*)</body>", 34);
        Matcher matcher = pattern.matcher(html);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("\n    ", "").trim().replaceAll("(?i)<br>", "\n").replaceAll("<.*?>", "");
        }
        throw new IllegalArgumentException("HTML text not as expected, must have <body> section");
    }

    public static boolean hasValue(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static String caseReplace(CharSequence target, String subString) {
        return Pattern.compile(subString, 18).matcher(target).replaceAll(subString);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public static String luceneEscape(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '!': 
                case '\"': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    sb.append("\\").append(ch);
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String ffmpegEscape(String s) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("\\\\\\'");
                    continue block6;
                }
                case ':': {
                    sb.append("\\\\:");
                    continue block6;
                }
                case '\\': {
                    sb.append("/");
                    continue block6;
                }
                case ',': 
                case ';': 
                case '[': 
                case ']': {
                    sb.append("\\").append(ch);
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String prettifyXML(String xml, Charset charset, int indentWidth) throws SAXException, ParserConfigurationException, XPathExpressionException, TransformerException {
        if (StringUtils.isBlank(xml)) {
            return "";
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            Document xmlDocument = XmlUtils.xxeDisabledDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(xml.getBytes(charset))));
            return StringUtil.prettifyXML(xmlDocument, indentWidth);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read XML document, returning the source document: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return xml;
        }
    }

    public static String prettifyXML(Document xmlDocument, int indentWidth) throws SAXException, ParserConfigurationException, XPathExpressionException, TransformerException {
        xmlDocument.normalize();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", xmlDocument, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
        TransformerFactory transformerFactory = XmlUtils.xxeDisabledTransformerFactory();
        transformerFactory.setAttribute("indent-number", indentWidth);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(xmlDocument), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static String createReadableCombinedString(Collection<String> strings) {
        return StringUtil.createReadableCombinedString(strings, false, null, null);
    }

    public static String createReadableCombinedString(Collection<String> strings, boolean quote) {
        return StringUtil.createReadableCombinedString(strings, quote, null, null);
    }

    public static String createReadableCombinedString(Collection<String> strings, String separator, String lastSeparator) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        return StringUtil.createReadableCombinedString((String[])strings.toArray(String[]::new), false, separator, lastSeparator);
    }

    public static String createReadableCombinedString(Collection<String> strings, boolean quote, String separator, String lastSeparator) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        return StringUtil.createReadableCombinedString((String[])strings.toArray(String[]::new), quote, separator, lastSeparator);
    }

    public static String createReadableCombinedString(String[] strings) {
        return StringUtil.createReadableCombinedString(strings, false, null, null);
    }

    public static String createReadableCombinedString(String[] strings, boolean quote) {
        return StringUtil.createReadableCombinedString(strings, quote, null, null);
    }

    public static String createReadableCombinedString(String[] strings, String separator, String lastSeparator) {
        return StringUtil.createReadableCombinedString(strings, false, separator, lastSeparator);
    }

    public static String createReadableCombinedString(String[] strings, boolean quote, String separator, String lastSeparator) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        separator = separator == null ? ", " : (String)separator + " ";
        if (StringUtils.isBlank((CharSequence)lastSeparator)) {
            lastSeparator = " and ";
        } else {
            if (!((String)lastSeparator).substring(0, 1).equals(" ")) {
                lastSeparator = " " + (String)lastSeparator;
            }
            if (!((String)lastSeparator).substring(((String)lastSeparator).length() - 1).equals(" ")) {
                lastSeparator = (String)lastSeparator + " ";
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                if (i == strings.length - 1) {
                    sb.append((String)lastSeparator);
                } else {
                    sb.append((String)separator);
                }
            }
            if (quote) {
                sb.append("\"").append(strings[i]).append("\"");
                continue;
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    public static String formatBytes(long bytes, boolean binary) {
        return StringUtil.formatBytes(bytes, binary, Locale.ROOT);
    }

    public static String formatBytes(long bytes, boolean binary, Locale locale) {
        String unit;
        long divisor;
        if (binary && bytes < 1024L || bytes < 1000L) {
            return String.format("%d %s", bytes, bytes == 1L ? "byte" : "bytes");
        }
        if (binary && bytes < 0x100000L || bytes < 1000000L) {
            divisor = binary ? 1024L : 1000L;
            unit = binary ? "KiB" : "kB";
        } else if (binary && bytes < 0x40000000L || bytes < 1000000000L) {
            divisor = binary ? 0x100000L : 1000000L;
            unit = binary ? "MiB" : "MB";
        } else if (binary && bytes < 0x10000000000L || bytes < 1000000000000L) {
            divisor = binary ? 0x40000000L : 1000000000L;
            unit = binary ? "GiB" : "GB";
        } else if (binary && bytes < 0x4000000000000L || bytes < 1000000000000000L) {
            divisor = binary ? 0x10000000000L : 1000000000000L;
            unit = binary ? "TiB" : "TB";
        } else if (binary && bytes < 0x1000000000000000L || bytes < 1000000000000000000L) {
            divisor = binary ? 0x4000000000000L : 1000000000000000L;
            unit = binary ? "PiB" : "PB";
        } else {
            divisor = binary ? 0x1000000000000000L : 1000000000000000000L;
            String string = unit = binary ? "EiB" : "EB";
        }
        if (bytes % divisor == 0L) {
            return String.format(locale, "%d %s", bytes / divisor, unit);
        }
        return String.format(locale, "%.1f %s", (double)bytes / (double)divisor, unit);
    }

    public static boolean parseBoolean(float value, boolean unknownTrue) {
        return unknownTrue ? Float.compare(value, 0.0f) != 0 : Float.compare(value, 1.0f) == 0;
    }

    public static boolean parseBoolean(double value, boolean unknownTrue) {
        return unknownTrue ? Double.compare(value, 0.0) != 0 : Double.compare(value, 1.0) == 0;
    }

    public static boolean parseBoolean(long value, boolean unknownTrue) {
        return unknownTrue ? value != 0L : value == 1L;
    }

    public static boolean parseBoolean(int value, boolean unknownTrue) {
        return unknownTrue ? value != 0 : value == 1;
    }

    public static boolean parseBoolean(short value, boolean unknownTrue) {
        return unknownTrue ? value != 0 : value == 1;
    }

    public static boolean parseBoolean(byte value, boolean unknownTrue) {
        return unknownTrue ? value != 0 : value == 1;
    }

    public static boolean parseBoolean(Object value, boolean unknownTrue) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            Boolean boolVal = (Boolean)value;
            return boolVal;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return unknownTrue ? number.intValue() != 0 : number.intValue() == 1;
        }
        String stringValue = value.toString();
        if (StringUtils.isBlank(stringValue)) {
            return false;
        }
        return switch (stringValue = stringValue.trim().toLowerCase(Locale.ROOT)) {
            case "0", "false", "no" -> false;
            case "1", "true", "yes" -> true;
            default -> unknownTrue;
        };
    }

    public static enum LetterCase {
        UPPER,
        LOWER;

    }

    public static class LaxUnicodeUnescaper
    extends UnicodeUnescaper {
        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            try {
                return super.translate(input, index, out);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return 0;
            }
        }
    }
}

