/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 3L;
    protected static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#0.####################", DecimalFormatSymbols.getInstance(Locale.ROOT));
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE, BigInteger.ONE, BigInteger.ZERO, BigInteger.ONE);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE, BigInteger.ONE, BigInteger.ONE, BigInteger.ONE);
    public static final Rational POSITIVE_INFINITY = new Rational(BigInteger.ONE, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ONE, BigInteger.ZERO);
    public static final Rational NEGATIVE_INFINITY = new Rational(BigInteger.ONE.negate(), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ONE.negate(), BigInteger.ZERO);
    public static final Rational NaN = new Rational(BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
    protected final BigInteger numerator;
    protected final BigInteger denominator;
    protected final BigInteger reducedNumerator;
    protected final BigInteger reducedDenominator;
    protected final BigInteger greatestCommonDivisor;
    protected final int hashCode;

    protected Rational(BigInteger numerator, BigInteger denominator, BigInteger greatestCommonDivisor, BigInteger reducedNumerator, BigInteger reducedDenominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.greatestCommonDivisor = greatestCommonDivisor;
        this.reducedNumerator = reducedNumerator;
        this.reducedDenominator = reducedDenominator;
        this.hashCode = this.calculateHashCode();
    }

    @Nonnull
    public static Rational valueOf(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Double.isNaN(value)) {
            return NaN;
        }
        return Rational.valueOf(BigDecimal.valueOf(value));
    }

    @Nonnull
    public static Rational valueOf(float value) {
        if (value == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Float.isNaN(value)) {
            return NaN;
        }
        return Rational.valueOf(BigDecimal.valueOf(value));
    }

    @Nullable
    public static Rational valueOf(@Nullable BigDecimal value) {
        BigInteger denominator;
        BigInteger numerator;
        if (value == null) {
            return null;
        }
        if (value.signum() == 0) {
            return ZERO;
        }
        if (BigDecimal.ONE.equals(value)) {
            return ONE;
        }
        if (value.scale() > 0) {
            BigInteger unscaled = value.unscaledValue();
            BigInteger tmpDenominator = BigInteger.TEN.pow(value.scale());
            BigInteger tmpGreatestCommonDivisor = unscaled.gcd(tmpDenominator);
            numerator = unscaled.divide(tmpGreatestCommonDivisor);
            denominator = tmpDenominator.divide(tmpGreatestCommonDivisor);
        } else {
            numerator = value.toBigIntegerExact();
            denominator = BigInteger.ONE;
        }
        return new Rational(numerator, denominator, BigInteger.ONE, numerator, denominator);
    }

    @Nullable
    public static Rational valueOf(@Nullable String value) {
        return Rational.valueOf(value, (NumberFormat)null);
    }

    @Nullable
    public static Rational valueOf(@Nullable String value, @Nullable Locale locale) {
        return Rational.valueOf(value, locale == null ? null : NumberFormat.getInstance(locale));
    }

    @Nullable
    public static Rational valueOf(@Nullable String value, @Nullable NumberFormat numberFormat) {
        DecimalFormat decimalFormat;
        if (StringUtils.isBlank(value)) {
            return null;
        }
        String[] numbers = value.trim().split("\\s*(?:/|:)\\s*", 2);
        BigDecimal decimalNumerator = Rational.parseBigDecimal(numbers[0], decimalFormat = numberFormat instanceof DecimalFormat ? (DecimalFormat)numberFormat : null);
        if (decimalNumerator == null) {
            return null;
        }
        BigDecimal decimalDenominator = numbers.length > 1 ? Rational.parseBigDecimal(numbers[1], decimalFormat) : BigDecimal.ONE;
        if (decimalDenominator == null) {
            return null;
        }
        return Rational.valueOf(decimalNumerator, decimalDenominator);
    }

    @Nonnull
    public static Rational valueOf(int value) {
        return Rational.valueOf((long)value);
    }

    @Nonnull
    public static Rational valueOf(long value) {
        BigInteger numerator = BigInteger.valueOf(value);
        return new Rational(numerator, BigInteger.ONE, BigInteger.ONE, numerator, BigInteger.ONE);
    }

    @Nullable
    public static Rational valueOf(@Nullable BigInteger value) {
        if (value == null) {
            return null;
        }
        return new Rational(value, BigInteger.ONE, BigInteger.ONE, value, BigInteger.ONE);
    }

    @Nonnull
    public static Rational valueOf(int numerator, int denominator) {
        return Rational.valueOf((long)numerator, (long)denominator);
    }

    @Nonnull
    public static Rational valueOf(long numerator, long denominator) {
        BigInteger reducedDenominator;
        BigInteger reducedNumerator;
        BigInteger biDenominator;
        BigInteger biNumerator;
        if (numerator == 0L && denominator == 0L) {
            return NaN;
        }
        if (denominator == 0L) {
            return numerator > 0L ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (numerator == 0L) {
            return ZERO;
        }
        if (numerator == denominator) {
            return ONE;
        }
        if (denominator < 0L) {
            biNumerator = BigInteger.valueOf(-numerator);
            biDenominator = BigInteger.valueOf(-denominator);
        } else {
            biNumerator = BigInteger.valueOf(numerator);
            biDenominator = BigInteger.valueOf(denominator);
        }
        long gcd = Rational.calculateGreatestCommonDivisor(numerator, denominator);
        BigInteger greatestCommonDivisor = BigInteger.valueOf(gcd);
        if (gcd == 1L) {
            reducedNumerator = biNumerator;
            reducedDenominator = biDenominator;
        } else {
            reducedNumerator = biNumerator.divide(greatestCommonDivisor);
            reducedDenominator = biDenominator.divide(greatestCommonDivisor);
        }
        return new Rational(biNumerator, biDenominator, greatestCommonDivisor, reducedNumerator, reducedDenominator);
    }

    @Nullable
    public static Rational valueOf(@Nullable BigInteger numerator, @Nullable BigInteger denominator) {
        BigInteger reducedDenominator;
        BigInteger reducedNumerator;
        BigInteger greatestCommonDivisor;
        if (numerator == null || denominator == null) {
            return null;
        }
        if (numerator.signum() == 0 && denominator.signum() == 0) {
            return NaN;
        }
        if (denominator.signum() == 0) {
            return numerator.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (numerator.signum() == 0) {
            return ZERO;
        }
        if (numerator.equals(denominator)) {
            return ONE;
        }
        if (denominator.signum() < 0) {
            numerator = numerator.negate();
            denominator = denominator.negate();
        }
        if (BigInteger.ONE.equals(greatestCommonDivisor = Rational.calculateGreatestCommonDivisor(numerator, denominator))) {
            reducedNumerator = numerator;
            reducedDenominator = denominator;
        } else {
            reducedNumerator = numerator.divide(greatestCommonDivisor);
            reducedDenominator = denominator.divide(greatestCommonDivisor);
        }
        return new Rational(numerator, denominator, greatestCommonDivisor, reducedNumerator, reducedDenominator);
    }

    @Nullable
    public static Rational valueOf(@Nullable BigDecimal numerator, @Nullable BigDecimal denominator) {
        BigInteger reducedDenominator;
        BigInteger reducedNumerator;
        BigInteger biDenominator;
        BigInteger biNumerator;
        BigInteger greatestCommonDivisor;
        int scale;
        if (numerator == null || denominator == null) {
            return null;
        }
        if (numerator.signum() == 0 && denominator.signum() == 0) {
            return NaN;
        }
        if (denominator.signum() == 0) {
            return numerator.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (numerator.signum() == 0) {
            return ZERO;
        }
        if (numerator.equals(denominator)) {
            return ONE;
        }
        if (denominator.signum() < 0) {
            numerator = numerator.negate();
            denominator = denominator.negate();
        }
        if ((scale = Math.max(numerator.scale(), denominator.scale())) > 0) {
            numerator = numerator.scaleByPowerOfTen(scale);
            denominator = denominator.scaleByPowerOfTen(scale);
        }
        if (BigInteger.ONE.equals(greatestCommonDivisor = Rational.calculateGreatestCommonDivisor(biNumerator = numerator.toBigIntegerExact(), biDenominator = denominator.toBigIntegerExact()))) {
            reducedNumerator = biNumerator;
            reducedDenominator = biDenominator;
        } else {
            reducedNumerator = biNumerator.divide(greatestCommonDivisor);
            reducedDenominator = biDenominator.divide(greatestCommonDivisor);
        }
        return new Rational(biNumerator, biDenominator, greatestCommonDivisor, reducedNumerator, reducedDenominator);
    }

    @Nonnull
    public Rational multiply(int value) {
        return this.multiply(BigInteger.valueOf(value));
    }

    @Nonnull
    public Rational multiply(long value) {
        return this.multiply(BigInteger.valueOf(value));
    }

    @Nullable
    public Rational multiply(@Nullable BigInteger value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (value.signum() == 0) {
                return NaN;
            }
            return this.numerator.signum() == value.signum() ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (value.signum() == 0) {
            return ZERO;
        }
        if (BigInteger.ONE.equals(value.abs())) {
            return value.signum() < 0 ? this.negate() : this;
        }
        return Rational.valueOf(this.reducedNumerator.multiply(value), this.reducedDenominator);
    }

    @Nonnull
    public Rational multiply(float value) {
        if (this.isNaN() || Float.isNaN(value)) {
            return NaN;
        }
        if (this.isInfinite() || Float.isInfinite(value)) {
            if (this.signum() == 0 || value == 0.0f) {
                return NaN;
            }
            if (value > 0.0f) {
                return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            }
            return this.signum() < 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (value == 0.0f) {
            return ZERO;
        }
        return this.multiply(Rational.valueOf(value));
    }

    @Nonnull
    public Rational multiply(double value) {
        if (this.isNaN() || Double.isNaN(value)) {
            return NaN;
        }
        if (this.isInfinite() || Double.isInfinite(value)) {
            if (this.signum() == 0 || value == 0.0) {
                return NaN;
            }
            if (value > 0.0) {
                return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            }
            return this.signum() < 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (value == 0.0) {
            return ZERO;
        }
        return this.multiply(Rational.valueOf(value));
    }

    @Nullable
    public Rational multiply(@Nullable BigDecimal value) {
        if (value == null) {
            return null;
        }
        return this.multiply(Rational.valueOf(value));
    }

    @Nullable
    public Rational multiply(@Nullable Rational value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN() || value.isNaN()) {
            return NaN;
        }
        if (this.isInfinite() || value.isInfinite()) {
            if (this.signum() == 0 || value.signum() == 0) {
                return NaN;
            }
            return this.numerator.signum() == value.signum() ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (value.signum() == 0) {
            return ZERO;
        }
        if (value.numerator.abs().equals(value.denominator)) {
            return value.signum() < 0 ? this.negate() : this;
        }
        BigInteger newNumerator = this.reducedNumerator.multiply(value.reducedNumerator);
        BigInteger newDenominator = this.reducedDenominator.multiply(value.reducedDenominator);
        BigInteger gcd = newNumerator.gcd(newDenominator);
        return Rational.valueOf(newNumerator.divide(gcd), newDenominator.divide(gcd));
    }

    @Nonnull
    public Rational subtract(int value) {
        return this.add(-value);
    }

    @Nonnull
    public Rational subtract(long value) {
        return this.add(-value);
    }

    @Nullable
    public Rational subtract(@Nullable BigInteger value) {
        if (value == null) {
            return null;
        }
        return this.add(value.negate());
    }

    @Nonnull
    public Rational subtract(float value) {
        if (this.isNaN() || Float.isNaN(value)) {
            return NaN;
        }
        return this.add(-value);
    }

    @Nonnull
    public Rational subtract(double value) {
        if (this.isNaN() || Double.isNaN(value)) {
            return NaN;
        }
        return this.add(-value);
    }

    @Nullable
    public Rational subtract(@Nullable BigDecimal value) {
        if (value == null) {
            return null;
        }
        return this.add(value.negate());
    }

    @Nullable
    public Rational subtract(@Nullable Rational value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN() || value.isNaN()) {
            return NaN;
        }
        if (value.signum() == 0) {
            return this;
        }
        return this.add(value.negate());
    }

    @Nonnull
    public Rational add(int value) {
        return this.add((long)value);
    }

    @Nonnull
    public Rational add(long value) {
        return this.add(BigInteger.valueOf(value));
    }

    @Nullable
    public Rational add(@Nullable BigInteger value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isInfinite() || value.signum() == 0) {
            return this;
        }
        if (BigInteger.ONE.equals(this.denominator)) {
            return Rational.valueOf(this.numerator.add(value), this.denominator);
        }
        return Rational.valueOf(this.numerator.add(value.multiply(this.denominator)), this.denominator);
    }

    @Nonnull
    public Rational add(float value) {
        if (this.isNaN() || Float.isNaN(value)) {
            return NaN;
        }
        if (value == 0.0f) {
            return this;
        }
        if (this.isInfinite()) {
            if (Float.isInfinite(value) && (float)this.signum() != Math.signum(value)) {
                return NaN;
            }
            return this;
        }
        return this.add(Rational.valueOf(value));
    }

    @Nonnull
    public Rational add(double value) {
        if (this.isNaN() || Double.isNaN(value)) {
            return NaN;
        }
        if (value == 0.0) {
            return this;
        }
        if (this.isInfinite()) {
            if (Double.isInfinite(value) && (double)this.signum() != Math.signum(value)) {
                return NaN;
            }
            return this;
        }
        return this.add(Rational.valueOf(value));
    }

    @Nullable
    public Rational add(@Nullable BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isInfinite() || value.signum() == 0) {
            return this;
        }
        return this.add(Rational.valueOf(value));
    }

    @Nullable
    public Rational add(@Nullable Rational value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN() || value.isNaN()) {
            return NaN;
        }
        if (value.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return value;
        }
        if (this.isInfinite()) {
            if (value.isInfinite() && this.signum() != value.signum()) {
                return NaN;
            }
            return this;
        }
        BigInteger lcm = Rational.calculateLeastCommonMultiple(this.denominator, value.denominator);
        return Rational.valueOf(this.numerator.multiply(lcm.divide(this.denominator)).add(value.numerator.multiply(lcm.divide(value.denominator))), lcm);
    }

    @Nonnull
    public Rational reciprocal() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            return ZERO;
        }
        if (this.numerator.signum() == 0) {
            return NaN;
        }
        return Rational.valueOf(this.denominator, this.numerator);
    }

    @Nonnull
    public Rational divide(int value) {
        return this.divide((long)value);
    }

    @Nonnull
    public Rational divide(long value) {
        if (this.isNaN()) {
            return NaN;
        }
        if (value == 0L) {
            if (this.signum() == 0) {
                return NaN;
            }
            return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (this.signum() == 0 || this.isInfinite() || 1L == Math.abs(value)) {
            return value < 0L ? this.negate() : this;
        }
        if (value < 0L) {
            return Rational.valueOf(this.reducedNumerator.negate(), this.reducedDenominator.multiply(BigInteger.valueOf(-value)));
        }
        return Rational.valueOf(this.reducedNumerator, this.reducedDenominator.multiply(BigInteger.valueOf(value)));
    }

    @Nullable
    public Rational divide(@Nullable BigInteger value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN()) {
            return NaN;
        }
        if (value.signum() == 0) {
            if (this.signum() == 0) {
                return NaN;
            }
            return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (this.signum() == 0 || this.isInfinite() || BigInteger.ONE.equals(value.abs())) {
            return value.signum() < 0 ? this.negate() : this;
        }
        if (value.signum() < 0) {
            return Rational.valueOf(this.reducedNumerator.negate(), this.reducedDenominator.multiply(value.negate()));
        }
        return Rational.valueOf(this.reducedNumerator, this.reducedDenominator.multiply(value));
    }

    @Nonnull
    public Rational divide(float value) {
        if (this.isNaN() || Float.isNaN(value) || this.isInfinite() && Float.isInfinite(value)) {
            return NaN;
        }
        if (value == 0.0f) {
            if (this.signum() == 0) {
                return NaN;
            }
            return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (Float.isInfinite(value)) {
            return ZERO;
        }
        if (this.signum() == 0 || this.isInfinite() || 1.0f == Math.abs(value)) {
            return value < 0.0f ? this.negate() : this;
        }
        return this.divide(Rational.valueOf(value));
    }

    @Nonnull
    public Rational divide(double value) {
        if (this.isNaN() || Double.isNaN(value) || this.isInfinite() && Double.isInfinite(value)) {
            return NaN;
        }
        if (value == 0.0) {
            if (this.signum() == 0) {
                return NaN;
            }
            return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (Double.isInfinite(value)) {
            return ZERO;
        }
        if (this.signum() == 0 || this.isInfinite() || 1.0 == Math.abs(value)) {
            return value < 0.0 ? this.negate() : this;
        }
        return this.divide(Rational.valueOf(value));
    }

    @Nullable
    public Rational divide(@Nullable BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN()) {
            return NaN;
        }
        if (value.signum() == 0) {
            if (this.signum() == 0) {
                return NaN;
            }
            return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (this.signum() == 0 || this.isInfinite() || BigDecimal.ONE.equals(value.abs())) {
            return value.signum() < 0 ? this.negate() : this;
        }
        return this.divide(Rational.valueOf(value));
    }

    @Nullable
    public Rational divide(@Nullable Rational value) {
        if (value == null) {
            return null;
        }
        if (this.isNaN() || value.isNaN() || this.isInfinite() && value.isInfinite()) {
            return NaN;
        }
        if (value.signum() == 0) {
            if (this.signum() == 0) {
                return NaN;
            }
            return this.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (value.isInfinite()) {
            return ZERO;
        }
        if (this.signum() == 0 || this.isInfinite() || ONE.equals(value.abs())) {
            return value.signum() < 0 ? this.negate() : this;
        }
        return this.numerator.signum() == 0 ? this : this.multiply(value.reciprocal());
    }

    @Nonnull
    public Rational negate() {
        if (this.numerator.signum() == 0) {
            return this;
        }
        return Rational.valueOf(this.numerator.negate(), this.denominator);
    }

    @Nonnull
    public Rational abs() {
        return this.numerator.signum() < 0 ? Rational.valueOf(this.numerator.negate(), this.denominator) : this;
    }

    @Nonnull
    public Rational pow(int exponent) {
        if (this.isNaN()) {
            return NaN;
        }
        if (exponent == 0) {
            return this.signum() == 0 || this.denominator.signum() == 0 ? NaN : ONE;
        }
        if (exponent == 1) {
            return this;
        }
        if (this.isInfinite()) {
            if (exponent < 0) {
                return ZERO;
            }
            return (exponent & 1) == 0 ? this.abs() : this;
        }
        if (this.signum() == 0) {
            return exponent > 0 ? ZERO : POSITIVE_INFINITY;
        }
        if (exponent < 0) {
            if (exponent == Integer.MIN_VALUE) {
                return this.reciprocal().pow(2).pow(-(exponent / 2));
            }
            return this.reciprocal().pow(-exponent);
        }
        Rational result = this.multiply(this);
        if ((exponent & 1) == 0) {
            return result.pow(exponent / 2);
        }
        return result.pow(exponent / 2).multiply(this);
    }

    public int signum() {
        return this.numerator.signum();
    }

    public boolean isInteger() {
        return !this.isNaN() && !this.isInfinite() && BigInteger.ONE.equals(this.reducedDenominator);
    }

    public boolean isNaN() {
        return this.numerator.signum() == 0 && this.denominator.signum() == 0;
    }

    public boolean isInfinite() {
        return this.numerator.signum() != 0 && this.denominator.signum() == 0;
    }

    public boolean isInfinitePositive() {
        return this.numerator.signum() > 0 && this.denominator.signum() == 0;
    }

    public boolean isInfiniteNegative() {
        return this.numerator.signum() < 0 && this.denominator.signum() == 0;
    }

    public BigInteger getNumerator() {
        if (this.isNaN() || this.isInfinite()) {
            throw new ArithmeticException("Numerator is undefined");
        }
        return this.numerator;
    }

    public BigInteger getDenominator() {
        if (this.isNaN() || this.isInfinite()) {
            throw new ArithmeticException("Denominator is undefined");
        }
        return this.denominator;
    }

    public BigInteger getReducedNumerator() {
        if (this.isNaN() || this.isInfinite()) {
            throw new ArithmeticException("Numerator is undefined");
        }
        return this.reducedNumerator;
    }

    public BigInteger getReducedDenominator() {
        if (this.isNaN() || this.isInfinite()) {
            throw new ArithmeticException("Denominator is undefined");
        }
        return this.reducedDenominator;
    }

    public BigInteger getGreatestCommonDivisor() {
        if (this.isNaN() || this.isInfinite()) {
            throw new ArithmeticException("Greatest common divisor is undefined");
        }
        return this.greatestCommonDivisor;
    }

    public String toString() {
        return Rational.generateRationalString(this.reducedNumerator, this.reducedDenominator);
    }

    @Nonnull
    public String toUnreducedString() {
        return Rational.generateRationalString(this.numerator, this.denominator);
    }

    @Nonnull
    public String toDecimalString() {
        return this.toDecimalString(null);
    }

    @Nonnull
    public String toDecimalString(@Nullable DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            decimalFormat = DECIMALFORMAT;
        }
        return Rational.generateDecimalString(this.reducedNumerator, this.reducedDenominator, decimalFormat);
    }

    @Nonnull
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value: ").append(Rational.generateRationalString(this.numerator, this.denominator)).append(", Reduced: ").append(Rational.generateRationalString(this.reducedNumerator, this.reducedDenominator)).append(", Decimal: ").append(Rational.generateDecimalString(this.reducedNumerator, this.reducedDenominator, DECIMALFORMAT));
        return sb.toString();
    }

    @Nonnull
    public String toHexString() {
        return Rational.generateRationalHexString(this.reducedNumerator, this.reducedDenominator);
    }

    @Nonnull
    public String toUnreducedHexString() {
        return Rational.generateRationalHexString(this.numerator, this.denominator);
    }

    @Override
    public int intValue() {
        if (this.isNaN()) {
            return 0;
        }
        if (this.isInfinite()) {
            return this.numerator.signum() > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), RoundingMode.DOWN).intValue();
    }

    @Override
    public long longValue() {
        if (this.isNaN()) {
            return 0L;
        }
        if (this.isInfinite()) {
            return this.numerator.signum() > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), RoundingMode.DOWN).longValue();
    }

    @Nonnull
    public BigInteger bigIntegerValue() {
        if (this.isNaN()) {
            throw new ArithmeticException("Impossible to express NaN as BigInteger");
        }
        if (this.isInfinite()) {
            throw new ArithmeticException("Impossible to express infinity as BigInteger");
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), RoundingMode.DOWN).toBigInteger();
    }

    @Override
    public float floatValue() {
        if (this.isNaN()) {
            return Float.NaN;
        }
        if (this.isInfinitePositive()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.isInfiniteNegative()) {
            return Float.NEGATIVE_INFINITY;
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), MathContext.DECIMAL32).floatValue();
    }

    @Override
    public double doubleValue() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinitePositive()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isInfiniteNegative()) {
            return Double.NEGATIVE_INFINITY;
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), MathContext.DECIMAL64).doubleValue();
    }

    @Nonnull
    public BigDecimal bigDecimalValue() {
        if (this.isNaN()) {
            throw new ArithmeticException("Impossible to express NaN as BigDecimal");
        }
        if (this.isInfinite()) {
            throw new ArithmeticException("Impossible to express infinity as BigDecimal");
        }
        if (BigInteger.ONE.equals(this.reducedDenominator)) {
            return new BigDecimal(this.reducedNumerator);
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), 100, RoundingMode.HALF_EVEN);
    }

    @Nonnull
    public BigDecimal bigDecimalValue(RoundingMode roundingMode) {
        if (this.isNaN()) {
            throw new ArithmeticException("Impossible to express NaN as BigDecimal");
        }
        if (this.isInfinite()) {
            throw new ArithmeticException("Impossible to express infinity as BigDecimal");
        }
        if (BigInteger.ONE.equals(this.reducedDenominator)) {
            return new BigDecimal(this.reducedNumerator);
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), 100, roundingMode);
    }

    @Nonnull
    public BigDecimal bigDecimalValue(int scale, RoundingMode roundingMode) {
        if (this.isNaN()) {
            throw new ArithmeticException("Impossible to express NaN as BigDecimal");
        }
        if (this.isInfinite()) {
            throw new ArithmeticException("Impossible to express infinity as BigDecimal");
        }
        if (BigInteger.ONE.equals(this.reducedDenominator)) {
            return new BigDecimal(this.reducedNumerator);
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), scale, roundingMode);
    }

    @Nonnull
    public BigDecimal bigDecimalValue(MathContext mathContext) {
        if (this.isNaN()) {
            throw new NumberFormatException("Impossible to express NaN as BigDecimal");
        }
        if (this.isInfinite()) {
            throw new NumberFormatException("Impossible to express infinity as BigDecimal");
        }
        if (BigInteger.ONE.equals(this.reducedDenominator)) {
            return new BigDecimal(this.reducedNumerator);
        }
        return new BigDecimal(this.reducedNumerator).divide(new BigDecimal(this.reducedDenominator), mathContext);
    }

    @Override
    public int compareTo(@Nonnull Rational other) {
        if (this.isNaN()) {
            return other.isNaN() ? 0 : 1;
        }
        if (other.isNaN()) {
            return -1;
        }
        if (this.isInfinite()) {
            if (other.isInfinite()) {
                return this.signum() - other.signum();
            }
            return this.signum();
        }
        if (other.isInfinite()) {
            return -other.signum();
        }
        if (this.signum() != other.signum()) {
            return this.signum() - other.signum();
        }
        BigInteger[] multipliers = this.getMultipliers(other);
        return this.reducedNumerator.multiply(multipliers[0]).compareTo(other.reducedNumerator.multiply(multipliers[1]));
    }

    @Override
    public int compareTo(int value) {
        return this.compareTo((Number)value);
    }

    @Override
    public int compareTo(long value) {
        return this.compareTo((Number)value);
    }

    @Override
    public int compareTo(float value) {
        return this.compareTo(Float.valueOf(value));
    }

    @Override
    public int compareTo(double value) {
        return this.compareTo((Number)value);
    }

    @Override
    public int compareTo(@Nonnull Number number) {
        int numberSignum;
        boolean numberIsInfinite;
        boolean numberIsNaN;
        if (number instanceof Rational) {
            numberIsNaN = Rational.isNaN((Rational)number);
            numberIsInfinite = Rational.isInfinite((Rational)number);
            numberSignum = ((Rational)number).numerator.signum();
        } else if (number instanceof Float) {
            numberIsNaN = Float.isNaN(number.floatValue());
            numberIsInfinite = Float.isInfinite(number.floatValue());
            numberSignum = (int)Math.signum(number.floatValue());
        } else if (number instanceof Double) {
            numberIsNaN = Double.isNaN(number.doubleValue());
            numberIsInfinite = Double.isInfinite(number.doubleValue());
            numberSignum = (int)Math.signum(number.doubleValue());
        } else {
            numberIsNaN = false;
            numberIsInfinite = false;
            long l = number.longValue();
            int n = l == 0L ? 0 : (numberSignum = l > 0L ? 1 : -1);
        }
        if (this.isNaN()) {
            return numberIsNaN ? 0 : 1;
        }
        if (numberIsNaN) {
            return -1;
        }
        if (this.isInfinite()) {
            if (numberIsInfinite) {
                return this.signum() - numberSignum;
            }
            return this.signum();
        }
        if (numberIsInfinite) {
            return -numberSignum;
        }
        if (number instanceof BigInteger) {
            if (this.isInteger()) {
                return this.bigIntegerValue().compareTo((BigInteger)number);
            }
            return this.bigDecimalValue(2, RoundingMode.HALF_EVEN).compareTo(new BigDecimal((BigInteger)number));
        }
        if (number instanceof AtomicInteger || number instanceof AtomicLong || number instanceof Byte || number instanceof Integer || number instanceof Long || number instanceof Short) {
            if (this.isInteger()) {
                return this.bigIntegerValue().compareTo(BigInteger.valueOf(number.longValue()));
            }
            return this.bigDecimalValue(2, RoundingMode.HALF_EVEN).compareTo(new BigDecimal(number.longValue()));
        }
        if (number instanceof BigDecimal) {
            Rational other = Rational.valueOf((BigDecimal)number);
            return this.compareTo(other);
        }
        return this.bigDecimalValue().compareTo(new BigDecimal(number.doubleValue()));
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reducedDenominator == null ? 0 : this.reducedDenominator.hashCode());
        result = 31 * result + (this.reducedNumerator == null ? 0 : this.reducedNumerator.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Number)) {
            return false;
        }
        if (object instanceof Rational) {
            Rational other = (Rational)object;
            if (this.reducedDenominator == null ? other.reducedDenominator != null : !this.reducedDenominator.equals(other.reducedDenominator)) {
                return false;
            }
            return !(this.reducedNumerator == null ? other.reducedNumerator != null : !this.reducedNumerator.equals(other.reducedNumerator));
        }
        if (this.reducedNumerator == null || this.reducedDenominator == null) {
            throw new AssertionError((Object)"reducedNumerator or reducedDenominator is null");
        }
        return this.compareTo((Number)object) == 0;
    }

    public boolean equalsExact(Rational other) {
        return other != null && this.numerator.equals(other.numerator) && this.denominator.equals(other.denominator);
    }

    @Nonnull
    protected BigInteger[] getMultipliers(@Nonnull Rational other) {
        if (this.isNaN() || this.isInfinite() || other.isNaN() || other.isInfinite()) {
            throw new ArithmeticException("Can't calculate multipliers for NaN or infinity");
        }
        BigInteger[] result = new BigInteger[2];
        BigInteger lcm = Rational.calculateLeastCommonMultiple(this.reducedDenominator, other.reducedDenominator);
        result[0] = lcm.divide(this.reducedDenominator);
        result[1] = lcm.divide(other.reducedDenominator);
        return result;
    }

    public static long calculateGreatestCommonDivisor(long u, long v) {
        long t;
        int k;
        if (Math.abs(u) <= 1L || Math.abs(v) <= 1L) {
            return 1L;
        }
        if (u > 0L) {
            u = -u;
        }
        if (v > 0L) {
            v = -v;
        }
        for (k = 0; (u & 1L) == 0L && (v & 1L) == 0L && k < 63; ++k) {
            u >>= 1;
            v >>= 1;
        }
        if (k == 63) {
            throw new ArithmeticException("Overflow: gcd is 2^63");
        }
        long l = t = (u & 1L) == 1L ? v : -(u >> 1);
        while (true) {
            if ((t & 1L) == 0L) {
                t >>= 1;
                continue;
            }
            if (t > 0L) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = v - u >> 1) == 0L) break;
        }
        return -u * (long)(1 << k);
    }

    @Nullable
    public static BigInteger calculateGreatestCommonDivisor(@Nullable BigInteger u, @Nullable BigInteger v) {
        if (u == null || v == null) {
            return null;
        }
        if (u.abs().compareTo(BigInteger.ONE) <= 0 || v.abs().compareTo(BigInteger.ONE) <= 0) {
            return BigInteger.ONE;
        }
        return u.gcd(v);
    }

    @Nullable
    public static BigInteger calculateLeastCommonMultiple(@Nullable BigInteger u, @Nullable BigInteger v) {
        if (u == null || v == null) {
            return null;
        }
        if (u.signum() == 0 && v.signum() == 0) {
            return BigInteger.ONE;
        }
        u = u.abs();
        v = v.abs();
        if (u.signum() == 0) {
            return v;
        }
        if (v.signum() == 0) {
            return u;
        }
        return u.divide(Rational.calculateGreatestCommonDivisor(u, v)).multiply(v);
    }

    public static boolean isBlank(@Nullable Rational rational) {
        return rational == null || rational.signum() == 0;
    }

    public static boolean isNotBlank(@Nullable Rational rational) {
        return rational != null && rational.numerator.signum() != 0;
    }

    public static boolean isRegular(@Nullable Rational rational) {
        return rational != null && rational.denominator != null;
    }

    public static boolean isInteger(@Nullable Rational rational) {
        return rational != null && rational.isInteger();
    }

    public static boolean isNaN(@Nullable Rational rational) {
        return rational != null && rational.isNaN();
    }

    public static boolean isInfinite(@Nullable Rational rational) {
        return rational != null && rational.isInfinite();
    }

    public static boolean isInfinitePositive(@Nullable Rational rational) {
        return rational != null && rational.isInfinitePositive();
    }

    public static boolean isInfiniteNegative(@Nullable Rational rational) {
        return rational != null && rational.isInfiniteNegative();
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String value, @Nullable DecimalFormat decimalFormat) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if (decimalFormat != null) {
            decimalFormat.setParseBigDecimal(true);
            try {
                return (BigDecimal)decimalFormat.parseObject(value);
            }
            catch (ParseException e) {
                throw new NumberFormatException("Unable to parse \"" + value + "\": " + e.getMessage());
            }
        }
        return new BigDecimal(value);
    }

    @Nonnull
    protected static String generateRationalHexString(@Nonnull BigInteger numerator, @Nonnull BigInteger denominator) {
        if (denominator.signum() == 0) {
            if (numerator.signum() == 0) {
                return "NaN";
            }
            return numerator.signum() > 0 ? "\u221e" : "-\u221e";
        }
        if (BigInteger.ONE.equals(denominator)) {
            return numerator.toString(16);
        }
        return numerator.toString(16) + "/" + denominator.toString(16);
    }

    @Nonnull
    protected static String generateRationalString(@Nonnull BigInteger numerator, @Nonnull BigInteger denominator) {
        if (denominator.signum() == 0) {
            if (numerator.signum() == 0) {
                return "NaN";
            }
            return numerator.signum() > 0 ? "\u221e" : "-\u221e";
        }
        if (BigInteger.ONE.equals(denominator)) {
            return numerator.toString();
        }
        return numerator.toString() + "/" + denominator.toString();
    }

    protected static String generateDecimalString(@Nonnull BigInteger numerator, @Nonnull BigInteger denominator, @Nonnull DecimalFormat decimalFormat) {
        if (denominator.signum() == 0) {
            if (numerator.signum() == 0) {
                return "NaN";
            }
            return numerator.signum() > 0 ? "\u221e" : "-\u221e";
        }
        if (BigInteger.ONE.equals(denominator)) {
            return numerator.toString();
        }
        BigDecimal decimalValue = new BigDecimal(numerator).divide(new BigDecimal(denominator), 20, RoundingMode.HALF_EVEN);
        return decimalFormat.format(decimalValue);
    }
}

