/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class PropertiesWrapper {
    private final Properties properties = new Properties();
    private static final Charset ENCODING = StandardCharsets.UTF_8;

    public void loadFromByteArray(byte[] data) throws IOException {
        try {
            String utf = new String(data, ENCODING);
            try (StringReader reader = new StringReader(utf);){
                this.properties.clear();
                this.properties.load(reader);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Could not decode " + ENCODING);
        }
    }

    public void loadFromResourceFile(String filename) throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(filename);){
            this.properties.load(inputStream);
        }
    }

    public void clear() {
        this.properties.clear();
    }

    public String get(String key) {
        Object obj = this.properties.get(key);
        if (obj != null) {
            return PropertiesWrapper.trimAndRemoveQuotes("" + obj);
        }
        return "";
    }

    private static String trimAndRemoveQuotes(String in) {
        if ((in = in.trim()).startsWith("\"")) {
            in = in.substring(1);
        }
        if (in.endsWith("\"")) {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }
}

