/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.sun.jna.Platform;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pms.util.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileWatcher.class);
    private static Notifier notifier = new Notifier("File event");
    private static WatchMap keys = new WatchMap();
    private static WatchService watchService = null;
    private static boolean running = false;

    private FileWatcher() {
    }

    public static void add(Watch w) {
        LOGGER.trace("FileWatcher: Adding " + w.getFileSpec());
        try {
            Path dir2 = Paths.get(FilenameUtils.getFullPath(w.getFileSpec()), new String[0]);
            LOGGER.trace("FileWatcher: path " + dir2);
            w.init(dir2);
            if (keys.contains(w)) {
                return;
            }
            if (Watch.isRecursive(w)) {
                FileWatcher.addRecursive(w, dir2);
            } else {
                FileWatcher.add(w, dir2);
            }
        }
        catch (NullPointerException e) {
            LOGGER.info("Not watching invalid path {} for changes", (Object)w.getFileSpec());
        }
    }

    private static void add(Watch w, Path dir2) {
        if (watchService == null) {
            FileWatcher.start();
        }
        if (Platform.isMac() && (dir2.toString().contains("/Music/Audio Music Apps") || dir2.toString().contains("/Pictures/Photos Library.photoslibrary/resources/cpl/cloudsync.noindex/storage/filecache/") || dir2.toString().contains("/Pictures/Photos Library.photoslibrary/private") || dir2.toString().contains("/Pictures/Photos Library.photoslibrary/external"))) {
            return;
        }
        try {
            WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
            WatchKey key = dir2.register(watchService, events);
            keys.put(key, w);
            LOGGER.debug("Added file watch at {}: {}", (Object)dir2, (Object)w.getFileSpec());
        }
        catch (IOException e) {
            LOGGER.debug("Register error: " + e, e);
        }
    }

    private static void addRecursive(final Watch w, Path dir2) {
        try {
            Files.walkFileTree(dir2, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                    if (w.getIgnoredFolderNames().contains(dir2.toFile().getName())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    FileWatcher.add(w, dir2);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (exc instanceof AccessDeniedException) {
                        if (Files.isDirectory(file, new LinkOption[0])) {
                            LOGGER.debug("Recursion for directory {} skipped: Access Denied", (Object)file);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    return super.visitFileFailed(file, exc);
                }
            });
        }
        catch (IOException e) {
            if (e instanceof AccessDeniedException && Files.isDirectory(dir2, new LinkOption[0])) {
                LOGGER.debug("Recursion for directory {} skipped: Access Denied", (Object)dir2);
                return;
            }
            LOGGER.debug("Recursion error: " + e, e);
        }
    }

    private static void cancelWatchKey(Path dir2) {
        Iterator iterator = keys.keys().asIterator();
        while (iterator.hasNext()) {
            Path path;
            WatchKey key = (WatchKey)iterator.next();
            Watchable watchable = key.watchable();
            if (!(watchable instanceof Path) || !(path = (Path)watchable).equals(dir2)) continue;
            LOGGER.debug("Deleting expired file watch at {}", (Object)path);
            key.cancel();
        }
    }

    public static boolean remove(Watch w) {
        LOGGER.trace("FileWatcher: Removing " + w.getFileSpec());
        return keys.remove(w);
    }

    private static synchronized void start() {
        if (running) {
            return;
        }
        try {
            watchService = FileSystems.getDefault().newWatchService();
            FileWatcher.addShutdownHook();
            running = true;
        }
        catch (IOException e) {
            LOGGER.debug("Error creating WatchService: " + e, e);
        }
        new Thread(() -> {
            try {
                while (running) {
                    if (!keys.isEmpty()) {
                        FileWatcher.processNextWatchKey();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (ClosedWatchServiceException e) {
                if (running) {
                    LOGGER.debug("Event process error: " + e, e);
                }
            }
            catch (InterruptedException e) {
                if (running) {
                    LOGGER.debug("Event process error: " + e, e);
                }
                Thread.currentThread().interrupt();
            }
        }, "File watcher").start();
    }

    private static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("File watcher shutdown"){

            @Override
            public void run() {
                try {
                    running = false;
                    watchService.close();
                    LOGGER.trace("Shut down file watcher");
                }
                catch (IOException e) {
                    LOGGER.debug("Error while shutting down file watcher service: {}", e);
                }
            }
        });
    }

    private static void processNextWatchKey() throws ClosedWatchServiceException, InterruptedException {
        WatchKey key = watchService.take();
        for (WatchEvent<?> e : key.pollEvents()) {
            WatchEvent.Kind<?> kind = e.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
            WatchEvent<?> event = e;
            Path path = (Path)key.watchable();
            Path filename = path.resolve((Path)event.context());
            boolean isDir = !Files.exists(filename, new LinkOption[0]) ? FileUtil.isDirectory(filename.toString()) : Files.isDirectory(filename, new LinkOption[0]);
            Iterator iterator = ((ArrayList)keys.get(key)).iterator();
            while (iterator.hasNext()) {
                Watch w = (Watch)iterator.next();
                if (!Watch.isValid(w)) {
                    LOGGER.debug("Deleting expired file watch at {}: {}", (Object)path, (Object)w.getFileSpec());
                    iterator.remove();
                    continue;
                }
                if (!w.matcher.matches(filename)) continue;
                LOGGER.debug("{} (ct={}): {}", kind, event.count(), filename);
                if (isDir && Watch.isRecursive(w) && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    FileWatcher.addRecursive(w, filename);
                }
                notifier.schedule(new Notice(filename.toString(), kind.toString(), w, isDir), kind == StandardWatchEventKinds.ENTRY_MODIFY ? 500L : 0L);
                if (!isDir || kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                FileWatcher.cancelWatchKey(filename);
            }
        }
        if (!key.reset()) {
            keys.remove(key);
        }
    }

    public static class Watch {
        private final String fspec;
        private final int flag;
        private WeakReference<Listener> listener;
        private WeakReference<Object> item;
        private PathMatcher matcher;
        private List<String> ignoredFolderNames;

        public Watch(String fspec, Listener listener) {
            this(fspec, listener, null, 0);
        }

        public Watch(String fspec, Listener listener, Object item) {
            this(fspec, listener, item, 0);
        }

        public Watch(String fspec, Listener listener, int flag) {
            this(fspec, listener, null, flag);
        }

        public Watch(String fspec, Listener listener, Object item, int flag) {
            this.fspec = fspec.replace("\\\\", "\\").replace("\\", "\\\\");
            this.listener = new WeakReference<Listener>(listener);
            this.item = item != null ? new WeakReference<Object>(item) : null;
            this.flag = flag;
        }

        public void init(Path dir2) {
            String match = this.fspec.startsWith("glob:") || this.fspec.startsWith("regex:") ? this.fspec : "glob:" + this.fspec;
            this.matcher = dir2.getFileSystem().getPathMatcher(match);
        }

        public String getFileSpec() {
            return this.fspec;
        }

        public boolean isFlag(int value) {
            return this.flag == value;
        }

        public Object getItem() {
            return this.item != null ? this.item.get() : null;
        }

        public void setIgnoredFolderNames(List<String> ignoredFolderNames) {
            this.ignoredFolderNames = ignoredFolderNames;
        }

        public List<String> getIgnoredFolderNames() {
            return this.ignoredFolderNames != null ? this.ignoredFolderNames : List.of();
        }

        public boolean equals(Object o) {
            if (o instanceof Watch) {
                Watch other = (Watch)o;
                return this.listener.get() == other.listener.get() && this.fspec != null && this.fspec.equals(other.fspec) && (this.item == other.item || this.item != null && other.item != null && (this.item.get() == other.item.get() || this.item.get().equals(other.item.get()))) && this.flag == other.flag;
            }
            return false;
        }

        public int hashCode() {
            return this.fspec.hashCode() + this.listener.hashCode();
        }

        public static boolean isRecursive(Watch w) {
            return w.fspec.contains("**") && !w.fspec.startsWith("regex:");
        }

        public static boolean isValid(Watch w) {
            return w.listener.get() != null || w.item != null && w.item.get() == null;
        }
    }

    private static class WatchMap
    extends ConcurrentHashMap<WatchKey, ArrayList<Watch>> {
        private static final long serialVersionUID = 66052264663459389L;

        private WatchMap() {
        }

        @Override
        public void put(WatchKey k, Watch w) {
            if (!this.containsKey(k)) {
                this.put(k, new ArrayList());
            }
            ((ArrayList)this.get(k)).add(w);
        }

        public boolean contains(Watch w) {
            for (ArrayList a : this.values()) {
                if (!a.contains(w)) continue;
                return true;
            }
            return false;
        }

        public boolean remove(Watch w) {
            for (ArrayList a : this.values()) {
                if (!a.contains(w)) continue;
                return a.remove(w);
            }
            return false;
        }
    }

    private static class Notifier
    extends ScheduledThreadPoolExecutor {
        HashMap<Notice, ScheduledFuture<?>> queue = new HashMap();

        public Notifier(String name) {
            super(5, (Runnable r) -> new Thread(r, name));
            this.setRemoveOnCancelPolicy(true);
        }

        public void schedule(Notice notice, long delay) {
            notice.notifierQueue = this.queue;
            ScheduledFuture<?> superceded = this.queue.put(notice, this.schedule(notice, delay, TimeUnit.MILLISECONDS));
            if (superceded != null) {
                superceded.cancel(false);
            }
        }
    }

    private static class Notice
    implements Runnable,
    Comparable<Notice> {
        String filename;
        String kind;
        Watch watch;
        boolean isDir;
        HashMap<Notice, ScheduledFuture<?>> notifierQueue = null;

        public Notice(String filename, String kind, Watch watch, boolean isDir) {
            this.filename = filename;
            this.kind = kind;
            this.watch = watch;
            this.isDir = isDir;
        }

        @Override
        public void run() {
            ((Listener)this.watch.listener.get()).notify(this.filename, this.kind, this.watch, this.isDir);
            this.notifierQueue.remove(this);
        }

        public boolean equals(Object o) {
            if (o instanceof Notice) {
                Notice other = (Notice)o;
                return this.filename.equals(other.filename) && this.kind.equals(other.kind) && this.watch.equals(other.watch);
            }
            return false;
        }

        public int hashCode() {
            return (this.filename + this.kind).hashCode();
        }

        @Override
        public int compareTo(Notice o) {
            return (this.filename + this.kind).compareTo(o.filename + o.kind);
        }
    }

    public static interface Listener {
        public void notify(String var1, String var2, Watch var3, boolean var4);
    }
}

