/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.sun.jna.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.formats.FormatFactory;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.platform.windows.WindowsProgramPaths;
import net.pms.store.MediaInfoStore;
import net.pms.util.Constants;
import net.pms.util.FileNameMetadata;
import net.pms.util.FilePermissions;
import net.pms.util.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static final char[] FILE_SEPARATORS;
    private static final String DEFAULT_BASENAME = "NO_DEFAULT_BASENAME_SUPPLIED.conf";
    private static final String COMMON_FILE_ENDS = "\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*";
    private static final String COMMON_FILE_ENDS_MATCH = ".*\\s\\[BD.*|.*[\\s\\(]DUBBED.*|.*[\\s\\(]AC3.*|.*[\\s\\(]NTSC.*|.*[\\s\\(]TVNZ.*|.*[\\s\\(]FP.*|.*[\\s\\(]AAC.*|.*[\\s\\(]REPACK.*|.*[\\s\\(]480p.*|.*[\\s\\(]720p.*|.*[\\s\\(]m-720p.*|.*[\\s\\(]900p.*|.*[\\s\\(]1080i.*|.*[\\s\\(]1080p.*|.*[\\s\\(]2160p.*|.*[\\s\\(]WEB-DL.*|.*[\\s\\(]HDTV.*|.*[\\s\\(]DSR.*|.*[\\s\\(]PDTV.*|.*[\\s\\(]SDTV.*|.*[\\s\\(]WS.*|.*[\\s\\(]HQ.*|.*[\\s\\(]DVDRip.*|.*[\\s\\(]TVRiP.*|.*[\\s\\(]BDRip.*|.*[\\s\\(]BRRip.*|.*[\\s\\(]WEBRip.*|.*[\\s\\(]BluRay.*|.*[\\s\\(]Blu-ray.*|.*[\\s\\(]SUBBED.*|.*[\\s\\(]x264.*|.*[\\s\\(]x265.*|.*[\\s\\(]XviD.*|.*[\\s\\(]Dual\\sAudio.*|.*[\\s\\(]HSBS.*|.*[\\s\\(]H-SBS.*|.*[\\s\\(]RERiP.*|.*[\\s\\(]DIRFIX.*|.*[\\s\\(]READNFO.*|.*[\\s\\(]60FPS.*|.*[\\s\\(]HDR.*|.*[\\s\\(]DV[\\s\\(].*";
    private static final String COMMON_ANIME_FILE_ENDS = "(?i)\\s\\(1280x720.*|\\s\\(1920x1080.*|\\s\\(720x400.*|\\s[\\[\\(]\\d{3,4}p.*|\\s\\(BD.*|\\s\\[Blu-Ray.*|\\s\\[DVD.*|\\.DVD.*|\\[[0-9a-zA-Z]{8}\\]$|\\[h264.*|R1DVD.*|\\[BD.*|[\\s_]\\(Dual\\sAudio.*|\\s\\[VOSTFR\\].*|\\s\\[HD_\\d{3,4}x\\d{3,4}\\].*";
    private static final String COMMON_ANIME_FILE_ENDS_MATCH = ".*\\s\\(1280x720.*|.*\\s\\(1920x1080.*|.*\\s\\(720x400.*|.*\\s[\\[\\(]\\d{3,4}p.*|.*\\s\\(BD.*|.*\\s\\[Blu-Ray.*|.*\\s\\[DVD.*|\\.DVD.*|.*\\s\\[[0-9a-zA-Z]{8}\\]$|.*\\s\\[h264.*|.*\\sR1DVD.*|.*\\s\\[BD.*|.*[\\s_]\\(Dual\\sAudio.*|.*\\s\\[VOSTFR\\].*|.*\\s\\[HD_\\d{3,4}x\\d{3,4}\\].*|.*\\s\\(\\d{1,2}bit.*";
    private static final String SCENE_P2P_EPISODE_REGEX = "[sS](\\d{1,2})(?:\\s|)[eE](\\d{1,}\\w{1}|\\d{1,})";
    private static final String SCENE_P2P_EPISODE_SPECIAL_REGEX = "[sS](\\d{2})\\s(\\w{3,})";
    private static final String MIXED_EPISODE_CONVENTION = "\\s(?:Ep|e)(?:\\s{1,2}|)(\\d{1,4})(?:\\s|$)";
    private static final String MIXED_EPISODE_CONVENTION_MATCH = ".*\\s(?:Ep|e)(?:\\s{1,2}|)(\\d{1,4})(?:\\s|$).*";
    private static final Pattern MIXED_EPISODE_CONVENTION_PATTERN;
    private static final String SCENE_P2P_MOVIE_MATCH = "^(?!.*\\d{1,3}[\\s:][\\s-]\\s).*\\s(?:19|20)\\d{2}.*";
    private static final String MINISERIES_CONVENTION = "\\s(\\d{1,2})of\\d{1,2}\\s";
    private static final String MINISERIES_CONVENTION_MATCH = ".*\\s(\\d{1,2})of\\d{1,2}\\s.*";
    private static final Pattern MINISERIES_CONVENTION_PATTERN;
    private static final String SCENE_MULTI_EPISODE_CONVENTION = "[sS](\\d{1,2})[eE](\\d{1,})([eE]|-[eE])(\\d{1,})";
    private static final String SCENE_MULTI_EPISODE_CONVENTION_MATCH = ".*[sS](\\d{1,2})[eE](\\d{1,})([eE]|-[eE])(\\d{1,}).*";
    private static final Pattern SCENE_MULTI_EPISODE_CONVENTION_PATTERN;
    private static final String SHOW_NAME_INDEX_MATCHER = "(?i) (S\\d{2}E\\d{2}\\w{1}|S\\d{2}E\\d{2}|S\\d{2}|S\\d{2}E\\d{2}-\\d{2}|\\d{4}/\\d{2}/\\d{2})";
    private static final Pattern SHOW_NAME_INDEX_PATTERN;
    private static final Pattern SHOW_NAME_INDEX_FALLBACK_PATTERN;
    private static final String COMMON_FILE_ENDS_CASE_SENSITIVE = "\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*";
    private static final String COMMON_FILE_EDITIONS = "(?i)(?!\\()(Special\\sEdition|Unrated|Final\\sCut|Remastered|Extended\\sCut|IMAX\\sEdition|Uncensored|Directors\\sCut|Uncut)(?!\\))";
    private static final Pattern COMMON_FILE_EDITIONS_PATTERN;
    private static final String COMMON_ANIME_EPISODE_NUMBERS = "(?:[\\s']|S\\d{1,2}\\sE|\\s-\\s)(?:[eE]|)(?:[pP]|)(\\d{1,4}\\s\\d{1}|\\d{1,4})(?:\\s|'|v\\d|)?";
    private static final Pattern COMMON_ANIME_EPISODE_NUMBERS_PATTERN;
    private static final Pattern SEASON_NUMBER_IN_SERIES_TITLE_PATTERN;
    private static final String COMMON_ANIME_MULTIPLE_EPISODES_NUMBERS = "(?:[\\s']|S\\d{1,2}\\sE)(?:[pP]|)(\\d{1,4}-\\d{1,4})(?:[\\s']|v\\d)";
    private static final Pattern COMMON_ANIME_MULTIPLE_EPISODES_NUMBERS_PATTERN;

    private FileUtil() {
    }

    public static FileLocation getFileLocation(String customPath, String defaultDirectory, String defaultBasename) {
        File customFile = null;
        File directory = null;
        File file = null;
        boolean isCustom = true;
        if (StringUtils.isBlank(defaultBasename)) {
            defaultBasename = DEFAULT_BASENAME;
        }
        if (defaultDirectory == null) {
            defaultDirectory = "";
        }
        if (customPath != null) {
            customFile = new File(customPath).getAbsoluteFile();
        }
        if (customFile != null) {
            if (customFile.exists()) {
                if (customFile.isDirectory()) {
                    directory = customFile;
                    file = new File(customFile, defaultBasename).getAbsoluteFile();
                } else {
                    directory = customFile.getParentFile();
                    file = customFile;
                }
            } else {
                File parentDirectoryFile = customFile.getParentFile();
                if (parentDirectoryFile != null && parentDirectoryFile.exists()) {
                    directory = parentDirectoryFile;
                    file = customFile;
                }
            }
        }
        if (directory == null || file == null) {
            directory = new File(defaultDirectory).getAbsoluteFile();
            file = new File(directory, defaultBasename).getAbsoluteFile();
            isCustom = false;
        }
        return new FileLocation(directory, file, isCustom);
    }

    public static boolean isSeparator(String character) {
        if (character == null || character.length() != 1) {
            return false;
        }
        return FileUtil.isSeparator(character.charAt(0));
    }

    public static boolean isSeparator(char character) {
        for (char entry : FILE_SEPARATORS) {
            if (character != entry) continue;
            return true;
        }
        return false;
    }

    public static int getIndexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        if (FILE_SEPARATORS.length == 2) {
            return Math.max(fileName.lastIndexOf(FILE_SEPARATORS[0]), fileName.lastIndexOf(FILE_SEPARATORS[1]));
        }
        return fileName.lastIndexOf(FILE_SEPARATORS[0]);
    }

    public static boolean isUrl(String filename) {
        return filename != null && filename.matches("\\S+://.*");
    }

    public static String getProtocol(String filename) {
        if (FileUtil.isUrl(filename)) {
            return filename.split("://")[0].toLowerCase(Locale.ROOT);
        }
        return null;
    }

    public static URL urlFrom(String base, String filename) throws MalformedURLException {
        if (FileUtil.isUrl((String)filename)) {
            return URI.create((String)filename).normalize().toURL();
        }
        if (filename == null || ((String)filename).isEmpty()) {
            filename = "/";
        }
        if (base == null) {
            base = "";
        }
        if (((String)filename).charAt(0) != '/') {
            filename = "/" + (String)filename;
        }
        return URI.create(base).normalize().resolve((String)filename).toURL();
    }

    public static String urlJoin(String base, String filename) {
        try {
            return FileUtil.urlFrom(base, filename).toString();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return filename;
        }
    }

    public static String getUrlExtension(String u) {
        return FileUtil.getExtension(StringUtils.substringBefore(u, "?"), null, null);
    }

    @Nullable
    public static String getExtension(@Nullable File file) {
        if (file == null || file.getName() == null) {
            return null;
        }
        return FileUtil.getExtension(file.getName(), null, null);
    }

    @Nullable
    public static String getExtension(@Nullable File file, StringUtil.LetterCase convertTo, Locale locale) {
        if (file == null || file.getName() == null) {
            return null;
        }
        return FileUtil.getExtension(file.getName(), convertTo, locale);
    }

    @Nullable
    public static String getExtension(@Nullable Path file) {
        return FileUtil.getExtension(file, null, null);
    }

    @Nullable
    public static String getExtension(@Nullable Path file, StringUtil.LetterCase convertTo, Locale locale) {
        if (file == null) {
            return null;
        }
        Path fileName = file.getFileName();
        if (fileName == null || StringUtils.isBlank(fileName.toString())) {
            return null;
        }
        return FileUtil.getExtension(fileName.toString(), convertTo, locale);
    }

    @Nullable
    public static String getExtension(@Nullable String fileName) {
        return FileUtil.getExtension(fileName, null, null);
    }

    @Nullable
    public static String getExtension(@Nullable String fileName, StringUtil.LetterCase convertTo, Locale locale) {
        if (fileName == null || StringUtils.isBlank(fileName)) {
            return null;
        }
        int dot = fileName.lastIndexOf(46);
        if (dot == -1 || FileUtil.getIndexOfLastSeparator(fileName) > dot) {
            return null;
        }
        if (convertTo != null && locale == null) {
            locale = Locale.ROOT;
        }
        String extension = fileName.substring(dot + 1);
        if (convertTo == StringUtil.LetterCase.UPPER) {
            return extension.toUpperCase(locale);
        }
        if (convertTo == StringUtil.LetterCase.LOWER) {
            return extension.toLowerCase(locale);
        }
        return extension;
    }

    public static String getFileNameWithoutExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileNameWithoutExtension(file.getName());
    }

    public static String getFileNameWithoutExtension(Path file) {
        if (file == null) {
            return null;
        }
        Path fileName = file.getFileName();
        if (fileName == null) {
            return null;
        }
        return FileUtil.getFileNameWithoutExtension(fileName.toString());
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return fileName;
        }
        int point = fileName.lastIndexOf(46);
        if (point == -1 || FileUtil.getIndexOfLastSeparator(fileName) > point) {
            return fileName;
        }
        return fileName.substring(0, point);
    }

    private static FormattedNameAndEdition removeAndSaveEditionToBeAddedLater(String formattedName) {
        Object edition = null;
        Matcher m = COMMON_FILE_EDITIONS_PATTERN.matcher(formattedName);
        if (m.find()) {
            edition = m.group().replaceAll("\\.", " ");
            edition = "(" + WordUtils.capitalizeFully((String)edition) + ")";
            formattedName = formattedName.replaceAll(" - (?i)(?!\\()(Special\\sEdition|Unrated|Final\\sCut|Remastered|Extended\\sCut|IMAX\\sEdition|Uncensored|Directors\\sCut|Uncut)(?!\\))", "");
            formattedName = formattedName.replaceAll(COMMON_FILE_EDITIONS, "");
        }
        return new FormattedNameAndEdition(formattedName, (String)edition);
    }

    private static String convertFormattedNameToTitleCaseParts(String formattedName) {
        if (formattedName.equals(formattedName.toLowerCase())) {
            StringBuilder formattedNameBuilder = new StringBuilder();
            for (String part : formattedName.split(" - ")) {
                if (formattedNameBuilder.length() > 0) {
                    formattedNameBuilder.append(" - ");
                }
                formattedNameBuilder.append(FileUtil.convertLowerCaseStringToTitleCase(part));
            }
            formattedName = formattedNameBuilder.toString();
        }
        return formattedName;
    }

    private static String convertFormattedNameToTitleCase(String formattedName) {
        if (formattedName.equals(formattedName.toLowerCase())) {
            formattedName = FileUtil.convertLowerCaseStringToTitleCase(formattedName);
        }
        return formattedName;
    }

    private static String removeGroupNameFromBeginning(String formattedName) {
        if (!"".equals(formattedName) && (formattedName.startsWith("[") || formattedName.startsWith("("))) {
            Pattern pattern = Pattern.compile("^[\\[\\(][^\\]]{0,25}[\\]\\)][^\\w]*(\\w.*?)\\s*$");
            Matcher matcher = pattern.matcher(formattedName);
            if (matcher.find()) {
                formattedName = matcher.group(1);
            } else if (formattedName.endsWith("]") && (matcher = (pattern = Pattern.compile("^\\[([^\\[\\]]+)\\]\\s*$")).matcher(formattedName)).find()) {
                formattedName = matcher.group(1);
            }
        }
        return formattedName;
    }

    private static String removeFilenameEndMetadata(String formattedName) {
        formattedName = formattedName.replaceAll(COMMON_FILE_ENDS_CASE_SENSITIVE, "");
        formattedName = formattedName.replaceAll("(?i)\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*", "");
        return formattedName;
    }

    public static String replaceShortFilenameWithParentDirectoryName(String filename, String absolutePath) {
        String groupNameFromFilename;
        if (absolutePath == null || filename == null) {
            return filename;
        }
        if (!filename.toLowerCase().equals(filename)) {
            return filename;
        }
        String pathWithoutFilename = StringUtils.substringBeforeLast(absolutePath, "\\");
        if (pathWithoutFilename == null) {
            return filename;
        }
        String parentDirectory = StringUtils.substringAfterLast(pathWithoutFilename, "\\");
        if (parentDirectory == null) {
            return filename;
        }
        String groupNameFromDirectory = StringUtils.substringAfterLast(parentDirectory, "-");
        if (groupNameFromDirectory == null) {
            return filename;
        }
        String groupNameFromDirectoryWithoutHost = StringUtils.substringBefore(groupNameFromDirectory, " ");
        if (groupNameFromDirectoryWithoutHost != null) {
            groupNameFromDirectory = groupNameFromDirectoryWithoutHost;
        }
        if ((groupNameFromFilename = StringUtils.substringBefore(filename, "-")) == null) {
            return filename;
        }
        if (!groupNameFromFilename.equals(StringUtils.lowerCase(groupNameFromDirectory))) {
            String groupNameFromDirectoryWithoutNumbers = StringUtils.lowerCase(groupNameFromDirectory).replaceAll("\\d", "");
            Pattern pattern = Pattern.compile("\\d");
            Matcher matcher = pattern.matcher(groupNameFromDirectory);
            if (matcher.find()) {
                Integer numberIndex = matcher.start();
                groupNameFromFilename = new StringBuilder(groupNameFromFilename).deleteCharAt(numberIndex).toString();
            }
            if (!groupNameFromDirectoryWithoutNumbers.startsWith(groupNameFromFilename)) {
                return filename;
            }
        }
        return parentDirectory;
    }

    public static String getFileNamePrettified(String f, String absolutePath) {
        return FileUtil.getFileNamePrettified(f, null, false, false, absolutePath, null);
    }

    public static Integer getYearFromYearString(String s) {
        Integer year = null;
        if (s != null) {
            if (s.length() > 4) {
                s = s.substring(0, 4);
            }
            try {
                year = Integer.valueOf(s);
                if (year == 0) {
                    year = null;
                }
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return year;
    }

    public static Integer getIntegerFromString(String s) {
        Integer result = null;
        if (s != null) {
            try {
                result = Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getFileNamePrettified(String f, MediaVideoMetadata mediaVideoMetadata, boolean isEpisodeWithinSeasonFolder, boolean isEpisodeWithinTVSeriesFolder, String absolutePath, String lang) {
        Object formattedName;
        boolean isTvEpisode;
        String tvEpisodeName;
        Object tvEpisodeNumber;
        Integer tvSeason;
        String extraInformation;
        String movieOrShowName;
        Integer year = null;
        MediaVideoMetadata videoMetadata = null;
        if (mediaVideoMetadata == null && absolutePath != null) {
            videoMetadata = MediaInfoStore.getMediaVideoMetadata(absolutePath);
        } else if (mediaVideoMetadata != null && StringUtils.isNotBlank(mediaVideoMetadata.getMovieOrShowName())) {
            videoMetadata = mediaVideoMetadata;
        }
        if (videoMetadata != null) {
            videoMetadata.ensureHavingTranslation(lang);
            movieOrShowName = videoMetadata.getMovieOrShowName(lang);
            year = videoMetadata.getYear();
            extraInformation = videoMetadata.getExtraInformation();
            tvSeason = videoMetadata.getTvSeason();
            tvEpisodeNumber = StringUtils.isNotBlank(videoMetadata.getTvEpisodeNumber()) ? videoMetadata.getTvEpisodeNumber() : "";
            tvEpisodeName = StringUtils.isNotBlank(videoMetadata.getTvEpisodeName()) ? videoMetadata.getTvEpisodeName(lang) : "";
            isTvEpisode = videoMetadata.isTvEpisode();
        } else {
            FileNameMetadata metadataFromFilename = FileUtil.getFileNameMetadata(f, absolutePath);
            movieOrShowName = metadataFromFilename.getMovieOrShowName();
            extraInformation = metadataFromFilename.getExtraInformation();
            tvSeason = metadataFromFilename.getTvSeasonNumber();
            tvEpisodeNumber = StringUtils.isNotBlank(metadataFromFilename.getTvEpisodeNumber()) ? metadataFromFilename.getTvEpisodeNumber() : "";
            tvEpisodeName = StringUtils.isNotBlank(metadataFromFilename.getTvEpisodeName()) ? metadataFromFilename.getTvEpisodeName() : "";
            isTvEpisode = metadataFromFilename.isTvEpisode();
            if (!isTvEpisode) {
                year = metadataFromFilename.getYear();
            }
        }
        if (StringUtils.isBlank(movieOrShowName)) {
            return FileUtil.basicPrettify(f);
        }
        if (isTvEpisode) {
            String tvSeasonPadded;
            boolean isEpisodeWithDate = false;
            if (tvSeason > 1899 && tvSeason < 2099) {
                tvSeasonPadded = tvSeason + "/";
                isEpisodeWithDate = true;
            } else {
                tvSeasonPadded = "S" + String.format("%02d", tvSeason);
            }
            if (((String)tvEpisodeNumber).length() == 1) {
                tvEpisodeNumber = "0" + (String)tvEpisodeNumber;
            }
            if (isEpisodeWithinSeasonFolder) {
                formattedName = "";
                if (StringUtils.isNotBlank((CharSequence)tvEpisodeNumber)) {
                    formattedName = (String)tvEpisodeNumber + " - ";
                }
                formattedName = StringUtils.isBlank(tvEpisodeName) ? (String)formattedName + "Episode " + (String)tvEpisodeNumber : (String)formattedName + tvEpisodeName;
            } else if (isEpisodeWithinTVSeriesFolder) {
                formattedName = tvSeasonPadded;
                if (!isEpisodeWithDate) {
                    formattedName = (String)formattedName + "E";
                }
                formattedName = (String)formattedName + (String)tvEpisodeNumber + " - ";
                formattedName = StringUtils.isBlank(tvEpisodeName) ? (String)formattedName + "Episode " + (String)tvEpisodeNumber : (String)formattedName + tvEpisodeName;
            } else {
                formattedName = movieOrShowName;
                if (StringUtils.isNotBlank(tvSeasonPadded)) {
                    formattedName = (String)formattedName + " " + tvSeasonPadded;
                }
                if (StringUtils.isNotBlank((CharSequence)tvEpisodeNumber)) {
                    if (!isEpisodeWithDate) {
                        formattedName = (String)formattedName + "E";
                    }
                    formattedName = (String)formattedName + (String)tvEpisodeNumber;
                }
                if (StringUtils.isNotBlank(tvEpisodeName)) {
                    formattedName = (String)formattedName + " - " + tvEpisodeName;
                }
            }
        } else {
            formattedName = movieOrShowName;
            if (year != null) {
                formattedName = (String)formattedName + " (" + year + ")";
            }
        }
        if (StringUtils.isNotBlank(extraInformation)) {
            formattedName = (String)formattedName + " " + extraInformation;
        }
        return formattedName;
    }

    public static FileNameMetadata getFileNameMetadata(String filename, String absolutePath) {
        Object extraInformation;
        String substr;
        Matcher matcher;
        if (filename == null) {
            return new FileNameMetadata();
        }
        boolean isMovieWithoutYear = false;
        boolean isSample = false;
        Object movieOrShowName = null;
        String year = null;
        Object tvSeason = null;
        String tvEpisodeName = null;
        Object tvEpisodeNumber = null;
        String edition = null;
        String formattedName = FileUtil.basicPrettify(filename = FileUtil.replaceShortFilenameWithParentDirectoryName(filename, absolutePath));
        if (formattedName.toLowerCase(Locale.ENGLISH).endsWith("sample")) {
            isSample = true;
        }
        boolean verboseDevLogging = false;
        if (formattedName.matches(SCENE_MULTI_EPISODE_CONVENTION_MATCH)) {
            if (verboseDevLogging) {
                System.out.println("SCENE_MULTI_EPISODE_CONVENTION_MATCH: " + formattedName);
            }
            if ((matcher = SCENE_MULTI_EPISODE_CONVENTION_PATTERN.matcher(formattedName)).find()) {
                tvSeason = matcher.group(1);
                if (((String)tvSeason).length() == 1) {
                    tvSeason = "0" + (String)tvSeason;
                }
                tvEpisodeNumber = matcher.group(2);
                tvEpisodeNumber = (String)tvEpisodeNumber + "-" + matcher.group(4);
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            formattedName = formattedName.replaceAll("\\s[sS](\\d{1,2})[eE](\\d{1,})([eE]|-[eE])(\\d{1,})\\s", " S" + (String)tvSeason + "E$2-$3 - ");
            formattedName = formattedName.replaceAll("\\s[sS](\\d{1,2})[eE](\\d{1,})([eE]|-[eE])(\\d{1,})", " S" + (String)tvSeason + "E$2-$3");
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(".*[sS](\\d{1,2})(?:\\s|)[eE](\\d{1,}\\w{1}|\\d{1,}).*")) {
            Pattern pattern;
            if (verboseDevLogging) {
                System.out.println("SCENE_P2P_EPISODE_REGEX: " + formattedName);
            }
            if ((matcher = (pattern = Pattern.compile(SCENE_P2P_EPISODE_REGEX)).matcher(formattedName)).find()) {
                tvSeason = matcher.group(1);
                if (((String)tvSeason).length() == 1) {
                    tvSeason = "0" + (String)tvSeason;
                }
                tvEpisodeNumber = matcher.group(2);
            }
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            formattedName = formattedName.replaceAll("(?i)\\s[sS](\\d{1,2})(?:\\s|)[eE](\\d{1,}\\w{1}|\\d{1,})\\s", " S" + (String)tvSeason + "E$2 - ");
            formattedName = formattedName.replaceAll("(?i)\\s[sS](\\d{1,2})(?:\\s|)[eE](\\d{1,}\\w{1}|\\d{1,})", " S" + (String)tvSeason + "E$2");
            formattedName = formattedName.replaceAll(SCENE_P2P_EPISODE_REGEX, " S" + (String)tvSeason + "E$2");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(".*[sS](\\d{2})\\s(\\w{3,}).*")) {
            Pattern pattern;
            if (verboseDevLogging) {
                System.out.println("SCENE_P2P_EPISODE_SPECIAL_REGEX: " + formattedName);
            }
            if ((matcher = (pattern = Pattern.compile(SCENE_P2P_EPISODE_SPECIAL_REGEX)).matcher(formattedName)).find() && ((String)(tvSeason = matcher.group(1))).length() == 1) {
                tvSeason = "0" + (String)tvSeason;
            }
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            formattedName = formattedName.replaceAll("(?i)\\s[sS](\\d{2})\\s(\\w{3,})", " S" + (String)tvSeason + " - $2");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(".*[\\s-\\.](\\d{1,2})[xX]\\d\\d.*")) {
            Pattern pattern;
            if (verboseDevLogging) {
                System.out.println("older scene 1: " + formattedName);
            }
            if ((matcher = (pattern = Pattern.compile("[\\s-\\.](\\d{1,2})[xX](\\d\\d)")).matcher(formattedName)).find()) {
                tvSeason = matcher.group(1);
                if (((String)tvSeason).length() == 1) {
                    tvSeason = "0" + (String)tvSeason;
                }
                tvEpisodeNumber = matcher.group(2);
            }
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            formattedName = formattedName.replaceAll("(?i)[\\s-\\.](\\d{1,2})[xX](\\d{1,})[\\s-\\.]", " S" + (String)tvSeason + "E$2 - ");
            formattedName = formattedName.replaceAll("(?i)[\\s-\\.](\\d{1,2})[xX](\\d{1,})", " S" + (String)tvSeason + "E$2");
            formattedName = formattedName.replaceAll("[\\s-\\.](\\d{1,2})[xX](\\d{1,})", " S" + (String)tvSeason + "E$2");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(".*\\s-\\s(\\d{3})\\s-\\s.*")) {
            Pattern pattern;
            if (verboseDevLogging) {
                System.out.println("older scene 2: " + formattedName);
            }
            if ((matcher = (pattern = Pattern.compile("\\s-\\s(\\d{3})\\s-\\s")).matcher(formattedName)).find()) {
                String tvSeasonAndEpisode = matcher.group(1);
                tvSeason = "0" + tvSeasonAndEpisode.substring(0, 1);
                tvEpisodeNumber = tvSeasonAndEpisode.substring(1, 3);
            }
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            formattedName = formattedName.replaceAll("(?i)\\s-\\s(\\d{3})\\s-\\s", " S" + (String)tvSeason + "E" + (String)tvEpisodeNumber + " - ");
            formattedName = formattedName.replaceAll("(?i)\\s(\\d{3})", " S" + (String)tvSeason + "E" + (String)tvEpisodeNumber);
            formattedName = formattedName.replaceAll("\\s(\\d{3})", " S" + (String)tvSeason + "E" + (String)tvEpisodeNumber);
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(MINISERIES_CONVENTION_MATCH)) {
            if (verboseDevLogging) {
                System.out.println("MINISERIES_CONVENTION_MATCH: " + formattedName);
            }
            if ((matcher = MINISERIES_CONVENTION_PATTERN.matcher(formattedName)).find()) {
                tvSeason = "01";
                tvEpisodeNumber = matcher.group(1);
                if (StringUtils.isNotBlank((CharSequence)tvEpisodeNumber) && ((String)tvEpisodeNumber).length() == 1) {
                    tvEpisodeNumber = "0" + (String)tvEpisodeNumber;
                }
            }
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            String seasonLetterReplace = "S";
            String episodeLetterReplace = "E";
            if (formattedName.equals(formattedName.toLowerCase())) {
                seasonLetterReplace = "s";
                episodeLetterReplace = "e";
            }
            formattedName = formattedName.replaceAll(MINISERIES_CONVENTION, " " + seasonLetterReplace + (String)tvSeason + episodeLetterReplace + (String)tvEpisodeNumber + " - ");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(MIXED_EPISODE_CONVENTION_MATCH)) {
            if (verboseDevLogging) {
                System.out.println("MIXED_EPISODE_CONVENTION_MATCH: " + formattedName);
            }
            if ((matcher = MIXED_EPISODE_CONVENTION_PATTERN.matcher(formattedName)).find()) {
                tvSeason = "01";
                tvEpisodeNumber = matcher.group(1);
            }
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            String seasonLetterReplace = "S";
            String episodeLetterReplace = "E";
            if (formattedName.equals(formattedName.toLowerCase())) {
                seasonLetterReplace = "s";
                episodeLetterReplace = "e";
            }
            formattedName = formattedName.replaceAll(MIXED_EPISODE_CONVENTION, " " + seasonLetterReplace + (String)tvSeason + episodeLetterReplace + (String)tvEpisodeNumber + " - ");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches(".*\\s(19|20)\\d{2}\\s[0-1]\\d\\s[0-3]\\d\\s.*")) {
            Pattern pattern;
            if (verboseDevLogging) {
                System.out.println("daily scene and p2p episode: " + formattedName);
            }
            if ((matcher = (pattern = Pattern.compile("\\s((?:19|20)\\d{2})\\s([0-1]\\d)\\s([0-3]\\d)\\s")).matcher(formattedName)).find()) {
                tvSeason = matcher.group(1);
                tvEpisodeNumber = matcher.group(2);
                tvEpisodeNumber = (String)tvEpisodeNumber + "/" + matcher.group(3);
            }
            formattedName = formattedName.replaceAll("(\\sPROPER\\s.*|\\siNTERNAL\\s.*|\\sLIMITED\\s.*|\\sLiMiTED\\s.*|\\sFESTiVAL\\s.*|\\sNORDIC\\s.*|\\sREAL\\s.*|\\sSUBBED\\s.*|\\sDUBBED\\s.*|\\sRETAIL\\s.*|\\sEXTENDED\\s.*|\\sNEWEDIT\\s.*|\\sWEB\\s.*)", "");
            formattedName = formattedName.replaceAll("(\\s\\[BD.*|[\\s\\(]DUBBED.*|[\\s\\(]AC3.*|[\\s\\(]NTSC.*|[\\s\\(]TVNZ\\s.*|[\\s\\(]FP\\s.*|[\\s\\(]AAC.*|[\\s\\(]REPACK.*|[\\s\\(]480p.*|[\\s\\(]720p.*|[\\s\\(]m-720p.*|[\\s\\(]900p.*|[\\s\\(]1080i.*|[\\s\\(]1080p.*|[\\s\\(]2160p.*|[\\s\\(]WEB-DL.*|[\\s\\(]HDTV.*|[\\s\\(]DSR.*|[\\s\\(]PDTV.*|[\\s\\(]SDTV.*|[\\s\\(]WS.*|[\\s\\(]HQ.*|[\\s\\(]DVDRip.*|[\\s\\(]TVRiP.*|[\\s\\(]BDRip.*|[\\s\\(]BRRip.*|[\\s\\(]WEBRip.*|[\\s\\(]BluRay.*|[\\s\\(]Blu-ray.*|[\\s\\(]SUBBED.*|[\\s\\(]x264.*|[\\s\\(]x265.*|[\\s\\(]XviD.*|[\\s\\(]Dual\\sAudio.*|[\\s\\(]HSBS.*|[\\s\\(]H-SBS.*|[\\s\\(]RERiP.*|[\\s\\(]DIRFIX.*|[\\s\\(]READNFO.*|[\\s\\(]60FPS.*|[\\s\\(]HDR.*|[\\s\\(]DV[\\s\\(].*)", "");
            formattedName = formattedName.replaceAll("(?i)\\s(19|20)(\\d{2})\\s([0-1]\\d)\\s([0-3]\\d)\\s", " $1$2/$3/$4 - ");
            formattedName = formattedName.replaceAll("(?i)\\s(19|20)(\\d{2})\\s([0-1]\\d)\\s([0-3]\\d)", " $1$2/$3/$4");
            formattedName = formattedName.replaceAll("\\s(19|20)(\\d{2})\\s([0-1]\\d)\\s([0-3]\\d)", " $1$2/$3/$4");
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCaseParts(formattedName);
        } else if (formattedName.matches("^(?!.*\\d{1,3}[\\s:][\\s-]).*\\s(?:19|20)\\d{2}([1-9]|1[0-2])([1-9]|[12][0-9]|3[01]).*")) {
            if (verboseDevLogging) {
                System.out.println("sports: " + formattedName);
            }
            formattedName = FileUtil.convertFormattedNameToTitleCase(formattedName);
        } else if (formattedName.matches(SCENE_P2P_MOVIE_MATCH)) {
            if (verboseDevLogging) {
                System.out.println("SCENE_P2P_MOVIE_MATCH: " + formattedName);
            }
            formattedName = formattedName.replaceAll("\\s(19|20)(\\d{2})", " ($1$2)");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = FileUtil.convertFormattedNameToTitleCase(formattedName);
        } else if (formattedName.matches(".*\\[(19|20)\\d{2}\\].*")) {
            if (verboseDevLogging) {
                System.out.println("rarer movies 1: " + formattedName);
            }
            formattedName = formattedName.replaceAll("(?i)\\[(19|20)(\\d{2})\\].*", " ($1$2)");
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCase(formattedName);
        } else if (formattedName.matches(".*\\((19|20)\\d{2}\\).*")) {
            if (verboseDevLogging) {
                System.out.println("rarer movies 2: " + formattedName);
            }
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            formattedName = FileUtil.convertFormattedNameToTitleCase(formattedName);
        } else if (formattedName.matches(".*\\[[0-9a-zA-Z]{8}\\]$") || formattedName.matches(".*\\s-\\s\\d{1,3}$") || formattedName.matches(COMMON_ANIME_FILE_ENDS_MATCH)) {
            if (verboseDevLogging) {
                System.out.println("anime: " + formattedName);
            }
            if ((matcher = COMMON_ANIME_EPISODE_NUMBERS_PATTERN.matcher(formattedName = formattedName.replaceAll(COMMON_ANIME_FILE_ENDS, ""))).find()) {
                tvSeason = "1";
                tvEpisodeNumber = matcher.group(1);
                showNameIndex = FileUtil.indexOf(COMMON_ANIME_EPISODE_NUMBERS_PATTERN, formattedName);
                if (showNameIndex != -1) {
                    movieOrShowName = formattedName.substring(0, showNameIndex);
                }
            } else {
                matcher = COMMON_ANIME_MULTIPLE_EPISODES_NUMBERS_PATTERN.matcher(formattedName);
                if (matcher.find()) {
                    tvSeason = "1";
                    tvEpisodeNumber = matcher.group(1);
                    showNameIndex = FileUtil.indexOf(COMMON_ANIME_MULTIPLE_EPISODES_NUMBERS_PATTERN, formattedName);
                    if (showNameIndex != -1) {
                        movieOrShowName = formattedName.substring(0, showNameIndex);
                    }
                }
            }
            if (tvEpisodeNumber != null && ((String)tvEpisodeNumber).length() > 2 && ((String)tvEpisodeNumber).charAt(0) == '0') {
                tvEpisodeNumber = ((String)tvEpisodeNumber).contains(" ") ? ((String)tvEpisodeNumber).replace(" ", ".") : ((String)tvEpisodeNumber).substring(1);
            }
            if (movieOrShowName != null && StringUtils.isNotBlank((CharSequence)movieOrShowName) && (matcher = SEASON_NUMBER_IN_SERIES_TITLE_PATTERN.matcher((CharSequence)(movieOrShowName = ((String)movieOrShowName).trim()))).find()) {
                tvSeason = matcher.group(1);
                movieOrShowName = ((String)movieOrShowName).substring(0, ((String)movieOrShowName).length() - 3);
            }
            formattedName = FileUtil.convertFormattedNameToTitleCase(formattedName);
        } else if (formattedName.matches(COMMON_FILE_ENDS_MATCH)) {
            if (verboseDevLogging) {
                System.out.println("COMMON_FILE_ENDS_MATCH: " + formattedName);
            }
            isMovieWithoutYear = true;
            formattedName = FileUtil.removeFilenameEndMetadata(formattedName);
            FormattedNameAndEdition result = FileUtil.removeAndSaveEditionToBeAddedLater(formattedName);
            formattedName = result.getFormattedName();
            if (result.getEdition() != null) {
                edition = result.getEdition();
            }
            formattedName = FileUtil.convertFormattedNameToTitleCase(formattedName);
        }
        formattedName = formattedName.replaceAll("\\s+", " ");
        formattedName = formattedName.trim();
        if (movieOrShowName != null && " -".equals(substr = ((String)(movieOrShowName = ((String)movieOrShowName).trim())).substring(Math.max(0, ((String)movieOrShowName).length() - 2)))) {
            movieOrShowName = ((String)movieOrShowName).substring(0, ((String)movieOrShowName).length() - 2);
        }
        if (tvSeason != null) {
            int yearIndex;
            if (((String)tvSeason).length() > 1 && ((String)tvSeason).startsWith("0")) {
                tvSeason = ((String)tvSeason).substring(1);
            }
            if (StringUtils.isEmpty((CharSequence)movieOrShowName)) {
                int showNameIndex = FileUtil.indexOf(SHOW_NAME_INDEX_PATTERN, formattedName);
                if (showNameIndex != -1) {
                    movieOrShowName = formattedName.substring(0, showNameIndex);
                    matcher = SHOW_NAME_INDEX_PATTERN.matcher(formattedName);
                    if (matcher.find()) {
                        tvEpisodeName = matcher.group(2).trim();
                        if (StringUtils.isEmpty(tvEpisodeName)) {
                            tvEpisodeName = null;
                        } else if (tvEpisodeName.startsWith("- ")) {
                            tvEpisodeName = tvEpisodeName.substring(2);
                        }
                    }
                    if (!StringUtils.isEmpty(tvEpisodeName)) {
                        tvEpisodeName = FileUtil.convertFormattedNameToTitleCase(tvEpisodeName);
                    }
                } else {
                    showNameIndex = FileUtil.indexOf(SHOW_NAME_INDEX_FALLBACK_PATTERN, formattedName);
                    if (showNameIndex != -1) {
                        movieOrShowName = formattedName.substring(0, showNameIndex);
                    }
                }
            }
            if (movieOrShowName != null) {
                movieOrShowName = ((String)movieOrShowName).trim();
            }
            if ((yearIndex = FileUtil.indexOf(Pattern.compile("(?:\\(|\\s)(?:19|20)\\d{2}"), (String)movieOrShowName)) > -1) {
                year = formattedName.substring(yearIndex + 1, yearIndex + 5);
                movieOrShowName = formattedName.substring(0, yearIndex);
                movieOrShowName = ((String)movieOrShowName).trim();
                movieOrShowName = (String)movieOrShowName + " (" + year + ")";
            }
        } else if (isMovieWithoutYear) {
            movieOrShowName = formattedName;
        } else {
            int yearIndex = FileUtil.indexOf(Pattern.compile("\\s\\((?:19|20)\\d{2}\\)"), formattedName);
            if (yearIndex > -1) {
                movieOrShowName = formattedName.substring(0, yearIndex);
                year = formattedName.substring(yearIndex + 2, yearIndex + 6);
            }
        }
        if (movieOrShowName != null && ((String)(movieOrShowName = ((String)movieOrShowName).trim())).endsWith(" -")) {
            movieOrShowName = ((String)movieOrShowName).substring(0, ((String)movieOrShowName).length() - 2);
        }
        if (isSample) {
            extraInformation = edition == null ? "" : edition + " ";
            extraInformation = (String)extraInformation + "(Sample)";
        } else {
            extraInformation = edition;
        }
        return new FileNameMetadata((String)movieOrShowName, year, (String)extraInformation, (String)tvSeason, (String)tvEpisodeNumber, tvEpisodeName);
    }

    public static String convertLowerCaseStringToTitleCase(String value) {
        value = value.trim();
        StringBuilder convertedValue = new StringBuilder();
        boolean loopedOnce = false;
        for (String word : value.split("\\s+")) {
            if (loopedOnce) {
                switch (word) {
                    case "a": 
                    case "an": 
                    case "and": 
                    case "in": 
                    case "it": 
                    case "for": 
                    case "of": 
                    case "on": 
                    case "the": 
                    case "to": 
                    case "vs": {
                        convertedValue.append(' ').append(word);
                        break;
                    }
                    default: {
                        convertedValue.append(' ').append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
                        break;
                    }
                }
                continue;
            }
            convertedValue.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
            loopedOnce = true;
        }
        return convertedValue.toString();
    }

    public static int indexOf(Pattern pattern, String s) {
        if (StringUtils.isBlank(s)) {
            return -1;
        }
        Matcher matcher = pattern.matcher(s);
        return matcher.find() ? matcher.start() : -1;
    }

    public static File getFileNameWithAddedExtension(File parent, File f, String ext) {
        File ff = new File(parent, f.getName() + ext);
        if (ff.exists()) {
            return ff;
        }
        return null;
    }

    public static File replaceExtension(File file, String extension, boolean nullIfNonExisting, boolean adjustExtensionCase) {
        if (file == null) {
            return null;
        }
        return FileUtil.replaceExtension(file.getParentFile(), file.getName(), extension, nullIfNonExisting, adjustExtensionCase);
    }

    public static File replaceExtension(File folder, File file, String extension, boolean nullIfNonExisting, boolean adjustExtensionCase) {
        if (file == null) {
            return null;
        }
        return FileUtil.replaceExtension(folder, file.getName(), extension, nullIfNonExisting, adjustExtensionCase);
    }

    public static File replaceExtension(File folder, String fileName, String extension, boolean nullIfNonExisting, boolean adjustExtensionCase) {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        int dot = fileName.lastIndexOf(46);
        String baseFileName = dot == -1 || FileUtil.getIndexOfLastSeparator(fileName) > dot ? fileName : fileName.substring(0, dot);
        if (StringUtils.isBlank(extension)) {
            File result = new File(folder, baseFileName);
            return !nullIfNonExisting || result.exists() ? result : null;
        }
        File result = new File(folder, baseFileName + "." + extension);
        if (result.exists() || !nullIfNonExisting && !adjustExtensionCase) {
            return result;
        }
        if (!Platform.isWindows() && adjustExtensionCase) {
            File adjustedResult = new File(folder, baseFileName + "." + extension.toLowerCase(Locale.ROOT));
            if (adjustedResult.exists()) {
                return adjustedResult;
            }
            adjustedResult = new File(folder, baseFileName + "." + extension.toUpperCase(Locale.ROOT));
            if (adjustedResult.exists()) {
                return adjustedResult;
            }
        }
        return nullIfNonExisting ? null : result;
    }

    public static Path replaceExtension(Path file, String extension, boolean nullIfNonExisting, boolean adjustExtensionCase) {
        if (file == null) {
            return null;
        }
        Path fileName = file.getFileName();
        if (fileName == null) {
            return null;
        }
        return FileUtil.replaceExtension(file.getParent(), fileName.toString(), extension, nullIfNonExisting, adjustExtensionCase);
    }

    public static Path replaceExtension(Path folder, Path file, String extension, boolean nullIfNonExisting, boolean adjustExtensionCase) {
        if (file == null) {
            return null;
        }
        Path fileName = file.getFileName();
        if (fileName == null) {
            return null;
        }
        return FileUtil.replaceExtension(folder, fileName.toString(), extension, nullIfNonExisting, adjustExtensionCase);
    }

    public static Path replaceExtension(Path folder, String fileName, String extension, boolean nullIfNonExisting, boolean adjustExtensionCase) {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        int point = fileName.lastIndexOf(46);
        String baseFileName = point == -1 ? fileName : fileName.substring(0, point);
        try {
            if (folder == null) {
                folder = Paths.get("", new String[0]);
            }
            if (StringUtils.isBlank(extension)) {
                Path result = folder.resolve(baseFileName);
                return !nullIfNonExisting || Files.exists(result, new LinkOption[0]) ? result : null;
            }
            Path result = folder.resolve(baseFileName + "." + extension);
            if (Files.exists(result, new LinkOption[0]) || !nullIfNonExisting && !adjustExtensionCase) {
                return result;
            }
            if (!Platform.isWindows() && adjustExtensionCase) {
                Path adjustedResult = folder.resolve(baseFileName + "." + extension.toLowerCase(Locale.ROOT));
                if (Files.exists(adjustedResult, new LinkOption[0])) {
                    return adjustedResult;
                }
                adjustedResult = folder.resolve(baseFileName + "." + extension.toUpperCase(Locale.ROOT));
                if (Files.exists(adjustedResult, new LinkOption[0])) {
                    return adjustedResult;
                }
            }
            return nullIfNonExisting ? null : result;
        }
        catch (InvalidPathException e) {
            LOGGER.error("Unexpected error during replaceExtension for folder \"{}\", file \"{}\" and extension \"{}\": {}", folder, fileName, extension, e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    public static CharsetMatch getFileCharsetMatch(@Nonnull File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        CharsetDetector detector = new CharsetDetector();
        detector.setText(in);
        return detector.detect();
    }

    @Nullable
    public static Charset getFileCharset(@Nullable File file) throws IOException {
        if (file == null) {
            return null;
        }
        CharsetMatch match = FileUtil.getFileCharsetMatch(file);
        try {
            if (Charset.isSupported(match.getName())) {
                LOGGER.debug("Detected charset \"{}\" in file \"{}\"", (Object)match.getName(), (Object)file.getAbsolutePath());
                return Charset.forName(match.getName());
            }
            LOGGER.debug("Detected charset \"{}\" in file \"{}\", but cannot use it because it's not supported by the Java Virtual Machine", (Object)match.getName(), (Object)file.getAbsolutePath());
            return null;
        }
        catch (IllegalCharsetNameException e) {
            LOGGER.debug("Illegal charset \"{}\" deteceted in file \"{}\"", (Object)match.getName(), (Object)file.getAbsolutePath());
            LOGGER.debug("Found no matching charset for file \"{}\"", (Object)file.getAbsolutePath());
            return null;
        }
    }

    public static Charset detectCharset(Path file, int confidenceThreshold) throws IOException {
        CharsetMatch[] matches;
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return null;
        }
        CharsetDetector detector = new CharsetDetector();
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            detector.setText(bis);
            detector.enableInputFilter(true);
            matches = detector.detectAll();
        }
        for (CharsetMatch match : matches) {
            if (match.getConfidence() < confidenceThreshold) {
                LOGGER.debug("Detected charset \"{}\" in \"{}\" but not with enough confidence ({} < {})", match.getName(), file, match.getConfidence(), confidenceThreshold);
                break;
            }
            try {
                if (Charset.isSupported(match.getName())) {
                    return Charset.forName(match.getName());
                }
                LOGGER.debug("The detected charset \"{}\" in \"{}\" isn't supported by the JVM - skipping", (Object)match.getName(), (Object)file);
            }
            catch (IllegalCharsetNameException e) {
                LOGGER.debug("Detected an illegal charset \"{}\" in \"{}\" - skipping: {}", match.getName(), file, e.getMessage());
                LOGGER.trace("", e);
            }
        }
        if (matches.length == 0) {
            LOGGER.debug("Found no matching charset for \"{}\"", (Object)file);
        } else {
            LOGGER.debug("Found {} matching charset{} for \"{}\", but {} both supported by the JVM and {} a high enough confidence ({})", matches.length, matches.length > 1 ? "s" : "", file, matches.length > 1 ? "none are" : "it isn't", matches.length > 1 ? "have" : "has", confidenceThreshold);
        }
        return null;
    }

    @Nullable
    public static String getFileCharsetName(@Nullable File file) throws IOException {
        if (file == null) {
            return null;
        }
        CharsetMatch match = FileUtil.getFileCharsetMatch(file);
        try {
            if (Charset.isSupported(match.getName())) {
                LOGGER.debug("Detected charset \"{}\" in file \"{}\"", (Object)match.getName(), (Object)file.getAbsolutePath());
                return match.getName().toUpperCase(Locale.ROOT);
            }
            LOGGER.debug("Detected charset \"{}\" in file \"{}\", but cannot use it because it's not supported by the Java Virtual Machine", (Object)match.getName(), (Object)file.getAbsolutePath());
            return null;
        }
        catch (IllegalCharsetNameException e) {
            LOGGER.debug("Illegal charset \"{}\" deteceted in file \"{}\"", (Object)match.getName(), (Object)file.getAbsolutePath());
            LOGGER.debug("Found no matching charset for file \"{}\"", (Object)file.getAbsolutePath());
            return null;
        }
    }

    public static boolean isFileUTF8(File file) throws IOException {
        return FileUtil.isCharsetUTF8(FileUtil.getFileCharset(file));
    }

    public static boolean isCharsetUTF8(Charset charset) {
        return charset != null && charset.equals(StandardCharsets.UTF_8);
    }

    public static boolean isCharsetUTF8(String charsetName) {
        return StringUtils.equalsIgnoreCase(charsetName, Constants.CHARSET_UTF_8);
    }

    public static boolean isFileUTF16(File file) throws IOException {
        return FileUtil.isCharsetUTF16(FileUtil.getFileCharset(file));
    }

    public static boolean isCharsetUTF16(Charset charset) {
        return charset != null && (charset.equals(StandardCharsets.UTF_16) || charset.equals(StandardCharsets.UTF_16BE) || charset.equals(StandardCharsets.UTF_16LE));
    }

    public static boolean isCharsetUTF16(String charsetName) {
        return StringUtils.equalsIgnoreCase(charsetName, Constants.CHARSET_UTF_16LE) || StringUtils.equalsIgnoreCase(charsetName, Constants.CHARSET_UTF_16BE);
    }

    public static boolean isCharsetUTF32(String charsetName) {
        return StringUtils.equalsIgnoreCase(charsetName, Constants.CHARSET_UTF_32LE) || StringUtils.equalsIgnoreCase(charsetName, Constants.CHARSET_UTF_32BE);
    }

    public static void convertFileFromUtf16ToUtf8(File inputFile, File outputFile) throws IOException {
        Charset charset;
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile cannot be null");
        }
        try {
            charset = FileUtil.getFileCharset(inputFile);
        }
        catch (IOException ex) {
            LOGGER.debug("Exception during charset detection.", ex);
            throw new IllegalArgumentException("Can't confirm that inputFile is UTF-16.");
        }
        if (FileUtil.isCharsetUTF16(charset)) {
            if (!outputFile.exists()) {
                try (BufferedReader reader = StandardCharsets.UTF_16LE.equals(charset) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_16)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), charset));
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
                    int c;
                    while ((c = reader.read()) != -1) {
                        writer.write(c);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("File is not UTF-16");
        }
    }

    public static FilePermissions getFilePermissions(File file) throws FileNotFoundException {
        return new FilePermissions(file);
    }

    public static FilePermissions getFilePermissionsNoThrow(File file) {
        try {
            return new FilePermissions(file);
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            return null;
        }
    }

    public static FilePermissions getFilePermissions(String path) throws FileNotFoundException {
        if (path != null) {
            return new FilePermissions(new File(path));
        }
        File file = null;
        return new FilePermissions(file);
    }

    public static FilePermissions getFilePermissionsNoThrow(String path) {
        if (path != null) {
            try {
                return new FilePermissions(new File(path));
            }
            catch (FileNotFoundException | IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isFileRelevant(File f, UmsConfiguration configuration) {
        String fileName = f.getName().toLowerCase();
        return configuration.isArchiveBrowsing() && (fileName.endsWith(".zip") || fileName.endsWith(".cbz") || fileName.endsWith(".rar") || fileName.endsWith(".cbr")) || fileName.endsWith(".iso") || fileName.endsWith(".img") || fileName.endsWith(".m3u") || fileName.endsWith(".m3u8") || fileName.endsWith(".pls") || fileName.endsWith(".cue");
    }

    public static boolean isFolderRelevant(File f, UmsConfiguration configuration) {
        return FileUtil.isFolderRelevant(f, configuration, Collections.emptySet());
    }

    public static boolean isFolderRelevant(File f, UmsConfiguration configuration, Set<String> ignoreFiles) {
        if (f.isDirectory() && configuration.isHideEmptyFolders()) {
            File[] children = f.listFiles();
            if (children == null) {
                LOGGER.warn("Can't list files in non-readable directory: {}", (Object)f.getAbsolutePath());
            } else {
                for (File child : children) {
                    if (ignoreFiles != null && ignoreFiles.contains(child.getAbsolutePath()) || !(child.isFile() ? FormatFactory.getAssociatedFormat(child.getName()) != null || FileUtil.isFileRelevant(child, configuration) : FileUtil.isFolderRelevant(child, configuration, ignoreFiles))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String basicPrettify(String filename) {
        filename = FileUtil.getFileNameWithoutExtension(filename);
        filename = FileUtil.removeGroupNameFromBeginning(filename);
        return filename.replaceAll("\\.|_", " ");
    }

    public static String renameForSorting(String filename) {
        return FileUtil.renameForSorting(filename, false, null);
    }

    public static String renameForSorting(String filename, boolean isEpisodeWithinTVSeriesFolder, String absolutePath) {
        if (PMS.getConfiguration().isPrettifyFilenames()) {
            filename = FileUtil.getFileNamePrettified(filename, null, false, isEpisodeWithinTVSeriesFolder, absolutePath, null);
        }
        if (PMS.getConfiguration().isIgnoreTheWordAandThe()) {
            filename = filename.replaceAll("^(?i)A[ .]|The[ .]", "");
            filename = filename.replaceAll("\\s{2,}", " ");
        }
        return filename;
    }

    public static BufferedReaderDetectCharsetResult createBufferedReaderDetectCharset(File file, Charset defaultCharset) throws IOException {
        Charset fileCharset = FileUtil.getFileCharset(file);
        if (fileCharset != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), fileCharset));
            return new BufferedReaderDetectCharsetResult(reader, fileCharset, true);
        }
        if (defaultCharset == null) {
            defaultCharset = Charset.defaultCharset();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), defaultCharset));
        LOGGER.warn("Could not detect character encoding for file \"{}\"; using the default charset \"{}\"", (Object)file.getAbsolutePath(), (Object)defaultCharset);
        return new BufferedReaderDetectCharsetResult(reader, defaultCharset, false);
    }

    public static boolean isValidFileName(String fileName) {
        return Platform.isWindows() ? fileName.matches("^[^\"*:<>?/\\\\]+$") : (Platform.isMac() ? fileName.matches("^[^:/]+$") : fileName.matches("^[A-Za-z0-9._][A-Za-z0-9._-]*$"));
    }

    public static String appendPathSeparator(String path) {
        if (path == null) {
            return null;
        }
        if (!((String)path).endsWith("\\") && !((String)path).endsWith("/")) {
            path = ((String)path).contains("\\") ? (String)path + "\\" : (((String)path).contains("/") ? (String)path + "/" : (String)path + File.separator);
        }
        return path;
    }

    @Nonnull
    public static String appendToFileName(@Nonnull String fileName, @Nullable String suffix) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        if (StringUtils.isBlank(suffix)) {
            return fileName;
        }
        int i = fileName.lastIndexOf(".");
        if (i < 0) {
            return fileName + suffix;
        }
        return fileName.substring(0, i) + suffix + fileName.substring(i);
    }

    @Nonnull
    public static List<Path> getOSPath() {
        String[] paths;
        ArrayList<Path> result = new ArrayList<Path>();
        String osPath = System.getenv("PATH");
        if (StringUtils.isBlank(osPath)) {
            return result;
        }
        for (String path : paths = osPath.split(File.pathSeparator)) {
            try {
                Path pathToAdd = Paths.get(path, new String[0]);
                result.add(pathToAdd);
            }
            catch (InvalidPathException e) {
                LOGGER.debug("Skipping invalid path {}", (Object)e.getMessage());
            }
        }
        return result;
    }

    @Nullable
    public static Path findExecutableInOSPath(@Nullable Path relativePath) {
        return FileUtil.findInOSPath(relativePath, true, FilePermissions.FileFlag.FILE, FilePermissions.FileFlag.READ, FilePermissions.FileFlag.EXECUTE);
    }

    @Nullable
    public static Path findInOSPath(@Nullable Path relativePath, boolean followSymlinks, FilePermissions.FileFlag ... requiredFlags) {
        LinkOption[] linkOptionArray;
        if (relativePath == null) {
            return null;
        }
        if (relativePath.isAbsolute()) {
            throw new IllegalArgumentException("relativePath must be relative");
        }
        if (followSymlinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        ArrayList<Path> osPath = new ArrayList<Path>();
        osPath.add(null);
        osPath.addAll(FileUtil.getOSPath());
        ArrayList<CallSite> extensions = new ArrayList<CallSite>();
        extensions.add(null);
        if (Platform.isWindows() && FileUtil.getExtension(relativePath) == null) {
            for (String string : WindowsProgramPaths.getWindowsPathExtensions()) {
                if (!StringUtils.isNotBlank(string)) continue;
                extensions.add((CallSite)((Object)("." + string)));
            }
        }
        for (String string : extensions) {
            for (Path path : osPath) {
                Path result;
                if (path == null) {
                    path = Paths.get("", new String[0]).toAbsolutePath();
                }
                if (!Files.exists(result = string == null ? path.resolve(relativePath) : path.resolve(relativePath.toString() + string), options)) continue;
                if (requiredFlags.length == 0) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Resolved \"{}\" from \"{}\" using OS path", (Object)result, (Object)relativePath);
                    }
                    try {
                        return result.toRealPath(options);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not get the real path of \"{}\": {}", (Object)result, (Object)e.getMessage());
                        LOGGER.trace("", e);
                        return result;
                    }
                }
                try {
                    FilePermissions permissions = new FilePermissions(result, options);
                    Set<FilePermissions.FileFlag> flags = permissions.getFlags(requiredFlags);
                    if (!flags.containsAll(Arrays.asList(requiredFlags))) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Resolved \"{}\" from \"{}\" using OS path", (Object)result, (Object)relativePath);
                    }
                    try {
                        return result.toRealPath(options);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not get the real path of \"{}\": {}", (Object)result, (Object)e.getMessage());
                        LOGGER.trace("", e);
                        return result;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Failed to resolve \"{}\" using OS path", (Object)relativePath);
        }
        return null;
    }

    public static String getSimplifiedShowName(String title) {
        if (title == null) {
            return null;
        }
        return title.toLowerCase().replaceAll("[^a-z0-9]", "");
    }

    public static boolean isDirectory(String filename) {
        return FileUtil.getExtension(filename) == null;
    }

    public static boolean isSymbolicLink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    public static File getRealFile(File file) {
        Path target = file.toPath();
        while (Files.isSymbolicLink(target)) {
            try {
                target = target.toRealPath(new LinkOption[0]);
            }
            catch (IOException ex) {
                return target.toFile();
            }
        }
        return target.toFile();
    }

    public static final boolean isLocked(File file) {
        boolean bl;
        RandomAccessFile srcFile = new RandomAccessFile(file, "rw");
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    srcFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return true;
            }
        }
        srcFile.close();
        return bl;
    }

    static {
        char separator = File.separatorChar;
        if (separator == '\\') {
            FILE_SEPARATORS = new char[2];
            FileUtil.FILE_SEPARATORS[0] = separator;
            FileUtil.FILE_SEPARATORS[1] = 47;
        } else {
            FILE_SEPARATORS = new char[1];
            FileUtil.FILE_SEPARATORS[0] = separator;
        }
        MIXED_EPISODE_CONVENTION_PATTERN = Pattern.compile(MIXED_EPISODE_CONVENTION);
        MINISERIES_CONVENTION_PATTERN = Pattern.compile(MINISERIES_CONVENTION);
        SCENE_MULTI_EPISODE_CONVENTION_PATTERN = Pattern.compile(SCENE_MULTI_EPISODE_CONVENTION);
        SHOW_NAME_INDEX_PATTERN = Pattern.compile("(?i) (S\\d{2}E\\d{2}\\w{1}|S\\d{2}E\\d{2}|S\\d{2}|S\\d{2}E\\d{2}-\\d{2}|\\d{4}/\\d{2}/\\d{2}) - (.*)");
        SHOW_NAME_INDEX_FALLBACK_PATTERN = Pattern.compile(SHOW_NAME_INDEX_MATCHER);
        COMMON_FILE_EDITIONS_PATTERN = Pattern.compile(COMMON_FILE_EDITIONS);
        COMMON_ANIME_EPISODE_NUMBERS_PATTERN = Pattern.compile(COMMON_ANIME_EPISODE_NUMBERS);
        SEASON_NUMBER_IN_SERIES_TITLE_PATTERN = Pattern.compile(".*\\sS(\\d)$");
        COMMON_ANIME_MULTIPLE_EPISODES_NUMBERS_PATTERN = Pattern.compile(COMMON_ANIME_MULTIPLE_EPISODES_NUMBERS);
    }

    public static final class FileLocation {
        private final String directoryPath;
        private final String filePath;
        private final boolean isCustom;

        FileLocation(File directory, File file, boolean isCustom) {
            this.directoryPath = FilenameUtils.normalize(directory.getAbsolutePath());
            this.filePath = FilenameUtils.normalize(file.getAbsolutePath());
            this.isCustom = isCustom;
        }

        public String getDirectoryPath() {
            return this.directoryPath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public boolean isCustom() {
            return this.isCustom;
        }
    }

    private static final class FormattedNameAndEdition {
        private final String formattedName;
        private final String edition;

        public FormattedNameAndEdition(String formattedName, String edition) {
            this.formattedName = formattedName;
            this.edition = edition;
        }

        public String getEdition() {
            return this.edition;
        }

        public String getFormattedName() {
            return this.formattedName;
        }
    }

    public static class BufferedReaderDetectCharsetResult
    implements Closeable {
        private final BufferedReader reader;
        private final Charset charset;
        private final boolean successfulDetection;

        public BufferedReaderDetectCharsetResult(BufferedReader reader, Charset charset, boolean successfulDetection) {
            this.reader = reader;
            this.charset = charset;
            this.successfulDetection = successfulDetection;
        }

        public BufferedReader getBufferedReader() {
            return this.reader;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public boolean isSuccessfulDetection() {
            return this.successfulDetection;
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    public static final class InvalidFileSystemException
    extends Exception {
        private static final long serialVersionUID = -4545843729375389876L;

        public InvalidFileSystemException() {
        }

        public InvalidFileSystemException(String message) {
            super(message);
        }

        public InvalidFileSystemException(Throwable cause) {
            super(cause);
        }

        public InvalidFileSystemException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

