/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.pms.platform.PlatformUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FilePermissions {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePermissions.class);
    private final Path path;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private String lastCause = null;
    @GuardedBy(value="lock")
    private boolean readChecked = false;
    @GuardedBy(value="lock")
    private boolean writeChecked = false;
    @GuardedBy(value="lock")
    private boolean executeChecked = false;
    @GuardedBy(value="lock")
    private final EnumSet<FileFlag> flags = EnumSet.noneOf(FileFlag.class);

    public FilePermissions(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (!(file = file.getAbsoluteFile()).exists()) {
            throw new FileNotFoundException("File \"" + file + "\" not found");
        }
        this.path = file.toPath();
        this.lock.writeLock().lock();
        try {
            if (file.isDirectory()) {
                this.flags.add(FileFlag.FOLDER);
            } else if (file.isFile()) {
                this.flags.add(FileFlag.FILE);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public FilePermissions(Path path, LinkOption ... options) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("Path argument cannot be null");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("File \"" + path + "\" not found");
        }
        this.path = path;
        this.lock.writeLock().lock();
        try {
            if (Files.isDirectory(path, options)) {
                this.flags.add(FileFlag.FOLDER);
            } else if (Files.isRegularFile(path, options)) {
                this.flags.add(FileFlag.FILE);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermissions(boolean checkRead, boolean checkWrite, boolean checkExecute) {
        this.lock.readLock().lock();
        try {
            if (!(checkRead && !this.readChecked || checkWrite && !this.writeChecked || checkExecute && !this.executeChecked)) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            boolean checkBrowse;
            boolean bl = checkBrowse = checkRead && !this.readChecked && (checkExecute || this.executeChecked) || checkExecute && !this.executeChecked && (checkRead || this.readChecked);
            if (!this.readChecked && checkRead) {
                try {
                    this.path.getFileSystem().provider().checkAccess(this.path, AccessMode.READ);
                    this.flags.add(FileFlag.READ);
                }
                catch (AccessDeniedException e) {
                    this.lastCause = this.path.toString().equals(e.getMessage()) ? "Insufficient permission to read permissions" : ("Permissions does not allow requested access".equals(e.getMessage()) ? "Permissions do not allow read access" : e.getMessage());
                }
                catch (IOException e) {
                    this.lastCause = e.getMessage();
                }
                this.readChecked = true;
            }
            if (!this.writeChecked && checkWrite) {
                try {
                    this.path.getFileSystem().provider().checkAccess(this.path, AccessMode.WRITE);
                    this.flags.add(FileFlag.WRITE);
                }
                catch (AccessDeniedException e) {
                    this.lastCause = e.getMessage().endsWith("Permissions does not allow requested access") ? "Permissions do not allow write access" : e.getMessage();
                }
                catch (FileSystemException e) {
                    LOGGER.debug("Couldn't determine write permissions for \"{}\", falling back to write testing. The error was: {}", (Object)this.path.toString(), (Object)e.getMessage());
                    if (this.isFolder()) {
                        if (this.testFolderWritable()) {
                            this.flags.add(FileFlag.WRITE);
                        }
                    } else if (this.testFileWritable(this.path.toFile())) {
                        this.flags.add(FileFlag.WRITE);
                    }
                }
                catch (IOException e) {
                    this.lastCause = e.getMessage();
                }
                this.writeChecked = true;
            }
            if (!this.executeChecked && checkExecute) {
                if (Platform.isLinux() && PlatformUtils.INSTANCE.isAdmin()) {
                    this.flags.add(FileFlag.EXECUTE);
                } else {
                    try {
                        this.path.getFileSystem().provider().checkAccess(this.path, AccessMode.EXECUTE);
                        this.flags.add(FileFlag.EXECUTE);
                    }
                    catch (AccessDeniedException e) {
                        this.lastCause = e.getMessage().endsWith("Permissions does not allow requested access") ? "Permissions do not allow execute access" : e.getMessage();
                    }
                    catch (IOException e) {
                        this.lastCause = e.getMessage();
                    }
                }
                this.executeChecked = true;
            }
            if (checkBrowse && this.flags.contains((Object)FileFlag.FOLDER) && this.flags.contains((Object)FileFlag.READ) && this.flags.contains((Object)FileFlag.EXECUTE)) {
                this.flags.add(FileFlag.BROWSE);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isFolder() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.FOLDER);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isFile() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.FILE);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isReadable() {
        this.checkPermissions(true, false, false);
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.READ);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isWritable() {
        this.checkPermissions(false, true, false);
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.WRITE);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isExecutable() {
        this.checkPermissions(false, false, true);
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.EXECUTE);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isExecutableFile() {
        this.checkPermissions(true, false, true);
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.FILE) && this.flags.contains((Object)FileFlag.READ) && this.flags.contains((Object)FileFlag.EXECUTE);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isBrowsable() {
        this.checkPermissions(true, false, true);
        this.lock.readLock().lock();
        try {
            boolean bl = this.flags.contains((Object)FileFlag.BROWSE);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<FileFlag> getFlags(FileFlag ... checkFlag) {
        boolean checkRead = checkFlag.length == 0;
        boolean checkWrite = checkFlag.length == 0;
        boolean checkExecute = checkFlag.length == 0;
        block11: for (FileFlag flag : checkFlag) {
            switch (flag) {
                case BROWSE: {
                    checkRead = true;
                    checkExecute = true;
                    continue block11;
                }
                case EXECUTE: {
                    checkExecute = true;
                    continue block11;
                }
                case FILE: {
                    if (this.isFile()) continue block11;
                    return EnumSet.noneOf(FileFlag.class);
                }
                case FOLDER: {
                    if (this.isFolder()) continue block11;
                    return EnumSet.noneOf(FileFlag.class);
                }
                case READ: {
                    checkRead = true;
                    continue block11;
                }
                case WRITE: {
                    checkWrite = true;
                    continue block11;
                }
                default: {
                    throw new AssertionError("Flag " + flag.name() + "isn't implemented", null);
                }
            }
        }
        this.checkPermissions(checkRead, checkWrite, checkExecute);
        this.lock.readLock().lock();
        try {
            Object object = this.flags.clone();
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public File getFile() {
        return this.path.toFile();
    }

    public Path getPath() {
        return this.path;
    }

    public void refresh() {
        this.lock.writeLock().lock();
        try {
            this.flags.clear();
            this.readChecked = false;
            this.writeChecked = false;
            this.executeChecked = false;
            this.lastCause = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public String getLastCause() {
        this.lock.readLock().lock();
        try {
            String string = this.lastCause;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean debug) {
        if (!debug) {
            this.checkPermissions(true, true, true);
        }
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            sb.append(this.flags.contains((Object)FileFlag.FOLDER) ? "d" : "-");
            if (!this.readChecked) {
                sb.append('?');
            } else {
                sb.append(this.flags.contains((Object)FileFlag.READ) ? "r" : "-");
            }
            if (!this.writeChecked) {
                sb.append('?');
            } else {
                sb.append(this.flags.contains((Object)FileFlag.WRITE) ? "w" : "-");
            }
            if (!this.executeChecked) {
                sb.append('?');
            } else {
                sb.append(this.flags.contains((Object)FileFlag.EXECUTE) ? "x" : "-");
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    private boolean testFolderWritable() {
        if (!this.isFolder()) {
            throw new IllegalStateException("testFolderWriteable can only be called on a folder");
        }
        boolean isWritable = false;
        File file = new File(this.path.toFile(), String.format("UMS_folder_write_test_%d_%d.tmp", System.currentTimeMillis(), Thread.currentThread().getId()));
        try {
            if (file.createNewFile()) {
                if (this.testFileWritable(file)) {
                    isWritable = true;
                }
                if (!file.delete()) {
                    LOGGER.error("Couldn't delete temporary test file: \"{}\"", (Object)file.getAbsolutePath());
                    file.deleteOnExit();
                }
            }
        }
        catch (IOException e) {
            this.lastCause = e.getMessage();
        }
        return isWritable;
    }

    private boolean testFileWritable(File file) {
        if ((file = file.getAbsoluteFile()).isDirectory()) {
            throw new IllegalStateException("Can't be called on a folder");
        }
        boolean isWritable = false;
        boolean fileAlreadyExists = file.isFile();
        if (fileAlreadyExists || !file.exists()) {
            try {
                new FileOutputStream(file, true).close();
                isWritable = true;
                if (!fileAlreadyExists && !file.delete()) {
                    LOGGER.warn("Can't delete temporary test file: {}", (Object)file.getAbsolutePath());
                    file.deleteOnExit();
                }
            }
            catch (IOException e) {
                this.lastCause = e.getMessage();
            }
        } else {
            this.lastCause = file.getAbsolutePath() + " isn't a file";
        }
        return isWritable;
    }

    public static enum FileFlag {
        READ,
        WRITE,
        EXECUTE,
        BROWSE,
        FILE,
        FOLDER;

    }
}

