/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.Version;

@Immutable
public class FFmpegExecutableInfo
extends ExecutableInfo {
    @Nullable
    protected final List<String> protocols;

    public FFmpegExecutableInfo(@Nullable Boolean available, @Nonnull Path path, @Nullable Version version, @Nullable ExecutableErrorType errorType, @Nullable String errorText, @Nullable List<String> protocols) {
        super(available, path, version, errorType, errorText);
        this.protocols = protocols == null ? null : Collections.unmodifiableList(new ArrayList<String>(protocols));
    }

    @Override
    public FFmpegExecutableInfoBuilder modify() {
        return new FFmpegExecutableInfoBuilder(this);
    }

    public static FFmpegExecutableInfoBuilder build(Path executablePath) {
        return new FFmpegExecutableInfoBuilder(executablePath);
    }

    @Nullable
    public List<String> getProtocols() {
        return this.protocols;
    }

    @Override
    public String toString() {
        return "FFmpegExecutableInfo [executablePath=" + this.executablePath + ", available=" + this.available + ", version=" + this.version + ", errorType=" + this.errorType + ", errorText=" + this.errorText + ", protocols=" + this.protocols + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.protocols == null ? 0 : this.protocols.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FFmpegExecutableInfo)) {
            return false;
        }
        FFmpegExecutableInfo other = (FFmpegExecutableInfo)obj;
        return !(this.protocols == null ? other.protocols != null : !this.protocols.equals(other.protocols));
    }

    public static class FFmpegExecutableInfoBuilder
    extends ExecutableInfo.ExecutableInfoBuilder {
        @Nullable
        protected List<String> protocols;

        public FFmpegExecutableInfoBuilder() {
        }

        public FFmpegExecutableInfoBuilder(Path executablePath) {
            this.executablePath = executablePath;
        }

        public FFmpegExecutableInfoBuilder(ExecutableInfo executableInfo) {
            this.available = executableInfo.available;
            this.executablePath = executableInfo.executablePath;
            this.version = executableInfo.version;
            this.errorType = executableInfo.errorType;
            this.errorText = executableInfo.errorText;
            if (executableInfo instanceof FFmpegExecutableInfo) {
                FFmpegExecutableInfo fFmpegExecutableInfo = (FFmpegExecutableInfo)executableInfo;
                this.protocols = fFmpegExecutableInfo.protocols;
            }
        }

        @Override
        @Nonnull
        public FFmpegExecutableInfo build() {
            return new FFmpegExecutableInfo(this.available, this.executablePath, this.version, this.errorType, this.errorText, this.protocols);
        }

        @Override
        @Nonnull
        public FFmpegExecutableInfoBuilder executablePath(Path executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        @Override
        @Nonnull
        public FFmpegExecutableInfoBuilder available(Boolean available) {
            this.available = available;
            return this;
        }

        @Override
        @Nonnull
        public FFmpegExecutableInfoBuilder version(Version version) {
            this.version = version;
            return this;
        }

        @Override
        @Nonnull
        public FFmpegExecutableInfoBuilder errorType(ExecutableErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public FFmpegExecutableInfoBuilder errorText(String errorText) {
            this.errorText = errorText;
            return this;
        }

        @Nullable
        public List<String> protocols() {
            return this.protocols;
        }

        public FFmpegExecutableInfoBuilder protocols(@Nullable List<String> protocols) {
            this.protocols = protocols;
            return this;
        }
    }
}

