/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.ProgramExecutableType;
import net.pms.util.Version;

@ThreadSafe
public class ExternalProgramInfo {
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    protected ProgramExecutableType defaultType;
    protected final ProgramExecutableType originalDefaultType;
    @GuardedBy(value="lock")
    protected final HashMap<ProgramExecutableType, ExecutableInfo> executablesInfo;
    protected final String programName;

    public ExternalProgramInfo(@Nullable String programName, @Nullable ProgramExecutableType defaultType) {
        this.programName = programName;
        this.defaultType = defaultType;
        this.originalDefaultType = defaultType;
        this.executablesInfo = new HashMap();
    }

    public ExternalProgramInfo(@Nullable String programName, @Nullable ProgramExecutableType defaultType, @Nullable Map<ProgramExecutableType, ? extends ExecutableInfo> executablesInfo) {
        this.programName = programName;
        this.defaultType = defaultType;
        this.originalDefaultType = defaultType;
        this.executablesInfo = executablesInfo != null ? new HashMap<ProgramExecutableType, ExecutableInfo>(executablesInfo) : new HashMap();
    }

    protected ExternalProgramInfo(@Nullable String programName, @Nullable ProgramExecutableType defaultType, @Nullable ProgramExecutableType originalDefaultType, @Nullable Map<ProgramExecutableType, ? extends ExecutableInfo> executablesInfo) {
        this.programName = programName;
        this.defaultType = defaultType;
        this.originalDefaultType = originalDefaultType;
        this.executablesInfo = executablesInfo != null ? new HashMap<ProgramExecutableType, ExecutableInfo>(executablesInfo) : new HashMap();
    }

    @Nonnull
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @Nullable
    public String getName() {
        return this.programName;
    }

    @Nullable
    public ProgramExecutableType getOriginalDefault() {
        return this.originalDefaultType;
    }

    @Nullable
    public ProgramExecutableType getDefault() {
        this.lock.readLock().lock();
        try {
            ProgramExecutableType programExecutableType = this.defaultType;
            return programExecutableType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDefault(@Nullable ProgramExecutableType defaultType) {
        this.lock.writeLock().lock();
        try {
            this.defaultType = defaultType;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setOriginalDefault() {
        this.lock.writeLock().lock();
        try {
            this.defaultType = this.originalDefaultType;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public ExecutableInfo getDefaultExecutableInfo() {
        this.lock.readLock().lock();
        try {
            ExecutableInfo executableInfo = this.defaultType == null ? null : this.executablesInfo.get((Object)this.defaultType);
            return executableInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nullable
    public Path getDefaultPath() {
        this.lock.readLock().lock();
        try {
            if (this.defaultType == null) {
                Path path = null;
                return path;
            }
            ExecutableInfo executableInfo = this.executablesInfo.get((Object)this.defaultType);
            Path path = executableInfo == null ? null : executableInfo.getPath();
            return path;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nullable
    public ExecutableInfo getExecutableInfo(@Nullable ProgramExecutableType executableType) {
        if (executableType == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            ExecutableInfo executableInfo = this.executablesInfo.get((Object)executableType);
            return executableInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setExecutableInfo(@Nonnull ProgramExecutableType executableType, @Nullable ExecutableInfo executableInfo) {
        if (executableType == null) {
            throw new IllegalArgumentException("executableType cannot be null");
        }
        this.lock.writeLock().lock();
        try {
            this.executablesInfo.put(executableType, executableInfo);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Path getPath(@Nullable ProgramExecutableType executableType) {
        this.lock.readLock().lock();
        try {
            ExecutableInfo executableInfo = this.executablesInfo.get((Object)executableType);
            Path path = executableInfo == null ? null : executableInfo.getPath();
            return path;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPath(@Nonnull ProgramExecutableType executableType, @Nullable Path path) {
        if (executableType == null) {
            throw new IllegalArgumentException("executableType cannot be null");
        }
        this.lock.writeLock().lock();
        try {
            ExecutableInfo executableInfo = this.executablesInfo.get((Object)executableType);
            if (path == null && executableInfo == null && this.executablesInfo.containsKey((Object)executableType) || path != null && executableInfo != null && path.equals(executableInfo.getPath())) {
                boolean bl = false;
                return bl;
            }
            ExecutableInfo newExecutableInfo = path == null ? null : this.createExecutableInfo(path);
            this.executablesInfo.put(executableType, newExecutableInfo);
            if (path == null && executableInfo == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    public void remove(@Nullable ProgramExecutableType executableType) {
        if (executableType == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.executablesInfo.remove((Object)executableType);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.executablesInfo.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.executablesInfo.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsType(@Nullable ProgramExecutableType executableType, boolean includeNull) {
        if (executableType == null) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.executablesInfo.containsKey((Object)executableType) && (includeNull || this.executablesInfo.get((Object)executableType) != null);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsExecutableInfo(@Nullable ExecutableInfo executableInfo) {
        if (executableInfo == null) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.executablesInfo.containsValue(executableInfo);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPath(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            for (ExecutableInfo executableInfo : this.executablesInfo.values()) {
                if (!path.equals(executableInfo.getPath())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.executablesInfo.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nonnull
    public Set<ProgramExecutableType> getExecutableTypes() {
        this.lock.readLock().lock();
        try {
            HashSet<ProgramExecutableType> hashSet = new HashSet<ProgramExecutableType>(this.executablesInfo.keySet());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    public ProgramExecutableType[] getExecutableTypesArray() {
        this.lock.readLock().lock();
        try {
            ProgramExecutableType[] programExecutableTypeArray = this.executablesInfo.keySet().toArray(new ProgramExecutableType[this.executablesInfo.size()]);
            return programExecutableTypeArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    public Map<ProgramExecutableType, ExecutableInfo> getExecutablesInfo() {
        this.lock.readLock().lock();
        try {
            HashMap<ProgramExecutableType, ExecutableInfo> hashMap = new HashMap<ProgramExecutableType, ExecutableInfo>(this.executablesInfo);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable(boolean available, @Nonnull ProgramExecutableType executableType, @Nullable Version version, @Nullable ExecutableErrorType errorType, @Nullable String errorText) {
        if (executableType == null) {
            throw new IllegalArgumentException("executableType cannot be null or unknown");
        }
        if (!(available || errorType != null && errorText != null)) {
            throw new IllegalArgumentException("errorType and errorType can only be null if available is true or null");
        }
        if (errorType == ExecutableErrorType.SPECIFIC) {
            throw new IllegalArgumentException("SPECIFIC error type isn't allowed");
        }
        this.lock.writeLock().lock();
        try {
            ExecutableInfo executableInfo = this.executablesInfo.get((Object)executableType);
            if (executableInfo == null) {
                throw new IllegalStateException("Cannot set availability for executable type " + executableType + " since its path is undefined");
            }
            executableInfo = executableInfo.modify().available(available).version(version).errorType(errorType).errorText(errorText).build();
            this.executablesInfo.put(executableType, executableInfo);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        this.lock.readLock().lock();
        try {
            if (this.programName != null) {
                sb.append(" ").append(this.programName);
            }
            boolean first = true;
            sb.append(": [");
            for (Map.Entry<ProgramExecutableType, ExecutableInfo> entry : this.executablesInfo.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (entry.getKey() == this.defaultType) {
                    sb.append("(*)");
                }
                sb.append((Object)entry.getKey()).append(" = \"").append(entry.getValue()).append("\"");
            }
            sb.append("]");
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.readLock().lock();
        try {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defaultType == null ? 0 : this.defaultType.hashCode());
            result = 31 * result + (this.programName == null ? 0 : this.programName.hashCode());
            int n = result = 31 * result + (this.executablesInfo == null ? 0 : this.executablesInfo.hashCode());
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalProgramInfo)) {
            return false;
        }
        ExternalProgramInfo other = (ExternalProgramInfo)obj;
        ReentrantReadWriteLock otherLock = other.getLock();
        this.lock.readLock().lock();
        try {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    otherLock.readLock().lock();
                                    try {
                                        if (this.defaultType != null) break block24;
                                        if (other.defaultType != null) {
                                            boolean bl = false;
                                            otherLock.readLock().unlock();
                                            return bl;
                                        }
                                        break block25;
                                    }
                                    catch (Throwable throwable) {
                                        otherLock.readLock().unlock();
                                        throw throwable;
                                    }
                                }
                                if (this.defaultType.equals((Object)other.defaultType)) break block25;
                                boolean bl = false;
                                otherLock.readLock().unlock();
                                return bl;
                            }
                            if (this.programName != null) break block26;
                            if (other.programName != null) {
                                boolean bl = false;
                                otherLock.readLock().unlock();
                                return bl;
                            }
                            break block27;
                        }
                        if (this.programName.equals(other.programName)) break block27;
                        boolean bl = false;
                        otherLock.readLock().unlock();
                        return bl;
                    }
                    if (this.executablesInfo != null) break block28;
                    if (other.executablesInfo != null) {
                        boolean bl = false;
                        otherLock.readLock().unlock();
                        return bl;
                    }
                    break block29;
                }
                if (this.executablesInfo.equals(other.executablesInfo)) break block29;
                boolean bl = false;
                otherLock.readLock().unlock();
                return bl;
            }
            boolean bl = true;
            otherLock.readLock().unlock();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    protected ExecutableInfo createExecutableInfo(@Nonnull Path executablePath) {
        return ExecutableInfo.build(executablePath).build();
    }

    @Nonnull
    public ExternalProgramInfo copy() {
        return new ExternalProgramInfo(this.programName, this.defaultType, this.originalDefaultType, this.executablesInfo);
    }
}

