/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.io.OutputStream;
import net.pms.util.FlowParserOutputStream;
import net.pms.util.PCMAudioOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSAudioOutputStream
extends FlowParserOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(DTSAudioOutputStream.class);
    private static final int[] BITS = new int[]{16, 16, 20, 20, 0, 24, 24};
    private final OutputStream out;
    private boolean dts = false;
    private boolean dtsHD = false;
    private int framesize;
    private int padding;

    public DTSAudioOutputStream(OutputStream out) {
        super(out, 600000);
        if (out instanceof PCMAudioOutputStream) {
            PCMAudioOutputStream pout = (PCMAudioOutputStream)out;
            pout.swapOrderBits = 0;
        }
        this.out = out;
        this.neededByteNumber = 15;
    }

    @Override
    protected void afterChunkSend() throws IOException {
        this.padWithZeros(this.padding);
    }

    @Override
    protected void analyzeBuffer(byte[] data, int off, int len) {
        block4: {
            block5: {
                block3: {
                    if (data[off + 0] != 100 || data[off + 1] != 88 || data[off + 2] != 32 || data[off + 3] != 37) break block3;
                    this.dtsHD = true;
                    this.streamableByteNumber = ((data[off + 6] & 0xF) << 11) + ((data[off + 7] & 0xFF) << 3) + ((data[off + 8] & 0xF0) >> 5) + 1;
                    this.discard = true;
                    break block4;
                }
                if (data[off + 0] != 127 || data[off + 1] != -2 || data[off + 2] != -128 || data[off + 3] != 1) break block5;
                this.discard = false;
                this.dts = true;
                this.streamableByteNumber = this.framesize;
                if (this.framesize != 0) break block4;
                this.framesize = ((data[off + 5] & 3) << 12) + ((data[off + 6] & 0xFF) << 4) + ((data[off + 7] & 0xF0) >> 4) + 1;
                int bitspersample = ((data[off + 11] & 1) << 2) + ((data[off + 12] & 0xFC) >> 6);
                this.streamableByteNumber = this.framesize;
                int pcmWrappedFrameSize = 2048;
                OutputStream outputStream = this.out;
                if (outputStream instanceof PCMAudioOutputStream) {
                    PCMAudioOutputStream pout = (PCMAudioOutputStream)outputStream;
                    pout.nbchannels = 2;
                    pout.sampleFrequency = 48000;
                    pout.bitsperSample = 16;
                    pout.init();
                }
                this.padding = pcmWrappedFrameSize - this.framesize;
                if (bitspersample < 7) {
                    LOGGER.trace("DTS bits per sample: " + BITS[bitspersample]);
                }
                LOGGER.trace("DTS framesize: " + this.framesize);
                break block4;
            }
            for (int i = 3; i < 2020; ++i) {
                if ((data.length <= i || data[i - 3] != 127 || data[i - 2] != -2 || data[i - 1] != -128 || data[i] != 1) && (data.length <= i || data[i - 3] != 100 || data[i - 2] != 88 || data[i - 1] != 32 || data[i] != 37)) continue;
                this.discard = true;
                this.streamableByteNumber = i - 3;
                break;
            }
        }
    }

    @Override
    protected void beforeChunkSend() throws IOException {
    }

    public boolean isDts() {
        return this.dts;
    }

    public boolean isDtsHD() {
        return this.dtsHD;
    }
}

