/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

public class CoverSupplier {
    public static final int NONE_INT = 0;
    public static final int COVER_ART_ARCHIVE_INT = 1;
    public static final Integer NONE_INTEGER = 0;
    public static final Integer COVER_ART_ARCHIVE_INTEGER = 1;
    public static final CoverSupplier NONE = new CoverSupplier(0, "None");
    public static final CoverSupplier COVER_ART_ARCHIVE = new CoverSupplier(1, "Cover Art Archive");
    public final int coverSupplierInt;
    public final String coverSupplierStr;

    private CoverSupplier(int coverSupplierInt, String coverSupplierStr) {
        this.coverSupplierInt = coverSupplierInt;
        this.coverSupplierStr = coverSupplierStr;
    }

    public String toString() {
        return this.coverSupplierStr;
    }

    public int toInt() {
        return this.coverSupplierInt;
    }

    public Integer toInteger() {
        switch (this.coverSupplierInt) {
            case 0: {
                return NONE_INTEGER;
            }
            case 1: {
                return COVER_ART_ARCHIVE_INTEGER;
            }
        }
        throw new IllegalStateException("CoverSupplier " + this.coverSupplierStr + ", " + this.coverSupplierInt + " is unknown.");
    }

    public static CoverSupplier toCoverSupplier(String sArg) {
        return CoverSupplier.toCoverSupplier(sArg, NONE);
    }

    public static CoverSupplier toCoverSupplier(int val) {
        return CoverSupplier.toCoverSupplier(val, NONE);
    }

    public static CoverSupplier toCoverSupplier(int val, CoverSupplier defaultCoverSupplier) {
        return switch (val) {
            case 0 -> NONE;
            case 1 -> COVER_ART_ARCHIVE;
            default -> defaultCoverSupplier;
        };
    }

    public static CoverSupplier toCoverSupplier(String sArg, CoverSupplier defaultCoverSupplier) {
        if (sArg == null) {
            return defaultCoverSupplier;
        }
        sArg = sArg.toLowerCase();
        return switch (sArg.toLowerCase()) {
            case "none" -> NONE;
            case "coverartarchive", "coverartarchive.org", "cover art archive" -> COVER_ART_ARCHIVE;
            default -> defaultCoverSupplier;
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.coverSupplierInt;
        result = 31 * result + (this.coverSupplierStr == null ? 0 : this.coverSupplierStr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverSupplier)) {
            return false;
        }
        CoverSupplier other = (CoverSupplier)obj;
        if (this.coverSupplierInt != other.coverSupplierInt) {
            return false;
        }
        return !(this.coverSupplierStr == null ? other.coverSupplierStr != null : !this.coverSupplierStr.equals(other.coverSupplierStr));
    }
}

