/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.pms.configuration.UmsConfiguration;
import net.pms.media.audio.MediaAudio;
import net.pms.platform.PlatformUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodecUtil.class);
    private static final List<String> CODECS = new ArrayList<String>();

    private CodecUtil() {
    }

    private static void initCodecs() {
        InputStream is = CodecUtil.class.getClassLoader().getResourceAsStream("resources/ffmpeg_formats.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.contains(" ")) {
                    CODECS.add(line.substring(0, line.indexOf(32)));
                    continue;
                }
                CODECS.add(line);
            }
            br.close();
            CODECS.add("iso");
        }
        catch (IOException e) {
            LOGGER.error("Error while retrieving codec list", e);
        }
    }

    public static List<String> getPossibleCodecs() {
        return CODECS;
    }

    public static int getAC3Bitrate(UmsConfiguration configuration, MediaAudio media) {
        int defaultBitrate = configuration.getAudioBitrate();
        if (media != null && defaultBitrate >= 384) {
            if (media.getNumberOfChannels() == 2 || configuration.getAudioChannelCount() == 2) {
                defaultBitrate = 448;
            } else if (media.getNumberOfChannels() == 1) {
                defaultBitrate = 192;
            }
        }
        return defaultBitrate;
    }

    public static String getDefaultFontPath() {
        return PlatformUtils.INSTANCE.getDefaultFontPath();
    }

    public static String isFontRegisteredInOS(String fontName) {
        if (StringUtils.isNotBlank(fontName)) {
            String[] fonts;
            File fontFile = new File(fontName);
            if (fontFile.exists()) {
                try {
                    fontName = Font.createFont(0, fontFile).getFontName();
                }
                catch (FontFormatException | IOException e) {
                    LOGGER.debug("Exception when implementing the custom font: ", (Object)e.getMessage());
                }
            }
            for (String font : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!font.equals(fontName)) continue;
                return font;
            }
        }
        LOGGER.debug("Font name not found. Check if it is properly specified or installed in the OS");
        return null;
    }

    static {
        CodecUtil.initCodecs();
    }
}

