/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.File;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.store.StoreResource;
import net.pms.util.DbHandler;
import net.pms.util.FileDb;
import org.apache.commons.lang3.StringUtils;

public class CodeDb
implements DbHandler {
    public static final String MASTER = "MASTER_CODE";
    private final FileDb db;

    public CodeDb() {
        PMS.getConfiguration();
        this.db = new FileDb(UmsConfiguration.getProfileDirectory() + File.separator + this.name(), this);
        this.db.setMinCnt(2);
        this.db.init();
    }

    public String getCode(String obj) {
        for (String key : this.db.keys()) {
            if (key.equals(MASTER) || !Pattern.matches(key, obj)) continue;
            return key;
        }
        return null;
    }

    public String getCode(StoreResource r) {
        String res = this.getCode(r.getName());
        if (StringUtils.isEmpty(res)) {
            res = this.getCode(r.getSystemName());
        }
        return res;
    }

    public String lookup(String key) {
        return (String)this.db.get(key);
    }

    @Override
    public Object create(String[] args) {
        return args[1];
    }

    @Override
    public String[] format(Object obj) {
        return new String[]{(String)obj};
    }

    @Override
    public final String name() {
        return "UMS.code";
    }
}

