/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.transcoding;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.pms.encoders.Engine;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.tabs.transcoding.TreeNodeSettings;

public class TreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 8830634234336247114L;
    private static final String ICON_TREEMENU_CATEGORY = "icon-treemenu-category.svg";
    private static final String ICON_TREEMENU_ENGINE_DISABLED = "icon-treemenu-enginedisabled.svg";
    private static final String ICON_TREEMENU_ENGINE_ENABLED = "icon-treemenu-engineenabled.svg";
    private static final String ICON_TREEMENU_ENGINE_WARNING = "icon-treemenu-enginewarning.svg";
    private final transient Border border = BorderFactory.createEmptyBorder(0, 3, 0, 3);

    @Override
    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = new Color(57, 114, 147);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf && value instanceof TreeNodeSettings) {
            Engine player = ((TreeNodeSettings)value).getPlayer();
            if (player == null) {
                this.setIcon(JavaGui.readImageIcon(ICON_TREEMENU_CATEGORY));
                this.setToolTipText(null);
            } else {
                if (player.isEnabled()) {
                    if (player.isAvailable()) {
                        this.setIcon(JavaGui.readImageIcon(ICON_TREEMENU_ENGINE_ENABLED));
                    } else {
                        this.setIcon(JavaGui.readImageIcon(ICON_TREEMENU_ENGINE_WARNING));
                    }
                } else {
                    this.setIcon(JavaGui.readImageIcon(ICON_TREEMENU_ENGINE_DISABLED));
                }
                this.setToolTipText(player.getStatusText());
            }
            if (player != null && ((TreeNodeSettings)value).getParent().getIndex((TreeNodeSettings)value) == 0) {
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
        } else {
            this.setIcon(JavaGui.readImageIcon(ICON_TREEMENU_CATEGORY));
        }
        this.setBorder(this.border);
        return this;
    }
}

