/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.status;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.metal.MetalIconFactory;
import net.pms.Messages;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.renderers.Renderer;
import net.pms.swing.components.CustomJButton;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.tabs.status.PlayerControlPanel;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererFrame
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererFrame.class);
    private static final RowSpec RSPEC = RowSpec.decode("center:pref");
    private final transient Renderer renderer;
    private final CellConstraints cc = new CellConstraints();
    private JPanel editBar;
    private boolean ready = false;

    public RendererFrame(JFrame top, Renderer renderer) {
        this.renderer = renderer;
        this.update();
        this.setResizable(false);
        this.setIconImage(top.getIconImage());
        this.setLocationRelativeTo(top);
        this.setVisible(true);
    }

    public final void update() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.buildPanel());
        String rendererName = this.renderer.getRendererName();
        if ("UnknownRenderer".equals(rendererName)) {
            rendererName = Messages.getGuiString(rendererName);
        }
        this.setTitle(rendererName + (String)(this.renderer.isActive() ? "" : " [" + Messages.getGuiString("Offline") + "]"));
        this.pack();
        this.ready = true;
    }

    private JPanel buildPanel() {
        FormLayout layout = new FormLayout("left:pref, 400:grow");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(new EmptyBorder(10, 10, 10, 10));
        int y = 0;
        builder.appendRow(RSPEC);
        this.editBar = new JPanel();
        this.editBar.setLayout(new BoxLayout(this.editBar, 0));
        builder.add(this.editBar).at(this.cc.xyw(1, ++y, 2));
        if (!this.renderer.isFileless()) {
            this.buildEditBar(false);
        }
        builder.appendRow(RSPEC);
        builder.addLabel(" ", new Object[0]).at(this.cc.xy(1, ++y));
        y = this.addMap(this.renderer.getDetails(), builder, y);
        if (this.renderer.isUpnp()) {
            y = this.addStrings("Services", WordUtils.wrap(StringUtils.join(this.renderer.getUpnpServices(), ", "), 60).split("\n"), builder, y);
        }
        if (this.renderer.isControllable()) {
            builder.appendRow(RSPEC);
            builder.addLabel(" ", new Object[0]).at(this.cc.xy(1, ++y));
            builder.appendRow(RSPEC);
            builder.addSeparator(Messages.getGuiString("Controls"), new Object[0]).at(this.cc.xyw(1, ++y, 2));
            builder.appendRow(RSPEC);
            builder.add(new PlayerControlPanel(this.renderer.getPlayer())).at(this.cc.xyw(1, ++y, 2));
        }
        return builder.getPanel();
    }

    private void buildEditBar(boolean updateUI) {
        boolean customized = this.renderer.isCustomized();
        boolean repack = this.ready && this.editBar.getComponentCount() == 0;
        this.editBar.removeAll();
        this.editBar.add(customized ? this.referenceButton() : this.editButton(true));
        if (this.renderer.getFile() != null) {
            this.editBar.add(Box.createHorizontalGlue());
            this.editBar.add(customized ? this.editButton(false) : this.customizeButton());
        }
        if (repack) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.pack();
            }
        } else if (updateUI) {
            this.editBar.updateUI();
        }
    }

    private JButton customizeButton() {
        CustomJButton open = new CustomJButton("+", MetalIconFactory.getTreeLeafIcon());
        open.setHorizontalTextPosition(0);
        open.setForeground(Color.lightGray);
        open.setToolTipText(Messages.getGuiString("CustomizeThisDevice"));
        open.setFocusPainted(false);
        open.addActionListener(e -> {
            File f = this.chooseConf(RendererConfigurations.getWritableRenderersDir(), this.renderer.getDefaultFilename());
            if (f != null) {
                File file = RendererConfigurations.createDeviceFile(this.renderer, f.getName(), true);
                this.buildEditBar(true);
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException ioe) {
                    LOGGER.debug("Failed to open default desktop application: " + ioe);
                }
            }
        });
        return open;
    }

    private JButton referenceButton() {
        File ref = this.renderer.getParentFile();
        CustomJButton open = new CustomJButton(MetalIconFactory.getTreeLeafIcon());
        boolean exists = ref != null && ref.exists();
        open.setToolTipText((String)(exists ? Messages.getGuiString("OpenParentConfiguration") + ": " + ref : Messages.getGuiString("NoParentConfiguration")));
        open.setFocusPainted(false);
        open.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(ref);
            }
            catch (IOException ioe) {
                LOGGER.debug("Failed to open default desktop application: " + ioe);
            }
        });
        if (!exists) {
            open.setText("!");
            open.setHorizontalTextPosition(0);
            open.setForeground(Color.lightGray);
            open.setEnabled(false);
        }
        return open;
    }

    private JButton editButton(boolean create) {
        File file = create ? this.renderer.getUsableFile() : this.renderer.getFile();
        String buttonText = file.exists() || !create ? "<html>" + file.getName() + "</html>" : "<html><font color=blue>" + Messages.getGuiString("StartNewConfigurationFile") + ":</font> " + file.getName() + "</html>";
        CustomJButton open = new CustomJButton(buttonText, MetalIconFactory.getTreeLeafIcon());
        open.setToolTipText(file.getAbsolutePath());
        open.setFocusPainted(false);
        open.addActionListener(e -> {
            File ref;
            boolean exists = file.isFile() && file.exists();
            File f = file;
            if (!exists && create && (f = this.chooseConf(RendererConfigurations.getWritableRenderersDir(), file.getName())) != null && (ref = this.chooseReferenceConf()) != null) {
                RendererConfigurations.createRendererFile(this.renderer, f, true, ref);
                open.setText(f.getName());
                exists = true;
            }
            if (exists) {
                try {
                    Desktop.getDesktop().open(f);
                }
                catch (IOException ioe) {
                    LOGGER.debug("Failed to open default desktop application: " + ioe);
                }
            } else {
                this.buildEditBar(true);
            }
        });
        return open;
    }

    private File chooseConf(final File dir2, String filename) {
        final File file = new File(filename);
        JFileChooser fc = new JFileChooser(dir2){
            private static final long serialVersionUID = -3606991702534289691L;

            @Override
            public boolean isTraversable(File d) {
                return dir2.equals(d);
            }

            @Override
            public void approveSelection() {
                if (this.getSelectedFile().exists()) {
                    int result = JOptionPane.showConfirmDialog(this, Messages.getGuiString("OverwriteExistingFile"), Messages.getGuiString("FileExists"), 1);
                    if (result == 2 || result == 1) {
                        this.setSelectedFile(file);
                    } else if (result == -1) {
                        return;
                    }
                }
                super.approveSelection();
            }
        };
        fc.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Conf Files", "conf");
        fc.addChoosableFileFilter(filter);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setCurrentDirectory(dir2);
        fc.setSelectedFile(file);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(Messages.getGuiString("SpecifyFileName"));
        if (fc.showSaveDialog(this) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    private File chooseReferenceConf() {
        JFileChooser fc = new JFileChooser(RendererConfigurations.getRenderersDir());
        fc.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Conf Files", "conf");
        fc.addChoosableFileFilter(filter);
        fc.setAcceptAllFileFilterUsed(true);
        File defaultRef = new File(RendererConfigurations.getRenderersDir(), "DefaultRenderer.conf");
        if (defaultRef.exists()) {
            fc.setSelectedFile(defaultRef);
        }
        fc.setFileSelectionMode(0);
        return switch (fc.showDialog(this, Messages.getGuiString("SelectReferenceFile"))) {
            case 0 -> fc.getSelectedFile();
            case 1 -> RendererConfiguration.NOFILE;
            default -> null;
        };
    }

    private int addItem(String key, String value, UmsFormBuilder builder, int y) {
        builder.appendRow(RSPEC);
        builder.addLabel((String)(key.length() > 0 ? key + ":  " : ""), new Object[0]).at(this.cc.xy(1, ++y));
        JTextField val = new JTextField(value);
        val.setEditable(false);
        val.setBackground(Color.white);
        builder.add(val).at(this.cc.xy(2, y));
        return y;
    }

    public int addMap(Map<String, String> map, UmsFormBuilder builder, int y) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            y = this.addItem(entry.getKey(), entry.getValue(), builder, y);
        }
        return y;
    }

    private int addStrings(String title, String[] strings, UmsFormBuilder builder, int y) {
        for (String string : strings) {
            y = this.addItem(title, string, builder, y);
            title = "";
        }
        return y;
    }

    private int addList(String title, List<String> list, UmsFormBuilder builder, int y) {
        for (String item : list) {
            y = this.addItem(title, item, builder, y);
            title = "";
        }
        return y;
    }
}

