/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.shared;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.configuration.sharedcontent.FeedAudioContent;
import net.pms.configuration.sharedcontent.FeedContent;
import net.pms.configuration.sharedcontent.FeedImageContent;
import net.pms.configuration.sharedcontent.FeedVideoContent;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentArray;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.configuration.sharedcontent.SharedContentListener;
import net.pms.configuration.sharedcontent.StreamAudioContent;
import net.pms.configuration.sharedcontent.StreamContent;
import net.pms.configuration.sharedcontent.StreamVideoContent;
import net.pms.configuration.sharedcontent.VirtualFolderContent;
import net.pms.database.MediaDatabase;
import net.pms.store.MediaScanner;
import net.pms.store.MediaStatusStore;
import net.pms.store.container.Feed;
import net.pms.swing.components.AnimatedIcon;
import net.pms.swing.components.JAnimatedButton;
import net.pms.swing.components.JImageButton;
import net.pms.swing.components.RestrictedFileSystemView;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.tabs.shared.ShortcutFileSystemView;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedContentTab
implements SharedContentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedContentTab.class);
    private static final String BUTTON_ADD_FOLDER = "button-add-folder.svg";
    private static final String BUTTON_ADD_WEBCONTENT = "button-add-webcontent.svg";
    private static final String BUTTON_ARROW_DOWN = "button-arrow-down.svg";
    private static final String BUTTON_ARROW_UP = "button-arrow-up.svg";
    private static final String BUTTON_CANCEL = "button-cancel.svg";
    private static final String BUTTON_CANCEL_PRESSED = "button-cancel_pressed.svg";
    private static final String BUTTON_REMOVE_FOLDER = "button-remove-folder.svg";
    private static final String BUTTON_SCAN = "button-scan.svg";
    private static final String BUTTON_SCAN_BUSY = "button-scan-busy.svg";
    private static final String BUTTON_SCAN_BUSY_DISABLED = "button-scan-busy_disabled.svg";
    private static final JAnimatedButton SCAN_BUTTON = new JAnimatedButton("button-scan.svg");
    private static final AnimatedIcon SCAN_NORMAL_ICON = (AnimatedIcon)SCAN_BUTTON.getIcon();
    private static final AnimatedIcon SCAN_ROLLOVER_ICON = (AnimatedIcon)SCAN_BUTTON.getRolloverIcon();
    private static final AnimatedIcon SCAN_PRESSED_ICON = (AnimatedIcon)SCAN_BUTTON.getPressedIcon();
    private static final AnimatedIcon SCAN_DISABLED_ICON = (AnimatedIcon)SCAN_BUTTON.getDisabledIcon();
    private static final AnimatedIcon SCAN_BUSY_ICON = new AnimatedIcon((JComponent)SCAN_BUTTON, "button-scan-busy.svg");
    private static final AnimatedIcon SCAN_BUSY_ROLLOVER_ICON = new AnimatedIcon((JComponent)SCAN_BUTTON, "button-cancel.svg");
    private static final AnimatedIcon SCAN_BUSY_PRESSED_ICON = new AnimatedIcon((JComponent)SCAN_BUTTON, "button-cancel_pressed.svg");
    private static final AnimatedIcon SCAN_BUSY_DISABLED_ICON = new AnimatedIcon((JComponent)SCAN_BUTTON, "button-scan-busy_disabled.svg");
    private static final String PANEL_COL_SPEC = "left:pref, 50dlu, pref, 150dlu, pref, 25dlu, pref, 9dlu, pref, default:grow, pref, 25dlu";
    private static final String PANEL_ROW_SPEC = "fill:default:grow";
    private static final String SHARED_FOLDER_COL_SPEC = "left:pref, left:pref, pref, pref, pref, pref, 0:grow";
    private static final String SHARED_FOLDER_ROW_SPEC = "2*(p, 3dlu), fill:default:grow";
    private final UmsConfiguration configuration;
    private final JavaGui looksFrame;
    private String[] typesReadable;
    private String readableTypeFolder;
    private String readableTypeFolders;
    private String readableTypeAudioFeed;
    private String readableTypeVideoFeed;
    private String readableTypeImageFeed;
    private String readableTypeAudioStream;
    private String readableTypeVideoStream;
    private JTable sharedContentList;
    private SharedContentTableModel sharedContentTableModel;
    private SharedContentArray sharedContentArray;

    public SharedContentTab(UmsConfiguration configuration, JavaGui looksFrame) {
        this.configuration = configuration;
        this.looksFrame = looksFrame;
        this.updateReadableTypes();
    }

    public JComponent build() {
        this.updateReadableTypes();
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec(PANEL_COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, PANEL_ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DLU4);
        builder.opaque(true);
        CellConstraints cc = new CellConstraints();
        JPanel sharedContentPanel = this.initSharedContentGuiComponents(cc).build();
        SharedContentConfiguration.addListener(this);
        builder.add(sharedContentPanel).at(FormLayoutUtil.flip(cc.xyw(1, 1, 12), colSpec, orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    private void updateReadableTypes() {
        this.typesReadable = new String[]{Messages.getGuiString("Folder"), Messages.getGuiString("VirtualFolders"), Messages.getGuiString("Podcast"), Messages.getGuiString("VideoFeed"), Messages.getGuiString("ImageFeed"), Messages.getGuiString("AudioStream"), Messages.getGuiString("VideoStream")};
        this.readableTypeFolder = this.typesReadable[0];
        this.readableTypeFolders = this.typesReadable[1];
        this.readableTypeAudioFeed = this.typesReadable[2];
        this.readableTypeVideoFeed = this.typesReadable[3];
        this.readableTypeImageFeed = this.typesReadable[4];
        this.readableTypeAudioStream = this.typesReadable[5];
        this.readableTypeVideoStream = this.typesReadable[6];
    }

    @Override
    public synchronized void updateSharedContent() {
        this.sharedContentArray = SharedContentConfiguration.getSharedContentArray();
        this.refreshSharedContent();
    }

    private UmsFormBuilder initSharedContentGuiComponents(CellConstraints cc) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec(SHARED_FOLDER_COL_SPEC, orientation);
        FormLayout layoutFolders = new FormLayout(colSpec, SHARED_FOLDER_ROW_SPEC);
        UmsFormBuilder builderFolder = UmsFormBuilder.create().layout(layoutFolders);
        builderFolder.opaque(true);
        builderFolder.addSeparator(Messages.getGuiString("SharedContent"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 1, 7), colSpec, orientation));
        this.sharedContentTableModel = new SharedContentTableModel();
        this.sharedContentList = new JTable(this.sharedContentTableModel);
        TableColumn column = this.sharedContentList.getColumnModel().getColumn(3);
        column.setMinWidth(500);
        this.sharedContentList.addMouseListener(new TableMouseListener(this.sharedContentList));
        this.addContentsFullyPlayedPopupMenu(this.sharedContentList);
        DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)this.sharedContentList.getCellRenderer(0, 0);
        FontMetrics metrics = cellRenderer.getFontMetrics(cellRenderer.getFont());
        this.sharedContentList.setRowHeight(metrics.getLeading() + metrics.getMaxAscent() + metrics.getMaxDescent() + 4);
        this.sharedContentList.setIntercellSpacing(new Dimension(8, 2));
        JImageButton addFolderButton = new JImageButton(BUTTON_ADD_FOLDER);
        addFolderButton.setToolTipText(Messages.getGuiString("AddFolder"));
        addFolderButton.addActionListener(e -> {
            JFileChooser chooser;
            try {
                chooser = new JFileChooser();
                if (Platform.isWindows()) {
                    chooser.setFileSystemView(new ShortcutFileSystemView());
                }
            }
            catch (Exception ee) {
                chooser = new JFileChooser(new RestrictedFileSystemView());
                LOGGER.debug("Using RestrictedFileSystemView because {}", (Object)ee.getMessage());
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog((Component)e.getSource());
            if (returnVal == 0) {
                int firstSelectedRow = this.sharedContentList.getSelectedRow();
                if (firstSelectedRow >= 0) {
                    this.sharedContentArray.add(firstSelectedRow, new FolderContent(chooser.getSelectedFile().getAbsoluteFile()));
                } else {
                    this.sharedContentArray.add(new FolderContent(chooser.getSelectedFile().getAbsoluteFile()));
                }
                SharedContentConfiguration.updateSharedContent(this.sharedContentArray, true);
            }
        });
        builderFolder.add(addFolderButton).at(FormLayoutUtil.flip(cc.xy(1, 3), colSpec, orientation));
        JImageButton addWebContentButton = new JImageButton(BUTTON_ADD_WEBCONTENT);
        addWebContentButton.setToolTipText(Messages.getGuiString("AddNewWebContent"));
        addWebContentButton.addActionListener(e -> {
            JLabel labelType = new JLabel(Messages.getGuiString("TypeColon"));
            JLabel labelFolders = new JLabel(Messages.getGuiString("FoldersSlashDelimited"));
            JLabel labelName = new JLabel(Messages.getGuiString("NameColon"));
            JLabel labelSource = new JLabel(Messages.getGuiString("SourceURLColon"));
            JTextField newEntryFolders = new JTextField(25);
            newEntryFolders.setText("Web/");
            JTextField newEntrySource = new JTextField(50);
            JTextField newEntryName = new JTextField(25);
            newEntryName.setEnabled(false);
            newEntryName.setText(Messages.getGuiString("NamesSetAutomaticallyFeeds"));
            String[] typesWebContent = new String[]{this.typesReadable[2], this.typesReadable[3], this.typesReadable[4], this.typesReadable[5], this.typesReadable[6]};
            JComboBox<String> newEntryType = new JComboBox<String>(typesWebContent);
            newEntryType.setEditable(false);
            newEntryType.addItemListener(e1 -> {
                if (this.readableTypeAudioFeed.equals(e1.getItem().toString()) || this.readableTypeVideoFeed.equals(e1.getItem().toString()) || this.readableTypeImageFeed.equals(e1.getItem().toString())) {
                    newEntryName.setEnabled(false);
                    newEntryName.setText(Messages.getGuiString("NamesSetAutomaticallyFeeds"));
                } else if (this.readableTypeAudioStream.equals(e1.getItem().toString()) || this.readableTypeVideoStream.equals(e1.getItem().toString())) {
                    newEntryName.setEnabled(true);
                    newEntryName.setText("");
                }
            });
            JPanel addNewWebContentPanel = new JPanel();
            labelType.setLabelFor(newEntryType);
            labelFolders.setLabelFor(newEntryFolders);
            labelName.setLabelFor(newEntryName);
            labelSource.setLabelFor(newEntrySource);
            GroupLayout layout = new GroupLayout(addNewWebContentPanel);
            addNewWebContentPanel.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(labelType).addComponent(newEntryType, -2, -2, -2).addComponent(labelFolders).addComponent(newEntryFolders, -2, -2, -2).addComponent(labelName).addComponent(newEntryName, -2, -2, -2).addComponent(labelSource).addComponent(newEntrySource)).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(labelType).addComponent(newEntryType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(labelFolders).addComponent(newEntryFolders).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(labelName).addComponent(newEntryName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(labelSource).addComponent(newEntrySource).addContainerGap()));
            int result = JOptionPane.showConfirmDialog(null, addNewWebContentPanel, Messages.getGuiString("AddNewWebContent"), 2);
            if (result == 0) {
                this.sharedContentList.setCursor(Cursor.getPredefinedCursor(3));
                this.sharedContentList.setEnabled(false);
                try {
                    String selectedItem;
                    String resourceName = null;
                    if (!StringUtils.isBlank(newEntrySource.getText())) {
                        try {
                            if (this.readableTypeImageFeed.equals(newEntryType.getSelectedItem().toString()) || this.readableTypeAudioFeed.equals(newEntryType.getSelectedItem().toString()) || this.readableTypeVideoFeed.equals(newEntryType.getSelectedItem().toString())) {
                                String uri = Feed.getFeedUrl(newEntrySource.getText());
                                resourceName = Feed.getFeedTitle(uri);
                            } else if (this.readableTypeVideoStream.equals(newEntryType.getSelectedItem().toString()) || this.readableTypeAudioStream.equals(newEntryType.getSelectedItem().toString())) {
                                resourceName = newEntryName.getText();
                            }
                        }
                        catch (Exception e2) {
                            LOGGER.debug("Error while getting feed title on add: " + e);
                        }
                    }
                    if ((selectedItem = newEntryType.getSelectedItem().toString()).equals(this.readableTypeAudioFeed)) {
                        this.sharedContentArray.add(new FeedAudioContent(newEntryFolders.getText(), resourceName, newEntrySource.getText()));
                    } else if (selectedItem.equals(this.readableTypeImageFeed)) {
                        this.sharedContentArray.add(new FeedImageContent(newEntryFolders.getText(), resourceName, newEntrySource.getText()));
                    } else if (selectedItem.equals(this.readableTypeVideoFeed)) {
                        this.sharedContentArray.add(new FeedVideoContent(newEntryFolders.getText(), resourceName, newEntrySource.getText()));
                    } else if (selectedItem.equals(this.readableTypeAudioStream)) {
                        this.sharedContentArray.add(new StreamAudioContent(newEntryFolders.getText(), resourceName, newEntrySource.getText()));
                    } else if (selectedItem.equals(this.readableTypeVideoStream)) {
                        this.sharedContentArray.add(new StreamVideoContent(newEntryFolders.getText(), resourceName, newEntrySource.getText()));
                    }
                    this.refreshSharedContent();
                    this.sharedContentList.changeSelection(((SharedContentTableModel)this.sharedContentList.getModel()).getRowCount() - 1, 1, false, false);
                    SharedContentConfiguration.updateSharedContent(this.sharedContentArray, true);
                }
                finally {
                    this.sharedContentList.setCursor(Cursor.getPredefinedCursor(0));
                    this.sharedContentList.setEnabled(true);
                }
            }
        });
        builderFolder.add(addWebContentButton).at(FormLayoutUtil.flip(cc.xy(2, 3), colSpec, orientation));
        JImageButton removeButton = new JImageButton(BUTTON_REMOVE_FOLDER);
        removeButton.setToolTipText(Messages.getGuiString("RemoveSelectedSharedContent"));
        removeButton.addActionListener(e -> {
            int currentlySelectedRow = this.sharedContentList.getSelectedRow();
            if (currentlySelectedRow > -1) {
                if (currentlySelectedRow > 0) {
                    this.sharedContentList.changeSelection(currentlySelectedRow - 1, 1, false, false);
                }
                this.sharedContentArray.remove(currentlySelectedRow);
                SharedContentConfiguration.updateSharedContent(this.sharedContentArray, true);
            }
        });
        builderFolder.add(removeButton).at(FormLayoutUtil.flip(cc.xy(3, 3), colSpec, orientation));
        JImageButton arrowDownButton = new JImageButton(BUTTON_ARROW_DOWN);
        arrowDownButton.setToolTipText(Messages.getGuiString("MoveSelectedContentDown"));
        arrowDownButton.addActionListener(e -> {
            int index = this.sharedContentList.getSelectedRow();
            if (index < this.sharedContentArray.size()) {
                SharedContent sharedContent = (SharedContent)this.sharedContentArray.remove(index);
                this.sharedContentArray.add(index + 1, sharedContent);
                this.sharedContentList.changeSelection(index + 1, 1, false, false);
                SharedContentConfiguration.updateSharedContent(this.sharedContentArray, true);
            }
        });
        builderFolder.add(arrowDownButton).at(FormLayoutUtil.flip(cc.xy(4, 3), colSpec, orientation));
        JImageButton arrowUpButton = new JImageButton(BUTTON_ARROW_UP);
        arrowUpButton.setToolTipText(Messages.getGuiString("MoveSelectedContentUp"));
        arrowUpButton.addActionListener(e -> {
            int index = this.sharedContentList.getSelectedRow();
            if (index > 0) {
                SharedContent sharedContent = (SharedContent)this.sharedContentArray.remove(index);
                this.sharedContentArray.add(index - 1, sharedContent);
                this.sharedContentList.changeSelection(index - 1, 1, false, false);
                SharedContentConfiguration.updateSharedContent(this.sharedContentArray, true);
            }
        });
        builderFolder.add(arrowUpButton).at(FormLayoutUtil.flip(cc.xy(5, 3), colSpec, orientation));
        SCAN_BUTTON.setToolTipText(Messages.getGuiString("ScanAllSharedFolders"));
        SCAN_BUSY_ICON.start();
        SCAN_BUSY_DISABLED_ICON.start();
        SCAN_BUTTON.addActionListener(e -> {
            if (MediaScanner.isMediaScanRunning()) {
                int option = JOptionPane.showConfirmDialog(this.looksFrame, Messages.getGuiString("DoYouWantStopScan"), Messages.getGuiString("Question"), 0);
                if (option == 0) {
                    MediaScanner.stopMediaScan();
                    this.looksFrame.setStatusLine(Messages.getGuiString("CancelingScan"));
                    SCAN_BUTTON.setEnabled(false);
                    SCAN_BUTTON.setToolTipText(Messages.getGuiString("CancelingScan"));
                }
            } else {
                MediaScanner.startMediaScan();
                SCAN_BUTTON.setIcon(SCAN_BUSY_ICON);
                SCAN_BUTTON.setRolloverIcon(SCAN_BUSY_ROLLOVER_ICON);
                SCAN_BUTTON.setPressedIcon(SCAN_BUSY_PRESSED_ICON);
                SCAN_BUTTON.setDisabledIcon(SCAN_BUSY_DISABLED_ICON);
                SCAN_BUTTON.setToolTipText(Messages.getGuiString("CancelScanningSharedFolders"));
            }
        });
        if (!this.configuration.isHideAdvancedOptions()) {
            builderFolder.add(SCAN_BUTTON).at(FormLayoutUtil.flip(cc.xy(6, 3), colSpec, orientation));
        }
        JCheckBox scanOnStartup = new JCheckBox(Messages.getGuiString("ScanSharedFoldersStartup"));
        scanOnStartup.setSelected(this.configuration.isScanSharedFoldersOnStartup());
        scanOnStartup.setContentAreaFilled(false);
        scanOnStartup.addItemListener(e -> this.configuration.setScanSharedFoldersOnStartup(e.getStateChange() == 1));
        scanOnStartup.setToolTipText(Messages.getGuiString("ThisControlsUmsScanShared"));
        builderFolder.add(scanOnStartup).at(FormLayoutUtil.flip(cc.xy(7, 3), colSpec, orientation));
        JScrollPane pane = new JScrollPane(this.sharedContentList);
        Dimension d = this.sharedContentList.getPreferredSize();
        pane.setPreferredSize(new Dimension(d.width, this.sharedContentList.getRowHeight() * 2));
        builderFolder.add(pane).at(FormLayoutUtil.flip(cc.xyw(1, 5, 7), colSpec, orientation));
        return builderFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshSharedContent() {
        if (this.sharedContentList == null) {
            return;
        }
        int previouslySelectedRow = this.sharedContentList.getSelectedRow();
        this.sharedContentList.setCursor(Cursor.getPredefinedCursor(3));
        this.sharedContentList.setEnabled(false);
        try {
            ((SharedContentTableModel)this.sharedContentList.getModel()).setRowCount(0);
            for (SharedContent sharedContent : this.sharedContentArray) {
                FolderContent folder;
                if (sharedContent instanceof FolderContent && (folder = (FolderContent)sharedContent).getFile() != null) {
                    this.sharedContentTableModel.addRow(new Object[]{this.readableTypeFolder, null, null, folder.getFile().getPath(), folder.isMonitored(), folder.isActive()});
                    continue;
                }
                if (sharedContent instanceof VirtualFolderContent) {
                    VirtualFolderContent virtualFolder = (VirtualFolderContent)sharedContent;
                    ArrayList<String> childs = new ArrayList<String>();
                    for (SharedContent child : virtualFolder.getChilds()) {
                        if (child == null) continue;
                        childs.add(child.toString());
                    }
                    this.sharedContentTableModel.addRow(new Object[]{this.readableTypeFolders, virtualFolder.getParent(), virtualFolder.getName(), String.join((CharSequence)", ", childs), null, virtualFolder.isActive()});
                    continue;
                }
                if (sharedContent instanceof StreamAudioContent) {
                    StreamAudioContent streamAudio = (StreamAudioContent)sharedContent;
                    this.sharedContentTableModel.addRow(new Object[]{this.readableTypeAudioStream, streamAudio.getParent(), streamAudio.getName(), streamAudio.getUri(), null, streamAudio.isActive()});
                    continue;
                }
                if (sharedContent instanceof StreamVideoContent) {
                    StreamVideoContent streamVideo = (StreamVideoContent)sharedContent;
                    this.sharedContentTableModel.addRow(new Object[]{this.readableTypeVideoStream, streamVideo.getParent(), streamVideo.getName(), streamVideo.getUri(), null, streamVideo.isActive()});
                    continue;
                }
                if (sharedContent instanceof FeedAudioContent) {
                    FeedAudioContent feedAudio = (FeedAudioContent)sharedContent;
                    this.sharedContentTableModel.addRow(new Object[]{this.readableTypeAudioFeed, feedAudio.getParent(), feedAudio.getName(), feedAudio.getUri(), null, feedAudio.isActive()});
                    continue;
                }
                if (sharedContent instanceof FeedImageContent) {
                    FeedImageContent feedImage = (FeedImageContent)sharedContent;
                    this.sharedContentTableModel.addRow(new Object[]{this.readableTypeImageFeed, feedImage.getParent(), feedImage.getName(), feedImage.getUri(), null, feedImage.isActive()});
                    continue;
                }
                if (!(sharedContent instanceof FeedVideoContent)) continue;
                FeedVideoContent feedVideo = (FeedVideoContent)sharedContent;
                this.sharedContentTableModel.addRow(new Object[]{this.readableTypeVideoFeed, feedVideo.getParent(), feedVideo.getName(), feedVideo.getUri(), false, feedVideo.isActive()});
            }
            if (previouslySelectedRow != -1) {
                this.sharedContentList.changeSelection(previouslySelectedRow, 1, false, false);
                Rectangle selectionToScrollTo = this.sharedContentList.getCellRect(previouslySelectedRow, 1, true);
                if (!selectionToScrollTo.isEmpty()) {
                    this.sharedContentList.scrollRectToVisible(selectionToScrollTo);
                }
            }
        }
        finally {
            this.sharedContentList.setCursor(Cursor.getPredefinedCursor(0));
            this.sharedContentList.setEnabled(true);
        }
    }

    private void addContentsFullyPlayedPopupMenu(JComponent component) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItemMarkPlayed = new JMenuItem(Messages.getGuiString("MarkContentsFullyPlayed"));
        JMenuItem menuItemMarkUnplayed = new JMenuItem(Messages.getGuiString("MarkContentsUnplayed"));
        menuItemMarkPlayed.addActionListener(e -> {
            int selectedIndex = this.sharedContentList.getSelectedRow();
            Object patt25617$temp = this.sharedContentArray.get(selectedIndex);
            if (patt25617$temp instanceof FolderContent) {
                FolderContent folderContent = (FolderContent)patt25617$temp;
                String path = folderContent.getFile().getAbsolutePath();
                Connection connection = null;
                try {
                    connection = MediaDatabase.getConnectionIfAvailable();
                    if (connection != null) {
                        MediaStatusStore.setDirectoryFullyPlayed(connection, path, 0, true);
                    }
                }
                finally {
                    MediaDatabase.close(connection);
                }
            }
        });
        menuItemMarkUnplayed.addActionListener(e -> {
            int selectedIndex = this.sharedContentList.getSelectedRow();
            Object patt26191$temp = this.sharedContentArray.get(selectedIndex);
            if (patt26191$temp instanceof FolderContent) {
                FolderContent folderContent = (FolderContent)patt26191$temp;
                String path = folderContent.getFile().getAbsolutePath();
                Connection connection = null;
                try {
                    connection = MediaDatabase.getConnectionIfAvailable();
                    if (connection != null) {
                        MediaStatusStore.setDirectoryFullyPlayed(connection, path, 0, false);
                    }
                }
                finally {
                    MediaDatabase.close(connection);
                }
            }
        });
        popupMenu.add(menuItemMarkPlayed);
        popupMenu.add(menuItemMarkUnplayed);
        component.setComponentPopupMenu(popupMenu);
    }

    public void setMediaScanEnabled(boolean running) {
        SCAN_BUTTON.setIcon(running ? SCAN_BUSY_ICON : SCAN_NORMAL_ICON);
        SCAN_BUTTON.setRolloverIcon(running ? SCAN_BUSY_ROLLOVER_ICON : SCAN_ROLLOVER_ICON);
        SCAN_BUTTON.setPressedIcon(running ? SCAN_BUSY_PRESSED_ICON : SCAN_PRESSED_ICON);
        SCAN_BUTTON.setDisabledIcon(running ? SCAN_BUSY_DISABLED_ICON : SCAN_DISABLED_ICON);
        SCAN_BUTTON.setToolTipText(running ? Messages.getGuiString("CancelScanningSharedFolders") : Messages.getGuiString("ScanAllSharedFolders"));
    }

    private class SharedContentTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -4247839506937958655L;

        public SharedContentTableModel() {
            super(new String[]{Messages.getGuiString("Type"), Messages.getGuiString("Path"), Messages.getGuiString("Name"), Messages.getGuiString("Source"), Messages.getGuiString("Status"), Messages.getGuiString("Enable")}, 0);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 4 || columnIndex == 5 ? Boolean.class : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.isMonitoredCheckbox(row, column) || this.isActiveCheckbox(row, column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (this.isMonitoredCheckbox(row, column)) {
                ((FolderContent)SharedContentTab.this.sharedContentArray.get(row)).setMonitored((Boolean)aValue);
                SharedContentConfiguration.updateSharedContent(SharedContentTab.this.sharedContentArray, true);
            } else if (this.isActiveCheckbox(row, column)) {
                ((SharedContent)SharedContentTab.this.sharedContentArray.get(row)).setActive((Boolean)aValue);
                SharedContentConfiguration.updateSharedContent(SharedContentTab.this.sharedContentArray, true);
            }
        }

        private boolean isMonitoredCheckbox(int row, int column) {
            return column == 4 && SharedContentTab.this.sharedContentArray != null && SharedContentTab.this.sharedContentArray.get(row) instanceof FolderContent;
        }

        private boolean isActiveCheckbox(int row, int column) {
            return column == 5 && SharedContentTab.this.sharedContentArray != null && SharedContentTab.this.sharedContentArray.get(row) != null;
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private final JTable table;

        public TableMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Point point = event.getPoint();
            int currentRow = this.table.rowAtPoint(point);
            this.table.setRowSelectionInterval(currentRow, currentRow);
            int currentColumn = this.table.columnAtPoint(point);
            if (currentColumn == 4 || currentColumn == 5) {
                return;
            }
            if (event.getClickCount() == 2) {
                SharedContent sharedContent = (SharedContent)SharedContentTab.this.sharedContentArray.get(currentRow);
                String currentType = (String)SharedContentTab.this.sharedContentList.getValueAt(currentRow, 0);
                String currentFolders = (String)SharedContentTab.this.sharedContentList.getValueAt(currentRow, 1);
                String currentName = (String)SharedContentTab.this.sharedContentList.getValueAt(currentRow, 2);
                String currentSource = (String)SharedContentTab.this.sharedContentList.getValueAt(currentRow, 3);
                if (sharedContent instanceof FolderContent) {
                    JFileChooser chooser;
                    FolderContent folder = (FolderContent)sharedContent;
                    try {
                        chooser = new JFileChooser();
                        chooser.setSelectedFile(folder.getFile());
                        if (Platform.isWindows()) {
                            chooser.setFileSystemView(new ShortcutFileSystemView());
                        }
                    }
                    catch (Exception ee) {
                        chooser = new JFileChooser(new RestrictedFileSystemView());
                        LOGGER.debug("Using RestrictedFileSystemView because {}", (Object)ee.getMessage());
                    }
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog((Component)event.getSource());
                    if (returnVal == 0) {
                        folder.setFile(chooser.getSelectedFile().getAbsoluteFile());
                        SharedContentConfiguration.updateSharedContent(SharedContentTab.this.sharedContentArray, true);
                    }
                    return;
                }
                int currentTypeIndex = Arrays.asList(SharedContentTab.this.typesReadable).indexOf(currentType);
                JTextField newEntryName = new JTextField(25);
                if (SharedContentTab.this.readableTypeAudioFeed.equals(currentType) || SharedContentTab.this.readableTypeVideoFeed.equals(currentType) || SharedContentTab.this.readableTypeImageFeed.equals(currentType)) {
                    newEntryName.setEnabled(false);
                    if (!StringUtils.isBlank(currentName)) {
                        newEntryName.setText(currentName);
                    } else {
                        newEntryName.setText(Messages.getGuiString("NamesSetAutomaticallyFeeds"));
                    }
                } else {
                    newEntryName.setEnabled(true);
                    newEntryName.setText(currentName);
                }
                JTextField newEntryFolders = new JTextField(25);
                newEntryFolders.setText(currentFolders);
                JTextField newEntrySource = new JTextField(50);
                newEntrySource.setText(currentSource);
                if (SharedContentTab.this.readableTypeFolders.equals(currentType)) {
                    newEntrySource.setEnabled(false);
                }
                JComboBox<String> newEntryType = new JComboBox<String>(SharedContentTab.this.typesReadable);
                newEntryType.setEditable(false);
                newEntryType.setSelectedIndex(currentTypeIndex);
                newEntryType.setEnabled(false);
                JPanel addNewSharedContentPanel = new JPanel();
                JLabel labelType = new JLabel(Messages.getGuiString("TypeColon"));
                JLabel labelFolders = new JLabel(Messages.getGuiString("FoldersSlashDelimited"));
                JLabel labelName = new JLabel(Messages.getGuiString("NameColon"));
                JLabel labelSource = new JLabel(Messages.getGuiString("SourceURLColon"));
                labelName.setLabelFor(newEntryName);
                labelType.setLabelFor(newEntryType);
                labelFolders.setLabelFor(newEntryFolders);
                labelSource.setLabelFor(newEntrySource);
                GroupLayout layout = new GroupLayout(addNewSharedContentPanel);
                addNewSharedContentPanel.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(labelType).addComponent(newEntryType, -2, -2, -2).addComponent(labelFolders).addComponent(newEntryFolders, -2, -2, -2).addComponent(labelName).addComponent(newEntryName, -2, -2, -2).addComponent(labelSource).addComponent(newEntrySource)).addContainerGap()));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(labelType).addComponent(newEntryType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(labelFolders).addComponent(newEntryFolders).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(labelName).addComponent(newEntryName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(labelSource).addComponent(newEntrySource).addContainerGap()));
                int result = JOptionPane.showConfirmDialog(null, addNewSharedContentPanel, Messages.getGuiString("AddNewWebContent"), 2);
                if (result == 0) {
                    if (sharedContent instanceof VirtualFolderContent) {
                        VirtualFolderContent virtualFolder = (VirtualFolderContent)sharedContent;
                        virtualFolder.setName(newEntryName.getText());
                        virtualFolder.setParent(newEntryFolders.getText());
                    } else if (sharedContent instanceof StreamContent) {
                        StreamContent stream = (StreamContent)sharedContent;
                        stream.setName(newEntryName.getText());
                        stream.setParent(newEntryFolders.getText());
                        stream.setUri(newEntrySource.getText());
                    } else if (sharedContent instanceof FeedContent) {
                        FeedContent feed = (FeedContent)sharedContent;
                        feed.setName(newEntryName.getText());
                        feed.setParent(newEntryFolders.getText());
                        feed.setUri(newEntrySource.getText());
                    }
                    SharedContentConfiguration.updateSharedContent(SharedContentTab.this.sharedContentArray, true);
                }
            }
        }
    }
}

