/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.navigation;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.CustomJButton;
import net.pms.swing.components.KeyedComboBoxModel;
import net.pms.swing.components.RestrictedFileSystemView;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.util.CoverSupplier;
import net.pms.util.FullyPlayedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationShareTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationShareTab.class);
    private final UmsConfiguration configuration;
    private final JavaGui looksFrame;
    private JCheckBox hideExtensions;
    private JCheckBox hideEmptyFolders;
    private JCheckBox hideEngines;
    private JTextField seekPosition;
    private JCheckBox generateThumbnails;
    private JCheckBox mplayerThumbnails;
    private JCheckBox dvdIsoThumbnails;
    private JCheckBox imageThumbnails;
    private JCheckBox archive;
    private JComboBox<String> sortMethod;
    private JComboBox<String> audioThumbnails;
    private JTextField defaultThumbFolder;
    private JCheckBox iPhoto;
    private JCheckBox aperture;
    private JCheckBox iTunes;
    private CustomJButton select;
    private CustomJButton cacheReset;
    private JCheckBox ignoreTheWordThe;
    private JTextField atzLimit;
    private JCheckBox prettifyFilenames;
    private JCheckBox resume;
    private JCheckBox useSymlinksTargetFile;
    private JComboBox<String> fullyPlayedAction;
    private JTextField fullyPlayedOutputDirectory;
    private CustomJButton selectFullyPlayedOutputDirectory;
    private JTextField chapterInterval;
    private JComboBox<String> addVideoSuffix;
    private JCheckBox isShowFolderServerSettings;
    private JCheckBox isShowFolderTranscode;
    private JCheckBox isChapterSupport;
    private JCheckBox isShowFolderMediaLibrary;
    private JCheckBox isShowFolderRecentlyPlayed;
    private JCheckBox isShowFolderLiveSubtitles;
    private JComponent component;
    private static final String PANEL_COL_SPEC = "left:pref,          3dlu,                pref, 3dlu,                       pref, 3dlu,               pref, 3dlu, pref, 3dlu, pref, default:grow";
    private static final String PANEL_ROW_SPEC = "p,3dlu,p,3dlu,p,3dlu,p,9dlu,p,3dlu,p,3dlu,p,3dlu,p,9dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,9dlu,fill:default:grow";

    public NavigationShareTab(UmsConfiguration configuration, JavaGui looksFrame) {
        this.configuration = configuration;
        this.looksFrame = looksFrame;
    }

    public JComponent build() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec(PANEL_COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, PANEL_ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout).border(Paddings.DLU4).opaque(true);
        CellConstraints cc = new CellConstraints();
        this.initSimpleComponents(cc);
        if (!this.configuration.isHideAdvancedOptions()) {
            builder.addSeparator(Messages.getGuiString("Thumbnails"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 1, 10), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.generateThumbnails)).at(FormLayoutUtil.flip(cc.xy(1, 3), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("ThumbnailSeekingPosition"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(3, 3), colSpec, orientation));
            builder.add(this.seekPosition).at(FormLayoutUtil.flip(cc.xy(5, 3), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.imageThumbnails)).at(FormLayoutUtil.flip(cc.xy(7, 3), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("AudioThumbnailsImport"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 5), colSpec, orientation));
            builder.add(this.audioThumbnails).at(FormLayoutUtil.flip(cc.xyw(3, 5, 3), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.mplayerThumbnails)).at(FormLayoutUtil.flip(cc.xy(7, 5), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("AlternateVideoCoverArtFolder"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 7), colSpec, orientation));
            builder.add(this.defaultThumbFolder).at(FormLayoutUtil.flip(cc.xy(3, 7), colSpec, orientation));
            builder.add(this.select).at(FormLayoutUtil.flip(cc.xy(5, 7), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.dvdIsoThumbnails)).at(FormLayoutUtil.flip(cc.xy(7, 7), colSpec, orientation));
            builder.addSeparator(Messages.getGuiString("FileSortingNaming"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 9, 10), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("FileOrder"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 11), colSpec, orientation));
            builder.add(this.sortMethod).at(FormLayoutUtil.flip(cc.xyw(3, 11, 3), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.ignoreTheWordThe)).at(FormLayoutUtil.flip(cc.xy(7, 11), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.prettifyFilenames)).at(FormLayoutUtil.flip(cc.xy(1, 13), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.hideExtensions)).at(FormLayoutUtil.flip(cc.xy(3, 13), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("AddSubtitlesInformationVideoNames"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 15), colSpec, orientation));
            builder.add(this.addVideoSuffix).at(FormLayoutUtil.flip(cc.xyw(3, 15, 3), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.hideEngines)).at(FormLayoutUtil.flip(cc.xy(7, 15), colSpec, orientation));
            builder.addSeparator(Messages.getGuiString("VirtualFoldersFiles"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 17, 10), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.iTunes)).at(FormLayoutUtil.flip(cc.xy(1, 19), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.iPhoto)).at(FormLayoutUtil.flip(cc.xy(3, 19), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.aperture)).at(FormLayoutUtil.flip(cc.xy(7, 19), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("DatabaseCache"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 21), colSpec, orientation));
            builder.add(this.cacheReset).at(FormLayoutUtil.flip(cc.xyw(3, 21, 3), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.isShowFolderMediaLibrary)).at(FormLayoutUtil.flip(cc.xy(7, 21), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.archive)).at(FormLayoutUtil.flip(cc.xy(1, 23), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.isShowFolderServerSettings)).at(FormLayoutUtil.flip(cc.xy(3, 23), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.isShowFolderTranscode)).at(FormLayoutUtil.flip(cc.xy(1, 25), colSpec, orientation));
            builder.add(this.isChapterSupport).at(FormLayoutUtil.flip(cc.xy(3, 25), colSpec, orientation));
            builder.add(this.chapterInterval).at(FormLayoutUtil.flip(cc.xy(7, 25), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.isShowFolderLiveSubtitles)).at(FormLayoutUtil.flip(cc.xy(1, 27), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("MinimumItemLimitBeforeAZ"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(3, 27), colSpec, orientation));
            builder.add(this.atzLimit).at(FormLayoutUtil.flip(cc.xy(5, 27), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.resume)).at(FormLayoutUtil.flip(cc.xy(1, 29), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.isShowFolderRecentlyPlayed)).at(FormLayoutUtil.flip(cc.xy(3, 29), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.hideEmptyFolders)).at(FormLayoutUtil.flip(cc.xy(7, 29), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(this.useSymlinksTargetFile)).at(FormLayoutUtil.flip(cc.xy(1, 31), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("FullyPlayedAction"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 33), colSpec, orientation));
            builder.add(this.fullyPlayedAction).at(FormLayoutUtil.flip(cc.xyw(3, 33, 3), colSpec, orientation));
            builder.add(this.fullyPlayedOutputDirectory).at(FormLayoutUtil.flip(cc.xy(7, 33), colSpec, orientation));
            builder.add(this.selectFullyPlayedOutputDirectory).at(FormLayoutUtil.flip(cc.xy(9, 33), colSpec, orientation));
        }
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        this.component = new JScrollPane(panel, 20, 30);
        this.component.setBorder(BorderFactory.createEmptyBorder());
        return this.component;
    }

    public Component getComponent() {
        return this.component;
    }

    private void initSimpleComponents(CellConstraints cc) {
        this.seekPosition = new JTextField("" + this.configuration.getThumbnailSeekPos());
        this.seekPosition.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(NavigationShareTab.this.seekPosition.getText());
                    NavigationShareTab.this.configuration.setThumbnailSeekPos(ab);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.debug("Could not parse thumbnail seek position from \"" + NavigationShareTab.this.seekPosition.getText() + "\"");
                }
            }
        });
        this.seekPosition.setEnabled(this.configuration.isThumbnailGenerationEnabled());
        this.generateThumbnails = new JCheckBox(Messages.getGuiString("GenerateThumbnails"), this.configuration.isThumbnailGenerationEnabled());
        this.generateThumbnails.setContentAreaFilled(false);
        this.generateThumbnails.addItemListener(e -> {
            this.configuration.setThumbnailGenerationEnabled(e.getStateChange() == 1);
            this.seekPosition.setEnabled(this.configuration.isThumbnailGenerationEnabled());
            this.mplayerThumbnails.setEnabled(this.configuration.isThumbnailGenerationEnabled());
        });
        this.mplayerThumbnails = new JCheckBox(Messages.getGuiString("UseMplayerVideoThumbnails"), this.configuration.isUseMplayerForVideoThumbs());
        this.mplayerThumbnails.setToolTipText(Messages.getGuiString("WhenSettingDisabledFfmpeg"));
        this.mplayerThumbnails.setContentAreaFilled(false);
        this.mplayerThumbnails.addItemListener(e -> this.configuration.setUseMplayerForVideoThumbs(e.getStateChange() == 1));
        this.mplayerThumbnails.setEnabled(this.configuration.isThumbnailGenerationEnabled());
        this.dvdIsoThumbnails = new JCheckBox(Messages.getGuiString("DvdIsoThumbnails"), this.configuration.isDvdIsoThumbnails());
        this.dvdIsoThumbnails.setContentAreaFilled(false);
        this.dvdIsoThumbnails.addItemListener(e -> this.configuration.setDvdIsoThumbnails(e.getStateChange() == 1));
        this.imageThumbnails = new JCheckBox(Messages.getGuiString("ImageThumbnails"), this.configuration.getImageThumbnailsEnabled());
        this.imageThumbnails.setContentAreaFilled(false);
        this.imageThumbnails.addItemListener(e -> this.configuration.setImageThumbnailsEnabled(e.getStateChange() == 1));
        KeyedComboBoxModel<CoverSupplier, String> thumbKCBM = new KeyedComboBoxModel<CoverSupplier, String>(new CoverSupplier[]{CoverSupplier.NONE, CoverSupplier.COVER_ART_ARCHIVE}, new String[]{Messages.getGuiString("None"), Messages.getGuiString("DownloadFromCoverArtArchive")});
        this.audioThumbnails = new JComboBox(thumbKCBM);
        this.audioThumbnails.setEditable(false);
        thumbKCBM.setSelectedKey(this.configuration.getAudioThumbnailMethod());
        this.audioThumbnails.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setAudioThumbnailMethod((CoverSupplier)thumbKCBM.getSelectedKey());
                LOGGER.info("Setting Audio thumbnails import: {}", thumbKCBM.getSelectedValue());
            }
        });
        this.defaultThumbFolder = new JTextField(this.configuration.getAlternateThumbFolder());
        this.defaultThumbFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NavigationShareTab.this.configuration.setAlternateThumbFolder(NavigationShareTab.this.defaultThumbFolder.getText());
            }
        });
        this.select = new CustomJButton("...");
        this.select.addActionListener(e -> {
            JFileChooser chooser;
            try {
                chooser = new JFileChooser();
            }
            catch (Exception ee) {
                chooser = new JFileChooser(new RestrictedFileSystemView());
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getGuiString("ChooseAFolder"));
            if (returnVal == 0) {
                this.defaultThumbFolder.setText(chooser.getSelectedFile().getAbsolutePath());
                this.configuration.setAlternateThumbFolder(chooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.isShowFolderServerSettings = new JCheckBox(Messages.getGuiString("ShowServerSettingsFolder"), this.configuration.isShowServerSettingsFolder());
        this.isShowFolderServerSettings.setToolTipText(Messages.getGuiString("WarningThisAllowsShutdownComputer"));
        this.isShowFolderServerSettings.setContentAreaFilled(false);
        this.isShowFolderServerSettings.addItemListener(e -> this.configuration.setShowServerSettingsFolder(e.getStateChange() == 1));
        this.isShowFolderTranscode = new JCheckBox(Messages.getGuiString("ShowTranscodeFolder"), this.configuration.isShowTranscodeFolder());
        this.isShowFolderTranscode.setContentAreaFilled(false);
        this.isShowFolderTranscode.addItemListener(e -> {
            this.configuration.setShowTranscodeFolder(e.getStateChange() == 1);
            this.isChapterSupport.setEnabled(this.configuration.isShowTranscodeFolder());
        });
        this.isChapterSupport = new JCheckBox(Messages.getGuiString("ChaptersSupportInTranscodeFolder"), this.configuration.isChapterSupport());
        this.isChapterSupport.setEnabled(this.configuration.isShowTranscodeFolder());
        this.isChapterSupport.setContentAreaFilled(false);
        this.isChapterSupport.addItemListener(e -> {
            this.configuration.setChapterSupport(e.getStateChange() == 1);
            this.chapterInterval.setEnabled(this.configuration.isShowTranscodeFolder() && this.configuration.isChapterSupport());
        });
        this.chapterInterval = new JTextField("" + this.configuration.getChapterInterval());
        this.chapterInterval.setEnabled(this.configuration.isChapterSupport());
        this.chapterInterval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(NavigationShareTab.this.chapterInterval.getText());
                    NavigationShareTab.this.configuration.setChapterInterval(ab);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.debug("Could not parse chapter interval from \"" + NavigationShareTab.this.chapterInterval.getText() + "\"");
                }
            }
        });
        this.isShowFolderMediaLibrary = new JCheckBox(Messages.getGuiString("ShowMediaLibraryFolder"), this.configuration.isShowMediaLibraryFolder());
        this.isShowFolderMediaLibrary.setContentAreaFilled(false);
        this.isShowFolderMediaLibrary.addItemListener(e -> this.configuration.setShowMediaLibraryFolder(e.getStateChange() == 1));
        this.isShowFolderMediaLibrary.setToolTipText(Messages.getGuiString("MediaLibraryFolderWillAvailable"));
        this.archive = new JCheckBox(Messages.getGuiString("BrowseCompressedArchives"), this.configuration.isArchiveBrowsing());
        this.archive.setContentAreaFilled(false);
        this.archive.addItemListener(e -> this.configuration.setArchiveBrowsing(e.getStateChange() == 1));
        this.cacheReset = new CustomJButton(Messages.getGuiString("ResetCache"));
        this.cacheReset.setToolTipText(Messages.getGuiString("CacheEmptiedExceptFullyPlayed"));
        this.cacheReset.addActionListener(e -> {
            int option = JOptionPane.showConfirmDialog(this.looksFrame, Messages.getGuiString("CacheEmptiedExceptFullyPlayed") + "\n" + Messages.getGuiString("AreYouSure"), Messages.getGuiString("Question"), 0);
            if (option == 0) {
                MediaDatabase.initForce();
                try {
                    MediaDatabase.resetCache();
                }
                catch (SQLException e2) {
                    LOGGER.debug("Error when re-initializing after manual cache reset:", e2);
                }
            }
        });
        this.hideExtensions = new JCheckBox(Messages.getGuiString("HideFileExtensions"), this.configuration.isHideExtensions());
        this.hideExtensions.setContentAreaFilled(false);
        if (this.configuration.isPrettifyFilenames()) {
            this.hideExtensions.setEnabled(false);
        }
        this.hideExtensions.addItemListener(e -> this.configuration.setHideExtensions(e.getStateChange() == 1));
        this.hideEngines = new JCheckBox(Messages.getGuiString("AddEnginesNamesAfterFilenames"), !this.configuration.isHideEngineNames());
        this.hideEngines.setToolTipText(Messages.getGuiString("IfEnabledEngineNameDisplayed"));
        this.hideEngines.setContentAreaFilled(false);
        this.hideEngines.addItemListener(e -> this.configuration.setHideEngineNames(e.getStateChange() != 1));
        KeyedComboBoxModel<UmsConfiguration.SubtitlesInfoLevel, String> videoSuffixKCBM = new KeyedComboBoxModel<UmsConfiguration.SubtitlesInfoLevel, String>(new UmsConfiguration.SubtitlesInfoLevel[]{UmsConfiguration.SubtitlesInfoLevel.NONE, UmsConfiguration.SubtitlesInfoLevel.BASIC, UmsConfiguration.SubtitlesInfoLevel.FULL}, new String[]{Messages.getGuiString("None"), Messages.getGuiString("Basic"), Messages.getGuiString("Full")});
        this.addVideoSuffix = new JComboBox(videoSuffixKCBM);
        this.addVideoSuffix.setEditable(false);
        this.addVideoSuffix.setToolTipText(Messages.getGuiString("AddsInformationAboutSelectedSubtitles"));
        videoSuffixKCBM.setSelectedKey(this.configuration.getSubtitlesInfoLevel());
        this.addVideoSuffix.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                LOGGER.debug("Setting Subtitles Info Level to \"{}\"", videoSuffixKCBM.getSelectedValue());
                this.configuration.setSubtitlesInfoLevel((UmsConfiguration.SubtitlesInfoLevel)((Object)((Object)videoSuffixKCBM.getSelectedKey())));
            }
        });
        this.hideEmptyFolders = new JCheckBox(Messages.getGuiString("HideEmptyFolders"), this.configuration.isHideEmptyFolders());
        this.hideEmptyFolders.setToolTipText(Messages.getGuiString("ThisMakesBrowsingSlower"));
        this.hideEmptyFolders.setContentAreaFilled(false);
        this.hideEmptyFolders.addItemListener(e -> this.configuration.setHideEmptyFolders(e.getStateChange() == 1));
        this.useSymlinksTargetFile = new JCheckBox(Messages.getGuiString("UseTargetFileSymbolicLinks"), this.configuration.isUseSymlinksTargetFile());
        this.useSymlinksTargetFile.setToolTipText(Messages.getGuiString("TreatMultipleSymbolicLinks"));
        this.useSymlinksTargetFile.setContentAreaFilled(false);
        this.useSymlinksTargetFile.addItemListener(e -> this.configuration.setUseSymlinksTargetFile(e.getStateChange() == 1));
        this.iTunes = new JCheckBox(Messages.getGuiString("ShowItunesLibrary"), false);
        this.iTunes.setToolTipText(Messages.getGuiString("IfEnabledThreeNewVirtual"));
        this.iTunes.setContentAreaFilled(false);
        this.iTunes.setEnabled(false);
        this.iPhoto = new JCheckBox(Messages.getGuiString("ShowIphotoLibrary"), false);
        this.iPhoto.setContentAreaFilled(false);
        this.iPhoto.setEnabled(false);
        this.aperture = new JCheckBox(Messages.getGuiString("ShowApertureLibrary"), false);
        this.aperture.setContentAreaFilled(false);
        this.aperture.setEnabled(false);
        KeyedComboBoxModel<Integer, String> kcbm = new KeyedComboBoxModel<Integer, String>(new Integer[]{0, 1, 2, 5, 6}, new String[]{Messages.getGuiString("ByDisplayName"), Messages.getGuiString("ByDateNewestFirst"), Messages.getGuiString("ByDateOldestFirst"), Messages.getGuiString("Random"), Messages.getGuiString("NoSorting")});
        this.sortMethod = new JComboBox(kcbm);
        this.sortMethod.setEditable(false);
        kcbm.setSelectedKey(this.configuration.getSortMethod());
        this.sortMethod.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setSortMethod((Integer)kcbm.getSelectedKey());
                LOGGER.info("Setting File Order to: {}", kcbm.getSelectedValue());
            }
        });
        this.ignoreTheWordThe = new JCheckBox(Messages.getGuiString("IgnoreArticlesATheSorting"), this.configuration.isIgnoreTheWordAandThe());
        this.ignoreTheWordThe.setToolTipText(Messages.getGuiString("IfEnabledFilesWillOrdered"));
        this.ignoreTheWordThe.setContentAreaFilled(false);
        this.ignoreTheWordThe.addItemListener(e -> this.configuration.setIgnoreTheWordAandThe(e.getStateChange() == 1));
        this.atzLimit = new JTextField("" + this.configuration.getATZLimit());
        this.atzLimit.setToolTipText(Messages.getGuiString("IfNumberItemsFolderExceeds"));
        this.atzLimit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(NavigationShareTab.this.atzLimit.getText());
                    NavigationShareTab.this.configuration.setATZLimit(ab);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.debug("Could not parse ATZ limit from \"" + NavigationShareTab.this.atzLimit.getText() + "\"");
                    LOGGER.debug("The full error was: " + nfe);
                }
            }
        });
        this.isShowFolderLiveSubtitles = new JCheckBox(Messages.getGuiString("ShowLiveSubtitlesFolder"), this.configuration.isShowLiveSubtitlesFolder());
        this.isShowFolderLiveSubtitles.setContentAreaFilled(false);
        this.isShowFolderLiveSubtitles.addItemListener(e -> this.configuration.setShowLiveSubtitlesFolder(e.getStateChange() == 1));
        this.prettifyFilenames = new JCheckBox(Messages.getGuiString("PrettifyFilenames"), this.configuration.isPrettifyFilenames());
        this.prettifyFilenames.setToolTipText(Messages.getGuiString("IfEnabledFilesWillAppear"));
        this.prettifyFilenames.setContentAreaFilled(false);
        this.prettifyFilenames.addItemListener(e -> {
            this.configuration.setPrettifyFilenames(e.getStateChange() == 1);
            this.hideExtensions.setEnabled(e.getStateChange() != 1);
        });
        this.resume = new JCheckBox(Messages.getGuiString("EnableVideoResuming"), this.configuration.isResumeEnabled());
        this.resume.setToolTipText(Messages.getGuiString("WhenEnabledPartiallyWatchVideo"));
        this.resume.setContentAreaFilled(false);
        this.resume.addItemListener(e -> this.configuration.setResume(e.getStateChange() == 1));
        this.isShowFolderRecentlyPlayed = new JCheckBox(Messages.getGuiString("ShowRecentlyPlayedFolder"), this.configuration.isShowRecentlyPlayedFolder());
        this.isShowFolderRecentlyPlayed.setContentAreaFilled(false);
        this.isShowFolderRecentlyPlayed.addItemListener(e -> this.configuration.setShowRecentlyPlayedFolder(e.getStateChange() == 1));
        KeyedComboBoxModel<FullyPlayedAction, String> fullyPlayedActionModel = new KeyedComboBoxModel<FullyPlayedAction, String>(new FullyPlayedAction[]{FullyPlayedAction.NO_ACTION, FullyPlayedAction.MARK, FullyPlayedAction.HIDE_MEDIA, FullyPlayedAction.MOVE_FOLDER, FullyPlayedAction.MOVE_FOLDER_AND_MARK, FullyPlayedAction.MOVE_TRASH}, new String[]{Messages.getGuiString("DoNothing"), Messages.getGuiString("MarkMedia"), Messages.getGuiString("HideMedia"), Messages.getGuiString("MoveFileToDifferentFolder"), Messages.getGuiString("MoveFileDifferentFolderMark"), Messages.getGuiString("MoveFileRecycleTrashBin")});
        this.fullyPlayedAction = new JComboBox(fullyPlayedActionModel);
        this.fullyPlayedAction.setEditable(false);
        fullyPlayedActionModel.setSelectedKey(this.configuration.getFullyPlayedAction());
        this.fullyPlayedAction.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setFullyPlayedAction((FullyPlayedAction)((Object)((Object)fullyPlayedActionModel.getSelectedKey())));
                this.fullyPlayedOutputDirectory.setEnabled(this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER || this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER_AND_MARK);
                this.selectFullyPlayedOutputDirectory.setEnabled(this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER || this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER_AND_MARK);
            }
        });
        this.fullyPlayedOutputDirectory = new JTextField(this.configuration.getFullyPlayedOutputDirectory());
        this.fullyPlayedOutputDirectory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NavigationShareTab.this.configuration.setFullyPlayedOutputDirectory(NavigationShareTab.this.fullyPlayedOutputDirectory.getText());
            }
        });
        this.fullyPlayedOutputDirectory.setEnabled(this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER || this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER_AND_MARK);
        this.selectFullyPlayedOutputDirectory = new CustomJButton("...");
        this.selectFullyPlayedOutputDirectory.addActionListener(e -> {
            JFileChooser chooser;
            try {
                chooser = new JFileChooser();
            }
            catch (Exception ee) {
                chooser = new JFileChooser(new RestrictedFileSystemView());
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getGuiString("ChooseAFolder"));
            if (returnVal == 0) {
                this.fullyPlayedOutputDirectory.setText(chooser.getSelectedFile().getAbsolutePath());
                this.configuration.setFullyPlayedOutputDirectory(chooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.selectFullyPlayedOutputDirectory.setEnabled(this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER || this.configuration.getFullyPlayedAction() == FullyPlayedAction.MOVE_FOLDER_AND_MARK);
    }
}

