/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.help;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.pms.platform.PlatformUtils;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpTab.class);
    private static final String[] HELP_PAGES = new String[]{"index.html", null, "general_configuration.html", null, "navigation_share.html", "transcoding.html", null, null};
    private String helpPage = "index.html";
    private JEditorPane editorPane;

    public JEditorPane getList() {
        return this.editorPane;
    }

    public JComponent build() {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "pref, fill:default:grow");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.opaque(true);
        CellConstraints cc = new CellConstraints();
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.setBackground(Color.WHITE);
        HTMLEditorKit editorKit = new HTMLEditorKit();
        StyleSheet styleSheet = ((HTMLDocument)editorKit.createDefaultDocument()).getStyleSheet();
        this.buildStyleSheet(styleSheet);
        editorKit.setStyleSheet(styleSheet);
        this.editorPane.setEditorKit(editorKit);
        this.updateContents();
        this.editorPane.addHyperlinkListener(event -> {
            try {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String urlString = event.getURL().toExternalForm();
                    if (urlString.startsWith("http://") || urlString.startsWith("https://") || urlString.startsWith("ftp://")) {
                        PlatformUtils.INSTANCE.browseURI(urlString);
                    } else {
                        this.editorPane.setPage(event.getURL());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
            }
        });
        JScrollPane pane = new JScrollPane(this.editorPane, 20, 30);
        pane.setPreferredSize(new Dimension(500, 400));
        pane.setBorder(BorderFactory.createEmptyBorder());
        builder.add(pane).at(cc.xy(2, 2));
        return builder.getPanel();
    }

    public void updateContents() {
        if (this.editorPane != null) {
            File helpFile;
            File sourceDocumentationDir;
            File documentationDir = new File(PropertiesUtil.getProjectProperties().get("project.documentation.dir"));
            if (!documentationDir.exists() && (sourceDocumentationDir = new File("src/main/external-resources/documentation")).exists()) {
                documentationDir = sourceDocumentationDir;
            }
            if ((helpFile = new File(documentationDir, this.helpPage)).exists()) {
                try {
                    this.editorPane.setPage(helpFile.toURI().toURL());
                }
                catch (IOException e) {
                    LOGGER.debug("Exception while trying to display help file: ", e);
                }
            } else {
                LOGGER.info("Couldn't find help file \"{}\". Help will not be available.", (Object)helpFile.getAbsolutePath());
            }
        }
    }

    public void buildStyleSheet(StyleSheet styleSheet) {
        int baseSize = this.editorPane.getFont().getSize();
        String rule = String.format("body { font-size: %dpt; padding: %dpx; }", Math.round((double)baseSize * 7.0 / 6.0), Math.round((double)baseSize * 5.0 / 6.0));
        styleSheet.addRule(rule);
        rule = String.format("h1 { font-size: %dpx; }", baseSize * 2);
        styleSheet.addRule(rule);
        rule = String.format("h2 { font-size: %dpx; }", Math.round((double)baseSize * 1.5));
        styleSheet.addRule(rule);
        rule = String.format("h3 { font-size: %dpx; }", Math.round((double)baseSize * 1.17));
        styleSheet.addRule(rule);
        rule = String.format("pre, tt { font-size: %dpt; }", baseSize);
        styleSheet.addRule(rule);
        rule = String.format("dd { margin-bottom: %dpx; }", Math.round((double)baseSize * 10.0 / 6.0));
        styleSheet.addRule(rule);
    }

    public void setTabIndex(int selectedIndex) {
        if (selectedIndex != -1 && HELP_PAGES.length > selectedIndex && HELP_PAGES[selectedIndex] != null) {
            this.helpPage = HELP_PAGES[selectedIndex];
            this.updateContents();
        }
    }
}

