/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.general;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.Build;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.network.configuration.NetworkConfiguration;
import net.pms.platform.windows.WindowsUtils;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import net.pms.swing.LanguageSelection;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.CustomJButton;
import net.pms.swing.components.KeyedComboBoxModel;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.ViewLevel;
import net.pms.swing.gui.tabs.general.SelectRenderers;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralTab.class);
    private static final String COL_SPEC = "left:pref, 3dlu, p, 3dlu , p, 3dlu, p, 3dlu, pref:grow";
    private static final String ROW_SPEC = "p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 15dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 15dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p";
    private final JavaGui looksFrame;
    private final UmsConfiguration configuration;
    private final JTextField currentLanguage = new JTextField();
    private JComboBox<String> renderers;
    private JTextField host;
    private JTextField port;
    private JTextField serverName;
    private JTextField ipFilter;
    private JTextField maxbitrate;
    private CustomJButton installService;
    private JCheckBox isUseInfoFromAPI;
    private JCheckBox useInfoFromTMDB;
    private JLabel tmdbApiKeyLabel;
    private JTextField tmdbApiKey;

    public GeneralTab(UmsConfiguration configuration, JavaGui looksFrame) {
        this.configuration = configuration;
        this.looksFrame = looksFrame;
    }

    public JComponent build() {
        int ypos = 1;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec(COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DLU4);
        builder.opaque(true);
        CellConstraints cc = new CellConstraints();
        JCheckBox smcheckBox = new JCheckBox(Messages.getGuiString("StartMinimizedSystemTray"), this.configuration.isMinimized());
        smcheckBox.setContentAreaFilled(false);
        smcheckBox.addItemListener(e -> this.configuration.setMinimized(e.getStateChange() == 1));
        builder.addSeparator(Messages.getGuiString("GeneralSettings_SentenceCase"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, ypos, 9), colSpec, orientation));
        ypos = 7;
        builder.addLabel(Messages.getGuiString("Language"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new BoxLayout(languagePanel, 2));
        this.currentLanguage.setEnabled(false);
        this.currentLanguage.setText(Messages.getGuiString("Language." + this.configuration.getLanguageTag()));
        languagePanel.add(this.currentLanguage);
        CustomJButton selectLanguage = new CustomJButton("    ...    ");
        selectLanguage.addActionListener(e -> {
            LanguageSelection selectionDialog = new LanguageSelection(this.looksFrame, this.configuration.getLanguageLocale(), true);
            selectionDialog.show();
            if (!selectionDialog.isAborted()) {
                this.currentLanguage.setText(Messages.getGuiString("Language." + this.configuration.getLanguageTag()));
                this.looksFrame.applyLanguage();
            }
        });
        languagePanel.add(selectLanguage);
        builder.add(languagePanel).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 3), colSpec, orientation));
        ypos += 2;
        if (!this.configuration.isHideAdvancedOptions()) {
            this.serverName = new JTextField(this.configuration.getServerName());
            this.serverName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GeneralTab.this.configuration.setServerName(GeneralTab.this.serverName.getText());
                }
            });
            builder.addLabel(Messages.getGuiString("ServerName"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
            builder.add(this.serverName).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 3), colSpec, orientation));
            JCheckBox appendProfileName = new JCheckBox(Messages.getGuiString("AppendProfileName"), this.configuration.isAppendProfileName());
            appendProfileName.setToolTipText(Messages.getGuiString("WhenEnabledUmsProfileName"));
            appendProfileName.setContentAreaFilled(false);
            appendProfileName.addItemListener(e -> this.configuration.setAppendProfileName(e.getStateChange() == 1));
            builder.add(SwingUtil.getPreferredSizeComponent(appendProfileName)).at(FormLayoutUtil.flip(cc.xy(7, ypos), colSpec, orientation));
            ypos += 2;
        }
        int xpos = 1;
        builder.add(smcheckBox).at(FormLayoutUtil.flip(cc.xy(xpos, ypos), colSpec, orientation));
        xpos += 2;
        if (Platform.isWindows()) {
            JCheckBox autoStart = new JCheckBox(Messages.getGuiString("StartWithWindows"), this.configuration.isAutoStart());
            autoStart.setContentAreaFilled(false);
            autoStart.addItemListener(e -> this.configuration.setAutoStart(e.getStateChange() == 1));
            builder.add(SwingUtil.getPreferredSizeComponent(autoStart)).at(FormLayoutUtil.flip(cc.xy(xpos, ypos), colSpec, orientation));
            xpos += 2;
        }
        JCheckBox showSplashScreen = new JCheckBox(Messages.getGuiString("EnableSplashScreen"), this.configuration.isShowSplashScreen());
        showSplashScreen.setContentAreaFilled(false);
        showSplashScreen.addItemListener(e -> this.configuration.setShowSplashScreen(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(showSplashScreen)).at(FormLayoutUtil.flip(cc.xy(xpos, ypos), colSpec, orientation));
        ypos += 2;
        xpos += 2;
        if (!this.configuration.isHideAdvancedOptions() && Platform.isWindows()) {
            this.installService = new CustomJButton();
            this.refreshInstallServiceButtonState();
            builder.add(this.installService).at(FormLayoutUtil.flip(cc.xy(xpos, ypos), colSpec, orientation));
        }
        CustomJButton checkForUpdates = new CustomJButton(Messages.getGuiString("CheckForUpdates"));
        checkForUpdates.addActionListener(e -> this.looksFrame.checkForUpdates(false));
        builder.add(checkForUpdates).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
        JCheckBox autoUpdateCheckBox = new JCheckBox(Messages.getGuiString("CheckAutomaticallyForUpdates"), this.configuration.isAutoUpdate());
        autoUpdateCheckBox.setContentAreaFilled(false);
        autoUpdateCheckBox.addItemListener(e -> this.configuration.setAutoUpdate(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(autoUpdateCheckBox)).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 7), colSpec, orientation));
        ypos += 2;
        if (!Build.isUpdatable()) {
            checkForUpdates.setEnabled(false);
            autoUpdateCheckBox.setEnabled(false);
        }
        JCheckBox showAdvancedOptions = new JCheckBox(Messages.getGuiString("ShowAdvancedSettings"), !this.configuration.isHideAdvancedOptions());
        showAdvancedOptions.setContentAreaFilled(false);
        showAdvancedOptions.addActionListener(e -> {
            this.configuration.setHideAdvancedOptions(!showAdvancedOptions.isSelected());
            if (!showAdvancedOptions.isSelected()) {
                this.looksFrame.setViewLevel(ViewLevel.NORMAL);
            } else {
                this.looksFrame.setViewLevel(ViewLevel.ADVANCED);
            }
        });
        builder.add(SwingUtil.getPreferredSizeComponent(showAdvancedOptions)).at(FormLayoutUtil.flip(cc.xyw(1, ypos, 9), colSpec, orientation));
        JCheckBox runWizardOnProgramStartup = new JCheckBox(Messages.getGuiString("RunTheConfigurationWizard"), this.configuration.isRunWizard());
        runWizardOnProgramStartup.setContentAreaFilled(false);
        runWizardOnProgramStartup.addActionListener(e -> this.configuration.setRunWizard(runWizardOnProgramStartup.isSelected()));
        builder.add(SwingUtil.getPreferredSizeComponent(runWizardOnProgramStartup)).at(FormLayoutUtil.flip(cc.xyw(1, ypos += 2, 9), colSpec, orientation));
        ypos += 2;
        if (!this.configuration.isHideAdvancedOptions()) {
            JCheckBox singleInstance = new JCheckBox(Messages.getGuiString("OnlyRunSingleInstance"), this.configuration.isRunSingleInstance());
            singleInstance.setContentAreaFilled(false);
            singleInstance.setToolTipText(Messages.getGuiString("UmsRunAdministratorSingleInstance"));
            singleInstance.addActionListener(e -> this.configuration.setRunSingleInstance(singleInstance.isSelected()));
            builder.add(SwingUtil.getPreferredSizeComponent(singleInstance)).at(FormLayoutUtil.flip(cc.xyw(1, ypos, 9), colSpec, orientation));
            ypos += 2;
        }
        List<RendererConfiguration> allConfs = RendererConfigurations.getEnabledRenderersConfigurations();
        ArrayList<String> keyValues = new ArrayList<String>();
        ArrayList<String> nameValues = new ArrayList<String>();
        keyValues.add("");
        nameValues.add(Messages.getGuiString("UnknownRenderer"));
        if (!allConfs.isEmpty()) {
            RendererConfigurations.sortRendererConfigurationsByName(allConfs);
            for (RendererConfiguration rendererConf : allConfs) {
                if (rendererConf == null) continue;
                keyValues.add(rendererConf.getRendererName());
                nameValues.add(rendererConf.getRendererName());
            }
        }
        KeyedComboBoxModel<String, String> renderersKcbm = new KeyedComboBoxModel<String, String>((String[])keyValues.toArray(String[]::new), (String[])nameValues.toArray(String[]::new));
        this.renderers = new JComboBox(renderersKcbm);
        this.renderers.setEditable(false);
        String defaultRenderer = this.configuration.getRendererDefault();
        renderersKcbm.setSelectedKey(defaultRenderer);
        if (this.renderers.getSelectedIndex() == -1) {
            this.renderers.setSelectedIndex(0);
        }
        if (!this.configuration.isHideAdvancedOptions()) {
            CustomJButton confEdit = new CustomJButton(Messages.getGuiString("EditUmsConfigurationFileManually"));
            GeneralTab generalTab = this;
            confEdit.setToolTipText(generalTab.configuration.getProfilePath());
            confEdit.addActionListener(e -> {
                JPanel tPanel = new JPanel(new BorderLayout());
                GeneralTab generalTab = this;
                File conf = new File(generalTab.configuration.getProfilePath());
                JTextArea textArea = new JTextArea();
                textArea.setFont(new Font("Courier", 0, 12));
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setPreferredSize(new Dimension(900, 450));
                try (FileInputStream fis = new FileInputStream(conf);
                     BufferedReader in = new BufferedReader(new InputStreamReader(fis));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    textArea.setText(sb.toString());
                }
                catch (IOException e1) {
                    return;
                }
                tPanel.add((Component)scrollPane, "North");
                Object[] options = new Object[]{Messages.getGuiString("Save"), Messages.getGuiString("Cancel")};
                if (JOptionPane.showOptionDialog(this.looksFrame, tPanel, Messages.getGuiString("EditUmsConfigurationFileManually"), 2, -1, null, options, null) == 0) {
                    String text = textArea.getText();
                    try {
                        try (FileOutputStream fos = new FileOutputStream(conf);){
                            fos.write(text.getBytes());
                            fos.flush();
                        }
                        this.configuration.reload();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(this.looksFrame, Messages.getGuiString("ErrorSavingConfigFile") + e1.toString());
                    }
                }
            });
            builder.add(confEdit).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
            ypos += 2;
            this.host = new JTextField(this.configuration.getServerHostname());
            this.host.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GeneralTab.this.configuration.setHostname(GeneralTab.this.host.getText());
                }
            });
            this.port = new JTextField((String)(this.configuration.getMediaServerPort() != 5001 ? "" + this.configuration.getMediaServerPort() : ""));
            this.port.setToolTipText(Messages.getGuiString("IfServerCantFindRenderer"));
            this.port.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        String p = GeneralTab.this.port.getText();
                        if (StringUtils.isEmpty(p)) {
                            p = "5001";
                        }
                        int ab = Integer.parseInt(p);
                        GeneralTab.this.configuration.setMediaServerPort(ab);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.debug("Could not parse port from \"" + GeneralTab.this.port.getText() + "\"");
                    }
                }
            });
            builder.addSeparator(Messages.getGuiString("NetworkSettingsAdvanced"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, ypos, 9), colSpec, orientation));
            ypos += 2;
            KeyedComboBoxModel<String, String> networkInterfaces = this.createNetworkInterfacesModel();
            JComboBox networkinterfacesCBX = new JComboBox(networkInterfaces);
            String savedNetworkInterface = this.configuration.getNetworkInterface();
            savedNetworkInterface = NetworkConfiguration.replaceShortInterfaceNameByDisplayName(savedNetworkInterface);
            networkInterfaces.setSelectedKey(savedNetworkInterface);
            networkinterfacesCBX.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.configuration.setNetworkInterface((String)networkInterfaces.getSelectedKey());
                }
            });
            this.ipFilter = new JTextField(this.configuration.getNetworkDevicesFilter());
            this.ipFilter.setToolTipText(Messages.getGuiString(this.configuration.isNetworkDevicesBlockedByDefault() ? "NetworkDevicesBlockedByDefault" : "NetworkDevicesAllowedByDefault"));
            this.ipFilter.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GeneralTab.this.configuration.setNetworkDevicesFilter(GeneralTab.this.ipFilter.getText());
                }
            });
            this.maxbitrate = new JTextField(this.configuration.getMaximumBitrateDisplay());
            this.maxbitrate.setToolTipText(Messages.getGuiString("AValue90Recommended"));
            this.maxbitrate.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GeneralTab.this.configuration.setMaximumBitrate(GeneralTab.this.maxbitrate.getText());
                }
            });
            this.maxbitrate.setEnabled(!this.configuration.isAutomaticMaximumBitrate());
            JCheckBox adaptBitrate = new JCheckBox(Messages.getGuiString("UseAutomaticMaximumBandwidth"), this.configuration.isAutomaticMaximumBitrate());
            adaptBitrate.setToolTipText(Messages.getGuiString("ItSetsOptimalBandwidth"));
            adaptBitrate.setContentAreaFilled(false);
            adaptBitrate.addActionListener(e -> {
                this.configuration.setAutomaticMaximumBitrate(adaptBitrate.isSelected());
                this.maxbitrate.setEnabled(!this.configuration.isAutomaticMaximumBitrate());
                this.looksFrame.getTranscodingTab().enableVideoQualitySettings(this.configuration.isAutomaticMaximumBitrate());
            });
            builder.addLabel(Messages.getGuiString("ForceNetworkingInterface"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
            builder.add(networkinterfacesCBX).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 7), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("ForceIpServer"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            builder.add(this.host).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 7), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("ForcePortServer"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            builder.add(this.port).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 7), colSpec, orientation));
            builder.addLabel(Messages.getGuiString(this.configuration.isNetworkDevicesBlockedByDefault() ? "AllowedNetworkDevices" : "BlockedNetworkDevices"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            builder.add(this.ipFilter).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 7), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("MaximumBandwidthMbs"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            builder.add(this.maxbitrate).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 3), colSpec, orientation));
            builder.add(SwingUtil.getPreferredSizeComponent(adaptBitrate)).at(FormLayoutUtil.flip(cc.xy(7, ypos), colSpec, orientation));
            builder.addSeparator(Messages.getGuiString("AdvancedHttpSystemSettings"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, ypos += 2, 9), colSpec, orientation));
            ypos += 2;
            boolean preventSleepSupported = SleepManager.isPreventSleepSupported();
            if (preventSleepSupported) {
                builder.addLabel(Messages.getGuiString("PreventSleep"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
                KeyedComboBoxModel<PreventSleepMode, String> preventSleepModel = this.createPreventSleepModel();
                JComboBox preventSleep = new JComboBox(preventSleepModel);
                preventSleep.setToolTipText(Messages.getGuiString("DuringPlaybackPreventOperating"));
                preventSleepModel.setSelectedKey(this.configuration.getPreventSleep());
                preventSleep.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        this.configuration.setPreventSleep((PreventSleepMode)((Object)((Object)preventSleepModel.getSelectedKey())));
                    }
                });
                builder.add(preventSleep).at(FormLayoutUtil.flip(cc.xy(3, ypos), colSpec, orientation));
                ypos += 2;
            }
            SelectRenderers selectRenderers = new SelectRenderers();
            builder.addLabel(Messages.getGuiString("EnabledRenderers"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
            CustomJButton setRenderers = new CustomJButton(Messages.getGuiString("SelectRenderers"));
            setRenderers.addActionListener(e -> selectRenderers.showDialog());
            builder.add(setRenderers).at(FormLayoutUtil.flip(cc.xy(3, ypos), colSpec, orientation));
            builder.addLabel(Messages.getGuiString("DefaultRendererWhenAutoFails"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            builder.add(this.renderers).at(FormLayoutUtil.flip(cc.xyw(3, ypos, 3), colSpec, orientation));
            JCheckBox forceDefaultRenderer = new JCheckBox(Messages.getGuiString("ForceDefaultRenderer"), this.configuration.isRendererForceDefault());
            forceDefaultRenderer.setToolTipText(Messages.getGuiString("DisablesAutomaticDetection"));
            forceDefaultRenderer.setContentAreaFilled(false);
            forceDefaultRenderer.addItemListener(e -> this.configuration.setRendererForceDefault(e.getStateChange() == 1));
            builder.add(forceDefaultRenderer).at(FormLayoutUtil.flip(cc.xy(7, ypos), colSpec, orientation));
            builder.addSeparator(Messages.getGuiString("ExternalOutgoingTraffic"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, ypos += 2, 9), colSpec, orientation));
            JCheckBox extNetBox = new JCheckBox(Messages.getGuiString("EnableExternalNetwork"), this.configuration.getExternalNetwork());
            extNetBox.setToolTipText(Messages.getGuiString("ThisControlsWhetherUmsTry"));
            extNetBox.setContentAreaFilled(false);
            extNetBox.addItemListener(e -> {
                boolean checked = e.getStateChange() == 1;
                this.configuration.setExternalNetwork(checked);
                this.isUseInfoFromAPI.setEnabled(checked);
                this.useInfoFromTMDB.setEnabled(checked);
                this.tmdbApiKey.setEnabled(checked && this.configuration.isUseInfoFromTMDB());
                this.tmdbApiKeyLabel.setEnabled(checked && this.configuration.isUseInfoFromTMDB());
            });
            builder.add(extNetBox).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            ypos += 2;
            this.isUseInfoFromAPI = new JCheckBox(Messages.getGuiString("UseInfoFromOurApi"), this.configuration.isUseInfoFromUmsAPI());
            this.isUseInfoFromAPI.setToolTipText(Messages.getGuiString("UsesInformationApiAllowBrowsing"));
            this.isUseInfoFromAPI.setContentAreaFilled(false);
            this.isUseInfoFromAPI.setEnabled(this.configuration.getExternalNetwork());
            this.isUseInfoFromAPI.addItemListener(e -> this.configuration.setUseInfoFromUmsAPI(e.getStateChange() == 1));
            builder.add(this.isUseInfoFromAPI).at(FormLayoutUtil.flip(cc.xy(1, ypos), colSpec, orientation));
            this.useInfoFromTMDB = new JCheckBox(Messages.getGuiString("UseInfoFromTMDB"), this.configuration.isUseInfoFromTMDB());
            this.useInfoFromTMDB.setContentAreaFilled(false);
            this.useInfoFromTMDB.setEnabled(this.configuration.getExternalNetwork());
            this.useInfoFromTMDB.addItemListener(e -> {
                boolean checked = e.getStateChange() == 1;
                this.configuration.setUseInfoFromTMDB(checked);
                this.tmdbApiKey.setEnabled(checked);
                this.tmdbApiKeyLabel.setEnabled(checked);
            });
            builder.add(this.useInfoFromTMDB).at(FormLayoutUtil.flip(cc.xy(1, ypos += 2), colSpec, orientation));
            this.tmdbApiKeyLabel = new JLabel(Messages.getGuiString("TMDBApiKey"), 11);
            this.tmdbApiKeyLabel.setToolTipText(Messages.getGuiString("ToRegisterTmdbApiKey"));
            this.tmdbApiKeyLabel.setEnabled(this.configuration.getExternalNetwork() && this.configuration.isUseInfoFromTMDB());
            builder.add(this.tmdbApiKeyLabel).at(FormLayoutUtil.flip(cc.xy(3, ypos), colSpec, orientation));
            this.tmdbApiKey = new JTextField(this.configuration.getTmdbApiKey());
            this.tmdbApiKey.setEnabled(this.configuration.getExternalNetwork() && this.configuration.isUseInfoFromTMDB());
            this.tmdbApiKey.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GeneralTab.this.configuration.setTmdbApiKey(GeneralTab.this.tmdbApiKey.getText());
                }
            });
            builder.add(this.tmdbApiKey).at(FormLayoutUtil.flip(cc.xy(5, ypos), colSpec, orientation));
        }
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    private void refreshInstallServiceButtonState() {
        if (System.getProperty("start.service") != null || !Platform.isWindows()) {
            this.installService.setEnabled(false);
            this.installService.setText(Messages.getGuiString("InstallAsWindowsService"));
        } else {
            this.installService.setEnabled(true);
            boolean isUmsServiceInstalled = WindowsUtils.isUmsServiceInstalled();
            if (isUmsServiceInstalled) {
                this.installService.setText(Messages.getGuiString("UninstallWindowsService"));
                this.installService.setToolTipText(null);
                for (ActionListener al : this.installService.getActionListeners()) {
                    this.installService.removeActionListener(al);
                }
                this.installService.addActionListener(e -> {
                    WindowsUtils.uninstallWin32Service();
                    LOGGER.info("Uninstalled UMS Windows service");
                    this.refreshInstallServiceButtonState();
                    JOptionPane.showMessageDialog(this.looksFrame, Messages.getGuiString("UninstalledWindowsService"), Messages.getGuiString("Information"), 1);
                });
            } else {
                this.installService.setText(Messages.getGuiString("InstallAsWindowsService"));
                this.installService.setToolTipText(Messages.getGuiString("NotRecommendedJustStartMinimized"));
                for (ActionListener al : this.installService.getActionListeners()) {
                    this.installService.removeActionListener(al);
                }
                this.installService.addActionListener(e -> {
                    if (WindowsUtils.installWin32Service()) {
                        LOGGER.info("Installed UMS Windows service");
                        this.refreshInstallServiceButtonState();
                        JOptionPane.showMessageDialog(this.looksFrame, Messages.getGuiString("YouHaveInstalledWindowsService") + Messages.getGuiString("ThenStartServiceWindows"), Messages.getGuiString("Information"), 1);
                    } else {
                        JOptionPane.showMessageDialog(this.looksFrame, Messages.getGuiString("CouldNotInstallWindowsService"), Messages.getGuiString("Error"), 0);
                    }
                });
            }
        }
    }

    private KeyedComboBoxModel<String, String> createNetworkInterfacesModel() {
        List<String> keys = NetworkConfiguration.getDisplayNames();
        List<String> names = NetworkConfiguration.getDisplayNamesWithAddress();
        keys.add(0, "");
        names.add(0, "");
        return new KeyedComboBoxModel<String, String>((String[])keys.toArray(String[]::new), (String[])names.toArray(String[]::new));
    }

    private KeyedComboBoxModel<PreventSleepMode, String> createPreventSleepModel() {
        PreventSleepMode[] modes = PreventSleepMode.values();
        String[] descriptions = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            descriptions[i] = modes[i].toString();
        }
        return new KeyedComboBoxModel<PreventSleepMode, String>(modes, descriptions);
    }

    public void addRenderers() {
        List<RendererConfiguration> allConfs = RendererConfigurations.getEnabledRenderersConfigurations();
        ArrayList<String> keyValues = new ArrayList<String>();
        ArrayList<String> nameValues = new ArrayList<String>();
        keyValues.add("");
        nameValues.add(Messages.getGuiString("UnknownRenderer"));
        if (!allConfs.isEmpty()) {
            RendererConfigurations.sortRendererConfigurationsByName(allConfs);
            for (RendererConfiguration rendererConf : allConfs) {
                if (rendererConf == null) continue;
                keyValues.add(rendererConf.getRendererName());
                nameValues.add(rendererConf.getRendererName());
            }
        }
        KeyedComboBoxModel<String, String> renderersKcbm = new KeyedComboBoxModel<String, String>((String[])keyValues.toArray(String[]::new), (String[])nameValues.toArray(String[]::new));
        this.renderers.setModel(renderersKcbm);
        this.renderers.setEditable(false);
        String defaultRenderer = this.configuration.getRendererDefault();
        renderersKcbm.setSelectedValue(defaultRenderer);
        if (this.renderers.getSelectedIndex() == -1) {
            this.renderers.setSelectedIndex(0);
        }
        this.renderers.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setRendererDefault((String)renderersKcbm.getSelectedKey());
                LOGGER.info("Setting default renderer to \"{}\"", (Object)(((String)renderersKcbm.getSelectedKey()).isEmpty() ? "Unknown renderer" : renderersKcbm.getSelectedKey()));
            }
        });
    }
}

