/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.about;

import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.platform.PlatformUtils;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.SvgMultiResolutionImage;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.util.PropertiesUtil;

public class AboutTab {
    private Integer rowPosition = 1;

    private Integer getAndIncrementRowPosition() {
        Integer currentRowPosition = this.rowPosition;
        this.rowPosition = this.rowPosition + 2;
        return currentRowPosition;
    }

    public JComponent build() {
        this.rowPosition = 1;
        FormLayout layout = new FormLayout("0:grow, pref, 0:grow", "pref, 3dlu, pref, 12dlu, pref, 12dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout).border(Paddings.DIALOG).opaque(true);
        CellConstraints cc = new CellConstraints();
        String projectName = PropertiesUtil.getProjectProperties().get("project.name");
        LinkMouseListener pms3Link = new LinkMouseListener(projectName + " " + PMS.getVersion(), "https://www.universalmediaserver.com/");
        JLabel lPms3Link = FormsSetup.getComponentFactoryDefault().createLabel(pms3Link.getLabel());
        lPms3Link.setCursor(Cursor.getPredefinedCursor(12));
        lPms3Link.addMouseListener(pms3Link);
        builder.add(lPms3Link).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        String commitId = PropertiesUtil.getProjectProperties().get("git.commit.id");
        String commitTime = PropertiesUtil.getProjectProperties().get("git.commit.time");
        String commitUrl = "https://github.com/UniversalMediaServer/UniversalMediaServer/commit/" + commitId;
        String buildLabel = Messages.getGuiString("BuildDate") + " " + commitTime;
        LinkMouseListener commitLink = new LinkMouseListener(buildLabel, commitUrl);
        JLabel lCommitLink = FormsSetup.getComponentFactoryDefault().createLabel(commitLink.getLabel());
        lCommitLink.setCursor(Cursor.getPredefinedCursor(12));
        lCommitLink.addMouseListener(commitLink);
        builder.add(lCommitLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        builder.add(AboutTab.buildLogoImage()).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        builder.addLabel(Messages.getGuiString("RelatedLinks"), new Object[0]).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        String crowdinName = String.format(Messages.getGuiString("XCrowdinProject"), PMS.NAME);
        LinkMouseListener crowdinLink = new LinkMouseListener(crowdinName, "https://crowdin.com/project/universalmediaserver");
        JLabel lCrowdinLink = FormsSetup.getComponentFactoryDefault().createLabel(crowdinLink.getLabel());
        lCrowdinLink.setCursor(Cursor.getPredefinedCursor(12));
        lCrowdinLink.addMouseListener(crowdinLink);
        builder.add(lCrowdinLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener ffmpegLink = new LinkMouseListener("FFmpeg", "https://ffmpeg.org/");
        JLabel lFfmpegLink = FormsSetup.getComponentFactoryDefault().createLabel(ffmpegLink.getLabel());
        lFfmpegLink.setCursor(Cursor.getPredefinedCursor(12));
        lFfmpegLink.addMouseListener(ffmpegLink);
        builder.add(lFfmpegLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener mplayerLink = new LinkMouseListener("MPlayer", "http://www.mplayerhq.hu");
        JLabel lMplayerLink = FormsSetup.getComponentFactoryDefault().createLabel(mplayerLink.getLabel());
        lMplayerLink.setCursor(Cursor.getPredefinedCursor(12));
        lMplayerLink.addMouseListener(mplayerLink);
        builder.add(lMplayerLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener spirtonLink = new LinkMouseListener("MPlayer, MEncoder and InterFrame builds", "https://www.spirton.com");
        JLabel lSpirtonLink = FormsSetup.getComponentFactoryDefault().createLabel(spirtonLink.getLabel());
        lSpirtonLink.setCursor(Cursor.getPredefinedCursor(12));
        lSpirtonLink.addMouseListener(spirtonLink);
        builder.add(lSpirtonLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener mediaInfoLink = new LinkMouseListener("MediaInfo", "https://mediaarea.net/en/MediaInfo");
        JLabel lMediaInfoLink = FormsSetup.getComponentFactoryDefault().createLabel(mediaInfoLink.getLabel());
        lMediaInfoLink.setCursor(Cursor.getPredefinedCursor(12));
        lMediaInfoLink.addMouseListener(mediaInfoLink);
        builder.add(lMediaInfoLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener avisynthMTLink = new LinkMouseListener("AviSynth MT", "https://forum.doom9.org/showthread.php?t=148782");
        JLabel lAvisynthMTLink = FormsSetup.getComponentFactoryDefault().createLabel(avisynthMTLink.getLabel());
        lAvisynthMTLink.setCursor(Cursor.getPredefinedCursor(12));
        lAvisynthMTLink.addMouseListener(avisynthMTLink);
        builder.add(lAvisynthMTLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener dryIconsLink = new LinkMouseListener("DryIcons", "https://dryicons.com/");
        JLabel lDryIconsLink = FormsSetup.getComponentFactoryDefault().createLabel(dryIconsLink.getLabel());
        lDryIconsLink.setCursor(Cursor.getPredefinedCursor(12));
        lDryIconsLink.addMouseListener(dryIconsLink);
        builder.add(lDryIconsLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener jmgIconsLink = new LinkMouseListener("Jordan Michael Groll's Icons", "https://www.deviantart.com/jrdng");
        JLabel lJmgIconsLink = FormsSetup.getComponentFactoryDefault().createLabel(jmgIconsLink.getLabel());
        lJmgIconsLink.setCursor(Cursor.getPredefinedCursor(12));
        lJmgIconsLink.addMouseListener(jmgIconsLink);
        builder.add(lJmgIconsLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener svpLink = new LinkMouseListener("SVP", "https://www.svp-team.com/");
        JLabel lSVPLink = FormsSetup.getComponentFactoryDefault().createLabel(svpLink.getLabel());
        lSVPLink.setCursor(Cursor.getPredefinedCursor(12));
        lSVPLink.addMouseListener(svpLink);
        builder.add(lSVPLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        LinkMouseListener openSubtitlesLink = new LinkMouseListener("OpenSubtitles.org", "https://www.opensubtitles.org/");
        JLabel lOpenSubtitlesLink = FormsSetup.getComponentFactoryDefault().createLabel(openSubtitlesLink.getLabel());
        lOpenSubtitlesLink.setCursor(Cursor.getPredefinedCursor(12));
        lOpenSubtitlesLink.addMouseListener(openSubtitlesLink);
        builder.add(lOpenSubtitlesLink).at(cc.xy(2, this.getAndIncrementRowPosition(), "center, fill"));
        JScrollPane scrollPane = new JScrollPane(builder.getPanel());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    private static ImageIcon buildLogoImage() {
        return new SvgMultiResolutionImage(SwingUtil.getImageResource("logo.svg"), 256, 256).toImageIcon();
    }

    private static class LinkMouseListener
    extends MouseAdapter {
        private final String name;
        private final String link;

        public LinkMouseListener(String n, String l) {
            this.name = n;
            this.link = l;
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<a href=\"");
            sb.append(this.link);
            sb.append("\">");
            sb.append(this.name);
            sb.append("</a>");
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PlatformUtils.INSTANCE.browseURI(this.link);
        }
    }
}

