/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class SimpleProgressUI
extends BasicProgressBarUI {
    Color fg;
    Color bg;

    public SimpleProgressUI() {
        this(null, null);
    }

    public SimpleProgressUI(Color fg, Color bg) {
        this.fg = fg != null ? fg : super.getSelectionForeground();
        this.bg = bg != null ? bg : super.getSelectionBackground();
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth() - (b.right + b.left);
        int h = this.progressBar.getHeight() - (b.top + b.bottom);
        if (w < 1 || h < 1) {
            return;
        }
        int filled = this.getAmountFull(b, w, h);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.progressBar.getForeground());
        g2.setStroke(new BasicStroke(h, 0, 2));
        g2.drawLine(b.left, h / 2 + b.top, filled + b.left, h / 2 + b.top);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, w, h, filled, b);
        }
    }

    @Override
    protected Color getSelectionForeground() {
        return this.fg;
    }

    @Override
    protected Color getSelectionBackground() {
        return this.bg;
    }
}

