/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.utils;

import java.io.File;
import java.text.Normalizer;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.SystemFileResource;
import org.jupnp.support.model.SortCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResourceSorter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreResourceSorter.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    public static final int SORT_TITLE_ASC = 0;
    public static final int SORT_DATE_MOD_DESC = 1;
    public static final int SORT_DATE_MOD_ASC = 2;
    public static final int SORT_RANDOM = 5;
    public static final int SORT_NO_SORT = 6;

    private StoreResourceSorter() {
    }

    public static void sortResources(List<StoreResource> resources, SortCriterion[] sortCriterions) {
        StoreResourceSorter.sortResources(resources, sortCriterions, null);
    }

    public static void sortResources(List<StoreResource> resources, SortCriterion[] sortCriterions, String lang) {
        List<SortCriterion> sortCriterionsList = List.of(sortCriterions);
        Collections.reverse(sortCriterionsList);
        block16: for (SortCriterion sortCriterion : sortCriterionsList) {
            switch (sortCriterion.getPropertyName()) {
                case "dc:title": {
                    StoreResourceSorter.sortResourcesByTitle(resources, true, lang);
                    continue block16;
                }
                case "upnp:class": {
                    StoreResourceSorter.sortResourcesByUpnpClass(resources, true, lang);
                    continue block16;
                }
                case "dc:creator": {
                    StoreResourceSorter.sortResourcesByCreator(resources, true, lang);
                    continue block16;
                }
                case "upnp:artist": {
                    StoreResourceSorter.sortResourcesByArtist(resources, true, lang);
                    continue block16;
                }
                case "upnp:album": {
                    StoreResourceSorter.sortResourcesByAlbum(resources, true, lang);
                    continue block16;
                }
                case "upnp:genre": {
                    StoreResourceSorter.sortResourcesByGenre(resources, true, lang);
                    continue block16;
                }
            }
            LOGGER.debug("StoreResourceSorter unhandled criterion \"{}\"", (Object)sortCriterion.getPropertyName());
        }
    }

    public static void sortResourcesByDefault(List<StoreResource> resources) {
        StoreResourceSorter.sortResourcesByDefault(resources, null);
    }

    public static void sortResourcesByDefault(List<StoreResource> resources, String lang) {
        int sortMethod = CONFIGURATION.getSortMethod();
        switch (sortMethod) {
            case 0: {
                StoreResourceSorter.sortResourcesByTitle(resources, lang);
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                StoreResourceSorter.sortResourcesByModifiedDate(resources, false);
                break;
            }
            case 2: {
                StoreResourceSorter.sortResourcesByModifiedDate(resources, true);
                break;
            }
            case 5: {
                Collections.shuffle(resources, new Random(System.currentTimeMillis()));
                break;
            }
            default: {
                StoreResourceSorter.sortResourcesByTitle(resources, lang);
            }
        }
    }

    public static void sortResourcesByTitle(List<StoreResource> resources) {
        StoreResourceSorter.sortResourcesByTitle(resources, true, null);
    }

    public static void sortResourcesByTitle(List<StoreResource> resources, String lang) {
        StoreResourceSorter.sortResourcesByTitle(resources, true, lang);
    }

    public static void sortResourcesByTitle(List<StoreResource> resources, boolean asc, String lang) {
        Collections.sort(resources, (resources1, resources2) -> {
            if (resources1 instanceof StoreResource && resources2 instanceof StoreResource) {
                if (resources1 instanceof StoreItem && resources2 instanceof StoreContainer) {
                    return 1;
                }
                if (resources1 instanceof StoreContainer && resources2 instanceof StoreItem) {
                    return -1;
                }
                if (!resources1.isSortable()) {
                    if (!resources2.isSortable()) {
                        return 0;
                    }
                    return asc ? -1 : 1;
                }
                if (!resources2.isSortable()) {
                    return asc ? 1 : -1;
                }
                String str1 = resources1.getLocalizedDisplayName(lang);
                String str2 = resources2.getLocalizedDisplayName(lang);
                if (PMS.getConfiguration().isIgnoreTheWordAandThe()) {
                    str1 = str1 != null ? str1.replaceAll("^(?i)A[ .]|The[ .]", "").replaceAll("\\s{2,}", " ") : null;
                    str2 = str2 != null ? str2.replaceAll("^(?i)A[ .]|The[ .]", "").replaceAll("\\s{2,}", " ") : null;
                }
                return StoreResourceSorter.compareToNormalizedString(str1, str2, asc);
            }
            return 0;
        });
    }

    public static void sortResourcesByModifiedDate(List<StoreResource> resources, boolean asc) {
        Collections.sort(resources, (resources1, resources2) -> {
            if (resources1 instanceof SystemFileResource) {
                SystemFileResource systemFileResource1 = (SystemFileResource)((Object)resources1);
                if (resources2 instanceof SystemFileResource) {
                    SystemFileResource systemFileResource2 = (SystemFileResource)((Object)resources2);
                    if (resources1 instanceof StoreItem && resources2 instanceof StoreContainer) {
                        return 1;
                    }
                    if (resources1 instanceof StoreContainer && resources2 instanceof StoreItem) {
                        return -1;
                    }
                    File file1 = systemFileResource1.getSystemFile();
                    File file2 = systemFileResource2.getSystemFile();
                    if (file1 == null || file2 == null) {
                        return 0;
                    }
                    if (asc) {
                        return Long.compare(file1.lastModified(), file2.lastModified());
                    }
                    return Long.compare(file2.lastModified(), file1.lastModified());
                }
            }
            return 0;
        });
    }

    public static void sortResourcesByUpnpClass(List<StoreResource> resources, boolean asc, String lang) {
    }

    public static void sortResourcesByCreator(List<StoreResource> resources, boolean asc, String lang) {
    }

    public static void sortResourcesByArtist(List<StoreResource> resources, boolean asc, String lang) {
    }

    public static void sortResourcesByAlbum(List<StoreResource> resources, boolean asc, String lang) {
    }

    public static void sortResourcesByGenre(List<StoreResource> resources, boolean asc, String lang) {
        Collections.sort(resources, (resources1, resources2) -> StoreResourceSorter.compareToNormalizedString(resources1.getGenre(), resources2.getGenre(), asc));
    }

    private static int compareToNormalizedString(String str1, String str2, boolean asc) {
        if (str2 == null) {
            return 1;
        }
        if (str1 == null) {
            return -1;
        }
        str1 = Normalizer.normalize(str1, Normalizer.Form.NFKD);
        str2 = Normalizer.normalize(str2, Normalizer.Form.NFKD);
        if (asc) {
            return str1.compareToIgnoreCase(str2);
        }
        return str2.compareToIgnoreCase(str1);
    }
}

