/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.pms.renderers.Renderer;
import net.pms.store.item.ArchiveEntry;
import net.pms.util.ArchiveFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedEntry
extends ArchiveEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZippedEntry.class);

    public ZippedEntry(Renderer renderer, File file, String entryName, long length) {
        super(renderer, file, entryName, length);
    }

    @Override
    public InputStream getInputStream() {
        return ArchiveFileInputStream.getZipEntryInputStream(this.file, this.entryName);
    }

    @Override
    public void push(OutputStream out) throws IOException {
        Runnable r = () -> {
            try (ArchiveFileInputStream in = ArchiveFileInputStream.getZipEntryInputStream(this.file, this.entryName);){
                ((InputStream)in).transferTo(out);
            }
            catch (IOException e) {
                if (!"Pipe closed".equals(e.getMessage())) {
                    LOGGER.error("UnZip error. Possibly harmless.", e);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exception", e);
                }
            }
        };
        new Thread(r, "Zip Extractor").start();
    }
}

