/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.IOException;
import java.io.InputStream;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.formats.FormatFactory;
import net.pms.media.MediaInfo;
import net.pms.media.video.MediaVideo;
import net.pms.network.HTTPResource;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import org.apache.commons.lang.StringUtils;

public abstract class VirtualVideoAction
extends StoreItem {
    private final String thumbnailIconOK;
    private final String thumbnailIconKO;
    private final String videoOk;
    private final String videoKo;
    private boolean enabled;
    private long timer1;
    protected String name;

    protected VirtualVideoAction(Renderer renderer, String name, boolean enabled, String enabledIconOverride) {
        super(renderer);
        this.name = name;
        this.thumbnailIconOK = StringUtils.isNotBlank(enabledIconOverride) ? enabledIconOverride : "images/store/action-ok.png";
        this.thumbnailIconKO = "images/store/action-cancel.png";
        this.videoOk = "videos/action_success-512.mpg";
        this.videoKo = "videos/button_cancel-512.mpg";
        this.timer1 = -1L;
        this.enabled = enabled;
        MediaInfo fakeMediaInfo = new MediaInfo();
        fakeMediaInfo.setContainer("mpegps");
        fakeMediaInfo.setMimeType("video/mpeg");
        MediaVideo video = new MediaVideo();
        video.setCodec("mpeg2");
        fakeMediaInfo.addVideoTrack(video);
        fakeMediaInfo.setMediaParser("NO_PARSER");
        this.setMediaInfo(fakeMediaInfo);
    }

    @Override
    public boolean isTranscodeFolderAvailable() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.timer1 == -1L) {
            this.timer1 = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.timer1 < 2000L) {
            this.timer1 = -1L;
        }
        if (this.timer1 != -1L) {
            this.enabled = this.enable();
        }
        return HTTPResource.getResourceInputStream(this.enabled ? this.videoOk : this.videoKo);
    }

    public abstract boolean enable();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String getSystemName() {
        return this.getName();
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        return DLNAThumbnailInputStream.toThumbnailInputStream(HTTPResource.getResourceInputStream(this.enabled ? this.thumbnailIconOK : this.thumbnailIconKO));
    }

    @Override
    public boolean isValid() {
        this.setFormat(FormatFactory.getAssociatedFormat(this.videoOk));
        return true;
    }

    @Override
    protected boolean isResumeable() {
        return false;
    }
}

