/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.volume.FileVolumeManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.pms.renderers.Renderer;
import net.pms.store.item.ArchiveEntry;
import net.pms.util.ArchiveFileInputStream;
import net.pms.util.IPushOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarredEntry
extends ArchiveEntry
implements IPushOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RarredEntry.class);

    public RarredEntry(Renderer renderer, File file, String entryName, long length) {
        super(renderer, file, entryName, length);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return ArchiveFileInputStream.getRarEntryInputStream(this.file, this.entryName);
    }

    @Override
    public void push(OutputStream out) throws IOException {
        Runnable r = () -> {
            try (Archive rarFile = new Archive(new FileVolumeManager(this.file), null, null);){
                FileHeader header = null;
                for (FileHeader fh : rarFile.getFileHeaders()) {
                    if (!fh.getFileName().equals(this.entryName)) continue;
                    header = fh;
                    break;
                }
                if (header != null) {
                    LOGGER.trace("Starting the extraction of " + header.getFileName());
                    rarFile.extractFile(header, out);
                }
            }
            catch (RarException | IOException e) {
                LOGGER.debug("Unpack error, maybe it's normal, as backend can be terminated: " + e.getMessage());
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exception", e);
                }
            }
        };
        new Thread(r, "Rar Extractor").start();
    }
}

