/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.File;
import java.io.IOException;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.media.MediaInfo;
import net.pms.parsers.Parser;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.IPushOutput;
import net.pms.util.InputFile;

abstract class ArchiveEntry
extends StoreItem
implements IPushOutput {
    protected final File file;
    protected final String entryName;
    protected final long length;
    protected final String name;

    protected ArchiveEntry(Renderer renderer, File file, String entryName, long length) {
        super(renderer);
        this.file = file;
        this.entryName = entryName;
        this.length = length;
        this.name = ArchiveEntry.getName(entryName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long length() {
        if (this.isTranscoded() && this.getTranscodingSettings().getEngine().type() != 2) {
            return 0x7FFFFFFF7FFFFFFFL;
        }
        return this.length;
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath() + "#" + this.entryName;
    }

    @Override
    public boolean isValid() {
        this.resolveFormat();
        return this.getFormat() != null;
    }

    @Override
    public boolean isUnderlyingSeekSupported() {
        return this.length() < 800000000L;
    }

    @Override
    protected void resolveOnce() {
        if (this.getMediaInfo() == null) {
            this.setMediaInfo(new MediaInfo());
        }
        if (this.getFormat() != null) {
            InputFile input = new InputFile();
            input.setPush(this);
            input.setSize(this.length());
            Parser.parse(this.getMediaInfo(), input, this.getFormat(), this.getType());
            if (this.getMediaInfo() != null && this.getMediaInfo().isSLS()) {
                this.setFormat(this.getMediaInfo().getAudioVariantFormat());
            }
        }
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        if (this.getMediaInfo() != null && this.getMediaInfo().getThumbnail() != null) {
            return this.getMediaInfo().getThumbnailInputStream();
        }
        return super.getThumbnailInputStream();
    }

    @Override
    public String write() {
        return this.entryName + ">" + this.file.getAbsolutePath() + ">" + this.length;
    }

    private static String getName(String entryName) {
        String name = entryName;
        while (name.endsWith("/") || name.endsWith("\\")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        if (name.contains("\\")) {
            name = name.substring(name.lastIndexOf("\\") + 1);
        }
        return name;
    }
}

