/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.PMS;
import net.pms.renderers.Renderer;
import net.pms.store.container.CodeEnter;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.item.VirtualVideoAction;
import net.pms.store.item.VirtualVideoActionLocalized;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoSettingsFolder
extends LocalizedStoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoSettingsFolder.class);

    public VideoSettingsFolder(Renderer renderer) {
        super(renderer, "VideoSettings_FolderName");
    }

    public static VideoSettingsFolder getVideoSettingsFolder(Renderer renderer) {
        VideoSettingsFolder res = null;
        if (renderer.getUmsConfiguration().isShowServerSettingsFolder()) {
            res = new VideoSettingsFolder(renderer);
            LocalizedStoreContainer vfSub = new LocalizedStoreContainer(renderer, "Subtitles");
            res.addChild(vfSub);
            if (renderer.getUmsConfiguration().useCode() && !PMS.get().masterCodeValid() && StringUtils.isNotEmpty(PMS.get().codeDb().lookup("MASTER_CODE"))) {
                VirtualVideoAction vva = new VirtualVideoAction(renderer, "MasterCode", true, null){

                    @Override
                    public boolean enable() {
                        CodeEnter ce = (CodeEnter)this.getParent();
                        if (ce.validCode(this)) {
                            PMS.get().setMasterCode(ce);
                            return true;
                        }
                        return false;
                    }
                };
                CodeEnter ce1 = new CodeEnter(vva);
                ce1.setCode("MASTER_CODE");
                res.addChild(ce1);
            }
            res.addChild(new VirtualVideoActionLocalized(renderer, "AvSyncAlternativeMethod", renderer.getUmsConfiguration().isMencoderNoOutOfSync(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setMencoderNoOutOfSync(!this.renderer.getUmsConfiguration().isMencoderNoOutOfSync());
                    return this.renderer.getUmsConfiguration().isMencoderNoOutOfSync();
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "DefaultH264RemuxMencoder", renderer.getUmsConfiguration().isMencoderMuxWhenCompatible(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setMencoderMuxWhenCompatible(!this.renderer.getUmsConfiguration().isMencoderMuxWhenCompatible());
                    return this.renderer.getUmsConfiguration().isMencoderMuxWhenCompatible();
                }
            });
            res.addChild(new VirtualVideoAction(renderer, "  !!-- Fix 23.976/25fps A/V Mismatch --!!", renderer.getUmsConfiguration().isFix25FPSAvMismatch(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setMencoderForceFps(!this.renderer.getUmsConfiguration().isFix25FPSAvMismatch());
                    this.renderer.getUmsConfiguration().setFix25FPSAvMismatch(!this.renderer.getUmsConfiguration().isFix25FPSAvMismatch());
                    return this.renderer.getUmsConfiguration().isFix25FPSAvMismatch();
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "DeinterlaceFilter", renderer.getUmsConfiguration().isMencoderYadif(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setMencoderYadif(!this.renderer.getUmsConfiguration().isMencoderYadif());
                    return this.renderer.getUmsConfiguration().isMencoderYadif();
                }
            });
            vfSub.addChild(new VirtualVideoActionLocalized(renderer, "DisableSubtitles", renderer.getUmsConfiguration().isDisableSubtitles(), null){

                @Override
                public boolean enable() {
                    boolean oldValue = this.renderer.getUmsConfiguration().isDisableSubtitles();
                    boolean newValue = !oldValue;
                    this.renderer.getUmsConfiguration().setDisableSubtitles(newValue);
                    return newValue;
                }
            });
            vfSub.addChild(new VirtualVideoActionLocalized(renderer, "AutomaticallyLoadSrtSubtitles", renderer.getUmsConfiguration().isAutoloadExternalSubtitles(), null){

                @Override
                public boolean enable() {
                    boolean oldValue = this.renderer.getUmsConfiguration().isAutoloadExternalSubtitles();
                    boolean newValue = !oldValue;
                    this.renderer.getUmsConfiguration().setAutoloadExternalSubtitles(newValue);
                    return newValue;
                }
            });
            vfSub.addChild(new VirtualVideoActionLocalized(renderer, "UseEmbeddedStyle", renderer.getUmsConfiguration().isUseEmbeddedSubtitlesStyle(), null){

                @Override
                public boolean enable() {
                    boolean oldValue = this.renderer.getUmsConfiguration().isUseEmbeddedSubtitlesStyle();
                    boolean newValue = !oldValue;
                    this.renderer.getUmsConfiguration().setUseEmbeddedSubtitlesStyle(newValue);
                    return newValue;
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "SkipLoopFilterDeblocking", renderer.getUmsConfiguration().getSkipLoopFilterEnabled(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setSkipLoopFilterEnabled(!this.renderer.getUmsConfiguration().getSkipLoopFilterEnabled());
                    return this.renderer.getUmsConfiguration().getSkipLoopFilterEnabled();
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "KeepDtsTracks", renderer.getUmsConfiguration().isAudioEmbedDtsInPcm(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setAudioEmbedDtsInPcm(!this.renderer.getUmsConfiguration().isAudioEmbedDtsInPcm());
                    return this.renderer.getUmsConfiguration().isAudioEmbedDtsInPcm();
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "SaveConfiguration", true, null){

                @Override
                public boolean enable() {
                    try {
                        this.renderer.getUmsConfiguration().save();
                    }
                    catch (ConfigurationException e) {
                        LOGGER.debug("Caught exception", e);
                    }
                    return true;
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "RestartServer", true, null){

                @Override
                public boolean enable() {
                    PMS.get().resetMediaServer();
                    return true;
                }
            });
            res.addChild(new VirtualVideoActionLocalized(renderer, "ShowLiveSubtitlesFolder", renderer.getUmsConfiguration().isShowLiveSubtitlesFolder(), null){

                @Override
                public boolean enable() {
                    this.renderer.getUmsConfiguration().setShowLiveSubtitlesFolder(this.renderer.getUmsConfiguration().isShowLiveSubtitlesFolder());
                    return this.renderer.getUmsConfiguration().isShowLiveSubtitlesFolder();
                }
            });
        }
        return res;
    }
}

